#include <iostream>
#include <string>
#include <list>
#include <map>

using namespace std;

bool
read_line(string & str)
{
   bool ret = false;
   char ch;

   ch = cin.get();

   while(cin) {
      if(ch == '\n')
         break;

      str += ch;

      ch = cin.get();
   }

   if(cin) 
      ret = true;

   return ret;
}

typedef list< string > string_list_type;

class Line {
public:
    string line;
    int lineno;

    Line() { lineno = -1; }

    Line(string & line, int lineno) {
       this->line = line;

       this->lineno = lineno;
    }

    ~Line() { }

    Line & operator=(const Line & arg) {
       line = arg.line;
       lineno = arg.lineno;
       return *this;
    }
};

typedef list< Line > Line_list_type;
typedef map< string, Line_list_type > Line_map_type;

int
main(int argc,
     char ** argv)
{
   string str;
   int lineno = 0;
   int start = -1;
   int end = -1;
   string_list_type text;
   Line line;
   Line_list_type line_list;
   Line_map_type line_map;

   while(read_line(str)) {
cout << "read: " << str << endl << flush;
      text.push_back(str);

      line.line = str;

      line.lineno = lineno;

      line_map[str].push_back(line);
      
      str = "";

      lineno++;
   }

   lineno = 0;
   for(string_list_type::iterator ptr = text.begin(); ptr != text.end(); ptr++) {
      if(*ptr == "") 
         continue;

cout << "compare: \"" << (*ptr) << "\"" << endl << flush;
      if(line_map.find(*ptr) != line_map.end()) {
         line_list = line_map[*ptr];
      }

      lineno++;
   }

   cout << "start=" << start << endl << flush;

   cout << "end=" << end << endl << flush;

   return 0;
}
