#include <iostream>
#include <string>
#include <list>
#include <map>

using namespace std;

bool
read_line(string & str)
{
   bool ret = false;
   char ch;

   ch = cin.get();

   while(cin) {
      if(ch == '\n')
         break;

      str += ch;

      ch = cin.get();
   }

   if(cin) 
      ret = true;

   return ret;
}

typedef list< string > string_list_type;
typedef map< string, size_t > count_map_type;

int
main(int argc,
     char ** argv)
{
   string str;
   string_list_type text;
   count_map_type count_map;

   while(read_line(str)) {
      text.push_back(str);
      str = "";
   }

   for(string_list_type::iterator ptr = text.begin(); ptr != text.end(); ptr++) {
      count_map[*ptr]++;

      if(count_map[*ptr] == 1 
         || ptr->find("-") != string::npos
         || ptr->find("*") != string::npos
         || ptr->find("+") != string::npos
         || ptr->find("|") != string::npos
         || *ptr == "") {
         cout << *ptr << endl << flush;
      }
   }

   return 0;
}
