/*

SECURE TEXT EDITOR...

Author: Matthew W. Coan
Date: Sun Jun 16 17:51:48 EDT 2013
 
*/

#include <cstdlib>
#include <iostream>
#include <fstream>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>

using namespace std;

#define DEFAULT_EDIT	"vi"
#define PLAIN_TEXT	"pt.txt"
#define ZIP_FILE 	"ct.zip"
#define WC_FILE		"wc.txt"

int
System(const string & cmd)
{
   return system(cmd.c_str());
}

void
on_signal(int sig)
{
   switch(sig) {
   case SIGCHLD:
   break;

   case SIGINT:
   case SIGTERM:
   case SIGHUP:
   break;
   }
}

void
Remove(const string & file)
{
   fstream fout(file.c_str(), ios::out | ios::binary);
   if(fout) {
      fout.seekg(0L, ios::end);
      off_t off = fout.tellg();
      fout.seekg(0L, ios::beg);
      char ch = '\0';
      for(off_t i = 0; i < off; i++) {
         fout.write(&ch, sizeof(char));
      }
      fout.flush();
      fout.close();
      unlink(file.c_str());
   }
}

class SecretEdit {
public:
   void run() {
      signal(SIGCHLD, on_signal);
      signal(SIGINT, on_signal);
      signal(SIGTERM, on_signal);
      signal(SIGHUP, on_signal);
      string password;
      password = getpass("Please enter the password: ");
      if(System(string("7z -p" +password+ " e ") + string(ZIP_FILE)) == 0) {
         int pid;
         if((pid = fork()) == 0) {
            if(System(string("cat ") + string(PLAIN_TEXT) + string(" | wc -l ") 
                      + string(" > ") + string(WC_FILE)) == 0) {
               Remove(ZIP_FILE);
               ifstream fin(WC_FILE, ios::in);
               if(fin) {
                  string wc;
                  fin >> wc;
                  fin.close();
                  Remove(WC_FILE);
                  wc = "+" + wc;
                  if(System(string("chmod go-rwx ./") + string(PLAIN_TEXT)) == 0) {
                     execlp(DEFAULT_EDIT, DEFAULT_EDIT, wc.c_str(), PLAIN_TEXT, 0);
                  }
               }
            }
         }
         int status = 0;
         waitpid(pid, &status, 0);
         if(System(string("zip --encrypt --password ") + password  
                   + string(" -r ") + string(ZIP_FILE) 
                   + string(" ") + string(PLAIN_TEXT)) == 0) {
            Remove(PLAIN_TEXT);
         }
      }
   }
};

int
main(int argc, char ** argv)
{
   try {
      SecretEdit vi;
      vi.run();
   }
   catch(...) {
      cerr << "error..." << endl;
      exit(1);
   }
   return 0;
}
