#include <iostream>
#include <list>
#include <string>

namespace snip {

using namespace std;

typedef list< string > string_list_type;

class Snip {
public:
   string read_line(istream & in) {
      string line;
      char ch;

      ch = in.get();
      while(in) {
         if(ch == '\n')
            break;
         line += ch;
         ch = in.get();
      }
 
      return line;
   }

   void output(const string_list_type & book) {
      for(string_list_type::const_iterator p = book.begin(); p != book.end(); p++) {
         cout << (*p) << endl << flush;
      }
   }

   void snip_date(string_list_type & book, 
                  string_list_type & date) {
      bool in = false;
      bool loop = true;
      string start_date, end_date;
      for(string_list_type::iterator p = date.begin(); p != date.end(); p++) {
         for(string_list_type::iterator p0 = date.begin(); p0 != date.end(); p0++) {
            if(p != p0) {
               if(*p == *p0) {
                  if(!in) {
                     start_date = (*p);
                     in = true;
                  }
               }
               else {
                  if(in) {
                     end_date = (*p);
                     in = false;
                     loop = false;
                     break;
                  }
               }
            }
         }
         if(!loop)
            break;
      }
 
      string_list_type::iterator ptr = book.begin();
      string_list_type temp;

      while(ptr != book.end()) {
         if((*ptr) == start_date) {
            break;
         }
         temp.push_back((*ptr));
         ptr++;
      }

      while(ptr != book.end()) {
         if((*ptr) == end_date) {
            break;
         }
         ptr++;
      }

      while(ptr != book.end()) {
         temp.push_back((*ptr));
         ptr++;
      }
   }

   void snipit(string_list_type & book) {
      string_list_type new_book;
      string_list_type date_list;
      string line;
      for(string_list_type::const_iterator p = book.begin(); p != book.end(); p++) {
         line = (*p); 
         if(line.size()) {
            if(line[0] == '|' && line[line.size()-1] == '|') {
               cerr << "DATE: " << line << endl;
               new_book.push_back(line);
               date_list.push_back(line);
            } 
            else if(line[0] == '*' && line[line.size()-1] == '*') {
               cerr << "DATE: " << line << endl;
               new_book.push_back(line);
               date_list.push_back(line);
            } 
            else {
               new_book.push_back(line);
            }
         }
         else {
            new_book.push_back(line);
         }
      }

      size_t size;

      do {
         size = new_book.size();

         snip_date(new_book, date_list);
      }
      while(size != new_book.size());

      book = new_book;
   }

   void run() {
      string start_date;
      string end_date;
      string line;
      string_list_type book;

      line = read_line(cin);
      while(cin) {
         book.push_back(line);

         line = read_line(cin);
      }

      snipit(book);

      output(book);
   }
};

}

int
main(int argc, char ** argv, char ** envp)
{
   snip::Snip snipit;

   snipit.run();

   return 0;
}
