/*

SIMULATION OF A DIGITAL COMPUTER IN C++

Author: Matthew W. Coan
Date: Tue Mar  7 18:35:37 EST 2017

*/

#ifndef _COMPUTER_H
#define _COMPUTER_H

#include <fstream>
#include "soft_cpu.h"
#include "cpu.h"
#include "memory.h"
#include "display.h"
#include "keyboard.h"

namespace computer_sim {

using namespace cpu_sim;
using namespace memory_sim;
using namespace keyboard_sim;
using namespace display_sim;

class Computer {
   CPU cpu;
   Memory memory;
   Display display;
   Keyboard keyboard;

   void load(const string & command) {
      ifstream fin(command.c_str(), ios::in | ios::binary);
      if(fin) {
         data_word_type data_word = 0;
         data_word_type address = 0;
         data_word_type size = 0;
         fin.read((char*)&size, sizeof(data_word_type));
         if(size > (Memory::MEMORY_SIZE / sizeof(data_word_type))) {
            display.print("error program too big...\n");
            cpu.set_CR(0);
         }
         else {
            for(data_word_type i = 0; i < size; i++) {
               fin.read((char*)&data_word, sizeof(data_word_type));
               memory.store(address, data_word);
               address += sizeof(data_word_type); 
            }   
            cpu.set_SP(address);
         }
         fin.close();
      }
      else {
         display.print("error loading program...\n");
         cpu.set_CR(0);
      }
   }


   void run_program() {
      data_word_type data_word;
      cpu.set_PC(0);
      while(cpu.get_CR().get_value()) {
         data_word = memory.fetch(cpu.get_PC().get_value());
         cpu.execute(data_word);
      }
   }

public:
   Computer() :cpu(&memory) { }
   ~Computer() { }
   void run() {
      string command;
      display.print(">>>Boot Soft OS\n");
      display.print("Hardware: SOFT CPU\n");
      display.print("Version: " + string(VERSION_NUMBER) + "\n");
      cpu.set_CR(1);
      while(cpu.get_CR().get_value()) {
         display.print("> ");
         command = keyboard.input();
         if(command == "quit")  
            break;
         load(command);
         run_program();
         cpu.set_CR(1);
      }
   }
};

}

#endif /* _COMPUTER_H */
