/*

SIMULATION OF COMPUTER MEMORY IN C++

Author: Matthew W. Coan
Date: Tue Mar  7 18:35:37 EST 2017

*/

#ifndef _MEMORY_H 
#define _MEMORY_H

#include "soft_cpu.h"

namespace memory_sim {

class Memory {
public:
   enum { MEMORY_SIZE = 0xFFFF };

private:
   char memory[MEMORY_SIZE];

public:
   Memory() { }
   ~Memory() { }

   data_word_type fetch(const data_word_type address) {
      if(address >= MEMORY_SIZE)
         throw "bad memory address...";
      data_word_type ret = 0;
      memcpy((char*)&ret, memory+address, sizeof(data_word_type));
      return ret;
   }

   void store(const data_word_type address, data_word_type data_word) {
      if(address >= MEMORY_SIZE)
         throw "bad memory address...";
      memcpy(memory+address, (char*)&data_word, sizeof(data_word_type));
   }
};

}

#endif /* _MEMORY_H */
