/*

    Copyright (C) 2009  Matthew William Coan

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


Simple spell checker program.

Date: Tue Dec  4 18:29:39 EST 2007
Author: Matthew William Coan

*/

#include <iostream>
#include <fstream>
#include <cstdlib>
#include <vector>
#include <string>
#include <algorithm>

#include <cstring>
#include <cstdio>

#include <sys/types.h>
#include <signal.h>

#include <readline/readline.h>
#include <readline/history.h>


using namespace std;

#define SPELL_CHECKER_PATH "/home/mcoan/spell_checker/"

#define SNDMAX (1 + 6 + 6*6 + 6*6*6)
#define SNDLEN (26 * SNDMAX)
#define NUL '\0'

char *soundex(char *instr, char *outstr)
{                   /* ABCDEFGHIJKLMNOPQRSTUVWXYZ */
        const char *table = "01230120022455012623010202";
        char *outptr = outstr;
        int count = 0;

        while(!isalpha(instr[0]) && instr[0])
                ++instr;

        if(!instr[0])     /* Hey!  Where'd the string go? */
                return(NULL);

        if(toupper(instr[0]) == 'P' && toupper(instr[1]) == 'H')
        {
                instr[0] = 'F';
                instr[1] = 'A';
        }

        *outptr++ = (char)toupper(*instr++);

        while(*instr && count < 8/*5*/)
        {
                if(isalpha(*instr) && *instr != *(instr-1))
                {
                        *outptr = table[toupper(instr[0]) - 'A'];
                        if(*outptr != '0')
                        {
                                ++outptr;
                                ++count;
                        }
                }
                ++instr;
        }

        *outptr = '\0';
        return(outstr);
}

fstream * ptr_stream = 0;

void
on_signal(int arg)
{
   switch(arg) {
   case SIGTERM:
   case SIGINT:
   case SIGHUP:
      if(ptr_stream != 0) {
         ptr_stream->close();
      }
      cout << endl << "Thank you..." << endl << flush;
      exit(0);
   break;

   case SIGCHLD:
   break;
   }
}

int
main(int argc, char ** argv)
{
   const size_t buf_size = 1024;
   char buffer[buf_size];
   char buffer2[buf_size];
   char buffer3[buf_size];
   char buffer4[buf_size];
   string str, last;
   char * ptr;

   signal(SIGTERM, on_signal);
   signal(SIGINT, on_signal);
   signal(SIGHUP, on_signal);
   signal(SIGCHLD, on_signal);

   cout << "Please type Ctrl-C to exit this program..." 
        << endl << endl << flush;

   //cout << "word> " << flush;

   //while(cin >> str) {
   while(true) {
      ptr = readline("word> ");

      if(ptr == NULL) {
         continue;
      }

      str = string(ptr);

      free(ptr);

      if(last != str) {
         add_history(str.c_str());
      }

      last = str;

      memset(buffer, 0, buf_size);

      memset(buffer4, 0, buf_size);

      strcpy(buffer4, str.c_str());

      char * code = soundex(buffer4, buffer);

      string path = string(SPELL_CHECKER_PATH) + string("words.txt");

      ifstream fin(path.c_str());

      char * code2;

      vector< string > vec;

      bool found = false;

      string str0 = str;

      while(fin >> str) {
         if(str.size() >= (buf_size - 1)) {
            continue;
         }

         if(strcasecmp(str0.c_str(), str.c_str()) == 0) {
            found = true;
         }

         memset(buffer2, 0, buf_size);

         memset(buffer3, 0, buf_size);

         strcpy(buffer3, str.c_str());

         code2 = soundex(buffer3, buffer2);

         if(code != NULL && code2 != NULL) {
            if(strcasecmp(code, code2) == 0) {
               vec.push_back(str);
            }
         }
      }

      fin.close();

      if(found) {
         cout << "correct spelling: " << str0 << endl << flush;
      }
      else {
         sort(vec.begin(), vec.end());

         for(size_t i = 0; i < vec.size(); i++) {
            cout << vec[i] << endl << flush;
         }
      }

      //cout << "word> " << flush;
   }

   return EXIT_SUCCESS;
}


