/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.db;

import com.mwc.sqld.db.CSVCurser;
import com.mwc.sqld.db.Curser;
import com.mwc.sqld.db.ReadWriteLock;
import com.mwc.sqld.db.Table;
import com.mwc.util.CSVEncoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;

public class MasterTable
implements Table {
    private File _masterFile;
    private static String[][] _cols = new String[][]{{"TableName", "VARCHAR(256)"}, {"ColumnName", "VARCHAR(256)"}, {"ColumnType", "VARCHAR(256)"}, {"NotNull", "BOOLEAN"}};
    private ReadWriteLock _rwLock = new ReadWriteLock();

    public MasterTable(File masterFile) {
        this._masterFile = masterFile;
        if (!this._masterFile.exists()) {
            try {
                FileOutputStream fout = new FileOutputStream(this._masterFile);
                BufferedOutputStream bout = new BufferedOutputStream(fout);
                PrintStream out = new PrintStream(bout);
                out.println("\"TableName\",\"ColumnName\",\"ColumnType\",\"NotNull\"");
                out.flush();
                fout.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[][] loadCols(String forTableName) {
        String[][] stringArray;
        Curser c;
        block6: {
            c = this.getNewCurser();
            try {
                String temp;
                String tableName;
                do {
                    if (c.next()) continue;
                    stringArray = null;
                    break block6;
                } while (!(tableName = c.getValue("TableName")).equalsIgnoreCase(forTableName));
                LinkedList<String> names = new LinkedList<String>();
                LinkedList<String> types = new LinkedList<String>();
                LinkedList<String> nns = new LinkedList<String>();
                do {
                    String columnName = c.getValue("ColumnName");
                    names.add(columnName);
                    String columnType = c.getValue("ColumnType");
                    types.add(columnType);
                    String notNull = c.getValue("NotNull");
                    nns.add(notNull);
                } while (c.next() && tableName.equalsIgnoreCase(temp = c.getValue("TableName")));
                String[][] cols = new String[names.size()][3];
                int i = 0;
                while (true) {
                    if (i >= cols.length) {
                        String[][] stringArray2 = cols;
                        Object var16_15 = null;
                        if (c == null) return stringArray2;
                        c.close();
                        return stringArray2;
                    }
                    cols[i][0] = (String)names.get(i);
                    cols[i][1] = (String)types.get(i);
                    cols[i][2] = (String)nns.get(i);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                if (c == null) throw throwable;
                c.close();
                throw throwable;
            }
        }
        Object var16_16 = null;
        if (c == null) return stringArray;
        c.close();
        return stringArray;
    }

    public String name() {
        return "Master";
    }

    public void saveState(String dataDirectory, Hashtable tables) throws IOException {
        this._rwLock.writeLock();
        try {
            FileOutputStream fout = new FileOutputStream(dataDirectory + "/data.dat");
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            PrintWriter out = new PrintWriter(bout);
            out.println("\"TableName\",\"ColumnName\",\"ColumnType\",\"NotNull\"");
            out.flush();
            Enumeration vals = tables.elements();
            while (vals.hasMoreElements()) {
                Table t = (Table)vals.nextElement();
                String[][] cols = t.cols();
                int index = 0;
                while (index < cols.length) {
                    out.println("\"" + CSVEncoder.encode(t.name()) + "\"," + "\"" + CSVEncoder.encode(cols[index][0]) + "\"," + "\"" + CSVEncoder.encode(cols[index][1]) + "\"," + "\"" + CSVEncoder.encode(cols[index][2]) + "\"");
                    out.flush();
                    ++index;
                }
            }
            fout.close();
            Object var11_10 = null;
            this._rwLock.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this._rwLock.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Curser getNewCurser() {
        try {
            void ioe;
            CSVCurser csvCurser = new CSVCurser(this._masterFile, _cols, -1, this._rwLock);
            csvCurser.noDeleteOnClose();
            return ioe;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public boolean insert(LinkedList values) {
        if (values.size() != _cols.length) {
            return false;
        }
        try {
            this._rwLock.writeLock();
            try {
                FileOutputStream fout = new FileOutputStream(this._masterFile.getAbsolutePath(), true);
                PrintStream out = new PrintStream(new BufferedOutputStream(fout));
                StringBuffer buffer = new StringBuffer();
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    String value = (String)it.next();
                    if (buffer.length() != 0) {
                        buffer.append(",");
                    }
                    buffer.append("\"" + CSVEncoder.encode(value) + "\"");
                }
                out.println(buffer.toString());
                out.flush();
                fout.close();
                Object var8_8 = null;
                this._rwLock.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this._rwLock.writeUnlock();
                throw throwable;
            }
            return true;
        }
        catch (Throwable th) {
            return false;
        }
    }

    public boolean drop() {
        return false;
    }

    public String[][] cols() {
        return _cols;
    }
}

