/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.db;

import com.mwc.sqld.db.DBException;

public class SQLDataTranslator {
    public static Object toData(String data, String type) throws DBException {
        if (data == null || type == null) {
            return null;
        }
        if (data.compareTo("''") == 0) {
            return "";
        }
        if (type.equalsIgnoreCase("INT")) {
            try {
                return new Integer(data);
            }
            catch (Throwable th) {
                return null;
            }
        }
        if (type.startsWith("FLOAT")) {
            try {
                return new Double(data);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        if (type.startsWith("CHAR")) {
            int i;
            if (data.length() > 0 && data.charAt(0) == '\'') {
                data = data.substring(1, data.length() - 1);
            }
            if ((i = type.indexOf(40)) >= 0) {
                i = Integer.parseInt(type.substring(i + 1, type.length() - 1));
                if (data.length() < i) {
                    StringBuffer buffer = new StringBuffer(i);
                    buffer.append(data);
                    while (buffer.length() < i) {
                        buffer.append(' ');
                    }
                    data = buffer.toString();
                }
            }
            return data;
        }
        if (type.startsWith("VARCHAR") || type.equalsIgnoreCase("TEXT")) {
            if (data.length() > 0 && data.charAt(0) == '\'') {
                data = data.substring(1, data.length() - 1);
            }
            return data;
        }
        if (type.equalsIgnoreCase("BOOLEAN")) {
            if (data.equalsIgnoreCase("true")) {
                return new Boolean(true);
            }
            if (data.equalsIgnoreCase("false")) {
                return new Boolean(false);
            }
            return null;
        }
        throw new DBException("Bad type \"" + type + "\"!");
    }
}

