/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.db;

import com.mwc.sqld.db.CSVFileReader;
import com.mwc.sqld.db.Curser;
import com.mwc.sqld.db.MasterTable;
import com.mwc.sqld.db.ReadWriteLock;
import com.mwc.sqld.db.SimpleDatabase;
import com.mwc.sqld.db.Table;
import com.mwc.sqld.db.ValueLookup;
import com.mwc.util.CSVEncoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;

public class TextDatabase
extends SimpleDatabase {
    private String _name;
    private String _dataDirectory;
    private Hashtable _tables;
    private long _currentTemp;
    private Object _tempLock;
    private boolean _mod;
    private Object _modLock;
    private MasterTable _masterTable;

    public void close() {
    }

    private String _getNextTemp() {
        Object object = this._tempLock;
        synchronized (object) {
            String ret = "TEMP" + this._currentTemp;
            ++this._currentTemp;
            String string = ret;
            return string;
        }
    }

    public File getTempFile() {
        File f;
        Object object = this._tempLock;
        synchronized (object) {
            StringBuffer buf;
            String tempFileName = this._dataDirectory + "/temp/";
            f = new File(tempFileName);
            if (!f.exists()) {
                f.mkdirs();
            }
            String choice = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            do {
                buf = new StringBuffer();
                int i = 0;
                while (i < 50) {
                    buf.append(choice.charAt((int)(Math.random() * 1.0E9) % choice.length()));
                    ++i;
                }
            } while ((f = new File(tempFileName + buf.toString())).exists());
            try {
                FileOutputStream fout = new FileOutputStream(f);
                fout.close();
            }
            catch (IOException ioe) {
                File file = null;
                return file;
            }
        }
        return f;
    }

    public TextDatabase(String name, String dataDirectory) throws Exception {
        block6: {
            this._tables = new Hashtable();
            this._currentTemp = 0L;
            this._tempLock = new Object();
            this._mod = false;
            this._modLock = new Object();
            this._name = name;
            this._dataDirectory = dataDirectory;
            File f = new File(this._dataDirectory);
            if (!f.exists()) {
                f.mkdir();
            }
            if ((f = new File(this._dataDirectory + "/data.dat")).exists()) {
                this._masterTable = new MasterTable(f);
                Curser c = this._masterTable.getNewCurser();
                try {
                    String lastTableName = "";
                    while (c.next()) {
                        String tableName = c.getValue("TableName");
                        if (lastTableName.equalsIgnoreCase(tableName)) continue;
                        String[][] cols = this._masterTable.loadCols(tableName);
                        lastTableName = tableName;
                        String tableFileName = this._dataDirectory + "/" + tableName + ".csv";
                        System.out.println("LOAD-TABLE(" + tableName + ")");
                        TextTable t = new TextTable(tableName, tableFileName, cols);
                        this._tables.put(t.name().toLowerCase(), t);
                    }
                    Object var12_10 = null;
                    if (c == null) break block6;
                    c.close();
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    if (c != null) {
                        c.close();
                    }
                    throw throwable;
                }
                {
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Table createTable(String name, String[][] cols) {
        try {
            void ioe;
            Table tbl = this.getTable(name);
            if (tbl != null) {
                return null;
            }
            String fileName = this._dataDirectory + "/" + name + ".csv";
            tbl = new TextTable(name, fileName, cols);
            Hashtable hashtable = this._tables;
            synchronized (hashtable) {
                this._tables.put(name.toLowerCase(), tbl);
            }
            Object object = this._modLock;
            synchronized (object) {
                this._mod = true;
            }
            return ioe;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public String name() {
        return this._name;
    }

    public Table getTable(String table) {
        if (table.equalsIgnoreCase("Master")) {
            return this._masterTable;
        }
        Hashtable hashtable = this._tables;
        synchronized (hashtable) {
            Table table2 = (Table)this._tables.get(table.toLowerCase());
            return table2;
        }
    }

    public String[] tableNames() {
        Hashtable hashtable = this._tables;
        synchronized (hashtable) {
            String[] ret = new String[this._tables.size()];
            Enumeration e = this._tables.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                ret[i] = ((Table)e.nextElement()).name();
                ++i;
            }
            String[] stringArray = ret;
            return stringArray;
        }
    }

    public boolean dropTable(String table) {
        Table tbl;
        table = table.toLowerCase();
        Hashtable hashtable = this._tables;
        synchronized (hashtable) {
            tbl = (Table)this._tables.get(table);
            if (tbl == null) {
                boolean bl = false;
                return bl;
            }
            this._tables.remove(table);
        }
        Object object = this._modLock;
        synchronized (object) {
            this._mod = true;
        }
        return tbl.drop();
    }

    public boolean save() {
        try {
            this._masterTable.saveState(this._dataDirectory, this._tables);
            Object object = this._modLock;
            synchronized (object) {
                this._mod = false;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public void sync() {
    }

    public boolean modified() {
        Object object = this._modLock;
        synchronized (object) {
            boolean bl = this._mod;
            return bl;
        }
    }

    class TextTable
    implements Table {
        private ReadWriteLock _rwLock = new ReadWriteLock();
        private String _fileName;
        private String _name;
        private String[][] _cols;

        private TextTable(String name, String fileName, String[][] cols) throws IOException {
            this._name = name;
            this._fileName = fileName;
            this._cols = cols;
            File f = new File(fileName);
            if (!f.exists()) {
                FileOutputStream fout = new FileOutputStream(fileName);
                PrintWriter out = new PrintWriter(new BufferedOutputStream(fout));
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < cols.length) {
                    if (buffer.length() != 0) {
                        buffer.append(",");
                    }
                    buffer.append("\"" + cols[i][0] + "\"");
                    ++i;
                }
                out.println(buffer.toString());
                out.flush();
                fout.close();
            }
        }

        public String[][] cols() {
            return this._cols;
        }

        public String name() {
            return this._name;
        }

        public Curser getNewCurser() {
            this._rwLock.readLock();
            TextCurser tc = new TextCurser(new CSVFileReader(this._fileName, true), this._rwLock, this._cols, this._name);
            try {
                tc._csvReader.open();
            }
            catch (IOException ioe) {
                return null;
            }
            return tc;
        }

        public boolean insert(LinkedList values) {
            if (values.size() != this._cols.length) {
                return false;
            }
            try {
                this._rwLock.writeLock();
                try {
                    FileOutputStream fout = new FileOutputStream(this._fileName, true);
                    PrintStream out = new PrintStream(new BufferedOutputStream(fout));
                    StringBuffer buffer = new StringBuffer();
                    Iterator it = values.iterator();
                    while (it.hasNext()) {
                        String value = (String)it.next();
                        if (buffer.length() != 0) {
                            buffer.append(",");
                        }
                        buffer.append("\"" + CSVEncoder.encode(value) + "\"");
                    }
                    out.println(buffer.toString());
                    out.flush();
                    fout.close();
                    Object object = TextDatabase.this._modLock;
                    synchronized (object) {
                        TextDatabase.this._mod = true;
                    }
                    Object var10_10 = null;
                    this._rwLock.writeUnlock();
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    this._rwLock.writeUnlock();
                    throw throwable;
                }
                return true;
            }
            catch (Throwable th) {
                return false;
            }
        }

        public boolean drop() {
            this._rwLock.writeLock();
            return new File(this._fileName).delete();
        }

        private class CSVValueLookup
        implements ValueLookup {
            private CSVFileReader _csv;
            private String[][] _cols;

            CSVValueLookup(CSVFileReader csv, String[][] cols) {
                this._csv = csv;
                this._cols = cols;
            }

            public String[][] cols() {
                return this._cols;
            }

            public int size() {
                return this._cols.length;
            }

            public String getValue(String name) {
                return this._csv.getValue(name);
            }

            public String getValue(int index) {
                return this._csv.getValue(index);
            }

            public String getType(String name) {
                int i = 0;
                while (i < this._cols.length) {
                    if (this._cols[i][0].equalsIgnoreCase(name)) {
                        return this._cols[i][1];
                    }
                    ++i;
                }
                return null;
            }
        }
    }

    class TextCurser
    implements Curser {
        private CSVFileReader _csvReader;
        private ReadWriteLock _tblReadWriteLock;
        private String[][] _cols;
        private String _name;

        private TextCurser(CSVFileReader csvReader, ReadWriteLock tblReadWriteLock, String[][] cols, String name) {
            this._csvReader = csvReader;
            this._tblReadWriteLock = tblReadWriteLock;
            this._cols = cols;
            this._name = name;
        }

        public String[][] cols() {
            return this._cols;
        }

        public int size() {
            return this._cols.length;
        }

        public boolean reset() {
            try {
                this._csvReader.close();
                this._csvReader.open();
                return true;
            }
            catch (IOException ioe) {
                return false;
            }
        }

        public boolean next() {
            try {
                return this._csvReader.readLine();
            }
            catch (IOException ioe) {
                return false;
            }
        }

        public String getValue(String colName) {
            int i = colName.indexOf(46);
            if (i < 0) {
                return this._csvReader.getValue(colName);
            }
            String tblName = colName.substring(0, i);
            if (tblName.equalsIgnoreCase(this._name)) {
                colName = colName.substring(i + 1);
                return this._csvReader.getValue(colName);
            }
            return null;
        }

        public String getValue(int index) {
            return this._csvReader.getValue(index);
        }

        public String getType(String colName) {
            int i = colName.indexOf(46);
            if (i >= 0) {
                String tblName = colName.substring(0, i);
                if (!tblName.equalsIgnoreCase(this._name)) {
                    return null;
                }
                colName = colName.substring(i + 1);
            }
            i = 0;
            while (i < this._cols.length) {
                if (colName.equalsIgnoreCase(this._cols[i][0])) {
                    return this._cols[i][1];
                }
                ++i;
            }
            return null;
        }

        public boolean close() {
            try {
                this._csvReader.close();
                this._tblReadWriteLock.readUnlock();
                return true;
            }
            catch (IOException ioe) {
                return false;
            }
        }

        public int recCount() {
            return -1;
        }
    }
}

