/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.db;

import com.mwc.sqld.db.CSVFileReader;
import com.mwc.sqld.db.Curser;
import com.mwc.sqld.db.DBException;
import com.mwc.sqld.db.Database;
import com.mwc.sqld.db.Sorter;
import com.mwc.sqld.db.ValueLookup;
import com.mwc.sqld.db.ValueLookupComparator;
import com.mwc.util.CSVEncoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;

public class TwoWayMergeSort
implements Sorter {
    private Database _db;

    /*
     * Unable to fully structure code
     */
    private void _mergeRuns(SortCurser c0, SortCurser c1, ValueLookup[] acurrent0, ValueLookup[] acurrent1, ValueLookupComparator cp, SortCurser out) throws IOException, DBException {
        block8: {
            current0 = acurrent0[0];
            current1 = acurrent1[0];
            done0 = c0.eof();
            done1 = c1.eof();
            while (!done0 && !done1) {
                if (cp.compare(current0, current1) < 0) {
                    prev0 = current0;
                    out.put(current0);
                    c0.next();
                    current0 = new TempValueLookup(c0);
                    if (c0.eof()) {
                        done0 = true;
                        continue;
                    }
                    done0 = cp.compare(current0, prev0) < 0;
                    continue;
                }
                prev1 = current1;
                out.put(current1);
                c1.next();
                current1 = new TempValueLookup(c1);
                if (c1.eof()) {
                    done1 = true;
                    continue;
                }
                v0 = done1 = cp.compare(current1, prev1) < 0;
            }
            if (!done0) ** GOTO lbl53
            while (!done1) {
                prev1 = current1;
                out.put(current1);
                c1.next();
                current1 = new TempValueLookup(c1);
                if (c1.eof()) {
                    done1 = true;
                    continue;
                }
                v1 = done1 = cp.compare(current1, prev1) < 0;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                prev0 = current0;
                out.put(current0);
                c0.next();
                current0 = new TempValueLookup(c0);
                if (c0.eof()) {
                    done0 = true;
                    continue;
                }
                v2 = done0 = cp.compare(current0, prev0) < 0;
lbl53:
                // 3 sources

                ** while (!done0)
            }
        }
        acurrent0[0] = current0;
        acurrent1[0] = current1;
    }

    private int _mergeStreams(SortCurser c0, SortCurser c1, ValueLookupComparator cp, SortCurser c2, SortCurser c3) throws IOException, DBException {
        c0.reset();
        c1.reset();
        c0.next();
        c1.next();
        TempValueLookup current0 = new TempValueLookup(c0);
        TempValueLookup current1 = new TempValueLookup(c1);
        ValueLookup[] a0 = new ValueLookup[]{current0};
        ValueLookup[] a1 = new ValueLookup[]{current1};
        c2.rewrite();
        c3.rewrite();
        int numberOfRuns = 0;
        while (!c0.eof() || !c1.eof()) {
            ++numberOfRuns;
            this._mergeRuns(c0, c1, a0, a1, cp, c2);
            if (c0.eof() && c1.eof()) continue;
            ++numberOfRuns;
            this._mergeRuns(c0, c1, a0, a1, cp, c3);
        }
        return numberOfRuns;
    }

    private Curser _twoWayMergeSort(SortCurser c0, SortCurser c1, ValueLookupComparator cp) throws IOException, DBException {
        int numberOfRuns;
        SortCurser c2 = new SortCurser(this._db.getTempFile(), c0.cols(), 0);
        SortCurser c3 = new SortCurser(this._db.getTempFile(), c0.cols(), 0);
        int count = 0;
        while ((numberOfRuns = ++count % 2 != 0 ? this._mergeStreams(c0, c1, cp, c2, c3) : this._mergeStreams(c2, c3, cp, c0, c1)) > 1) {
        }
        if (count % 2 != 0) {
            c0.close();
            c1.close();
            c3.close();
            return c2;
        }
        c1.close();
        c2.close();
        c3.close();
        return c0;
    }

    public TwoWayMergeSort(Database db) {
        this._db = db;
    }

    public Curser sort(Curser c, ValueLookupComparator cp) throws DBException {
        try {
            int j;
            StringBuffer buf;
            int recCount = 0;
            if (c.recCount() < 0) {
                while (c.next()) {
                    ++recCount;
                }
                c.reset();
            } else {
                recCount = c.recCount();
            }
            if (recCount == 0 || recCount == 1) {
                return c;
            }
            int half0 = recCount / 2;
            int half1 = half0 + half0 != recCount ? half0 + 1 : half0;
            String[][] cols = c.cols();
            File temp0 = this._db.getTempFile();
            SortCurser c0 = new SortCurser(temp0, cols, half0);
            int i = 0;
            while (i < half0) {
                buf = new StringBuffer();
                c.next();
                j = 0;
                while (j < c.size()) {
                    if (buf.length() != 0) {
                        buf.append(",");
                    }
                    buf.append("\"" + CSVEncoder.encode(c.getValue(j)) + "\"");
                    ++j;
                }
                c0.put(buf.toString());
                ++i;
            }
            File temp1 = this._db.getTempFile();
            SortCurser c1 = new SortCurser(temp1, cols, half1);
            i = 0;
            while (i < half1) {
                buf = new StringBuffer();
                c.next();
                j = 0;
                while (j < c.size()) {
                    if (buf.length() != 0) {
                        buf.append(",");
                    }
                    buf.append("\"" + CSVEncoder.encode(c.getValue(j)) + "\"");
                    ++j;
                }
                c1.put(buf.toString());
                ++i;
            }
            c.close();
            c0.reset();
            c1.reset();
            c = this._twoWayMergeSort(c0, c1, cp);
            c.reset();
            return c;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    class TempValueLookup
    implements ValueLookup {
        private Hashtable _tbl = new Hashtable();
        private String[] _array;
        private String[][] _cols;

        public TempValueLookup(Curser c) {
            this._array = new String[c.size()];
            this._cols = c.cols();
            int i = 0;
            while (i < this._cols.length) {
                this._array[i] = c.getValue(i);
                this._tbl.put(this._cols[i][0].toLowerCase(), new Integer(i));
                ++i;
            }
        }

        public String getValue(String name) {
            Integer i = (Integer)this._tbl.get(name.toLowerCase());
            if (i == null) {
                return null;
            }
            return this._array[i];
        }

        public String getValue(int index) {
            return this._array[index];
        }

        public String getType(String name) {
            int i = 0;
            while (i < this._cols.length) {
                if (name.equalsIgnoreCase(this._cols[i][0])) {
                    return this._cols[i][1];
                }
                ++i;
            }
            return null;
        }

        public int size() {
            return this._cols.length;
        }

        public String[][] cols() {
            return this._cols;
        }
    }

    public class SortCurser
    implements Curser {
        private File _file;
        private CSVFileReader _csvReader;
        private String[][] _cols;
        private int _recCount;
        private boolean _eof = false;
        private PrintWriter _out = null;

        public SortCurser(File f, String[][] cols, int recCount) throws IOException {
            this._file = f;
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < cols.length) {
                if (buf.length() != 0) {
                    buf.append(",");
                }
                buf.append("\"" + CSVEncoder.encode(cols[i][0]) + "\"");
                ++i;
            }
            FileOutputStream fout = new FileOutputStream(this._file.getAbsolutePath());
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            PrintWriter out = new PrintWriter(bout);
            out.println(buf.toString());
            out.flush();
            fout.close();
            this._csvReader = new CSVFileReader(f.getAbsolutePath(), true);
            this._csvReader.open();
            this._cols = cols;
            this._recCount = recCount;
        }

        public String[][] cols() {
            return this._cols;
        }

        public int size() {
            return this._cols.length;
        }

        public boolean reset() {
            if (this._out != null) {
                this._out.flush();
                this._out.close();
                this._out = null;
            }
            try {
                if (this._csvReader != null) {
                    this._csvReader.close();
                    this._csvReader.open();
                } else {
                    this._csvReader = new CSVFileReader(this._file.getAbsolutePath(), true);
                    this._csvReader.open();
                }
                this._eof = false;
                return true;
            }
            catch (IOException ioe) {
                return false;
            }
        }

        public boolean put(ValueLookup c) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < c.size()) {
                if (buf.length() != 0) {
                    buf.append(",");
                }
                buf.append("\"" + CSVEncoder.encode(c.getValue(i)) + "\"");
                ++i;
            }
            return this.put(buf.toString());
        }

        public boolean put(String rec) {
            return this.put(rec, true);
        }

        public boolean put(String rec, boolean append) {
            try {
                if (!append) {
                    this._recCount = 0;
                }
                if (this._out == null) {
                    FileOutputStream fout = new FileOutputStream(this._file.getAbsolutePath(), append);
                    BufferedOutputStream bout = new BufferedOutputStream(fout);
                    this._out = new PrintWriter(bout);
                }
                this._out.println(rec);
                this._out.flush();
                this._eof = false;
                ++this._recCount;
                return true;
            }
            catch (IOException ioe) {
                return false;
            }
        }

        public boolean next() {
            try {
                this._eof = !this._csvReader.readLine();
                return !this._eof;
            }
            catch (IOException ioe) {
                return false;
            }
        }

        public String getValue(String colName) {
            return this._csvReader.getValue(colName);
        }

        public String getValue(int index) {
            return this._csvReader.getValue(index);
        }

        public String getType(String colName) {
            int i = 0;
            while (i < this._cols.length) {
                if (colName.equalsIgnoreCase(this._cols[i][0])) {
                    return this._cols[i][1];
                }
                ++i;
            }
            return null;
        }

        public boolean close() {
            try {
                if (this._csvReader != null) {
                    this._csvReader.close();
                }
                if (this._out != null) {
                    this._out.flush();
                    this._out.close();
                }
                this._file.delete();
                this._eof = false;
                return true;
            }
            catch (IOException ioe) {
                return false;
            }
        }

        public int recCount() {
            return this._recCount;
        }

        private boolean rewrite() {
            try {
                if (this._csvReader != null) {
                    this._csvReader.close();
                }
                this._csvReader = null;
                this._eof = false;
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < this._cols.length) {
                    if (buf.length() != 0) {
                        buf.append(",");
                    }
                    buf.append("\"" + CSVEncoder.encode(this._cols[i][0]) + "\"");
                    ++i;
                }
                return this.put(buf.toString(), false);
            }
            catch (IOException ioe) {
                return false;
            }
        }

        public boolean eof() {
            return this._eof;
        }
    }
}

