/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.jdbc;

import com.mwc.util.SQLEncoder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.Socket;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class SQLDDriver
implements Driver {
    public static final String VERSION = "1.0.0";

    public boolean acceptsURL(String url) throws SQLException {
        return url.toLowerCase().startsWith("jdbc:sqld:");
    }

    public Connection connect(String url, Properties info) throws SQLException {
        return new SQLDConnection(url, info);
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new SQLDDriver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    class SQLDConnection
    implements Connection {
        private String _url;
        private String _host;
        private int _port;
        private String _currCat;
        private Socket _sock;
        private PrintWriter _out;
        private BufferedReader _br;
        private String _username;
        private String _password;

        /*
         * WARNING - void declaration
         */
        private String _readError(BufferedReader br) throws IOException {
            String res;
            StringBuffer error = new StringBuffer();
            while ((res = br.readLine()) != null) {
                void var2_3;
                if (var2_3.compareTo("~~~END-OF-ERROR-MESSAGE~~~") == 0) break;
                error.append((String)var2_3 + "\n");
            }
            return error.toString();
        }

        private String _getResponse() throws IOException, SQLException {
            return this._getResponse(this._br);
        }

        private String _getResponse(BufferedReader br) throws IOException, SQLException {
            String res = br.readLine();
            if (res == null) {
                throw new SQLException("Unable to read response code from server!");
            }
            if (res.compareTo("ERROR") == 0) {
                throw new SQLException(this._readError(br));
            }
            if (res.compareTo("OK") != 0 && res.compareTo("END") != 0) {
                throw new SQLException("Bad response code!");
            }
            return res;
        }

        private SQLDConnection(String url, Properties info) throws SQLException {
            this._url = url;
            this._username = info.getProperty("user");
            this._password = info.getProperty("password");
            url = url.substring(10);
            int i = url.indexOf(58);
            if (i < 0 || i + 1 > url.length()) {
                throw new SQLException("No port number in the DB URL!");
            }
            this._host = url.substring(0, i);
            if ((i = (url = url.substring(i + 1)).indexOf(58)) >= 0 && i + 1 < url.length()) {
                this._port = Integer.parseInt(url.substring(0, i));
                this._currCat = url.substring(i + 1);
            } else {
                this._port = Integer.parseInt(url);
                this._currCat = null;
            }
            this._sock = null;
            try {
                this._sock = new Socket(this._host, this._port);
                this._out = new PrintWriter(new BufferedOutputStream(this._sock.getOutputStream()));
                this._br = new BufferedReader(new InputStreamReader(this._sock.getInputStream()));
                String auth = this._br.readLine();
                if (auth.compareTo("Authentication") != 0) {
                    throw new SQLException("No Authentication!");
                }
                this._out.println(this._username + ";" + this._password + ";");
                this._out.flush();
                this._getResponse();
                if (this._currCat != null) {
                    this._out.print("SET CURRENT DATABASE " + this._currCat + ";");
                    this._out.flush();
                    this._getResponse();
                }
            }
            catch (IOException ioe) {
                if (this._sock != null) {
                    try {
                        this._sock.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                }
                throw new SQLException(ioe.getMessage());
            }
        }

        public void clearWarnings() throws SQLException {
        }

        public void close() throws SQLException {
            try {
                PrintWriter printWriter = this._out;
                synchronized (printWriter) {
                    this._out.println("exit;");
                    this._out.flush();
                    this._sock.close();
                }
            }
            catch (IOException ioe) {
                throw new SQLException(ioe.getMessage());
            }
        }

        public void commit() throws SQLException {
        }

        public Statement createStatement() throws SQLException {
            return new SQLDStatement(this);
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.createStatement();
        }

        public boolean getAutoCommit() throws SQLException {
            return true;
        }

        public String getCatalog() throws SQLException {
            return this._currCat;
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            return new SQLDDatabaseMetaData(this);
        }

        public int getTransactionIsolation() throws SQLException {
            return 0;
        }

        public Map getTypeMap() throws SQLException {
            return null;
        }

        public SQLWarning getWarnings() throws SQLException {
            return null;
        }

        public boolean isClosed() throws SQLException {
            return false;
        }

        public boolean isReadOnly() throws SQLException {
            return false;
        }

        public String nativeSQL(String sql) throws SQLException {
            return sql;
        }

        public CallableStatement prepareCall(String sql) throws SQLException {
            return null;
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return null;
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return null;
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return null;
        }

        public void rollback() throws SQLException {
        }

        public void setAutoCommit(boolean autoCommit) throws SQLException {
        }

        public void setCatalog(String catalog) throws SQLException {
            try {
                this._currCat = catalog;
                PrintWriter printWriter = this._out;
                synchronized (printWriter) {
                    this._out.print("SET CURRENT DATABASE " + this._currCat + ";");
                    this._out.flush();
                    this._getResponse();
                }
            }
            catch (IOException ioe) {
                throw new SQLException(ioe.getMessage());
            }
        }

        public void setReadOnly(boolean readOnly) throws SQLException {
        }

        public void setTransactionIsolation(int level) throws SQLException {
        }

        public void setTypeMap(Map map) throws SQLException {
        }

        class SQLDStatement
        implements Statement {
            private ResultSet _currRS = null;
            private Connection _con;

            private SQLDStatement(Connection con) {
                this._con = con;
            }

            public void addBatch(String sql) throws SQLException {
            }

            public void cancel() throws SQLException {
            }

            public void clearBatch() throws SQLException {
            }

            public void clearWarnings() throws SQLException {
            }

            public void close() throws SQLException {
            }

            public boolean execute(String sql) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public int[] executeBatch() throws SQLException {
                return null;
            }

            public ResultSet executeQuery(String sql) throws SQLException {
                try {
                    String rsID;
                    PrintWriter printWriter = SQLDConnection.this._out;
                    synchronized (printWriter) {
                        SQLDConnection.this._out.print(sql + ";");
                        SQLDConnection.this._out.flush();
                        SQLDConnection.this._getResponse();
                        rsID = SQLDConnection.this._br.readLine();
                    }
                    if (rsID == null) {
                        throw new SQLException("Can't read result set ID!");
                    }
                    this._currRS = new SQLDResultSet(rsID, this);
                    return this._currRS;
                }
                catch (IOException ioe) {
                    throw new SQLException(ioe.getMessage());
                }
            }

            public int executeUpdate(String sql) throws SQLException {
                try {
                    PrintWriter printWriter = SQLDConnection.this._out;
                    synchronized (printWriter) {
                        SQLDConnection.this._out.print(sql + ";");
                        SQLDConnection.this._out.flush();
                        SQLDConnection.this._getResponse();
                    }
                    return 1;
                }
                catch (IOException ioe) {
                    return -1;
                }
            }

            public Connection getConnection() throws SQLException {
                return this._con;
            }

            public int getFetchDirection() throws SQLException {
                return 0;
            }

            public int getFetchSize() throws SQLException {
                return 0;
            }

            public int getMaxFieldSize() throws SQLException {
                return 0;
            }

            public int getMaxRows() throws SQLException {
                return 0;
            }

            public boolean getMoreResults() throws SQLException {
                return false;
            }

            public int getQueryTimeout() throws SQLException {
                return 0;
            }

            public ResultSet getResultSet() throws SQLException {
                return this._currRS;
            }

            public int getResultSetConcurrency() throws SQLException {
                return 0;
            }

            public int getResultSetType() throws SQLException {
                return 0;
            }

            public int getUpdateCount() throws SQLException {
                return 0;
            }

            public SQLWarning getWarnings() throws SQLException {
                return null;
            }

            public void setCursorName(String name) throws SQLException {
            }

            public void setEscapeProcessing(boolean enable) throws SQLException {
            }

            public void setFetchDirection(int direction) throws SQLException {
            }

            public void setFetchSize(int rows) throws SQLException {
            }

            public void setMaxFieldSize(int max) throws SQLException {
            }

            public void setMaxRows(int max) throws SQLException {
            }

            public void setQueryTimeout(int seconds) throws SQLException {
            }

            class SQLDResultSet
            implements ResultSet {
                private String _id;
                private Socket _sock = null;
                private BufferedReader _br;
                private PrintStream _ps;
                private Hashtable _map;
                private Vector _columnNames = new Vector();
                private Vector _columnTypes = new Vector();
                private Vector _line;
                private Statement _s;
                private boolean _wasNull = false;

                /*
                 * Enabled aggressive block sorting
                 */
                private boolean _readRec() throws IOException {
                    String rec = this._br.readLine();
                    if (rec == null) {
                        return false;
                    }
                    this._line = new Vector();
                    boolean gotC = false;
                    int i = 0;
                    boolean j = false;
                    while (i < rec.length()) {
                        boolean gotQ = false;
                        gotC = false;
                        StringBuffer field = new StringBuffer();
                        if (rec.charAt(i) == '\"') {
                            gotQ = true;
                            ++i;
                        }
                        while (i < rec.length()) {
                            block11: {
                                if (rec.charAt(i) == '\"' && gotQ) {
                                    if (i + 1 >= rec.length()) break;
                                    if (rec.charAt(i + 1) == '\"') {
                                        field.append('\"');
                                        ++i;
                                        break block11;
                                    } else {
                                        gotQ = false;
                                        break;
                                    }
                                }
                                if (!gotQ && rec.charAt(i) == ',') break;
                                field.append(rec.charAt(i));
                            }
                            while (i + 1 == rec.length() && gotQ) {
                                String temp = this._br.readLine();
                                if (temp == null) break;
                                rec = rec + "\n";
                                rec = rec + temp;
                            }
                            ++i;
                        }
                        if (i < rec.length() && rec.charAt(i) == '\"') {
                            ++i;
                        }
                        if (i < rec.length() && rec.charAt(i) == ',') {
                            ++i;
                            gotC = true;
                        }
                        this._line.addElement(field.toString());
                    }
                    if (gotC) {
                        this._line.addElement("");
                    }
                    return true;
                }

                SQLDResultSet(String id, Statement s) throws IOException, SQLException {
                    try {
                        this._s = s;
                        this._id = id;
                        this._sock = new Socket(SQLDConnection.this._host, SQLDConnection.this._port);
                        this._br = new BufferedReader(new InputStreamReader(this._sock.getInputStream()));
                        this._ps = new PrintStream(new BufferedOutputStream(this._sock.getOutputStream()));
                        String res = this._br.readLine();
                        if (res == null) {
                            throw new SQLException("No Authentication!");
                        }
                        if (res.compareTo("Authentication") != 0) {
                            throw new SQLException("No Authentication!");
                        }
                        this._ps.println(SQLDConnection.this._username + ";" + SQLDConnection.this._password + ";");
                        this._ps.flush();
                        res = this._br.readLine();
                        if (res == null) {
                            throw new SQLException("Unable to get results!");
                        }
                        this._ps.println("get results " + this._id + ";");
                        this._ps.flush();
                        SQLDConnection.this._getResponse(this._br);
                        if (!this._readRec()) {
                            throw new SQLException("Unable to read column names!");
                        }
                        this._map = new Hashtable();
                        int i = 0;
                        while (i < this._line.size()) {
                            this._map.put(this._line.elementAt(i).toString().toLowerCase(), new Integer(i));
                            this._columnNames.addElement(this._line.elementAt(i));
                            ++i;
                        }
                        if (!this._readRec()) {
                            throw new SQLException("Unable to read column types!");
                        }
                        int i2 = 0;
                        while (i2 < this._line.size()) {
                            this._columnTypes.addElement(this._line.elementAt(i2));
                            ++i2;
                        }
                        this._line = null;
                    }
                    catch (SQLException sqle) {
                        if (this._sock != null) {
                            this._sock.close();
                        }
                        throw sqle;
                    }
                    catch (IOException ioe) {
                        if (this._sock != null) {
                            this._sock.close();
                        }
                        throw ioe;
                    }
                }

                public boolean absolute(int row) throws SQLException {
                    throw new SQLException("TYPE_FORWARD_ONLY");
                }

                public void afterLast() throws SQLException {
                }

                public void beforeFirst() throws SQLException {
                    try {
                        this._line = null;
                        this._ps.println("reset;");
                        this._ps.flush();
                        SQLDConnection.this._getResponse(this._br);
                    }
                    catch (IOException ioe) {
                        throw new SQLException(ioe.getMessage());
                    }
                }

                public void cancelRowUpdates() throws SQLException {
                }

                public void clearWarnings() throws SQLException {
                }

                public void close() throws SQLException {
                    try {
                        this._ps.println("close;");
                        this._ps.flush();
                        this._ps.println("exit;");
                        this._ps.flush();
                        this._sock.close();
                    }
                    catch (IOException ioe) {
                        throw new SQLException(ioe.getMessage());
                    }
                }

                public void deleteRow() throws SQLException {
                }

                public int findColumn(String columnName) throws SQLException {
                    Integer i = (Integer)this._map.get(columnName);
                    if (i == null) {
                        return -1;
                    }
                    return i;
                }

                public boolean first() throws SQLException {
                    this.beforeFirst();
                    return this.next();
                }

                public Array getArray(int i) throws SQLException {
                    return null;
                }

                public Array getArray(String colName) throws SQLException {
                    return null;
                }

                public InputStream getAsciiStream(int columnIndex) throws SQLException {
                    return null;
                }

                public InputStream getAsciiStream(String columnName) throws SQLException {
                    return null;
                }

                public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
                    String value = this.getString(columnIndex);
                    if (value == null) {
                        return null;
                    }
                    return new BigDecimal(value);
                }

                public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
                    String value = this.getString(columnIndex);
                    if (value == null) {
                        return null;
                    }
                    return new BigDecimal(value);
                }

                public BigDecimal getBigDecimal(String columnName) throws SQLException {
                    String value = this.getString(columnName);
                    if (value == null) {
                        return null;
                    }
                    return new BigDecimal(value);
                }

                public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
                    String value = this.getString(columnName);
                    if (value == null) {
                        return null;
                    }
                    return new BigDecimal(value);
                }

                public InputStream getBinaryStream(int columnIndex) throws SQLException {
                    return null;
                }

                public InputStream getBinaryStream(String columnName) throws SQLException {
                    return null;
                }

                public Blob getBlob(int i) throws SQLException {
                    return null;
                }

                public Blob getBlob(String colName) throws SQLException {
                    return null;
                }

                public boolean getBoolean(int columnIndex) throws SQLException {
                    String type = this._columnTypes.elementAt(--columnIndex).toString();
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return false;
                    }
                    if (type.equalsIgnoreCase("INT")) {
                        int i = Integer.parseInt(data);
                        return i != 0;
                    }
                    if (type.equalsIgnoreCase("BOOLEAN")) {
                        return new Boolean(data);
                    }
                    throw new SQLException("Can not convert " + type + " to boolean!");
                }

                public boolean getBoolean(String columnName) throws SQLException {
                    Integer index = (Integer)this._map.get(columnName);
                    if (index == null) {
                        throw new SQLException("Column name " + columnName + " not found!");
                    }
                    String type = this._columnTypes.elementAt(index).toString();
                    String data = this.getString(columnName);
                    if (data == null) {
                        return false;
                    }
                    if (type.equalsIgnoreCase("INT")) {
                        int i = Integer.parseInt(data);
                        return i != 0;
                    }
                    if (type.equalsIgnoreCase("BOOLEAN")) {
                        return new Boolean(data);
                    }
                    throw new SQLException("Can not convert " + type + " to boolean!");
                }

                public byte getByte(int columnIndex) throws SQLException {
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return 0;
                    }
                    return new Byte(data);
                }

                public byte getByte(String columnName) throws SQLException {
                    String data = this.getString(columnName);
                    if (data == null) {
                        return 0;
                    }
                    return new Byte(data);
                }

                public byte[] getBytes(int columnIndex) throws SQLException {
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return null;
                    }
                    return data.getBytes();
                }

                public byte[] getBytes(String columnName) throws SQLException {
                    String data = this.getString(columnName);
                    if (data == null) {
                        return null;
                    }
                    return data.getBytes();
                }

                public Reader getCharacterStream(int columnIndex) throws SQLException {
                    return null;
                }

                public Reader getCharacterStream(String columnName) throws SQLException {
                    return null;
                }

                public Clob getClob(int i) throws SQLException {
                    return null;
                }

                public Clob getClob(String colName) throws SQLException {
                    return null;
                }

                public int getConcurrency() throws SQLException {
                    return 1007;
                }

                public String getCursorName() throws SQLException {
                    return null;
                }

                public Date getDate(int columnIndex) throws SQLException {
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return null;
                    }
                    return new Date(new java.util.Date(data).getTime());
                }

                public Date getDate(int columnIndex, Calendar cal) throws SQLException {
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return null;
                    }
                    return new Date(new java.util.Date(data).getTime());
                }

                public Date getDate(String columnName) throws SQLException {
                    String data = this.getString(columnName);
                    if (data == null) {
                        return null;
                    }
                    return new Date(new java.util.Date(data).getTime());
                }

                public Date getDate(String columnName, Calendar cal) throws SQLException {
                    String data = this.getString(columnName);
                    if (data == null) {
                        return null;
                    }
                    return new Date(new java.util.Date(data).getTime());
                }

                public double getDouble(int columnIndex) throws SQLException {
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return 0.0;
                    }
                    return new Double(data);
                }

                public double getDouble(String columnName) throws SQLException {
                    String data = this.getString(columnName);
                    if (data == null) {
                        return 0.0;
                    }
                    return new Double(data);
                }

                public int getFetchDirection() throws SQLException {
                    return 1003;
                }

                public int getFetchSize() throws SQLException {
                    return 1;
                }

                public float getFloat(int columnIndex) throws SQLException {
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return 0.0f;
                    }
                    return new Float(data).floatValue();
                }

                public float getFloat(String columnName) throws SQLException {
                    String data = this.getString(columnName);
                    if (data == null) {
                        return 0.0f;
                    }
                    return new Float(data).floatValue();
                }

                public int getInt(int columnIndex) throws SQLException {
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return 0;
                    }
                    return Integer.parseInt(data);
                }

                public int getInt(String columnName) throws SQLException {
                    String data = this.getString(columnName);
                    if (data == null) {
                        return 0;
                    }
                    return Integer.parseInt(data);
                }

                public long getLong(int columnIndex) throws SQLException {
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return 0L;
                    }
                    return new Long(data);
                }

                public long getLong(String columnName) throws SQLException {
                    String data = this.getString(columnName);
                    if (data == null) {
                        return 0L;
                    }
                    return new Long(data);
                }

                public ResultSetMetaData getMetaData() throws SQLException {
                    return new SQLDResultSetMetaData();
                }

                public Object getObject(int columnIndex) throws SQLException {
                    return null;
                }

                public Object getObject(int i, Map map) throws SQLException {
                    return null;
                }

                public Object getObject(String columnName) throws SQLException {
                    return null;
                }

                public Object getObject(String colName, Map map) throws SQLException {
                    return null;
                }

                public Ref getRef(int i) throws SQLException {
                    return null;
                }

                public Ref getRef(String colName) throws SQLException {
                    return null;
                }

                public int getRow() throws SQLException {
                    return 0;
                }

                public short getShort(int columnIndex) throws SQLException {
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return 0;
                    }
                    return new Short(data);
                }

                public short getShort(String columnName) throws SQLException {
                    String data = this.getString(columnName);
                    if (data == null) {
                        return 0;
                    }
                    return new Short(data);
                }

                public Statement getStatement() throws SQLException {
                    return this._s;
                }

                public String getString(int columnIndex) throws SQLException {
                    --columnIndex;
                    if (this._line == null) {
                        throw new SQLException("No current row!");
                    }
                    Object o = this._line.elementAt(columnIndex);
                    String s = (String)o;
                    if (s.compareTo("") == 0) {
                        this._wasNull = true;
                        return null;
                    }
                    this._wasNull = false;
                    return s;
                }

                public String getString(String columnName) throws SQLException {
                    if (this._line == null) {
                        throw new SQLException("No current row!");
                    }
                    Object o = this._map.get(columnName.toLowerCase().trim());
                    if (o == null) {
                        throw new SQLException("Column name: \"" + columnName + "\" not found!");
                    }
                    Integer i = (Integer)o;
                    String s = (String)(o = this._line.elementAt(i));
                    if (s.compareTo("") == 0) {
                        this._wasNull = true;
                        return null;
                    }
                    this._wasNull = false;
                    return s;
                }

                public Time getTime(int columnIndex) throws SQLException {
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return null;
                    }
                    return new Time(new java.util.Date(data).getTime());
                }

                public Time getTime(int columnIndex, Calendar cal) throws SQLException {
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return null;
                    }
                    return new Time(new java.util.Date(data).getTime());
                }

                public Time getTime(String columnName) throws SQLException {
                    String data = this.getString(columnName);
                    if (data == null) {
                        return null;
                    }
                    return new Time(new java.util.Date(data).getTime());
                }

                public Time getTime(String columnName, Calendar cal) throws SQLException {
                    String data = this.getString(columnName);
                    if (data == null) {
                        return null;
                    }
                    return new Time(new java.util.Date(data).getTime());
                }

                public Timestamp getTimestamp(int columnIndex) throws SQLException {
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return null;
                    }
                    return new Timestamp(new java.util.Date(data).getTime());
                }

                public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
                    String data = this.getString(columnIndex);
                    if (data == null) {
                        return null;
                    }
                    return new Timestamp(new java.util.Date(data).getTime());
                }

                public Timestamp getTimestamp(String columnName) throws SQLException {
                    String data = this.getString(columnName);
                    if (data == null) {
                        return null;
                    }
                    return new Timestamp(new java.util.Date(data).getTime());
                }

                public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
                    String data = this.getString(columnName);
                    if (data == null) {
                        return null;
                    }
                    return new Timestamp(new java.util.Date(data).getTime());
                }

                public int getType() throws SQLException {
                    return 1003;
                }

                public InputStream getUnicodeStream(int columnIndex) throws SQLException {
                    return null;
                }

                public InputStream getUnicodeStream(String columnName) throws SQLException {
                    return null;
                }

                public SQLWarning getWarnings() throws SQLException {
                    return null;
                }

                public void insertRow() throws SQLException {
                }

                public boolean isAfterLast() throws SQLException {
                    return false;
                }

                public boolean isBeforeFirst() throws SQLException {
                    return false;
                }

                public boolean isFirst() throws SQLException {
                    return false;
                }

                public boolean isLast() throws SQLException {
                    return false;
                }

                public boolean last() throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void moveToCurrentRow() throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void moveToInsertRow() throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public boolean next() throws SQLException {
                    try {
                        this._ps.println("next;");
                        this._ps.flush();
                        String res = SQLDConnection.this._getResponse(this._br);
                        if (res.compareTo("END") == 0) {
                            return false;
                        }
                        return this._readRec();
                    }
                    catch (IOException ioe) {
                        throw new SQLException(ioe.getMessage());
                    }
                }

                public boolean previous() throws SQLException {
                    throw new SQLException("Only forward traversals of the result set can be made!");
                }

                public void refreshRow() throws SQLException {
                }

                public boolean relative(int rows) throws SQLException {
                    if (rows < 0) {
                        throw new SQLException("Only forward traversals of the result set can be made!");
                    }
                    int i = 0;
                    while (i < rows) {
                        if (!this.next()) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }

                public boolean rowDeleted() throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public boolean rowInserted() throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public boolean rowUpdated() throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void setFetchDirection(int direction) throws SQLException {
                }

                public void setFetchSize(int rows) throws SQLException {
                }

                public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateBoolean(int columnIndex, boolean x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateBoolean(String columnName, boolean x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateByte(int columnIndex, byte x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateByte(String columnName, byte x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateBytes(int columnIndex, byte[] x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateBytes(String columnName, byte[] x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateDate(int columnIndex, Date x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateDate(String columnName, Date x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateDouble(int columnIndex, double x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateDouble(String columnName, double x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateFloat(int columnIndex, float x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateFloat(String columnName, float x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateInt(int columnIndex, int x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateInt(String columnName, int x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateLong(int columnIndex, long x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateLong(String columnName, long x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateNull(int columnIndex) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateNull(String columnName) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateObject(int columnIndex, Object x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateObject(String columnName, Object x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateObject(String columnName, Object x, int scale) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateRow() throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateShort(int columnIndex, short x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateShort(String columnName, short x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateString(int columnIndex, String x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateString(String columnName, String x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateTime(int columnIndex, Time x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateTime(String columnName, Time x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
                    throw new SQLException("Not implemented!");
                }

                public boolean wasNull() throws SQLException {
                    return this._wasNull;
                }

                private class SQLDResultSetMetaData
                implements ResultSetMetaData {
                    private SQLDResultSetMetaData() {
                    }

                    public String getCatalogName(int column) throws SQLException {
                        return SQLDConnection.this._currCat;
                    }

                    public String getColumnClassName(int column) throws SQLException {
                        return "java.lang.String";
                    }

                    public int getColumnCount() throws SQLException {
                        return SQLDResultSet.this._columnNames.size();
                    }

                    public int getColumnDisplaySize(int column) throws SQLException {
                        return 1024;
                    }

                    public String getColumnLabel(int column) throws SQLException {
                        return (String)SQLDResultSet.this._columnNames.elementAt(--column);
                    }

                    public String getColumnName(int column) throws SQLException {
                        return (String)SQLDResultSet.this._columnNames.elementAt(--column);
                    }

                    public int getColumnType(int column) throws SQLException {
                        String type = (String)SQLDResultSet.this._columnTypes.elementAt(--column);
                        if (type.equalsIgnoreCase("INT")) {
                            return 4;
                        }
                        if (type.equalsIgnoreCase("TEXT")) {
                            return 12;
                        }
                        if (type.equalsIgnoreCase("FLOAT")) {
                            return 7;
                        }
                        if (type.equalsIgnoreCase("BOOLEAN")) {
                            return 4;
                        }
                        throw new SQLException("Unknown type!");
                    }

                    public String getColumnTypeName(int column) throws SQLException {
                        return (String)SQLDResultSet.this._columnTypes.elementAt(column);
                    }

                    public int getPrecision(int column) throws SQLException {
                        return -1;
                    }

                    public int getScale(int column) throws SQLException {
                        return -1;
                    }

                    public String getSchemaName(int column) throws SQLException {
                        return null;
                    }

                    public String getTableName(int column) throws SQLException {
                        return null;
                    }

                    public boolean isAutoIncrement(int column) throws SQLException {
                        return false;
                    }

                    public boolean isCaseSensitive(int column) throws SQLException {
                        return false;
                    }

                    public boolean isCurrency(int column) throws SQLException {
                        return SQLDResultSet.this._columnTypes.elementAt(--column).toString().equalsIgnoreCase("FLOAT");
                    }

                    public boolean isDefinitelyWritable(int column) throws SQLException {
                        return false;
                    }

                    public int isNullable(int column) throws SQLException {
                        return 1;
                    }

                    public boolean isReadOnly(int column) throws SQLException {
                        return true;
                    }

                    public boolean isSearchable(int column) throws SQLException {
                        return true;
                    }

                    public boolean isSigned(int column) throws SQLException {
                        String type = (String)SQLDResultSet.this._columnTypes.elementAt(column);
                        return type.equalsIgnoreCase("INT") || type.equalsIgnoreCase("FLOAT");
                    }

                    public boolean isWritable(int column) throws SQLException {
                        return false;
                    }
                }
            }
        }

        class SQLDDatabaseMetaData
        implements DatabaseMetaData {
            private Connection _connection;

            SQLDDatabaseMetaData(Connection connnection) {
                this._connection = connnection;
            }

            public boolean allProceduresAreCallable() throws SQLException {
                return false;
            }

            public boolean allTablesAreSelectable() throws SQLException {
                return true;
            }

            public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
                return true;
            }

            public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
                return true;
            }

            public boolean deletesAreDetected(int type) throws SQLException {
                return false;
            }

            public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
                return false;
            }

            public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public ResultSet getCatalogs() throws SQLException {
                ResultSet resultSet;
                Statement s;
                block3: {
                    s = this._connection.createStatement();
                    String catalog = this._connection.getCatalog();
                    this._connection.setCatalog("MasterDB");
                    try {
                        resultSet = s.executeQuery("SELECT name AS TABLE_CAT FROM Databases");
                        Object var5_4 = null;
                        if (catalog == null) break block3;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (catalog != null) {
                            this._connection.setCatalog(catalog);
                        }
                        s.close();
                        throw throwable;
                    }
                    this._connection.setCatalog(catalog);
                }
                s.close();
                return resultSet;
            }

            public String getCatalogSeparator() throws SQLException {
                return ".";
            }

            public String getCatalogTerm() throws SQLException {
                return "catalog";
            }

            public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public Connection getConnection() throws SQLException {
                return this._connection;
            }

            public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public String getDatabaseProductName() throws SQLException {
                return "SQLD";
            }

            public String getDatabaseProductVersion() throws SQLException {
                return SQLDDriver.VERSION;
            }

            public int getDefaultTransactionIsolation() throws SQLException {
                return 0;
            }

            public int getDriverMajorVersion() {
                return 2;
            }

            public int getDriverMinorVersion() {
                return 0;
            }

            public String getDriverName() throws SQLException {
                return "SQLD JDBC Driver";
            }

            public String getDriverVersion() throws SQLException {
                return SQLDDriver.VERSION;
            }

            public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public String getExtraNameCharacters() throws SQLException {
                return "";
            }

            public String getIdentifierQuoteString() throws SQLException {
                return "\"";
            }

            public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public int getMaxBinaryLiteralLength() throws SQLException {
                return 0;
            }

            public int getMaxCatalogNameLength() throws SQLException {
                return 0;
            }

            public int getMaxCharLiteralLength() throws SQLException {
                return 0;
            }

            public int getMaxColumnNameLength() throws SQLException {
                return 0;
            }

            public int getMaxColumnsInGroupBy() throws SQLException {
                return 0;
            }

            public int getMaxColumnsInIndex() throws SQLException {
                return 0;
            }

            public int getMaxColumnsInOrderBy() throws SQLException {
                return 0;
            }

            public int getMaxColumnsInSelect() throws SQLException {
                return 0;
            }

            public int getMaxColumnsInTable() throws SQLException {
                return 0;
            }

            public int getMaxConnections() throws SQLException {
                return 0;
            }

            public int getMaxCursorNameLength() throws SQLException {
                return 0;
            }

            public int getMaxIndexLength() throws SQLException {
                return 0;
            }

            public int getMaxProcedureNameLength() throws SQLException {
                return 0;
            }

            public int getMaxRowSize() throws SQLException {
                return 0;
            }

            public int getMaxSchemaNameLength() throws SQLException {
                return 0;
            }

            public int getMaxStatementLength() throws SQLException {
                return 0;
            }

            public int getMaxStatements() throws SQLException {
                return 0;
            }

            public int getMaxTableNameLength() throws SQLException {
                return 0;
            }

            public int getMaxTablesInSelect() throws SQLException {
                return 0;
            }

            public int getMaxUserNameLength() throws SQLException {
                return 0;
            }

            public String getNumericFunctions() throws SQLException {
                return "";
            }

            public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public String getProcedureTerm() throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public ResultSet getSchemas() throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public String getSchemaTerm() throws SQLException {
                return "schema";
            }

            public String getSearchStringEscape() throws SQLException {
                return "\\";
            }

            public String getSQLKeywords() throws SQLException {
                return "CURRENT,DATABASE";
            }

            public String getStringFunctions() throws SQLException {
                return "LEFT,RIGHT,SOUNDEX,CONCAT,SUBSTRING";
            }

            public String getSystemFunctions() throws SQLException {
                return "";
            }

            public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
                ResultSet resultSet;
                String oldCatalog = this._connection.getCatalog();
                this._connection.setCatalog(catalog);
                try {
                    ResultSet rs;
                    Statement s = this._connection.createStatement();
                    if (catalog != null) {
                        catalog = "'" + SQLEncoder.encode(catalog) + "'";
                    }
                    String sql = "SELECT '" + SQLEncoder.encode(catalog) + "' AS TABLE_CAT, " + "NULL AS TABLE_SCHEM, " + "TableName AS TABLE_NAME, " + "'TABLE' AS TABLE_TYPE, " + "'None' AS REMARKS " + "FROM Master " + "WHERE UNIQUE('TableName', TableName) ";
                    if (tableNamePattern != null) {
                        sql = sql + "AND ColumnName LIKE '" + SQLEncoder.encode(tableNamePattern) + "' ";
                    }
                    sql = sql + "ORDER BY TABLE_NAME";
                    resultSet = rs = s.executeQuery(sql);
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    this._connection.setCatalog(oldCatalog);
                    throw throwable;
                }
                this._connection.setCatalog(oldCatalog);
                return resultSet;
            }

            public ResultSet getTableTypes() throws SQLException {
                Statement s = this._connection.createStatement();
                String sql = "SELECT 'TABLE' AS TABLE_TYPE";
                ResultSet rs = s.executeQuery(sql);
                return rs;
            }

            public String getTimeDateFunctions() throws SQLException {
                return "";
            }

            public ResultSet getTypeInfo() throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public String getURL() throws SQLException {
                return SQLDConnection.this._url;
            }

            public String getUserName() throws SQLException {
                return SQLDConnection.this._username;
            }

            public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
                throw new SQLException("Not implemented!");
            }

            public boolean insertsAreDetected(int type) throws SQLException {
                return false;
            }

            public boolean isCatalogAtStart() throws SQLException {
                return true;
            }

            public boolean isReadOnly() throws SQLException {
                return false;
            }

            public boolean nullPlusNonNullIsNull() throws SQLException {
                return true;
            }

            public boolean nullsAreSortedAtEnd() throws SQLException {
                return false;
            }

            public boolean nullsAreSortedAtStart() throws SQLException {
                return true;
            }

            public boolean nullsAreSortedHigh() throws SQLException {
                return true;
            }

            public boolean nullsAreSortedLow() throws SQLException {
                return false;
            }

            public boolean othersDeletesAreVisible(int type) throws SQLException {
                return true;
            }

            public boolean othersInsertsAreVisible(int type) throws SQLException {
                return true;
            }

            public boolean othersUpdatesAreVisible(int type) throws SQLException {
                return true;
            }

            public boolean ownDeletesAreVisible(int type) throws SQLException {
                return true;
            }

            public boolean ownInsertsAreVisible(int type) throws SQLException {
                return true;
            }

            public boolean ownUpdatesAreVisible(int type) throws SQLException {
                return true;
            }

            public boolean storesLowerCaseIdentifiers() throws SQLException {
                return false;
            }

            public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
                return false;
            }

            public boolean storesMixedCaseIdentifiers() throws SQLException {
                return true;
            }

            public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
                return true;
            }

            public boolean storesUpperCaseIdentifiers() throws SQLException {
                return false;
            }

            public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
                return false;
            }

            public boolean supportsAlterTableWithAddColumn() throws SQLException {
                return false;
            }

            public boolean supportsAlterTableWithDropColumn() throws SQLException {
                return false;
            }

            public boolean supportsANSI92EntryLevelSQL() throws SQLException {
                return true;
            }

            public boolean supportsANSI92FullSQL() throws SQLException {
                return false;
            }

            public boolean supportsANSI92IntermediateSQL() throws SQLException {
                return false;
            }

            public boolean supportsBatchUpdates() throws SQLException {
                return false;
            }

            public boolean supportsCatalogsInDataManipulation() throws SQLException {
                return false;
            }

            public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
                return false;
            }

            public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
                return false;
            }

            public boolean supportsCatalogsInProcedureCalls() throws SQLException {
                return false;
            }

            public boolean supportsCatalogsInTableDefinitions() throws SQLException {
                return false;
            }

            public boolean supportsColumnAliasing() throws SQLException {
                return true;
            }

            public boolean supportsConvert() throws SQLException {
                return false;
            }

            public boolean supportsConvert(int fromType, int toType) throws SQLException {
                return false;
            }

            public boolean supportsCoreSQLGrammar() throws SQLException {
                return false;
            }

            public boolean supportsCorrelatedSubqueries() throws SQLException {
                return true;
            }

            public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
                return false;
            }

            public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
                return false;
            }

            public boolean supportsDifferentTableCorrelationNames() throws SQLException {
                return false;
            }

            public boolean supportsExpressionsInOrderBy() throws SQLException {
                return false;
            }

            public boolean supportsExtendedSQLGrammar() throws SQLException {
                return false;
            }

            public boolean supportsFullOuterJoins() throws SQLException {
                return false;
            }

            public boolean supportsGroupBy() throws SQLException {
                return false;
            }

            public boolean supportsGroupByBeyondSelect() throws SQLException {
                return false;
            }

            public boolean supportsGroupByUnrelated() throws SQLException {
                return false;
            }

            public boolean supportsIntegrityEnhancementFacility() throws SQLException {
                return false;
            }

            public boolean supportsLikeEscapeClause() throws SQLException {
                return true;
            }

            public boolean supportsLimitedOuterJoins() throws SQLException {
                return false;
            }

            public boolean supportsMinimumSQLGrammar() throws SQLException {
                return true;
            }

            public boolean supportsMixedCaseIdentifiers() throws SQLException {
                return false;
            }

            public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
                return false;
            }

            public boolean supportsMultipleResultSets() throws SQLException {
                return false;
            }

            public boolean supportsMultipleTransactions() throws SQLException {
                return false;
            }

            public boolean supportsNonNullableColumns() throws SQLException {
                return false;
            }

            public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
                return false;
            }

            public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
                return false;
            }

            public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
                return false;
            }

            public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
                return false;
            }

            public boolean supportsOrderByUnrelated() throws SQLException {
                return true;
            }

            public boolean supportsOuterJoins() throws SQLException {
                return false;
            }

            public boolean supportsPositionedDelete() throws SQLException {
                return false;
            }

            public boolean supportsPositionedUpdate() throws SQLException {
                return false;
            }

            public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
                return concurrency == 1007 && type == 1003;
            }

            public boolean supportsResultSetType(int type) throws SQLException {
                return type == 1003;
            }

            public boolean supportsSchemasInDataManipulation() throws SQLException {
                return false;
            }

            public boolean supportsSchemasInIndexDefinitions() throws SQLException {
                return false;
            }

            public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
                return false;
            }

            public boolean supportsSchemasInProcedureCalls() throws SQLException {
                return false;
            }

            public boolean supportsSchemasInTableDefinitions() throws SQLException {
                return false;
            }

            public boolean supportsSelectForUpdate() throws SQLException {
                return false;
            }

            public boolean supportsStoredProcedures() throws SQLException {
                return false;
            }

            public boolean supportsSubqueriesInComparisons() throws SQLException {
                return false;
            }

            public boolean supportsSubqueriesInExists() throws SQLException {
                return false;
            }

            public boolean supportsSubqueriesInIns() throws SQLException {
                return true;
            }

            public boolean supportsSubqueriesInQuantifieds() throws SQLException {
                return false;
            }

            public boolean supportsTableCorrelationNames() throws SQLException {
                return false;
            }

            public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
                return level == 0;
            }

            public boolean supportsTransactions() throws SQLException {
                return false;
            }

            public boolean supportsUnion() throws SQLException {
                return false;
            }

            public boolean supportsUnionAll() throws SQLException {
                return false;
            }

            public boolean updatesAreDetected(int type) throws SQLException {
                return false;
            }

            public boolean usesLocalFilePerTable() throws SQLException {
                return true;
            }

            public boolean usesLocalFiles() throws SQLException {
                return true;
            }
        }
    }
}

