/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.server;

import com.mwc.sqld.SQLParser;
import com.mwc.sqld.db.Curser;
import com.mwc.sqld.db.DBException;
import com.mwc.sqld.db.Database;
import com.mwc.sqld.db.DatabaseFactory;
import com.mwc.sqld.db.DatabaseImplManager;
import com.mwc.sqld.db.SQLExpression;
import com.mwc.sqld.db.SQLFunctions;
import com.mwc.sqld.db.Table;
import com.mwc.sqld.db.UserContext;
import com.mwc.util.ThreadPool;
import cryptix.provider.Cryptix;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class sqld
implements Runnable {
    private ServerSocket _svr;
    private Properties _props;
    private Hashtable _databaseTable;
    private Database _masterDB;
    private Hashtable _resultsTable;
    private Hashtable _resultsSourceTable = new Hashtable();
    private ThreadPool _threadPool;

    private void _debug(String msg) {
        System.out.println(msg);
    }

    public sqld(String propFileName) throws Exception {
        String name;
        this._resultsTable = new Hashtable();
        FileInputStream fin = new FileInputStream(propFileName);
        BufferedInputStream bin = new BufferedInputStream(fin);
        this._props = new Properties();
        this._props.load(bin);
        fin.close();
        this._svr = new ServerSocket(Integer.parseInt(this._props.getProperty("server.port")), Integer.parseInt(this._props.getProperty("server.backlog")), InetAddress.getByName(this._props.getProperty("server.bindAddress")));
        this._databaseTable = new Hashtable();
        int n = Integer.parseInt(this._props.getProperty("database.impl.n"));
        int i = 1;
        while (i <= n) {
            name = this._props.getProperty("database.impl." + i + ".name");
            String className = this._props.getProperty("database.impl." + i + ".class");
            Class<?> clazz = Class.forName(className);
            DatabaseImplManager.registerImpl(name, clazz);
            ++i;
        }
        n = Integer.parseInt(this._props.getProperty("database.n"));
        int i2 = 1;
        while (i2 <= n) {
            name = this._props.getProperty("database." + i2 + ".name");
            name = name.toLowerCase();
            String dir = this._props.getProperty("database." + i2 + ".dir");
            String type = this._props.getProperty("database." + i2 + ".type");
            type.toLowerCase();
            this._debug("LOADING-DATABASE(" + name + "," + dir + "," + type + ")");
            Database db = DatabaseFactory.getDatabase(type, name, dir);
            if (db == null) {
                throw new DBException("Unable to load database:\n   Database type: " + type + "\n   For database: " + name + "\n   In directory: " + dir);
            }
            this._databaseTable.put(name, db);
            ++i2;
        }
        this._masterDB = (Database)this._databaseTable.get("masterdb");
        if (this._masterDB == null) {
            throw new DBException("No master database found!");
        }
        this._threadPool = new ThreadPool(Integer.parseInt(this._props.getProperty("server.threadPool.min")), Integer.parseInt(this._props.getProperty("server.threadPool.max")), new Long(this._props.getProperty("server.threadPool.timeout")), Integer.parseInt(this._props.getProperty("server.threadPool.maxQueue")));
    }

    public void run() {
        new StatThread().start();
        while (true) {
            try {
                Socket client = this._svr.accept();
                HandlerTask task = new HandlerTask(client);
                this._threadPool.postTaskForExecution(task);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void stop() {
        Enumeration enumeration;
        this._threadPool.stop();
        try {
            this._svr.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Hashtable hashtable = this._databaseTable;
        synchronized (hashtable) {
            enumeration = this._databaseTable.keys();
            while (enumeration.hasMoreElements()) {
                Database db = (Database)this._databaseTable.get(enumeration.nextElement());
                db.close();
            }
            this._databaseTable = new Hashtable();
        }
        Hashtable hashtable2 = this._resultsTable;
        synchronized (hashtable2) {
            enumeration = this._resultsTable.keys();
            while (enumeration.hasMoreElements()) {
                Object o = this._resultsTable.get(enumeration.nextElement());
                if (o instanceof Curser) {
                    ((Curser)o).close();
                }
                o.notify();
            }
            this._resultsTable = new Hashtable();
        }
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new Cryptix());
        if (args.length != 1) {
            System.err.println("Usage: com.mwc.sqld.server.sqld <properties file name>");
            System.exit(1);
        }
        try {
            sqld svr = new sqld(args[0]);
            svr.run();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private class StatThread
    extends Thread {
        private StatThread() {
        }

        public void run() {
            while (true) {
                System.out.println(sqld.this._threadPool.getStats().toString());
                try {
                    Thread.sleep(2000L);
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    class HandlerTask
    implements Runnable {
        private String _username;
        private Socket _sock;
        private boolean _killSwitch = false;
        private Object _killLock = new Object();

        private void _killThread() {
            Object object = this._killLock;
            synchronized (object) {
                this._killSwitch = true;
            }
        }

        private boolean _killed() {
            Object object = this._killLock;
            synchronized (object) {
                boolean bl = this._killSwitch;
                return bl;
            }
        }

        HandlerTask(Socket client) {
            this._sock = client;
        }

        /*
         * WARNING - void declaration
         */
        String readCommand(InputStream in) throws IOException {
            int ch;
            StringBuffer buffer = new StringBuffer();
            while ((ch = in.read()) >= 0) {
                void var3_3;
                buffer.append((char)var3_3);
                if (var3_3 == 59) break;
            }
            if (ch < 0) {
                return null;
            }
            return buffer.toString();
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block28: {
                block22: {
                    block27: {
                        block21: {
                            block26: {
                                block20: {
                                    block25: {
                                        block19: {
                                            ctx = null;
                                            try {
                                                try {
                                                    in = this._sock.getInputStream();
                                                    bin = new BufferedInputStream(in);
                                                    out = this._sock.getOutputStream();
                                                    bout = new BufferedOutputStream(out);
                                                    printer = new PrintStream(bout);
                                                    ctx = new SQLDContext(printer, bin);
                                                    printer.println("Authentication");
                                                    printer.flush();
                                                    this._username = this.readCommand(bin);
                                                    if (this._username == null) {
                                                        var14_8 = null;
                                                        break block19;
                                                    }
                                                    this._username = this._username.trim();
                                                    this._username = this._username.substring(0, this._username.length() - 1);
                                                    password = this.readCommand(bin);
                                                    if (password == null) {
                                                        break block20;
                                                    }
                                                    password = password.trim();
                                                    password = password.substring(0, password.length() - 1);
                                                    password = SQLFunctions.crypt("76", password);
                                                    users = sqld.access$400(sqld.this).getTable("Users");
                                                    curser = users.getNewCurser();
                                                    found = false;
                                                    while (curser.next()) {
                                                        if (curser.getValue("username").compareTo(this._username) != 0) continue;
                                                        if (curser.getValue("password").compareTo(password) != 0) break;
                                                        found = true;
                                                        break;
                                                    }
                                                    curser.close();
                                                    if (!found) {
                                                        break block21;
                                                    }
                                                    printer.println("OK");
                                                    printer.flush();
                                                    while (!this._killed() && (cmd = this.readCommand(bin)) != null) {
                                                        try {
                                                            SQLParser.parseStatement((String)var7_24, ctx);
                                                            if (!ctx.exited()) continue;
                                                            break block22;
                                                        }
                                                        catch (Throwable th) {
                                                            th.printStackTrace();
                                                            printer.println("ERROR");
                                                            printer.println(th.getMessage());
                                                            printer.println();
                                                            printer.println("~~~END-OF-ERROR-MESSAGE~~~");
                                                            printer.flush();
                                                        }
                                                    }
                                                    break block22;
                                                }
                                                catch (Throwable throwable) {
                                                    throwable.printStackTrace();
                                                    var14_12 = null;
                                                    try {
                                                        this._sock.close();
                                                    }
                                                    catch (IOException ioe) {
                                                        // empty catch block
                                                    }
                                                    if (ctx == null) return;
                                                    db = ctx.currentDatabase();
                                                    if (db == null) return;
                                                    db.sync();
                                                    if (db.modified() == false) return;
                                                    db.save();
                                                    return;
                                                }
                                            }
                                            catch (Throwable var13_26) {
                                                block24: {
                                                    var14_13 = null;
                                                    ** try [egrp 3[TRYBLOCK] [3 : 394->404)] { 
lbl77:
                                                    // 1 sources

                                                    this._sock.close();
                                                    break block24;
lbl79:
                                                    // 1 sources

                                                    catch (IOException ioe) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (ctx == null) throw var13_26;
                                                db = ctx.currentDatabase();
                                                if (db == null) throw var13_26;
                                                db.sync();
                                                if (db.modified() == false) throw var13_26;
                                                db.save();
                                                throw var13_26;
                                            }
                                        }
                                        ** try [egrp 3[TRYBLOCK] [3 : 394->404)] { 
lbl92:
                                        // 1 sources

                                        this._sock.close();
                                        break block25;
lbl94:
                                        // 1 sources

                                        catch (IOException ioe) {
                                            // empty catch block
                                        }
                                    }
                                    if (ctx == null) return;
                                    db = ctx.currentDatabase();
                                    if (db == null) return;
                                    db.sync();
                                    if (db.modified() == false) return;
                                    db.save();
                                    return;
                                }
                                var14_9 = null;
                                ** try [egrp 3[TRYBLOCK] [3 : 394->404)] { 
lbl108:
                                // 1 sources

                                this._sock.close();
                                break block26;
lbl110:
                                // 1 sources

                                catch (IOException ioe) {
                                    // empty catch block
                                }
                            }
                            if (ctx == null) return;
                            db = ctx.currentDatabase();
                            if (db == null) return;
                            db.sync();
                            if (db.modified() == false) return;
                            db.save();
                            return;
                        }
                        var14_10 = null;
                        ** try [egrp 3[TRYBLOCK] [3 : 394->404)] { 
lbl124:
                        // 1 sources

                        this._sock.close();
                        break block27;
lbl126:
                        // 1 sources

                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    if (ctx == null) return;
                    db = ctx.currentDatabase();
                    if (db == null) return;
                    db.sync();
                    if (db.modified() == false) return;
                    db.save();
                    return;
                }
                var14_11 = null;
                ** try [egrp 3[TRYBLOCK] [3 : 394->404)] { 
lbl140:
                // 1 sources

                this._sock.close();
                break block28;
lbl142:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (ctx == null) return;
            db = ctx.currentDatabase();
            if (db == null) return;
            db.sync();
            if (db.modified() == false) return;
            db.save();
        }

        public class SQLDContext
        implements UserContext {
            private Database _db = null;
            private boolean _exited = false;
            private PrintStream _printer;
            private boolean _read = false;
            private boolean _write = false;
            private BufferedInputStream _bin;

            private SQLDContext(PrintStream printer, BufferedInputStream bin) {
                this._printer = printer;
                this._bin = bin;
            }

            public ThreadPool threadPool() {
                return sqld.this._threadPool;
            }

            public String readLine() {
                try {
                    return HandlerTask.this.readCommand(this._bin);
                }
                catch (IOException ioe) {
                    return null;
                }
            }

            public String username() {
                return HandlerTask.this._username;
            }

            public Database currentDatabase() {
                return this._db;
            }

            public boolean changeCurrentDatabase(String dbName) {
                String dbname = dbName.toLowerCase();
                Object o = sqld.this._databaseTable.get(dbname);
                if (o == null) {
                    return false;
                }
                Table access = sqld.this._masterDB.getTable("Access");
                Curser curser = access.getNewCurser();
                boolean hasAccess = false;
                String lowUN = HandlerTask.this._username.toLowerCase();
                while (curser.next()) {
                    if (!SQLExpression.like(lowUN, curser.getValue("username").toLowerCase()) || !SQLExpression.like(dbname, curser.getValue("dbname").toLowerCase())) continue;
                    String r = curser.getValue("readAccess");
                    String w = curser.getValue("writeAccess");
                    if (!r.equalsIgnoreCase("true") && !w.equalsIgnoreCase("true")) break;
                    hasAccess = true;
                    this._read = new Boolean(r);
                    this._write = new Boolean(w);
                    break;
                }
                curser.close();
                if (!hasAccess) {
                    return false;
                }
                this._db = (Database)o;
                return true;
            }

            public String getNextResultSetID() {
                String key;
                boolean found;
                String choices = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
                do {
                    StringBuffer keyBuf = new StringBuffer();
                    keyBuf.append('A');
                    int i = 0;
                    while (i < 49) {
                        keyBuf.append(choices.charAt((int)(Math.random() * 100000.0) % choices.length()));
                        ++i;
                    }
                    key = keyBuf.toString();
                    Hashtable hashtable = sqld.this._resultsTable;
                    synchronized (hashtable) {
                        if (sqld.this._resultsTable.get(key) == null) {
                            found = false;
                            sqld.this._resultsTable.put(key, new Object());
                            Hashtable hashtable2 = sqld.this._resultsSourceTable;
                            synchronized (hashtable2) {
                                sqld.this._resultsSourceTable.put(key, this._db.name());
                            }
                        } else {
                            found = true;
                        }
                    }
                } while (found);
                return key;
            }

            public void registerResults(String id, Object results) {
                Object ref = null;
                Hashtable hashtable = sqld.this._resultsTable;
                synchronized (hashtable) {
                    ref = sqld.this._resultsTable.put(id, results);
                }
                if (ref != null) {
                    Object object = ref;
                    synchronized (object) {
                        ref.notify();
                    }
                }
            }

            public boolean exited() {
                return this._exited;
            }

            public void exit() {
                this._exited = true;
            }

            public PrintStream out() {
                return this._printer;
            }

            public boolean readAccess() {
                return this._read;
            }

            public boolean writeAccess() {
                return this._write;
            }

            public Object acquireResults(String id) {
                Object ref;
                Hashtable hashtable;
                boolean found;
                String dbname;
                Hashtable hashtable2 = sqld.this._resultsSourceTable;
                synchronized (hashtable2) {
                    dbname = (String)sqld.this._resultsSourceTable.get(id);
                }
                if (dbname == null) {
                    return null;
                }
                Table access = sqld.this._masterDB.getTable("Access");
                Curser curser = access.getNewCurser();
                boolean hasAccess = false;
                String lowUN = HandlerTask.this._username.toLowerCase();
                while (curser.next()) {
                    if (!SQLExpression.like(lowUN, curser.getValue("username").toLowerCase()) || !SQLExpression.like(dbname, curser.getValue("dbname").toLowerCase())) continue;
                    String r = curser.getValue("readAccess");
                    if (!r.equalsIgnoreCase("true")) break;
                    hasAccess = true;
                    break;
                }
                curser.close();
                if (!hasAccess) {
                    return null;
                }
                do {
                    found = false;
                    hashtable = sqld.this._resultsTable;
                    synchronized (hashtable) {
                        ref = sqld.this._resultsTable.get(id);
                    }
                    if (ref == null) {
                        return null;
                    }
                    if (ref instanceof Exception) {
                        found = true;
                        continue;
                    }
                    if (ref instanceof Curser) {
                        found = true;
                        continue;
                    }
                    Object v = ref;
                    synchronized (v) {
                        try {
                            ref.wait();
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                } while (!found);
                hashtable = sqld.this._resultsTable;
                synchronized (hashtable) {
                    sqld.this._resultsTable.remove(id);
                }
                Hashtable hashtable3 = sqld.this._resultsSourceTable;
                synchronized (hashtable3) {
                    sqld.this._resultsSourceTable.remove(id);
                }
                return ref;
            }
        }
    }
}

