/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.LiteralElement;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.Pattern;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.Stylesheet;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.TopLevelElement;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

public final class Template
extends TopLevelElement {
    private QName _name;
    private QName _mode;
    private Pattern _pattern;
    private double _priority;
    private int _position;
    private boolean _disabled = false;
    private boolean _compiled = false;
    private boolean _hasVariableFrame;
    private boolean _hasParams = false;
    private boolean _simplified = false;
    private Hashtable _variables;
    private int _nextIndex;
    private Stylesheet _stylesheet = null;

    public boolean hasParams() {
        return this._hasParams;
    }

    public void hasParams(boolean hasParams) {
        this._hasParams = hasParams;
    }

    public boolean isSimplified() {
        return this._simplified;
    }

    public void setSimplified() {
        this._simplified = true;
    }

    public void disable() {
        this._disabled = true;
    }

    public boolean disabled() {
        return this._disabled;
    }

    public double getPriority() {
        return this._priority;
    }

    public int getPosition() {
        return this._position;
    }

    public boolean isNamed() {
        return this._name != null;
    }

    public Pattern getPattern() {
        return this._pattern;
    }

    public QName getName() {
        return this._name;
    }

    public void setName(QName qname) {
        if (this._name == null) {
            this._name = qname;
        }
    }

    public QName getModeName() {
        return this._mode;
    }

    public int compareTo(Object template) {
        Template other = (Template)template;
        if (this._priority > other._priority) {
            return 1;
        }
        if (this._priority < other._priority) {
            return -1;
        }
        if (this._position > other._position) {
            return 1;
        }
        if (this._position < other._position) {
            return -1;
        }
        return 0;
    }

    public int allocateIndex(QName varName) {
        if (this._variables == null) {
            this._hasVariableFrame = true;
            this._variables = new Hashtable<QName, Integer>();
            this._variables.put(varName, new Integer(0));
            this._nextIndex = 1;
            return 0;
        }
        Integer index = (Integer)this._variables.get(varName);
        if (index == null) {
            index = new Integer(this._nextIndex++);
            this._variables.put(varName, index);
        }
        return index;
    }

    private final int localVariablesCount() {
        return this._variables == null ? 0 : this._variables.size();
    }

    public void display(int indent) {
        Util.println('\n');
        this.indent(indent);
        if (this._name != null) {
            this.indent(indent);
            Util.println("name = " + this._name);
        } else if (this._pattern != null) {
            this.indent(indent);
            Util.println("match = " + this._pattern.toString());
        }
        if (this._mode != null) {
            this.indent(indent);
            Util.println("mode = " + this._mode);
        }
        this.displayContents(indent + 4);
    }

    private boolean resolveNamedTemplates(Template other, Parser parser2) {
        int them;
        if (other == null) {
            return true;
        }
        SymbolTable stable = parser2.getSymbolTable();
        int us = this.getImportPrecedence();
        if (us > (them = other.getImportPrecedence())) {
            other.disable();
            return true;
        }
        if (us < them) {
            stable.addTemplate(other);
            this.disable();
            return true;
        }
        return false;
    }

    public Stylesheet getStylesheet() {
        return this._stylesheet;
    }

    public void parseContents(Parser parser2) {
        Template other;
        String name = this.getAttribute("name");
        String mode = this.getAttribute("mode");
        String match = this.getAttribute("match");
        String priority = this.getAttribute("priority");
        this._stylesheet = super.getStylesheet();
        if (name.length() > 0) {
            this._name = parser2.getQName(name);
        }
        if (mode.length() > 0) {
            this._mode = parser2.getQName(mode);
        }
        if (match.length() > 0) {
            this._pattern = parser2.parsePattern(this, "match", null);
        }
        this._priority = priority.length() > 0 ? Double.parseDouble(priority) : (this._pattern != null ? this._pattern.getPriority() : Double.NaN);
        this._position = parser2.getTemplateIndex();
        if (this._name != null && !this.resolveNamedTemplates(other = parser2.getSymbolTable().addTemplate(this), parser2)) {
            ErrorMsg err = new ErrorMsg(1, (Object)this._name, this);
            parser2.reportError(3, err);
        }
        parser2.setTemplate(this);
        this.parseChildren(parser2);
        parser2.setTemplate(null);
    }

    public void parseSimplified(Stylesheet stylesheet, Parser parser2) {
        this._stylesheet = stylesheet;
        this.setParent(stylesheet);
        this._name = null;
        this._mode = null;
        this._priority = Double.NaN;
        this._pattern = parser2.parsePattern(this, "/");
        Vector contents = this._stylesheet.getContents();
        SyntaxTreeNode root = (SyntaxTreeNode)contents.elementAt(0);
        if (root instanceof LiteralElement) {
            this.addElement(root);
            root.setParent(this);
            contents.set(0, this);
            parser2.setTemplate(this);
            root.parseContents(parser2);
            parser2.setTemplate(null);
        }
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        if (this._pattern != null) {
            this._pattern.typeCheck(stable);
        }
        return this.typeCheckContents(stable);
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (this._disabled) {
            return;
        }
        String className = classGen.getClassName();
        if (this._compiled && this.isNamed()) {
            String methodName = Util.escape(this._name.toString());
            il.append(classGen.loadTranslet());
            il.append(methodGen.loadDOM());
            il.append(methodGen.loadIterator());
            il.append(methodGen.loadHandler());
            il.append(methodGen.loadCurrentNode());
            il.append(new INVOKEVIRTUAL(cpg.addMethodref(className, methodName, "(Lorg/apache/xalan/xsltc/DOM;Lorg/apache/xalan/xsltc/NodeIterator;Lorg/apache/xalan/xsltc/TransletOutputHandler;I)V")));
            return;
        }
        if (this._compiled) {
            return;
        }
        this._compiled = true;
        if (this._hasVariableFrame) {
            il.append(classGen.loadTranslet());
            il.append(new PUSH(cpg, this.localVariablesCount()));
            il.append(new INVOKEVIRTUAL(cpg.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "pushVarFrame", "(I)V")));
        }
        InstructionHandle start = il.getEnd();
        this.translateContents(classGen, methodGen);
        InstructionHandle end = il.getEnd();
        il.setPositions(true);
        if (this._hasVariableFrame) {
            il.append(classGen.loadTranslet());
            il.append(new INVOKEVIRTUAL(cpg.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "popVarFrame", "()V")));
        }
    }
}

