/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime;

import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.TransletOutputHandler;
import org.apache.xalan.xsltc.dom.DOMBuilder;
import org.apache.xalan.xsltc.runtime.AttributeList;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.runtime.Hashtable;
import org.xml.sax.SAXException;

public final class SAXAdapter
implements TransletOutputHandler {
    private final DOMBuilder _domBuilder;
    private final AttributeList _attributes = new AttributeList();
    private String _openElementName;

    public SAXAdapter(DOMBuilder domBuilder) {
        this._domBuilder = domBuilder;
    }

    private void maybeEmitStartElement() throws SAXException {
        if (this._openElementName != null) {
            this._domBuilder.startElement(null, null, this._openElementName, this._attributes);
            this._openElementName = null;
        }
    }

    public void startDocument() throws TransletException {
        try {
            this._domBuilder.startDocument();
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void endDocument() throws TransletException {
        try {
            this._domBuilder.endDocument();
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void characters(char[] characters, int offset, int length) throws TransletException {
        try {
            this.maybeEmitStartElement();
            this._domBuilder.characters(characters, offset, length);
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void startElement(String elementName) throws TransletException {
        try {
            this.maybeEmitStartElement();
            this._openElementName = elementName;
            this._attributes.clear();
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void endElement(String elementName) throws TransletException {
        try {
            this.maybeEmitStartElement();
            this._domBuilder.endElement(null, null, elementName);
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void attribute(String name, String value) throws TransletException {
        if (this._openElementName != null) {
            this._attributes.add(name, value);
        } else {
            BasisLibrary.runTimeError(10, name);
        }
    }

    public void namespace(String prefix, String uri) throws TransletException {
    }

    public void comment(String comment) throws TransletException {
        try {
            this.maybeEmitStartElement();
            if (this._domBuilder != null) {
                char[] chars = comment.toCharArray();
                this._domBuilder.comment(chars, 0, chars.length);
            }
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void processingInstruction(String target, String data) throws TransletException {
        try {
            this.maybeEmitStartElement();
            this._domBuilder.processingInstruction(target, data);
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public boolean setEscaping(boolean escape) throws TransletException {
        return this._domBuilder.setEscaping(escape);
    }

    public void setType(int type) {
    }

    public void setHeader(String header) {
    }

    public void setIndent(boolean indent) {
    }

    public void omitHeader(boolean value) {
    }

    public void setCdataElements(Hashtable elements) {
    }

    public void close() {
    }

    public String getPrefix(String uri) {
        return "";
    }
}

