/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.ParentNode;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EntityReferenceImpl
extends ParentNode
implements EntityReference {
    static final long serialVersionUID = -7381452955687102062L;
    protected String name;

    public EntityReferenceImpl(CoreDocumentImpl ownerDoc, String name) {
        super(ownerDoc);
        this.name = name;
        this.isReadOnly(true);
        this.needsSyncChildren(true);
    }

    public short getNodeType() {
        return 5;
    }

    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public Node cloneNode(boolean deep) {
        EntityReferenceImpl er = (EntityReferenceImpl)super.cloneNode(deep);
        er.setReadOnly(true, deep);
        return er;
    }

    protected void synchronizeChildren() {
        NamedNodeMap entities;
        this.needsSyncChildren(false);
        DocumentType doctype = this.getOwnerDocument().getDoctype();
        if (null != doctype && null != (entities = doctype.getEntities())) {
            EntityImpl entDef = (EntityImpl)entities.getNamedItem(this.getNodeName());
            if (entDef == null) {
                return;
            }
            this.isReadOnly(false);
            Node defkid = entDef.getFirstChild();
            while (defkid != null) {
                Node newkid = defkid.cloneNode(true);
                this.insertBefore(newkid, null);
                defkid = defkid.getNextSibling();
            }
            this.setReadOnly(true, true);
        }
    }
}

