package com.mwc.sqld.db;
      
import java.io.*;

import com.mwc.util.*;

public class CSVCurser implements Curser {
   private File _file;
   private CSVFileReader _csvReader;
   private String _cols[][];
   private int _recCount;
   private boolean _doDelete = true;
   private ReadWriteLock _rwLock = null;
      
   public CSVCurser(File f,
                    String cols[][],
                    int recCount)
   throws IOException {
      _file = f;
      _csvReader  = new CSVFileReader(f.getAbsolutePath(), true);
      _csvReader.open();
      _cols = cols;
      _recCount = recCount;
   }

   public CSVCurser(File f,
                    String cols[][],
                    int recCount,
                    ReadWriteLock rwLock)
   throws IOException {
      _file = f;
      _csvReader  = new CSVFileReader(f.getAbsolutePath(), true);
      _csvReader.open();
      _cols = cols;
      _recCount = recCount;
      _rwLock = rwLock;
      _rwLock.readLock();
   }
   
   public void noDeleteOnClose() {
      _doDelete = false;
   }
   
   public String[][] cols() {
      return _cols;
   }

   public int size() {
      return _cols.length;
   }
      
   public boolean reset() {
      try {
         _csvReader.close();
         _csvReader.open();
         return true;
      }
      catch(IOException ioe) {
         return false;
      }
   }
   
   public boolean next() {
      try {
         return _csvReader.readLine();
      }
      catch(IOException ioe) {
         return false;
      }
   }
   
   public String getValue(String colName) {
      return _csvReader.getValue(colName);
   }
   
   public String getValue(int index) {
      return _csvReader.getValue(index);
   }
      
   public String getType(String colName) {
      for(int i = 0; i < _cols.length; i++) {
         if(colName.equalsIgnoreCase(_cols[i][0])) {
            return _cols[i][1];
         }
      }
      return null;
   }
      
   public boolean close() {
      try {
         if(_rwLock != null)
            _rwLock.readUnlock();
         _csvReader.close();
         if(_doDelete)
            _file.delete();
         return true;
      }
      catch(IOException ioe) {
         return false;
      }
   }
      
   public int recCount() {
      return _recCount;
   }
}