package com.mwc.sqld.db;

import java.io.*;
import java.util.*;

public interface Database {
   Table createTable(String name, String cols[][]);
   Curser select(Curser data[], Criteria c, LinkedList colList) throws DBException;
   int insert(LinkedList tables, LinkedList colList, LinkedList values) throws DBException;
   int delete(UpdateCurser data[], Criteria c) throws DBException;
   int update(UpdateCurser data[], LinkedList setList, Criteria c) throws DBException;
   String name();
   File getTempFile();
   Table getTable(String table);
   String[] tableNames();
   boolean dropTable(String table);
   boolean save();
   boolean modified();
   void sync();
   void close();
   Sorter getNewSorter();
}