package com.mwc.sqld.db;

import java.io.*;
import java.util.*;

import com.mwc.util.*;

public class MasterTable implements Table {
   private File _masterFile;
   private static String _cols[][] = new String[][] 
                                { 
                                {"TableName", "VARCHAR(256)"},
                                {"ColumnName", "VARCHAR(256)"},
                                {"ColumnType", "VARCHAR(256)"},
                                {"NotNull", "BOOLEAN"}
                                };
   private ReadWriteLock _rwLock = new ReadWriteLock();
   
   public MasterTable(File masterFile) {
      _masterFile = masterFile;
      if(!_masterFile.exists()) {
         try {
            FileOutputStream fout = new FileOutputStream(_masterFile);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            PrintStream out = new PrintStream(bout);
            out.println("\"TableName\",\"ColumnName\",\"ColumnType\",\"NotNull\"");
            out.flush();
            fout.close();
         }
         catch(Throwable th) {
            ;
         }
      }
   }
   
   public String[][] loadCols(String forTableName) {
      Curser c = getNewCurser();
      try {
         Table t;
         String tableName, columnName, columnType, notNull;
         String temp;
         String cols[][];
         LinkedList names, types, nns;
         int i;
         while(c.next()) {
            tableName = c.getValue("TableName");
            if(!tableName.equalsIgnoreCase(forTableName))
               continue;
            names = new LinkedList();
            types = new LinkedList();
            nns = new LinkedList();
            while(true) {
               columnName = c.getValue("ColumnName");
               names.add(columnName);
               columnType = c.getValue("ColumnType");
               types.add(columnType);
               notNull = c.getValue("NotNull");
               nns.add(notNull);
               if(!c.next())
                  break;
               temp = c.getValue("TableName");
               if(!tableName.equalsIgnoreCase(temp))
                  break;
            }
                     
            cols = new String[names.size()][3];
            for(i = 0; i < cols.length; i++) {
               cols[i][0] = (String)names.get(i);
               cols[i][1] = (String)types.get(i);
               cols[i][2] = (String)nns.get(i);
            }
            return cols;
         }
         return null;
      }
      finally {
         if(c != null)
            c.close();
      }
   }
   
   public String name() {
      return "Master";
   }
   
   public void saveState(String dataDirectory, Hashtable tables)
   throws IOException {
      _rwLock.writeLock();
      try {
         FileOutputStream fout = new FileOutputStream(dataDirectory + "/data.dat");
         BufferedOutputStream bout = new BufferedOutputStream(fout);
         PrintWriter out = new PrintWriter(bout);
            

         out.println("\"TableName\",\"ColumnName\",\"ColumnType\",\"NotNull\"");
         out.flush();
         Enumeration vals = tables.elements();
         Table t;
         String [][] cols;
         int index;
         while(vals.hasMoreElements()) {
            t = (Table)vals.nextElement();
            cols = t.cols();
            for(index = 0; index < cols.length; index++) {
               out.println("\"" + CSVEncoder.encode(t.name()) + "\","
                           +"\"" + CSVEncoder.encode(cols[index][0]) + "\","
                           +"\"" + CSVEncoder.encode(cols[index][1]) + "\","
                           +"\"" + CSVEncoder.encode(cols[index][2]) + "\"");
               out.flush();
            }
         }
         fout.close();
      }
      finally {
         _rwLock.writeUnlock();
      }
   }
   
   public Curser getNewCurser() {
      try {
         CSVCurser csvCurser = new CSVCurser(_masterFile, _cols, -1, _rwLock);
         csvCurser.noDeleteOnClose();
         return csvCurser;
      }
      catch(IOException ioe) {
         return null;
      }
   }
   
   public boolean insert(LinkedList values) {
      if(values.size() != _cols.length) 
         return false;
      try {
         _rwLock.writeLock();
         try {
            FileOutputStream fout = new FileOutputStream(_masterFile.getAbsolutePath(),
                                                         true);
            PrintStream out = new PrintStream(new BufferedOutputStream(fout));
            StringBuffer buffer = new StringBuffer();
            String value;
            Iterator it = values.iterator();
            while(it.hasNext()) {
               value = (String)it.next();
               if(buffer.length() != 0)
                  buffer.append(",");
               buffer.append("\""+CSVEncoder.encode(value)+"\"");
            }
            out.println(buffer.toString());
            out.flush();
            fout.close();
         }
         finally {
            _rwLock.writeUnlock();
         }
         return true;
      }
      catch(Throwable th) {
         return false;
      }
   }
   
   public boolean drop() {
      return false;
   }
   
   public String[][] cols() {
      return _cols;
   }
}