package com.mwc.sqld.db;

import java.util.*;

public class NormalInsertEngine implements InsertEngine {
   
   private LinkedList _normailizeValueList(Table tbl, LinkedList colList, LinkedList values)
   throws DBException {
      String [][]cols = tbl.cols();
      LinkedList insertList = new LinkedList();
      boolean found;
      String temp;
      Object o;
      if(colList == null) {
         Iterator it = values.iterator();
         for(int i = 0; i < cols.length; i++) {
            temp = values.get(i).toString();
            o = SQLDataTranslator.toData(temp, cols[i][1]);
            if(o == null)
               throw new DBException("Insert value does not match table type!");
            if(o.equals("") && cols[i][2].equalsIgnoreCase("true"))
               throw new DBException("NULL not allowed for column \"" + cols[i][0] + "\"!");
            insertList.add(o.toString());
         }
         return insertList;
      }
      for(int i = 0; i < cols.length; i++) {
	        found = false;
         for(int j = 0; j < colList.size(); j++) {
            if(cols[i][0].equalsIgnoreCase(colList.get(j).toString())) {
               temp = values.get(j).toString();
               o = SQLDataTranslator.toData(temp, cols[i][1]);
               if(o == null)
                  throw new DBException("Insert value does not match table type!");
               if(o.equals("") && cols[i][2].equalsIgnoreCase("true"))
                  throw new DBException("NULL not allowed for column \"" + colList.get(j).toString() + "\"!");
               insertList.add(o.toString());
               found = true;
               break;
            }
         }
         if(!found && cols[i][2].equalsIgnoreCase("true"))
            throw new DBException("NULL not allowed for column \"" + cols[i][3] + "\"!");
         if(!found)
            insertList.add("");
	     }
      return insertList;
   }
   
   public int insert(Database db, 
                     LinkedList tables, 
                     LinkedList colList,
                     LinkedList values) 
   throws DBException {
      String name;
      Table tbl;
      Iterator it = tables.iterator();
      while(it.hasNext()) {
         name = it.next().toString();
         tbl = db.getTable(name);
         if(tbl == null || (!tbl.insert(_normailizeValueList(tbl, colList, values))))
            throw new DBException("Unable to insert into table: " + name);
      }
      return tables.size();      
   }
}