package com.mwc.sqld.db;

public class SQLDataTranslator {
   public static Object toData(String data, String type)
   throws DBException {
      if(data == null || type == null)
         return null;
      if(data.compareTo("''") == 0)
         return "";
      if(type.equalsIgnoreCase("INT")) {
         try {
            return new Integer(data);
         }
         catch(Throwable th) {
            return null;
         }
      }
      else if(type.startsWith("FLOAT")) {
         try {
            return new Double(data);
         }
         catch(NumberFormatException nfe) {
            return null;
         }
      }
      else if(type.startsWith("CHAR")) {
         if(data.length() > 0 && data.charAt(0) == '\'')
            data = data.substring(1, data.length()-1);         
         int i = type.indexOf('(');
         if(i >= 0) {
            i = Integer.parseInt(type.substring(i+1, type.length()-1));
            if(data.length() < i) {
               StringBuffer buffer = new StringBuffer(i);
               buffer.append(data);
               while(buffer.length() < i)
                  buffer.append(' ');
               data = buffer.toString();
            }
         }
         return data;
      }
      else if(type.startsWith("VARCHAR")
              || type.equalsIgnoreCase("TEXT")) {
         if(data.length() > 0 && data.charAt(0) == '\'')
            data = data.substring(1, data.length()-1);         
         return data;
      }
      else if(type.equalsIgnoreCase("BOOLEAN")) {
         if(data.equalsIgnoreCase("true"))
            return new Boolean(true);
         else if(data.equalsIgnoreCase("false"))
            return new Boolean(false);
         else
            return null;
      }      
      else
         throw new DBException("Bad type \"" + type + "\"!");
   }
}