package com.mwc.sqld.db;

import java.util.*;

public class SQLValueLookupComparator implements ValueLookupComparator {
   private LinkedList _orderByList;
   private boolean _asc;
   
   public SQLValueLookupComparator(LinkedList orderByList, boolean asc) {
      _orderByList = orderByList;
      _asc = asc;
   }
   
   private int _compare(int i, ValueLookup vl0, ValueLookup vl1)
   throws DBException {
      String colName = (String)_orderByList.get(i);
      String v0 = vl0.getType(colName);
      String v1 = vl1.getType(colName);
      if(v0 == null || v1 == null)
         throw new DBException("Column " + colName + " not found!");
      Object o0 = SQLDataTranslator.toData(vl0.getValue(colName), v0);
      Object o1 = SQLDataTranslator.toData(vl1.getValue(colName), v1);
      if(o0 == null 
         || o1 == null 
         || !(o0 instanceof Comparable
              && o1 instanceof Comparable)
         || (o0.getClass() != o1.getClass())) {
         throw new DBException("Can only sort on comparable fields of the same type!");
      }
      if(o0 instanceof String
         && o1 instanceof String) {
         o0 = o0.toString().toLowerCase();
         o1 = o1.toString().toLowerCase();
      }
      int rc = ((Comparable)o0).compareTo(o1);
      if(rc != 0 || (i+1) >= _orderByList.size()) {
         if(_asc)
            return rc;
         else
            return -rc;
      }
      return _compare(i+1, vl0, vl1);
   }
   
   public int compare(ValueLookup vl0, ValueLookup vl1)
   throws DBException {
      return _compare(0, vl0, vl1);
   }
}