package com.mwc.sqld.db;

import java.util.*;

public abstract class SimpleDatabase implements Database {
   public Curser select(Curser data[], Criteria c, LinkedList colList) 
   throws DBException {
      return new CSVSelectEngine().select(this, data, c, colList);
   }
   
   public int insert(LinkedList tables, LinkedList colList, LinkedList values)
   throws DBException {
      return new NormalInsertEngine().insert(this, tables, colList, values);
   }
   
   public int delete(UpdateCurser data[], Criteria c) 
   throws DBException {
      return new SimpleDeleteEngine().delete(data, c);
   }

   public int update(UpdateCurser data[], LinkedList setList, Criteria c)
   throws DBException {
      return new SimpleUpdateEngine().update(data, setList, c);
   }
   
   public Sorter getNewSorter() {
      return new TwoWayMergeSort(this);
   }
}