package com.mwc.sqld.db;

import java.io.*;
import java.util.*;

import com.mwc.util.*;

public class TextDatabase extends SimpleDatabase {
   private String _name;
   private String _dataDirectory;
   private Hashtable _tables = new Hashtable();
   private long _currentTemp = 0;
   private Object _tempLock = new Object();
   private boolean _mod = false;
   private Object _modLock = new Object();
   private MasterTable _masterTable;
      
   public void close() {
      ;
   }
      
   private String _getNextTemp() {
      synchronized(_tempLock) {
         String ret = "TEMP"+_currentTemp;
         _currentTemp++;
         return ret;
      }
   }
   
   public File getTempFile() {
      File f;
      synchronized(_tempLock) {
         String tempFileName =  _dataDirectory + "/temp/";
         f = new File(tempFileName);
         if(!f.exists())
            f.mkdirs();
         String choice = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
         StringBuffer buf;
         do {
            buf = new StringBuffer();
            for(int i = 0; i < 50; i++)
               buf.append(choice.charAt((int)(Math.random() * 1000000000) % choice.length()));
            f = new File(tempFileName + buf.toString());
         }
         while(f.exists());
         try {
            FileOutputStream fout = new FileOutputStream(f);
            fout.close();
         }
         catch(IOException ioe) {
            return null;
         }
      }
      return f;
   }
   
   class TextCurser implements Curser {
      private CSVFileReader _csvReader;
      private ReadWriteLock _tblReadWriteLock;
      private String _cols[][];
      private String _name;
      
      private TextCurser(CSVFileReader csvReader,
                         ReadWriteLock tblReadWriteLock,
                         String cols[][],
                         String name) {
         _csvReader  = csvReader;
         _tblReadWriteLock = tblReadWriteLock;
         _cols = cols;
         _name = name;
      }

      public String[][] cols() {
         return _cols;
      }

      public int size() {
         return _cols.length;
      }
      
      public boolean reset() {
         try {
            _csvReader.close();
            _csvReader.open();
            return true;
         }
         catch(IOException ioe) {
            return false;
         }
      }
   
      public boolean next() {
         try {
            return _csvReader.readLine();
         }
         catch(IOException ioe) {
            return false;
         }
      }
   
      public String getValue(String colName) {
         int i = colName.indexOf('.');
         if(i < 0) 
            return _csvReader.getValue(colName);
         else {
            String tblName = colName.substring(0,i);
            if(tblName.equalsIgnoreCase(_name)) {
               colName = colName.substring(i+1);
               return _csvReader.getValue(colName);
            }
            else
               return null;
         }
      }
      
      public String getValue(int index) {
         return _csvReader.getValue(index);
      }
   
      public String getType(String colName) {
         int i = colName.indexOf('.');
         if(i >= 0) {
            String tblName = colName.substring(0,i);
            if(!tblName.equalsIgnoreCase(_name))
               return null;
            colName = colName.substring(i+1);
         }
         for(i = 0; i < _cols.length; i++) {
            if(colName.equalsIgnoreCase(_cols[i][0])) {
               return _cols[i][1];
            }
         }
         return null;
      }
      
      public boolean close() {
         try {
            _csvReader.close();
            _tblReadWriteLock.readUnlock();
            return true;
         }
         catch(IOException ioe) {
            return false;
         }
      }
      
      public int recCount() { 
         return -1; 
      }
   }
   
   class TextTable implements Table {
      private ReadWriteLock _rwLock;
      private String _fileName;
      private String _name;
      private String _cols[][];
            
      private TextTable(String name, String fileName, String cols[][])
      throws IOException {
         _rwLock = new ReadWriteLock();
         _name = name;
         _fileName = fileName;
         _cols = cols;
         File f = new File(fileName);
         if(!f.exists()) {
            FileOutputStream fout = new FileOutputStream(fileName);
            PrintWriter out = new PrintWriter(new BufferedOutputStream(fout));
            StringBuffer buffer = new StringBuffer();
            for(int i = 0; i < cols.length; i++) {
               if(buffer.length() != 0)
                  buffer.append(",");
               buffer.append("\""+ cols[i][0] + "\"");
            }
            out.println(buffer.toString());
            out.flush();
            fout.close();
         }
      }
      
      public String[][] cols() {
         return _cols;
      }
      
      public String name() {
         return _name;
      }
            
      public Curser getNewCurser() {
         _rwLock.readLock();
         TextCurser tc = new TextCurser(new CSVFileReader(_fileName, true), 
                                        _rwLock,
                                        _cols,
                                        _name);
         try {
            tc._csvReader.open();
         }
         catch(IOException ioe) {
            return null;
         }
         return tc;
      }
            
      public boolean insert(LinkedList values) {
         if(values.size() != _cols.length) 
            return false;
         try {
            _rwLock.writeLock();
            try {
               FileOutputStream fout = new FileOutputStream(_fileName, true);
               PrintStream out = new PrintStream(new BufferedOutputStream(fout));
               StringBuffer buffer = new StringBuffer();
               String value;
               Iterator it = values.iterator();
               while(it.hasNext()) {
                  value = (String)it.next();
                  if(buffer.length() != 0)
                     buffer.append(",");
                  buffer.append("\""+CSVEncoder.encode(value)+"\"");
               }
               out.println(buffer.toString());
               out.flush();
               fout.close();
               synchronized(_modLock) {
                  _mod = true;
               }
            }
            finally {
               _rwLock.writeUnlock();
            }
            return true;
         }
         catch(Throwable th) {
            return false;
         }
      }
      
      private class CSVValueLookup implements ValueLookup {
         private CSVFileReader _csv;
         private String _cols[][];
            
         CSVValueLookup(CSVFileReader csv,
                        String cols[][]) {
            _csv = csv;
            _cols = cols;
         }
         
         public String[][] cols() {
            return _cols;
         }
 
         public int size() {
            return _cols.length;
         }
         
         public String getValue(String name) {
            return _csv.getValue(name);
         }
         public String getValue(int index) {
            return _csv.getValue(index);
         }

         public String getType(String name) {
            for(int i = 0; i < _cols.length; i++) {
               if(_cols[i][0].equalsIgnoreCase(name)) {
                  return _cols[i][1];
               }
            }
            return null;
         }
      }
            
      public boolean drop() {
         _rwLock.writeLock();
         return new File(_fileName).delete();         
      }
   }
   
   
   
   public TextDatabase(String name, String dataDirectory)
   throws Exception {
      _name = name;
      _dataDirectory = dataDirectory;
      File f = new File(_dataDirectory);
      if(!f.exists())
         f.mkdir();
      f = new File(_dataDirectory + "/data.dat");
      if(f.exists()) {
         _masterTable = new MasterTable(f);
         Curser c = _masterTable.getNewCurser();
         try {
            Table t;
            String tableName, tableFileName, lastTableName = "";
            String cols[][];
            int i;
            while(c.next()) {
               tableName = c.getValue("TableName");
               if(!lastTableName.equalsIgnoreCase(tableName)) {
                  cols = _masterTable.loadCols(tableName);
                  lastTableName = tableName;
                  tableFileName = _dataDirectory + "/" + tableName + ".csv";
                           
System.out.println("LOAD-TABLE("+tableName+")");                           
                  t = new TextTable(tableName, tableFileName, cols);
                  _tables.put(t.name().toLowerCase(), t);
               }
            }
         }
         finally {
            if(c != null)
               c.close();
         }
      }
   }
   
   public Table createTable(String name, String cols[][]) {
      try {
         Table tbl = getTable(name);
         if(tbl != null)
            return null;
         String fileName = _dataDirectory + "/" + name + ".csv";
         tbl = new TextTable(name, 
                             fileName, 
                             cols);
         synchronized(_tables) {
            _tables.put(name.toLowerCase(), tbl);
         }
         synchronized(_modLock) {
            _mod = true;
         }
         return tbl;
      }
      catch(IOException ioe) {
         return null;
      }
   }
   
   public String name() {
      return _name;
   }
   
   public Table getTable(String table) {
      if(table.equalsIgnoreCase("Master"))
         return _masterTable;
      synchronized(_tables) {
         return (Table)_tables.get(table.toLowerCase());
      }
   }
   
   public String[] tableNames() {
      synchronized(_tables) {
         String ret[] = new String[_tables.size()];
         Enumeration e = _tables.elements();
         int i = 0;
         while(e.hasMoreElements()) {
            ret[i] = ((Table)e.nextElement()).name();
            i++;
         }
         return ret;
      }
   }
   
   public boolean dropTable(String table) {
      Table tbl;
      table = table.toLowerCase();
      synchronized(_tables) {
         tbl = (Table)_tables.get(table);
         if(tbl == null)
            return false;
         _tables.remove(table);
      }
      synchronized(_modLock) {
         _mod = true;
      }
      return tbl.drop();
   }
   
   public boolean save() {
      try {
         _masterTable.saveState(_dataDirectory, _tables);
         synchronized(_modLock) {
            _mod = false;
         }
      }
      catch(Throwable throwable) {
         return false;
      }
      return true;
   }
   
   public void sync() {
      ;
   }
   
   public boolean modified() {
      synchronized(_modLock) {
         return _mod;
      }
   }
}