package com.mwc.sqld.db;

import java.util.*;
import java.io.*;

import com.mwc.util.*;

public class TwoWayMergeSort implements Sorter {
   private Database _db;
   
   public class SortCurser implements Curser {
      private File _file;
      private CSVFileReader _csvReader;
      private String _cols[][];
      private int _recCount;
      private boolean _eof = false;
      private PrintWriter _out = null;
      
      public SortCurser(File f,
                       String cols[][],
                       int recCount)
      throws IOException {
         _file = f;
         StringBuffer buf = new StringBuffer();
         for(int i = 0; i < cols.length; i++) {
            if(buf.length() != 0)
               buf.append(",");
            buf.append("\"" + CSVEncoder.encode(cols[i][0]) + "\"");
         }
         FileOutputStream fout = new FileOutputStream(_file.getAbsolutePath());
         BufferedOutputStream bout = new BufferedOutputStream(fout);
         PrintWriter out = new PrintWriter(bout);
         out.println(buf.toString());
         out.flush();
         fout.close();
         _csvReader  = new CSVFileReader(f.getAbsolutePath(), true);
         _csvReader.open();
         _cols = cols;
         _recCount = recCount;
      }
      
      public String[][] cols() {
         return _cols;
      }

      public int size() {
         return _cols.length;
      }
      
      public boolean reset() {
         if(_out != null) {
            _out.flush();
            _out.close();
            _out = null;
         }
         try {
            if(_csvReader != null) {
               _csvReader.close();
               _csvReader.open();
            }
            else {
               _csvReader  = new CSVFileReader(_file.getAbsolutePath(), true);
               _csvReader.open();
            }
            _eof = false;
            return true;
         }
         catch(IOException ioe) {
            return false;
         }
      }
   
      public boolean put(ValueLookup c) {
         StringBuffer buf;
         int i;
         buf = new StringBuffer();
         for(i = 0; i < c.size(); i++) {
            if(buf.length() != 0)
               buf.append(",");
            buf.append("\"" + CSVEncoder.encode(c.getValue(i)) + "\"");
         }
            
         return put(buf.toString());
      }
      
      public boolean put(String rec) {
         return put(rec, true);
      }
      
      public boolean put(String rec, boolean append) {
         try {                        
            if(append == false)
               _recCount = 0;
            if(_out == null) {
               FileOutputStream fout = new FileOutputStream(_file.getAbsolutePath(), append);
               BufferedOutputStream bout = new BufferedOutputStream(fout);
               _out = new PrintWriter(bout);
            }
            _out.println(rec);
            _out.flush();
            
            _eof = false;
            
            _recCount++;
            return true;
         }
         catch(IOException ioe) {
            return false;
         }
      }

      public boolean next() {
         try {
            _eof = !_csvReader.readLine();            
            return !_eof;
         }
         catch(IOException ioe) {
            return false;
         }
      }
   
      public String getValue(String colName) {
         return _csvReader.getValue(colName);
      }
   
      public String getValue(int index) {
         return _csvReader.getValue(index);
      }
      
      public String getType(String colName) {
         for(int i = 0; i < _cols.length; i++) {
            if(colName.equalsIgnoreCase(_cols[i][0])) {
               return _cols[i][1];
            }
         }
         return null;
      }
      
      public boolean close() {
         try {
            if(_csvReader != null)
               _csvReader.close();
            if(_out != null) {
               _out.flush();
               _out.close();
            }
            _file.delete();
            _eof = false;
            return true;
         }
         catch(IOException ioe) {
            return false;
         }
      }
      
      public int recCount() {
         return _recCount;
      }
      
      private boolean rewrite() {
         try {
            if(_csvReader != null) 
               _csvReader.close();
            _csvReader = null;
            _eof = false;
            StringBuffer buf = new StringBuffer();
            for(int i = 0; i < _cols.length; i++) {
               if(buf.length() != 0)
                  buf.append(",");
               buf.append("\"" + CSVEncoder.encode(_cols[i][0]) + "\"");
            }
            return put(buf.toString(), false);
         }
         catch(IOException ioe) {
            return false;
         }
      }
      
      public boolean eof() {
         return _eof;
      }
   }
   
   class TempValueLookup implements ValueLookup {
      private Hashtable _tbl = new Hashtable();
      private String _array[];
      private String _cols[][];
      
      public TempValueLookup(Curser c) {
         _array = new String[c.size()];
         _cols = c.cols();
         for(int i = 0; i < _cols.length; i++) {
            _array[i] = c.getValue(i);
            _tbl.put(_cols[i][0].toLowerCase(), new Integer(i));
         } 
      }
      
      public String getValue(String name) {
         Integer i = (Integer)_tbl.get(name.toLowerCase());
         if(i == null)
            return null;
         return _array[i.intValue()];
      }
      
      public String getValue(int index) {
         return _array[index];
      }
      
      public String getType(String name) {
         for(int i = 0; i < _cols.length; i++) {
            if(name.equalsIgnoreCase(_cols[i][0]))
               return _cols[i][1];
         }
         return null;
      }
      
      public int size() {
         return _cols.length;
      }
      
      public String[][] cols() {
         return _cols;
      }
   }
   
   private void _mergeRuns(SortCurser c0, 
                           SortCurser c1,
                           ValueLookup acurrent0[],
                           ValueLookup acurrent1[],
                           ValueLookupComparator cp,
                           SortCurser out)
   throws IOException, DBException {
      ValueLookup prev0, prev1;
      boolean done0, done1;
      ValueLookup current0 = acurrent0[0];
      ValueLookup current1 = acurrent1[0];
      
      done0 = c0.eof();
      
      done1 = c1.eof();
      while((!done0) && (!done1)) {
         if(cp.compare(current0, current1) < 0) {
            prev0 = current0;
            out.put(current0);
            c0.next();
            current0 = new TempValueLookup(c0);
            if(c0.eof())
               done0 = true;
            else 
               done0 = cp.compare(current0, prev0) < 0;
         }
         else {
            prev1 = current1;
            out.put(current1);
            
            c1.next();
            current1 = new TempValueLookup(c1);
            if(c1.eof())
               done1 = true;
            else
               done1 = cp.compare(current1, prev1) < 0;
         }
      }
      if(done0) {
         while(!done1) {
            prev1 = current1;
            out.put(current1);
 
            c1.next();
            current1 = new TempValueLookup(c1);
            if(c1.eof())
               done1 = true;
            else
               done1 = cp.compare(current1, prev1) < 0;
         }
      }
      else {
         while(!done0) {
            prev0 = current0;
            out.put(current0);

            c0.next();
            current0 = new TempValueLookup(c0);
            if(c0.eof())
               done0 = true;
            else
               done0 = cp.compare(current0, prev0) < 0;
         }
      }
      
      acurrent0[0] = current0;
      acurrent1[0] = current1;
   }
   
   private int _mergeStreams(SortCurser c0, 
                             SortCurser c1,
                             ValueLookupComparator cp,
                             SortCurser c2, 
                             SortCurser c3)
   throws IOException, DBException {
      ValueLookup current0, current1;
      
      c0.reset();
      c1.reset();
      
      c0.next();
      c1.next();
      
      current0 = new TempValueLookup(c0);
      current1 = new TempValueLookup(c1);
      
      ValueLookup a0[] = new ValueLookup[] { current0 };
      ValueLookup a1[] = new ValueLookup[] { current1 };
      
      c2.rewrite();
      c3.rewrite();
      
      int numberOfRuns = 0;
      
      while(!c0.eof() || !c1.eof()) {
         ++numberOfRuns;
         _mergeRuns(c0, c1, a0, a1, cp, c2);
         if(!c0.eof() || !c1.eof()) {
            ++numberOfRuns;
            _mergeRuns(c0, c1, a0, a1, cp, c3);
         }
      }
      
      return numberOfRuns;
   }
   
   private Curser _twoWayMergeSort(SortCurser c0, 
                                   SortCurser c1,
                                   ValueLookupComparator cp)
   throws IOException, DBException  {
      int count;
      int numberOfRuns;
      SortCurser c2, c3;
      
      c2 = new SortCurser(_db.getTempFile(), c0.cols(), 0);
      c3 = new SortCurser(_db.getTempFile(), c0.cols(), 0);

      count = 0;
      do {
         ++count;
         if((count % 2) != 0) {
            numberOfRuns = _mergeStreams(c0, c1, cp, c2, c3);
         }
         else {
            numberOfRuns = _mergeStreams(c2, c3, cp, c0, c1);
         }
      }
      while(numberOfRuns > 1);
      
      if((count % 2) != 0) {
         c0.close();
         c1.close();
         c3.close();
         return c2;
      }
      else {
         c1.close();
         c2.close();
         c3.close();
         return c0;
      }
   }
    
   public TwoWayMergeSort(Database db) {
      _db = db;
   }                  
   
   public Curser sort(Curser c, ValueLookupComparator cp)
   throws DBException {
      try {
         int recCount = 0;
         if(c.recCount() < 0) {
            while(c.next())
               recCount++;
            c.reset();
         }
         else 
            recCount = c.recCount();

         if(recCount == 0 || recCount == 1)
            return c;
         
         int half0 = recCount / 2;
         int half1;
                  
         if((half0 + half0) != recCount)
            half1 = half0 + 1;
         else
            half1 = half0;

         String [][]cols;      
         cols = c.cols();

         File temp0 = _db.getTempFile();
         SortCurser c0 = new SortCurser(temp0, cols, half0);
         StringBuffer buf;
         int i, j;
            
         for(i = 0; i < half0; i++) {
            buf = new StringBuffer();
            c.next();
            for(j = 0; j < c.size(); j++) {
               if(buf.length() != 0)
                  buf.append(",");
               buf.append("\"" + CSVEncoder.encode(c.getValue(j)) + "\"");
            }
            c0.put(buf.toString());
         }
            
         File temp1 = _db.getTempFile();
         SortCurser c1 = new SortCurser(temp1, cols, half1);
         for(i = 0; i < half1; i++) {
            buf = new StringBuffer();
            c.next();
            for(j = 0; j < c.size(); j++) {
               if(buf.length() != 0)
                  buf.append(",");
               buf.append("\"" + CSVEncoder.encode(c.getValue(j)) + "\"");
            }
            c1.put(buf.toString());
         }
         c.close();
            
         c0.reset();
         c1.reset();
         c = _twoWayMergeSort(c0, c1, cp);
         c.reset();
         return c;
      }
      catch(IOException ioe) {
         return null;
      }
   }
}