import java.io.*;
import java.util.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class TestClient extends JPanel implements LayoutManager {
   JButton exeButton;
   JTextArea input = new JTextArea();
   JTextArea text = new JTextArea();
   JScrollPane inputScr = new JScrollPane(input);
   JScrollPane textScr = new JScrollPane(text);                                          
   PrintStream out;
   Dimension dim = new Dimension(0,0);
   
   public void addLayoutComponent(String name, Component comp) {
   }

   public void layoutContainer(Container parent) {
      Rectangle rec = parent.getBounds();
      int h = exeButton.getPreferredSize().height * 2;
      textScr.setBounds(0,0, rec.width, rec.height - h);
      inputScr.setBounds(0, 
                      rec.height - h,
                      rec.width - exeButton.getPreferredSize().width,
                      h);
      exeButton.setBounds(rec.width - exeButton.getPreferredSize().width,
                          rec.height - h,
                          exeButton.getPreferredSize().width,
                          h);
   }

   public Dimension minimumLayoutSize(Container parent) {
      return dim;
   }
   public Dimension preferredLayoutSize(Container parent) {
      return dim;
   }

   public void removeLayoutComponent(Component comp) {
   }
   
   class TestReader extends Thread {
      InputStream in;
      
      TestReader(InputStream in) {
         this.in = in;
      }
      public void run() {
         try {
            int ch;
            while((ch = in.read()) >= 0) {
               text.append(((char)ch)+"");
            }
         }
         catch(Throwable th) {
            th.printStackTrace();
         }
      }
   }
      
   public TestClient()
   throws Exception {
      super();
      exeButton = new JButton("Execute");
      exeButton.addActionListener(new ActionListener() {
       	 public void actionPerformed(ActionEvent e) {
            text.setText("");
            out.println(input.getText());
            out.flush();
         }
      });
      inputScr.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
      inputScr.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
      textScr.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
      textScr.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
      setLayout(this);
      add(textScr);
      add(inputScr);
      add(exeButton);

      Socket con = new Socket("127.0.0.1", 2002);
      InputStream in = con.getInputStream();
      new TestReader(in).start();
      out = new PrintStream(new BufferedOutputStream(con.getOutputStream()));
    }
   
   public static void main(String args[]) throws Exception {
      try {
         UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
      } 
      catch (Exception exc) {
         System.err.println("Error loading L&F: " + exc);
      }
      TestClient panel = new TestClient();
      JFrame frame = new JFrame("SQLD Client");
      frame.addWindowListener(new WindowAdapter() {
         public void windowClosing(WindowEvent e) {System.exit(0);}
      });
      frame.getContentPane().setLayout(new GridLayout(1,0,0,0));
      frame.getContentPane().add(panel);
      frame.pack(); 
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
      int w = 640;
      int h = 480;
      frame.setLocation(screenSize.width/2 - w/2, screenSize.height/2 - h/2);
      frame.setSize(w, h);
      frame.setVisible(true);
   }
}