package com.mwc.sqld.server;

import java.io.*;
import java.util.*;
import java.net.*;

import com.mwc.util.*;
import com.mwc.sqld.*;
import com.mwc.sqld.db.*;

public class sqld implements Runnable {   
   private ServerSocket _svr;
   private Properties _props;
   private Hashtable _databaseTable;
   private Database _masterDB;
   private Hashtable _resultsTable;
   private Hashtable _resultsSourceTable;
   private ThreadPool _threadPool;
   
   private void _debug(String msg) {
      if(true)
         System.out.println(msg);
   }
   
   public sqld(String propFileName)
   throws Exception {
      _resultsSourceTable = new Hashtable();
      _resultsTable = new Hashtable();
      FileInputStream fin = new FileInputStream(propFileName);
      BufferedInputStream bin = new BufferedInputStream(fin);
      _props = new Properties();
      _props.load(bin);
      fin.close();
      _svr = new ServerSocket(Integer.parseInt(_props.getProperty("server.port")),
                              Integer.parseInt(_props.getProperty("server.backlog")),
                              InetAddress.getByName(_props.getProperty("server.bindAddress")));
      _databaseTable = new Hashtable();
      int n = Integer.parseInt(_props.getProperty("database.impl.n"));
      Class clazz;
      String name, className;
      for(int i = 1; i <= n; i++) {
         name = _props.getProperty("database.impl."+i+".name");
         className = _props.getProperty("database.impl."+i+".class");
         clazz = Class.forName(className);
         DatabaseImplManager.registerImpl(name, clazz);
      }
      
      n = Integer.parseInt(_props.getProperty("database.n"));
      Database db;
      String dir, type;
      for(int i = 1; i <= n; i++) {
         name = _props.getProperty("database."+i+".name");
         name = name.toLowerCase();
         dir = _props.getProperty("database."+i+".dir");
         type = _props.getProperty("database."+i+".type");
         type.toLowerCase();
         _debug("LOADING-DATABASE("+name+","+dir+","+type+")");
         db = DatabaseFactory.getDatabase(type, name, dir);
         if(db == null)
            throw new DBException("Unable to load database:"
                                + "\n   Database type: " + type 
                                + "\n   For database: " + name 
                                + "\n   In directory: " + dir);
         _databaseTable.put(name, db);
      }
      _masterDB = (Database)_databaseTable.get("masterdb");
      if(_masterDB == null)
         throw new DBException("No master database found!");
      _threadPool = new ThreadPool(Integer.parseInt(_props.getProperty("server.threadPool.min")),
                                   Integer.parseInt(_props.getProperty("server.threadPool.max")),
                                   new Long(_props.getProperty("server.threadPool.timeout")).longValue(),
                                   Integer.parseInt(_props.getProperty("server.threadPool.maxQueue")));
   }
   
   class HandlerTask implements Runnable {
      private String _username;
      private Socket _sock;
      private boolean _killSwitch = false;
      private Object _killLock = new Object();
      
      private void _killThread() {
         synchronized(_killLock) {
            _killSwitch = true;
         }
      }
      
      private boolean _killed() {
         synchronized(_killLock) {
            return _killSwitch;
         }
      }
      
      public class SQLDContext implements UserContext {
         private Database _db = null;
         private boolean _exited = false;
         private PrintStream _printer;
         private boolean _read = false;
         private boolean _write = false;
         private BufferedInputStream _bin;
         
         private SQLDContext(PrintStream printer, BufferedInputStream bin) {
            _printer = printer;
            _bin = bin;
         }
         
         public ThreadPool threadPool() {
            return _threadPool;
         }
         
         public String readLine() {
            try {
               return readCommand(_bin);
            }
            catch(IOException ioe) {
               return null;
            }
         }
         
         public String username() {
            return _username;
         }
         
         public Database currentDatabase() {
            return _db;
         }
         
         public boolean changeCurrentDatabase(String dbName) {
            String dbname = dbName.toLowerCase();
            Object o = _databaseTable.get(dbname);
            if(o == null)
               return false;
            Table access = _masterDB.getTable("Access");
            Curser curser = access.getNewCurser();
            boolean hasAccess = false;
            String r,w;
            String lowUN = _username.toLowerCase();
            while(curser.next()) {
               if(SQLExpression.like(lowUN, curser.getValue("username").toLowerCase())
                  && SQLExpression.like(dbname, curser.getValue("dbname").toLowerCase())) {
                  r = curser.getValue("readAccess");
                  w = curser.getValue("writeAccess");
                  if(r.equalsIgnoreCase("true") || w.equalsIgnoreCase("true")) {
                     hasAccess = true;
                     _read = new Boolean(r).booleanValue();
                     _write = new Boolean(w).booleanValue();
                  }
                  break;
               }
            }
            curser.close();
            if(!hasAccess)
               return false;
            _db = (Database)o;
            return true;
         }
         
         public String getNextResultSetID() {
            String choices = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            StringBuffer keyBuf;
            boolean found;
            String key;
            do {
               keyBuf = new StringBuffer();
               keyBuf.append('A');
               for(int i = 0; i < 49; i++)
                  keyBuf.append(choices.charAt(((int)(Math.random() * 100000)) % choices.length()));
               key = keyBuf.toString();
               synchronized(_resultsTable) {
                  if(_resultsTable.get(key) == null) {
                     found = false;
                     _resultsTable.put(key, new Object());
                     synchronized(_resultsSourceTable) {
                        _resultsSourceTable.put(key, _db.name());
                     }
                  }
                  else 
                     found = true;
               }
            }
            while(found);
            
            return key;
         }
         
         public void registerResults(String id, Object results) {
            Object ref = null;
            synchronized(_resultsTable) {
               ref = _resultsTable.put(id, results);
            }
            if(ref != null) {
               synchronized(ref) {
                  ref.notify();
               }
            }
         }
                  
         public boolean exited() {
            return _exited;
         }
         
         public void exit() {
            _exited = true;
         }
                  
         public PrintStream out() {
            return _printer;
         }
         
         public boolean readAccess() {
            return _read;
         }
         
         public boolean writeAccess() {
            return _write;
         }
         
         public Object acquireResults(String id) {
            String dbname;
            synchronized(_resultsSourceTable) {
               dbname = (String)_resultsSourceTable.get(id);
            }
            if(dbname == null)
               return null;
            
            Table access = _masterDB.getTable("Access");
            Curser curser = access.getNewCurser();
            boolean hasAccess = false;
            String r,w;
            String lowUN = _username.toLowerCase();
            while(curser.next()) {
               if(SQLExpression.like(lowUN, curser.getValue("username").toLowerCase())
                  && SQLExpression.like(dbname, curser.getValue("dbname").toLowerCase())) {
                  r = curser.getValue("readAccess");
                  if(r.equalsIgnoreCase("true"))
                     hasAccess = true;
                  break;
               }
            }
            curser.close();
            if(!hasAccess)
               return null;

            Object ref;
            boolean found;
            do {
               found = false;
               synchronized(_resultsTable) {
                  ref = _resultsTable.get(id);
               }
               if(ref == null)
                  return null;
               if(ref instanceof Exception)
                  found = true;
               else if(ref instanceof Curser)
                  found = true;
               else {
                  synchronized(ref) {
                     try {
                        ref.wait();
                     }
                     catch(InterruptedException ie) {
                        ;
                     }
                  }
               }
            }
            while(!found);
            synchronized(_resultsTable) {
               _resultsTable.remove(id);
            }
            synchronized(_resultsSourceTable) {
               _resultsSourceTable.remove(id);
            }
            return ref;
         }
      }
      
      HandlerTask(Socket client) {
         _sock = client;
      }
      
      String readCommand(InputStream in)
      throws IOException {
         StringBuffer buffer = new StringBuffer();
         int ch;
         while((ch = in.read()) >= 0) {
            buffer.append((char)ch);
            if(ch == ';')
               break;
         }
         if(ch < 0)
            return null;
         return buffer.toString();
      }
      
      public void run() {
         SQLDContext ctx = null;
         try {
            InputStream in = _sock.getInputStream();
            BufferedInputStream bin = new BufferedInputStream(in);
            OutputStream out = _sock.getOutputStream();
            BufferedOutputStream bout = new BufferedOutputStream(out);
            PrintStream printer = new PrintStream(bout);
            ctx = new SQLDContext(printer, bin);
            String cmd;
            
            printer.println("Authentication");
            printer.flush();
            
            _username = readCommand(bin);
            if(_username == null) 
               return;
            _username = _username.trim();
            _username = _username.substring(0,_username.length()-1);
            String password = readCommand(bin);
            if(password == null)
               return;
            password = password.trim();
            password = password.substring(0,password.length()-1);
            password = SQLFunctions.crypt("76", password);
            
            Table users = _masterDB.getTable("Users");
            Curser curser = users.getNewCurser();
            boolean found = false;
            while(curser.next()) {
               if(curser.getValue("username").compareTo(_username) == 0) {
                  if(curser.getValue("password").compareTo(password) == 0)
                     found = true;
                  break;
               }
            }
            curser.close();

            if(!found) 
               return;
            
            printer.println("OK");
            printer.flush();
            
            while((!_killed()) && ((cmd = readCommand(bin)) != null)) {
               try {
                  SQLParser.parseStatement(cmd, ctx);
                  if(ctx.exited()) 
                     break;
               }
               catch(Throwable th) {
                  th.printStackTrace();
                  printer.println("ERROR");
                  printer.println(th.getMessage());
                  printer.println();
                  printer.println("~~~END-OF-ERROR-MESSAGE~~~");
                  printer.flush();
               }
            }
         }
         catch(Throwable throwable) {
            throwable.printStackTrace();
         }
         finally {
            try {
               _sock.close();
            }
            catch(IOException ioe) {
               ;
            }
            if(ctx != null) {
               Database db = ctx.currentDatabase();
               if(db != null) {
                  db.sync();
                  if(db.modified())
                     db.save();
               }
            }
         }
      }
   }
   
   private class StatThread extends Thread {
      public void run() {
         while(true) {
            System.out.println(_threadPool.getStats().toString());
            try {
               Thread.sleep(2*1000);
            }
            catch(Throwable t) {
               ;
            }
         }
      }
   }
   
   public void run() {
      new StatThread().start();
      Socket client;
      Runnable task;
      while(true) {
         try {
            client = _svr.accept();
            task = new HandlerTask(client);
            _threadPool.postTaskForExecution(task);
         }
         catch(Throwable throwable) {
            throwable.printStackTrace();
         }
      }
   }
   
   public void stop() {
      _threadPool.stop();
      try {
         _svr.close();
      }
      catch(IOException ioe) {
         ;
      }
      Database db;
      Enumeration enumeration;
      synchronized(_databaseTable) {
         enumeration = _databaseTable.keys();
         while(enumeration.hasMoreElements()) {
            db = (Database)_databaseTable.get(enumeration.nextElement());
            db.close();
         }
         _databaseTable = new Hashtable();
      }
      Object o;
      synchronized(_resultsTable) {
         enumeration = _resultsTable.keys();
         while(enumeration.hasMoreElements()) {
            o = _resultsTable.get(enumeration.nextElement());
            if(o instanceof Curser) 
               ((Curser)o).close();
            o.notify();
         }
         _resultsTable = new Hashtable();
      }
   }
   
   public static void main(String args[]) {
      java.security.Security.addProvider(new cryptix.provider.Cryptix());
      if(args.length != 1) {
         System.err.println("Usage: com.mwc.sqld.server.sqld <properties file name>");
         System.exit(1);
      }
      try {
         sqld svr = new sqld(args[0]);
         svr.run();
      }
      catch(Throwable throwable) {
         throwable.printStackTrace();
      }
   }
}