/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.DatatypeException;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.XSAtomicSimpleType;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.AttributePSVImpl;
import org.apache.xerces.impl.xs.ElementPSVImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUse;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.FieldActivator;
import org.apache.xerces.impl.xs.identity.IDValue;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.KeyRef;
import org.apache.xerces.impl.xs.identity.Selector;
import org.apache.xerces.impl.xs.identity.UniqueOrKey;
import org.apache.xerces.impl.xs.identity.ValueStore;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.xml.sax.InputSource;

public class XMLSchemaValidator
implements XMLComponent,
XMLDocumentFilter,
FieldActivator {
    private static final boolean DEBUG = false;
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String SCHEMA_ELEMENT_DEFAULT = "http://apache.org/xml/features/validation/schema/element-default";
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    public static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://xml.org/sax/features/namespaces", "http://apache.org/xml/features/validation/schema", "http://apache.org/xml/features/validation/dynamic", "http://apache.org/xml/features/validation/schema-full-checking"};
    protected static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/validation-manager", "http://apache.org/xml/properties/schema/external-schemaLocation", "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", "http://java.sun.com/xml/jaxp/properties/schemaSource"};
    protected boolean fSeenRoot = false;
    protected boolean fNamespaces = false;
    protected final ElementPSVImpl fElemPSVI = new ElementPSVImpl();
    protected ElementPSVImpl fCurrentPSVI = null;
    protected final AugmentationsImpl fAugmentations = new AugmentationsImpl();
    protected XMLString fDefaultValue;
    protected boolean fValidation = false;
    protected boolean fDynamicValidation = false;
    protected boolean fDoValidation = false;
    protected boolean fFullChecking = false;
    protected boolean fNormalizeData = true;
    protected boolean fSchemaElementDefault = true;
    protected boolean fEntityRef = false;
    protected boolean fInCDATA = false;
    protected SymbolTable fSymbolTable;
    protected XSIErrorReporter fXSIErrorReporter = new XSIErrorReporter();
    protected XMLEntityResolver fEntityResolver;
    protected ValidationManager fValidationManager = null;
    protected ValidationState fValidationState = new ValidationState();
    protected XMLGrammarPool fGrammarPool;
    protected String fExternalSchemas = null;
    protected String fExternalNoNamespaceSchema = null;
    protected Object fJaxpSchemaSource = null;
    XMLResourceIdentifierImpl fResourceIdentifier = new XMLResourceIdentifierImpl();
    protected final XSDDescription fXSDDescription = new XSDDescription();
    protected final Hashtable fLocationPairs = new Hashtable();
    protected final LocationArray fNoNamespaceLocationArray = new LocationArray();
    protected XMLDocumentHandler fDocumentHandler;
    static final int INITIAL_STACK_SIZE = 8;
    static final int INC_STACK_SIZE = 8;
    String XMLNS;
    String URI_XSI;
    String XSI_SCHEMALOCATION;
    String XSI_NONAMESPACESCHEMALOCATION;
    String XSI_TYPE;
    String XSI_NIL;
    String URI_SCHEMAFORSCHEMA;
    private static final boolean DEBUG_NORMALIZATION = false;
    private final XMLString fEmptyXMLStr = new XMLString(null, 0, -1);
    private static final int BUFFER_SIZE = 20;
    private char[] fCharBuffer = new char[20];
    private final StringBuffer fNormalizedStr = new StringBuffer();
    private final XMLString fXMLString = new XMLString(this.fCharBuffer, 0, -1);
    private boolean fFirstChunk = true;
    private boolean fTrailing = false;
    private short fWhiteSpace = (short)-1;
    private boolean fUnionType = false;
    final XSGrammarBucket fGrammarBucket;
    final SubstitutionGroupHandler fSubGroupHandler;
    final XSDHandler fSchemaHandler;
    final NamespaceSupport fNamespaceSupport = new NamespaceSupport();
    boolean fPushForNextBinding;
    final XSSimpleType fQNameDV = (XSSimpleType)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("QName");
    final CMBuilder fCMBuilder = new CMBuilder(new XSDeclarationPool());
    String fValidationRoot;
    int fValidationRootDepth;
    int fSkipValidationDepth;
    int fPartialValidationDepth;
    int fElementDepth;
    int fChildCount;
    int[] fChildCountStack = new int[8];
    XSElementDecl fCurrentElemDecl;
    XSElementDecl[] fElemDeclStack = new XSElementDecl[8];
    boolean fNil;
    boolean[] fNilStack = new boolean[8];
    XSTypeDecl fCurrentType;
    XSTypeDecl[] fTypeStack = new XSTypeDecl[8];
    XSCMValidator fCurrentCM;
    XSCMValidator[] fCMStack = new XSCMValidator[8];
    int[] fCurrCMState;
    int[][] fCMStateStack = new int[8][];
    final StringBuffer fBuffer = new StringBuffer();
    boolean fSawCharacters = false;
    boolean[] fStringContent = new boolean[8];
    boolean fSawChildren = false;
    boolean[] fSawChildrenStack = new boolean[8];
    final QName fTempQName = new QName();
    ValidatedInfo fValidatedInfo = new ValidatedInfo();
    private ValidationState fState4XsiType = new ValidationState();
    private ValidationState fState4ApplyDefault = new ValidationState();
    protected XPathMatcherStack fMatcherStack = new XPathMatcherStack();
    protected ValueStoreCache fValueStoreCache = new ValueStoreCache();
    static /* synthetic */ Class class$java$lang$Object;

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
    }

    public void setDocumentHandler(XMLDocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    public void startDocument(XMLLocator locator, String encoding, Augmentations augs) throws XNIException {
        this.handleStartDocument(locator, encoding);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startDocument(locator, encoding, augs);
        }
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(version, encoding, standalone, augs);
        }
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(rootElement, publicId, systemId, augs);
        }
    }

    public void startPrefixMapping(String prefix, String uri, Augmentations augs) throws XNIException {
        this.handleStartPrefix(prefix, uri);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startPrefixMapping(prefix, uri, augs);
        }
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        Augmentations modifiedAugs = this.handleStartElement(element, attributes, augs);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startElement(element, attributes, modifiedAugs);
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        Augmentations modifiedAugs = this.handleStartElement(element, attributes, augs);
        XSTypeDecl type = this.fCurrentPSVI.fTypeDecl;
        XSNotationDecl notation = this.fCurrentPSVI.fNotation;
        String vContext = this.fCurrentPSVI.fValidationContext;
        modifiedAugs = this.handleEndElement(element, modifiedAugs);
        if (this.fDocumentHandler != null) {
            this.fCurrentPSVI.fTypeDecl = type;
            this.fCurrentPSVI.fNotation = notation;
            this.fCurrentPSVI.fValidationContext = vContext;
            if (!this.fSchemaElementDefault || this.fDefaultValue == null) {
                this.fDocumentHandler.emptyElement(element, attributes, modifiedAugs);
            } else {
                this.fDocumentHandler.startElement(element, attributes, modifiedAugs);
                this.fDocumentHandler.characters(this.fDefaultValue, modifiedAugs);
                this.fDocumentHandler.endElement(element, modifiedAugs);
            }
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        boolean emptyAug = false;
        if (augs == null) {
            emptyAug = true;
            augs = this.fAugmentations;
            augs.clear();
        }
        this.fCurrentPSVI = (ElementPSVImpl)augs.getItem("ELEMENT_PSVI");
        if (this.fCurrentPSVI == null) {
            this.fCurrentPSVI = this.fElemPSVI;
            this.fCurrentPSVI.reset();
            augs.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
        }
        this.handleCharacters(text);
        if (this.fDocumentHandler != null) {
            if (this.fUnionType) {
                if (!emptyAug) {
                    this.fDocumentHandler.characters(this.fEmptyXMLStr, augs);
                }
            } else {
                this.fDocumentHandler.characters(text, augs);
            }
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        this.handleIgnorableWhitespace(text);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(text, augs);
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        Augmentations modifiedAugs = this.handleEndElement(element, augs);
        if (this.fDocumentHandler != null) {
            if (this.fSchemaElementDefault || this.fDefaultValue == null) {
                this.fDocumentHandler.endElement(element, modifiedAugs);
            } else {
                this.fDocumentHandler.characters(this.fDefaultValue, modifiedAugs);
                this.fDocumentHandler.endElement(element, modifiedAugs);
            }
        }
    }

    public void endPrefixMapping(String prefix, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endPrefixMapping(prefix, augs);
        }
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        this.fInCDATA = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startCDATA(augs);
        }
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        this.fInCDATA = false;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endCDATA(augs);
        }
    }

    public void endDocument(Augmentations augs) throws XNIException {
        this.handleEndDocument();
        if (this.fGrammarPool != null) {
            this.fGrammarPool.cacheGrammars("XSD", this.fGrammarBucket.getGrammars());
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument(augs);
        }
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        this.fEntityRef = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startGeneralEntity(name, identifier, encoding, augs);
        }
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.textDecl(version, encoding, augs);
        }
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        this.fSawChildren = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.comment(text, augs);
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        this.fSawChildren = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.processingInstruction(target, data, augs);
        }
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        this.fEntityRef = false;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endGeneralEntity(name, augs);
        }
    }

    public XMLSchemaValidator() {
        this.fGrammarBucket = new XSGrammarBucket();
        this.fSubGroupHandler = new SubstitutionGroupHandler(this.fGrammarBucket);
        this.fSchemaHandler = new XSDHandler(this.fGrammarBucket);
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.fXSIErrorReporter.reset((XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER));
        SymbolTable symbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        if (symbolTable != this.fSymbolTable) {
            this.XMLNS = symbolTable.addSymbol("xmlns");
            this.URI_XSI = symbolTable.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
            this.XSI_SCHEMALOCATION = symbolTable.addSymbol("schemaLocation");
            this.XSI_NONAMESPACESCHEMALOCATION = symbolTable.addSymbol("noNamespaceSchemaLocation");
            this.XSI_TYPE = symbolTable.addSymbol("type");
            this.XSI_NIL = symbolTable.addSymbol("nil");
            this.URI_SCHEMAFORSCHEMA = symbolTable.addSymbol("http://www.w3.org/2001/XMLSchema");
        }
        this.fSymbolTable = symbolTable;
        try {
            this.fNamespaces = componentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException e) {
            this.fNamespaces = true;
        }
        try {
            this.fValidation = componentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fValidation = false;
        }
        try {
            this.fValidation = this.fValidation && componentManager.getFeature(SCHEMA_VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fValidation = false;
        }
        try {
            this.fFullChecking = componentManager.getFeature(SCHEMA_FULL_CHECKING);
        }
        catch (XMLConfigurationException e) {
            this.fFullChecking = false;
        }
        try {
            this.fDynamicValidation = componentManager.getFeature(DYNAMIC_VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fDynamicValidation = false;
        }
        try {
            this.fNormalizeData = componentManager.getFeature(NORMALIZE_DATA);
        }
        catch (XMLConfigurationException e) {
            this.fNormalizeData = false;
        }
        try {
            this.fSchemaElementDefault = componentManager.getFeature(SCHEMA_ELEMENT_DEFAULT);
        }
        catch (XMLConfigurationException e) {
            this.fSchemaElementDefault = false;
        }
        this.fEntityResolver = (XMLEntityResolver)componentManager.getProperty(ENTITY_MANAGER);
        this.fNamespaceSupport.reset(this.fSymbolTable);
        this.fPushForNextBinding = true;
        this.fValidationManager = (ValidationManager)componentManager.getProperty(VALIDATION_MANAGER);
        this.fValidationManager.addValidationState(this.fValidationState);
        this.fValidationState.setNamespaceSupport(this.fNamespaceSupport);
        this.fValidationState.setSymbolTable(this.fSymbolTable);
        this.fExternalSchemas = (String)componentManager.getProperty(SCHEMA_LOCATION);
        this.fExternalNoNamespaceSchema = (String)componentManager.getProperty(SCHEMA_NONS_LOCATION);
        this.fJaxpSchemaSource = componentManager.getProperty(JAXP_SCHEMA_SOURCE);
        this.fResourceIdentifier.clear();
        this.fGrammarBucket.reset();
        this.fGrammarPool = (XMLGrammarPool)componentManager.getProperty(XMLGRAMMAR_POOL);
        if (this.fGrammarPool != null) {
            Grammar[] initialGrammars = this.fGrammarPool.retrieveInitialGrammarSet("XSD");
            int i = 0;
            while (i < initialGrammars.length) {
                this.fGrammarBucket.putGrammar((SchemaGrammar)initialGrammars[i]);
                ++i;
            }
        }
        this.fSubGroupHandler.reset();
        this.fSchemaHandler.reset(this.fXSIErrorReporter.fErrorReporter, this.fEntityResolver, this.fSymbolTable, this.fExternalSchemas, this.fExternalNoNamespaceSchema, this.fGrammarPool);
        this.fXSDDescription.reset();
        this.fLocationPairs.clear();
        this.fNoNamespaceLocationArray.resize(0, 2);
        this.fCurrentElemDecl = null;
        this.fNil = false;
        this.fCurrentPSVI = null;
        this.fCurrentType = null;
        this.fCurrentCM = null;
        this.fCurrCMState = null;
        this.fBuffer.setLength(0);
        this.fSawCharacters = false;
        this.fSawChildren = false;
        this.fValidationRootDepth = -1;
        this.fValidationRoot = null;
        this.fSkipValidationDepth = -1;
        this.fPartialValidationDepth = -1;
        this.fElementDepth = -1;
        this.fChildCount = 0;
        this.fFirstChunk = true;
        this.fTrailing = false;
        this.fNormalizedStr.setLength(0);
        this.fWhiteSpace = (short)-1;
        this.fUnionType = false;
        this.fWhiteSpace = (short)-1;
        this.fAugmentations.clear();
        this.fEntityRef = false;
        this.fInCDATA = false;
        this.fMatcherStack.clear();
        this.fValueStoreCache = new ValueStoreCache();
        this.fState4XsiType.setExtraChecking(false);
        this.fState4XsiType.setSymbolTable(symbolTable);
        this.fState4XsiType.setSymbolTable(symbolTable);
        this.fState4XsiType.setNamespaceSupport(this.fNamespaceSupport);
        this.fState4ApplyDefault.setFacetChecking(false);
        this.fState4ApplyDefault.setSymbolTable(symbolTable);
        this.fState4ApplyDefault.setSymbolTable(symbolTable);
        this.fState4ApplyDefault.setNamespaceSupport(this.fNamespaceSupport);
    }

    public void startValueScopeFor(IdentityConstraint identityConstraint) throws XNIException {
        int i = 0;
        while (i < identityConstraint.getFieldCount()) {
            Field field = identityConstraint.getFieldAt(i);
            ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(field);
            valueStore.startValueScope();
            ++i;
        }
    }

    public XPathMatcher activateField(Field field) throws XNIException {
        ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(field);
        field.setMayMatch(true);
        XPathMatcher matcher = field.createMatcher(valueStore);
        this.fMatcherStack.addMatcher(matcher);
        matcher.startDocumentFragment(this.fSymbolTable);
        return matcher;
    }

    public void endValueScopeFor(IdentityConstraint identityConstraint) throws XNIException {
        ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(identityConstraint);
        valueStore.endValueScope();
    }

    private void activateSelectorFor(IdentityConstraint ic) throws XNIException {
        Selector selector = ic.getSelector();
        XMLSchemaValidator activator = this;
        if (selector == null) {
            return;
        }
        XPathMatcher matcher = selector.createMatcher(activator);
        this.fMatcherStack.addMatcher(matcher);
        matcher.startDocumentFragment(this.fSymbolTable);
    }

    void ensureStackCapacity() {
        if (this.fElementDepth == this.fElemDeclStack.length) {
            int newSize = this.fElementDepth + 8;
            int[] newArrayI = new int[newSize];
            System.arraycopy(this.fChildCountStack, 0, newArrayI, 0, this.fElementDepth);
            this.fChildCountStack = newArrayI;
            XSElementDecl[] newArrayE = new XSElementDecl[newSize];
            System.arraycopy(this.fElemDeclStack, 0, newArrayE, 0, this.fElementDepth);
            this.fElemDeclStack = newArrayE;
            boolean[] newArrayB = new boolean[newSize];
            System.arraycopy(this.fNilStack, 0, newArrayB, 0, this.fElementDepth);
            this.fNilStack = newArrayB;
            XSTypeDecl[] newArrayT = new XSTypeDecl[newSize];
            System.arraycopy(this.fTypeStack, 0, newArrayT, 0, this.fElementDepth);
            this.fTypeStack = newArrayT;
            XSCMValidator[] newArrayC = new XSCMValidator[newSize];
            System.arraycopy(this.fCMStack, 0, newArrayC, 0, this.fElementDepth);
            this.fCMStack = newArrayC;
            boolean[] newArrayD = new boolean[newSize];
            System.arraycopy(this.fStringContent, 0, newArrayD, 0, this.fElementDepth);
            this.fStringContent = newArrayD;
            newArrayD = new boolean[newSize];
            System.arraycopy(this.fSawChildrenStack, 0, newArrayD, 0, this.fElementDepth);
            this.fSawChildrenStack = newArrayD;
            int[][] newArrayIA = new int[newSize][];
            System.arraycopy(this.fCMStateStack, 0, newArrayIA, 0, this.fElementDepth);
            this.fCMStateStack = newArrayIA;
        }
    }

    void handleStartDocument(XMLLocator locator, String encoding) {
        if (this.fValidation) {
            this.fValueStoreCache.startDocument();
        }
    }

    void handleEndDocument() {
        if (this.fValidation) {
            this.fValueStoreCache.endDocument();
        }
    }

    void handleCharacters(XMLString text) {
        this.fCurrentPSVI.fNormalizedValue = null;
        if (this.fSkipValidationDepth >= 0) {
            return;
        }
        String normalizedStr = null;
        boolean allWhiteSpace = true;
        if (this.fNormalizeData && !this.fEntityRef && !this.fInCDATA && this.fWhiteSpace != -1 && !this.fUnionType && this.fWhiteSpace != 0) {
            int spaces = this.normalizeWhitespace(text, this.fWhiteSpace == 2);
            int length = this.fNormalizedStr.length();
            if (length > 0 && !this.fFirstChunk && this.fWhiteSpace == 2) {
                if (this.fTrailing) {
                    this.fNormalizedStr.insert(0, ' ');
                } else if (spaces == 1 || spaces == 3) {
                    this.fNormalizedStr.insert(0, ' ');
                }
            }
            this.fCurrentPSVI.fNormalizedValue = normalizedStr = this.fNormalizedStr.toString();
            this.fTrailing = spaces > 1;
        }
        boolean mixed = false;
        if (this.fCurrentType != null && this.fCurrentType.getXSType() == 1) {
            XSComplexTypeDecl ctype = (XSComplexTypeDecl)this.fCurrentType;
            if (ctype.fContentType == 2) {
                mixed = true;
            }
        }
        if (!mixed && this.fWhiteSpace == -1 && !this.fUnionType) {
            int i = text.offset;
            while (i < text.offset + text.length) {
                if (!XMLChar.isSpace(text.ch[i])) {
                    allWhiteSpace = false;
                    break;
                }
                ++i;
            }
        }
        this.fFirstChunk = false;
        if (this.fNil) {
            this.fCurrentPSVI.fNormalizedValue = null;
            this.fBuffer.append(text.toString());
        }
        if (normalizedStr != null) {
            this.fBuffer.append(normalizedStr);
        } else {
            this.fBuffer.append(text.toString());
        }
        if (!allWhiteSpace) {
            this.fSawCharacters = true;
        }
        int count = this.fMatcherStack.getMatcherCount();
        int i = 0;
        while (i < count) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
            matcher.characters(text);
            ++i;
        }
    }

    private int normalizeWhitespace(XMLString value, boolean collapse) {
        int c;
        boolean skipSpace = collapse;
        boolean sawNonWS = false;
        int leading = 0;
        int trailing = 0;
        int size = value.offset + value.length;
        this.fNormalizedStr.setLength(0);
        int i = value.offset;
        while (i < size) {
            c = value.ch[i];
            if (c == 32 || c == 13 || c == 10 || c == 9) {
                if (!skipSpace) {
                    this.fNormalizedStr.append(' ');
                    skipSpace = collapse;
                }
                if (!sawNonWS) {
                    leading = 1;
                }
            } else {
                this.fNormalizedStr.append((char)c);
                skipSpace = false;
                sawNonWS = true;
            }
            ++i;
        }
        if (skipSpace) {
            c = this.fNormalizedStr.length();
            if (c != 0) {
                this.fNormalizedStr.setLength(--c);
                trailing = 2;
            } else if (leading != 0 && !sawNonWS) {
                trailing = 2;
            }
        }
        return collapse ? leading + trailing : 0;
    }

    void handleIgnorableWhitespace(XMLString text) {
        if (this.fSkipValidationDepth >= 0) {
            return;
        }
        int count = this.fMatcherStack.getMatcherCount();
        int i = 0;
        while (i < count) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
            matcher.characters(text);
            ++i;
        }
    }

    Augmentations handleStartElement(QName element, XMLAttributes attributes, Augmentations augs) {
        String xsiType;
        SchemaGrammar sGrammar;
        if (augs == null) {
            augs = this.fAugmentations;
            augs.clear();
        }
        if (this.fNormalizeData) {
            this.fFirstChunk = true;
            this.fUnionType = false;
            this.fWhiteSpace = (short)-1;
        }
        Object decl = null;
        if (this.fSkipValidationDepth < 0 && this.fCurrentCM != null) {
            decl = this.fCurrentCM.oneTransition(element, this.fCurrCMState, this.fSubGroupHandler);
            if (this.fCurrCMState[0] == -1 && this.fDoValidation) {
                XSComplexTypeDecl ctype = (XSComplexTypeDecl)this.fCurrentType;
                if (ctype.fParticle != null) {
                    this.reportSchemaError("cvc-complex-type.2.4.a", new Object[]{element.rawname, ctype.fParticle.toString()});
                } else {
                    this.reportSchemaError("cvc-complex-type.2.4.a", new Object[]{element.rawname, "mixed with no element content"});
                }
            }
        }
        this.fXSIErrorReporter.pushContext();
        if (this.fPushForNextBinding) {
            this.fNamespaceSupport.pushContext();
        } else {
            this.fPushForNextBinding = true;
        }
        if (this.fElementDepth == -1) {
            this.fDoValidation = this.fValidation && !this.fValidationManager.isGrammarFound() && !this.fDynamicValidation;
            this.storeLocations(this.fExternalSchemas, this.fExternalNoNamespaceSchema);
            this.processJAXPSchemaSource(this.fJaxpSchemaSource, this.fEntityResolver);
        }
        this.fCurrentPSVI = (ElementPSVImpl)augs.getItem("ELEMENT_PSVI");
        if (this.fCurrentPSVI == null) {
            this.fCurrentPSVI = this.fElemPSVI;
            augs.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
        }
        this.fCurrentPSVI.reset();
        String sLocation = attributes.getValue(this.URI_XSI, this.XSI_SCHEMALOCATION);
        String nsLocation = attributes.getValue(this.URI_XSI, this.XSI_NONAMESPACESCHEMALOCATION);
        this.storeLocations(sLocation, nsLocation);
        if (sLocation != null || nsLocation != null) {
            this.fDoValidation = this.fValidation;
        }
        if (this.fSkipValidationDepth >= 0) {
            ++this.fElementDepth;
            return augs;
        }
        if (this.fElementDepth != -1) {
            this.ensureStackCapacity();
            this.fChildCountStack[this.fElementDepth] = this.fChildCount + 1;
            this.fChildCount = 0;
            this.fElemDeclStack[this.fElementDepth] = this.fCurrentElemDecl;
            this.fNilStack[this.fElementDepth] = this.fNil;
            this.fTypeStack[this.fElementDepth] = this.fCurrentType;
            this.fCMStack[this.fElementDepth] = this.fCurrentCM;
            this.fStringContent[this.fElementDepth] = this.fSawCharacters;
            this.fSawChildrenStack[this.fElementDepth] = this.fSawChildren;
        }
        this.fCurrentElemDecl = null;
        this.fNil = false;
        XSWildcardDecl wildcard = null;
        if (decl != null) {
            if (decl instanceof XSElementDecl) {
                this.fCurrentElemDecl = (XSElementDecl)decl;
            } else {
                wildcard = (XSWildcardDecl)decl;
            }
        }
        if (this.fElementDepth != -1) {
            this.fCMStateStack[this.fElementDepth] = this.fCurrCMState;
        }
        ++this.fElementDepth;
        if (wildcard != null && wildcard.fProcessContents == 2) {
            this.fSkipValidationDepth = this.fElementDepth;
            return augs;
        }
        if (this.fCurrentElemDecl == null && (sGrammar = this.findSchemaGrammar((short)5, element.uri, null, element, attributes)) != null) {
            this.fCurrentElemDecl = sGrammar.getGlobalElementDecl(element.localpart);
        }
        if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.isAbstract()) {
            this.reportSchemaError("cvc-elt.2", new Object[]{element.rawname});
        }
        this.fCurrentType = null;
        if (this.fCurrentElemDecl != null) {
            this.fCurrentType = this.fCurrentElemDecl.fType;
        }
        if ((xsiType = attributes.getValue(this.URI_XSI, this.XSI_TYPE)) != null) {
            this.getAndCheckXsiType(element, xsiType, attributes);
        }
        if (this.fCurrentType == null) {
            if (this.fDoValidation) {
                if (this.fValidationRootDepth == -1) {
                    this.reportSchemaError("cvc-elt.1", new Object[]{element.rawname});
                } else if (wildcard != null && wildcard.fProcessContents == 0) {
                    this.reportSchemaError("cvc-complex-type.2.4.c", new Object[]{element.rawname});
                }
            }
            if (this.fValidationRootDepth >= 0) {
                this.fSkipValidationDepth = this.fElementDepth;
            }
            return augs;
        }
        if (this.fValidationRootDepth == -1) {
            this.fValidationRootDepth = this.fElementDepth;
            this.fValidationRoot = element.rawname;
        }
        this.fCurrentPSVI.fValidationContext = this.fValidationRoot;
        this.fCurrentPSVI.fDeclaration = this.fCurrentElemDecl;
        this.fCurrentPSVI.fTypeDecl = this.fCurrentType;
        if (this.fCurrentType.getXSType() == 1) {
            XSComplexTypeDecl ctype = (XSComplexTypeDecl)this.fCurrentType;
            if (ctype.isAbstractType()) {
                this.reportSchemaError("cvc-type.2", new Object[]{"Element " + element.rawname + " is declared with a type that is abstract.  Use xsi:type to specify a non-abstract type"});
            }
            if (this.fNormalizeData && ctype.fContentType == 1) {
                if (ctype.fXSSimpleType.getVariety() == 3) {
                    this.fUnionType = true;
                } else {
                    try {
                        this.fWhiteSpace = ctype.fXSSimpleType.getWhitespace();
                    }
                    catch (DatatypeException e) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.fNormalizeData && this.fCurrentType.getXSType() == 2) {
            XSSimpleType dv = (XSSimpleType)this.fCurrentType;
            if (dv.getVariety() == 3) {
                this.fUnionType = true;
            } else {
                try {
                    this.fWhiteSpace = dv.getWhitespace();
                }
                catch (DatatypeException e) {
                    // empty catch block
                }
            }
        }
        this.fCurrentCM = null;
        if (this.fCurrentType.getXSType() == 1) {
            this.fCurrentCM = ((XSComplexTypeDecl)this.fCurrentType).getContentModel(this.fCMBuilder);
        }
        this.fCurrCMState = null;
        if (this.fCurrentCM != null) {
            this.fCurrCMState = this.fCurrentCM.startContentModel();
        }
        this.fBuffer.setLength(0);
        this.fSawCharacters = false;
        this.fSawChildren = false;
        String xsiNil = attributes.getValue(this.URI_XSI, this.XSI_NIL);
        if (xsiNil != null && this.fCurrentElemDecl != null) {
            this.getXsiNil(element, xsiNil);
        }
        XSAttributeGroupDecl attrGrp = null;
        if (this.fCurrentType.getXSType() == 1) {
            XSComplexTypeDecl ctype = (XSComplexTypeDecl)this.fCurrentType;
            attrGrp = ctype.fAttrGrp;
        }
        this.processAttributes(element, attributes, attrGrp);
        if (this.fDoValidation) {
            this.fValueStoreCache.startElement();
            this.fMatcherStack.pushContext();
            if (this.fCurrentElemDecl != null) {
                this.fValueStoreCache.initValueStoresFor(this.fCurrentElemDecl);
                int icCount = this.fCurrentElemDecl.fIDCPos;
                int uniqueOrKey = 0;
                while (uniqueOrKey < icCount) {
                    if (this.fCurrentElemDecl.fIDConstraints[uniqueOrKey].getType() == 2) break;
                    this.activateSelectorFor(this.fCurrentElemDecl.fIDConstraints[uniqueOrKey]);
                    ++uniqueOrKey;
                }
                int keyref = uniqueOrKey;
                while (keyref < icCount) {
                    this.activateSelectorFor(this.fCurrentElemDecl.fIDConstraints[keyref]);
                    ++keyref;
                }
            }
            int count = this.fMatcherStack.getMatcherCount();
            int i = 0;
            while (i < count) {
                XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
                matcher.startElement(element, attributes, this.fCurrentElemDecl);
                ++i;
            }
        }
        return augs;
    }

    Augmentations handleEndElement(QName element, Augmentations augs) {
        if (augs == null) {
            augs = this.fAugmentations;
            augs.clear();
        }
        this.fCurrentPSVI = (ElementPSVImpl)augs.getItem("ELEMENT_PSVI");
        if (this.fCurrentPSVI == null) {
            this.fCurrentPSVI = this.fElemPSVI;
            augs.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
        }
        this.fCurrentPSVI.reset();
        if (this.fSkipValidationDepth >= 0 || this.fValidationRootDepth == -1) {
            if (this.fSkipValidationDepth == this.fElementDepth && this.fSkipValidationDepth > 0) {
                this.fPartialValidationDepth = this.fSkipValidationDepth - 1;
                this.fSkipValidationDepth = -1;
                --this.fElementDepth;
                this.fChildCount = this.fChildCountStack[this.fElementDepth];
                this.fCurrentElemDecl = this.fElemDeclStack[this.fElementDepth];
                this.fNil = this.fNilStack[this.fElementDepth];
                this.fCurrentType = this.fTypeStack[this.fElementDepth];
                this.fCurrentCM = this.fCMStack[this.fElementDepth];
                this.fCurrCMState = this.fCMStateStack[this.fElementDepth];
                this.fSawCharacters = this.fStringContent[this.fElementDepth];
                this.fSawChildren = this.fSawChildrenStack[this.fElementDepth];
            } else {
                --this.fElementDepth;
            }
            this.fNamespaceSupport.popContext();
            String[] errors = this.fXSIErrorReporter.popContext();
            if (this.fElementDepth == -1 && this.fDoValidation && this.fFullChecking) {
                XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fXSIErrorReporter.fErrorReporter);
            }
            this.fDefaultValue = null;
            return augs;
        }
        XMLString defaultValue = this.processElementContent(element);
        int oldCount = this.fMatcherStack.getMatcherCount();
        int i = oldCount - 1;
        while (i >= 0) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
            matcher.endElement(element, this.fCurrentElemDecl);
            --i;
        }
        if (this.fMatcherStack.size() > 0) {
            this.fMatcherStack.popContext();
        }
        int newCount = this.fMatcherStack.getMatcherCount();
        int i2 = oldCount - 1;
        while (i2 >= newCount) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i2);
            IdentityConstraint id = matcher.getIDConstraint();
            if (id != null && id.getType() != 2) {
                matcher.endDocumentFragment();
                this.fValueStoreCache.transplant(id);
            } else if (id == null) {
                matcher.endDocumentFragment();
            }
            --i2;
        }
        int i3 = oldCount - 1;
        while (i3 >= newCount) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i3);
            IdentityConstraint id = matcher.getIDConstraint();
            if (id != null && id.getType() == 2) {
                ValueStoreBase values = this.fValueStoreCache.getValueStoreFor(id);
                if (values != null) {
                    values.endDocumentFragment();
                }
                matcher.endDocumentFragment();
            }
            --i3;
        }
        this.fValueStoreCache.endElement();
        if (this.fValidationRootDepth == this.fElementDepth) {
            this.fValidationRootDepth = -1;
            this.fValidationRoot = null;
            if (this.fDoValidation && this.fValidationState.checkIDRefID() != null) {
                this.reportSchemaError("ValidationRoot", null);
            }
            this.fValidationState.resetIDTables();
        }
        if (this.fElementDepth <= this.fPartialValidationDepth) {
            this.fCurrentPSVI.fValidationAttempted = (short)2;
            if (this.fElementDepth == this.fPartialValidationDepth) {
                --this.fPartialValidationDepth;
            }
        } else {
            this.fCurrentPSVI.fValidationAttempted = (short)3;
        }
        --this.fElementDepth;
        if (this.fElementDepth == -1) {
            if (this.fDoValidation && this.fFullChecking) {
                XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fXSIErrorReporter.fErrorReporter);
            }
        } else {
            this.fChildCount = this.fChildCountStack[this.fElementDepth];
            this.fCurrentElemDecl = this.fElemDeclStack[this.fElementDepth];
            this.fNil = this.fNilStack[this.fElementDepth];
            this.fCurrentType = this.fTypeStack[this.fElementDepth];
            this.fCurrentCM = this.fCMStack[this.fElementDepth];
            this.fCurrCMState = this.fCMStateStack[this.fElementDepth];
            this.fSawCharacters = this.fStringContent[this.fElementDepth];
            this.fSawChildren = this.fSawChildrenStack[this.fElementDepth];
        }
        this.fNamespaceSupport.popContext();
        String[] errors = this.fXSIErrorReporter.popContext();
        this.fCurrentPSVI.fErrorCodes = errors;
        this.fCurrentPSVI.fValidity = (short)(errors == null ? 2 : 1);
        this.fDefaultValue = defaultValue;
        if (this.fNormalizeData) {
            this.fTrailing = false;
            this.fUnionType = false;
            this.fWhiteSpace = (short)-1;
        }
        return augs;
    }

    void handleStartPrefix(String prefix, String uri) {
        if (this.fPushForNextBinding) {
            this.fNamespaceSupport.pushContext();
            this.fPushForNextBinding = false;
        }
        this.fNamespaceSupport.declarePrefix(prefix, uri.length() != 0 ? uri : null);
    }

    void storeLocations(String sLocation, String nsLocation) {
        if (sLocation != null) {
            StringTokenizer t = new StringTokenizer(sLocation, " \n\t\r");
            while (t.hasMoreTokens()) {
                String namespace = this.fSymbolTable.addSymbol(t.nextToken());
                if (!t.hasMoreTokens()) {
                    this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "SchemaLocation", new Object[]{sLocation}, (short)0);
                    break;
                }
                Object locationArray = this.fLocationPairs.get(namespace);
                if (locationArray == null) {
                    locationArray = new LocationArray();
                    this.fLocationPairs.put(namespace, locationArray);
                }
                String location = t.nextToken();
                ((LocationArray)locationArray).setLocation(location);
            }
        }
        if (nsLocation != null) {
            this.fNoNamespaceLocationArray.setLocation(nsLocation);
        }
    }

    SchemaGrammar findSchemaGrammar(short contextType, String namespace, QName enclosingElement, QName triggeringComponet, XMLAttributes attributes) {
        SchemaGrammar grammar = null;
        grammar = this.fGrammarBucket.getGrammar(namespace);
        if (grammar == null) {
            grammar = this.getSchemaGrammarFromAppl(contextType, namespace, enclosingElement, triggeringComponet, attributes);
            if (grammar != null) {
                return grammar;
            }
        } else {
            return grammar;
        }
        grammar = this.parseSchema(namespace, contextType);
        return grammar;
    }

    SchemaGrammar getSchemaGrammarFromAppl(short contextType, String namespace, QName enclosingElement, QName triggeringComponet, XMLAttributes attribute) {
        if (this.fGrammarPool != null) {
            this.fXSDDescription.reset();
            this.fXSDDescription.fContextType = contextType;
            this.fXSDDescription.fTargetNamespace = namespace;
            this.fXSDDescription.fEnclosedElementName = enclosingElement;
            this.fXSDDescription.fTriggeringComponent = triggeringComponet;
            this.fXSDDescription.fAttributes = attribute;
            Object locationArray = null;
            if (namespace != null) {
                locationArray = this.fLocationPairs.get(namespace);
                if (locationArray != null) {
                    String[] temp = ((LocationArray)locationArray).getLocationArray();
                    this.fXSDDescription.fLocationHints = new String[temp.length];
                    System.arraycopy(temp, 0, this.fXSDDescription.fLocationHints, 0, temp.length);
                }
            } else {
                String[] temp = this.fNoNamespaceLocationArray.getLocationArray();
                this.fXSDDescription.fLocationHints = new String[temp.length];
                System.arraycopy(temp, 0, this.fXSDDescription.fLocationHints, 0, temp.length);
            }
            return (SchemaGrammar)this.fGrammarPool.retrieveGrammar(this.fXSDDescription);
        }
        return null;
    }

    SchemaGrammar parseSchema(String namespace, short reference) {
        String locationHint = null;
        LocationArray locationArray = null;
        SchemaGrammar grammar = null;
        if (namespace != null) {
            locationArray = (LocationArray)this.fLocationPairs.get(namespace);
            if (locationArray != null) {
                locationHint = locationArray.getFirstLocation();
            }
        } else {
            locationHint = this.fNoNamespaceLocationArray.getFirstLocation();
        }
        if (namespace != null || locationHint != null) {
            grammar = this.fSchemaHandler.parseSchema(namespace, locationHint, reference);
        }
        return grammar;
    }

    void parseSchemas(String sLocation, String nsLocation) {
        if (sLocation != null) {
            StringTokenizer t = new StringTokenizer(sLocation, " \n\t\r");
            while (t.hasMoreTokens()) {
                String namespace = this.fSymbolTable.addSymbol(t.nextToken());
                if (!t.hasMoreTokens()) {
                    this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "SchemaLocation", new Object[]{sLocation}, (short)0);
                    break;
                }
                String location = t.nextToken();
                if (this.fGrammarBucket.getGrammar(namespace) != null) continue;
                this.fSchemaHandler.parseSchema(namespace, location, (short)4);
            }
        }
        if (nsLocation != null && this.fGrammarBucket.getGrammar(null) == null) {
            this.fSchemaHandler.parseSchema(null, nsLocation, (short)4);
        }
    }

    private void processJAXPSchemaSource(Object val, XMLEntityResolver xer) {
        if (val == null) {
            return;
        }
        Class<?> componentType = val.getClass().getComponentType();
        if (componentType == null) {
            this.fSchemaHandler.parseSchema(null, this.XSD2XMLInputSource(val, xer), (short)3);
            return;
        }
        if (componentType != (class$java$lang$Object == null ? (class$java$lang$Object = XMLSchemaValidator.class$("java.lang.Object")) : class$java$lang$Object)) {
            throw new XMLConfigurationException(1, JAXP_SCHEMA_SOURCE);
        }
        Object[] objArr = (Object[])val;
        int i = 0;
        while (i < objArr.length) {
            this.fSchemaHandler.parseSchema(null, this.XSD2XMLInputSource(objArr[i], xer), (short)3);
            ++i;
        }
    }

    private XMLInputSource XSD2XMLInputSource(Object val, XMLEntityResolver entityResolver) {
        if (val instanceof String) {
            String loc = (String)val;
            if (entityResolver != null) {
                this.fResourceIdentifier.setValues(null, loc, null, null);
                XMLInputSource xis = null;
                try {
                    xis = entityResolver.resolveEntity(this.fResourceIdentifier);
                }
                catch (IOException ex) {
                    this.reportSchemaError("schema_reference.4", new Object[]{loc});
                }
                if (xis == null) {
                    return new XMLInputSource(null, loc, null);
                }
                return xis;
            }
        } else {
            if (val instanceof InputSource) {
                return XMLSchemaValidator.SAX2XMLInputSource((InputSource)val);
            }
            if (val instanceof InputStream) {
                return new XMLInputSource(null, null, null, (InputStream)val, null);
            }
            if (val instanceof File) {
                File file = (File)val;
                BufferedInputStream is = null;
                try {
                    is = new BufferedInputStream(new FileInputStream(file));
                }
                catch (FileNotFoundException ex) {
                    this.reportSchemaError("schema_reference.4", new Object[]{file.toString()});
                }
                return new XMLInputSource(null, null, null, is, null);
            }
        }
        throw new XMLConfigurationException(1, JAXP_SCHEMA_SOURCE);
    }

    private static XMLInputSource SAX2XMLInputSource(InputSource sis) {
        String publicId = sis.getPublicId();
        String systemId = sis.getSystemId();
        Reader charStream = sis.getCharacterStream();
        if (charStream != null) {
            return new XMLInputSource(publicId, systemId, null, charStream, null);
        }
        InputStream byteStream = sis.getByteStream();
        if (byteStream != null) {
            return new XMLInputSource(publicId, systemId, null, byteStream, sis.getEncoding());
        }
        return new XMLInputSource(publicId, systemId, null);
    }

    void getAndCheckXsiType(QName element, String xsiType, XMLAttributes attributes) {
        SchemaGrammar grammar;
        QName typeName = null;
        try {
            typeName = (QName)this.fQNameDV.validate(xsiType, this.fValidationState, null);
        }
        catch (InvalidDatatypeValueException e) {
            this.reportSchemaError("cvc-elt.4.1", new Object[]{element.rawname, this.URI_XSI + "," + this.XSI_TYPE, xsiType});
            return;
        }
        XSTypeDecl type = null;
        if (typeName.uri == this.URI_SCHEMAFORSCHEMA) {
            type = SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl(typeName.localpart);
        }
        if (type == null && (grammar = this.findSchemaGrammar((short)7, typeName.uri, element, typeName, attributes)) != null) {
            type = grammar.getGlobalTypeDecl(typeName.localpart);
        }
        if (type == null) {
            this.reportSchemaError("cvc-elt.4.2", new Object[]{element.rawname, xsiType});
            return;
        }
        if (this.fCurrentType != null) {
            short block = this.fCurrentElemDecl.fBlock;
            if (this.fCurrentType.getXSType() == 1) {
                block = (short)(block | ((XSComplexTypeDecl)this.fCurrentType).fBlock);
            }
            if (!XSConstraints.checkTypeDerivationOk(type, this.fCurrentType, block)) {
                this.reportSchemaError("cvc-elt.4.3", new Object[]{element.rawname, xsiType});
            }
        }
        this.fCurrentType = type;
    }

    void getXsiNil(QName element, String xsiNil) {
        if (this.fCurrentElemDecl != null && !this.fCurrentElemDecl.isNillable()) {
            this.reportSchemaError("cvc-elt.3.1", new Object[]{element.rawname, this.URI_XSI + "," + this.XSI_NIL});
        } else {
            String value = xsiNil.trim();
            if (value.equals("true") || value.equals("1")) {
                this.fNil = true;
                if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2) {
                    this.reportSchemaError("cvc-elt.3.2.2", new Object[]{element.rawname, this.URI_XSI + "," + this.XSI_NIL});
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void processAttributes(QName element, XMLAttributes attributes, XSAttributeGroupDecl attrGrp) {
        augs = null;
        attrPSVI = null;
        k = 0;
        while (k < attributes.getLength()) {
            augs = attributes.getAugmentations(k);
            attrPSVI = (AttributePSVImpl)augs.getItem("ATTRIBUTE_PSVI");
            if (attrPSVI != null) {
                attrPSVI.reset();
            } else {
                attrPSVI = new AttributePSVImpl();
                augs.putItem("ATTRIBUTE_PSVI", attrPSVI);
            }
            attrPSVI.fValidationContext = element.rawname;
            ++k;
        }
        if (attrGrp != null) {
            this.addDefaultAttributes(element, attributes, attrGrp);
        }
        if (!this.fDoValidation) {
            return;
        }
        if (this.fCurrentType == null || this.fCurrentType.getXSType() == 2) {
            attCount = attributes.getLength();
            index = 0;
            while (index < attCount) {
                attributes.getName(index, this.fTempQName);
                attrPSVI = (AttributePSVImpl)attributes.getAugmentations(index).getItem("ATTRIBUTE_PSVI");
                attrPSVI.fValidationAttempted = (short)3;
                attrPSVI.fValidity = (short)2;
                attrPSVI.fNormalizedValue = attributes.getValue(index);
                if (this.fTempQName.uri == this.URI_XSI) {
                    if (this.fTempQName.localpart != this.XSI_SCHEMALOCATION && this.fTempQName.localpart != this.XSI_NONAMESPACESCHEMALOCATION && this.fTempQName.localpart != this.XSI_NIL && this.fTempQName.localpart != this.XSI_TYPE) {
                        attrPSVI.fValidity = 1;
                        attrPSVI.addErrorCode("cvc-type.3.1.1");
                        this.reportSchemaError("cvc-type.3.1.1", new Object[]{element.rawname});
                    }
                } else if (this.fTempQName.rawname != this.XMLNS && !this.fTempQName.rawname.startsWith("xmlns:")) {
                    attrPSVI.fValidity = 1;
                    attrPSVI.addErrorCode("cvc-type.3.1.1");
                    this.reportSchemaError("cvc-type.3.1.1", new Object[]{element.rawname});
                }
                ++index;
            }
            return;
        }
        attrUses = attrGrp.getAttributeUses();
        useCount = attrUses.length;
        attrWildcard = attrGrp.fAttributeWC;
        wildcardIDName = null;
        attCount = attributes.getLength();
        index = 0;
        while (index < attCount) {
            block31: {
                block33: {
                    block32: {
                        attrPSVI = (AttributePSVImpl)attributes.getAugmentations(index).getItem("ATTRIBUTE_PSVI");
                        attrPSVI.fValidationAttempted = (short)3;
                        attrPSVI.fValidity = (short)2;
                        attrPSVI.fNormalizedValue = attributes.getValue(index);
                        attributes.getName(index, this.fTempQName);
                        if (this.fTempQName.uri == this.URI_XSI ? this.fTempQName.localpart == this.XSI_SCHEMALOCATION || this.fTempQName.localpart == this.XSI_NONAMESPACESCHEMALOCATION || this.fTempQName.localpart == this.XSI_NIL || this.fTempQName.localpart == this.XSI_TYPE : this.fTempQName.rawname == this.XMLNS || this.fTempQName.rawname.startsWith("xmlns:") != false) break block31;
                        currUse = null;
                        i = 0;
                        while (i < useCount) {
                            if (attrUses[i].fAttrDecl.fName == this.fTempQName.localpart && attrUses[i].fAttrDecl.fTargetNamespace == this.fTempQName.uri) {
                                currUse = attrUses[i];
                                break;
                            }
                            ++i;
                        }
                        if (currUse != null || attrWildcard != null && attrWildcard.allowNamespace(this.fTempQName.uri)) break block32;
                        this.reportSchemaError("cvc-complex-type.3.2.2", new Object[]{element.rawname, this.fTempQName.rawname});
                        attrPSVI.fValidity = 1;
                        attrPSVI.addErrorCode("cvc-complex-type.3.2.2");
                        break block31;
                    }
                    currDecl = null;
                    if (currUse == null) break block33;
                    currDecl = currUse.fAttrDecl;
                    ** GOTO lbl91
                }
                if (attrWildcard.fProcessContents == 2) break block31;
                grammar = this.findSchemaGrammar((short)6, this.fTempQName.uri, element, this.fTempQName, attributes);
                if (grammar != null) {
                    currDecl = grammar.getGlobalAttributeDecl(this.fTempQName.localpart);
                }
                if (currDecl == null) {
                    if (attrWildcard.fProcessContents == 0) {
                        this.reportSchemaError("cvc-complex-type.3.2.2", new Object[]{element.rawname, this.fTempQName.rawname});
                        attrPSVI.fValidity = 1;
                        attrPSVI.addErrorCode("cvc-complex-type.3.2.2");
                    }
                } else {
                    if (currDecl.fType.getXSType() == 2 && currDecl.fType.isIDType()) {
                        if (wildcardIDName != null) {
                            this.reportSchemaError("cvc-complex-type.5.1", new Object[]{element.rawname, currDecl.fName, wildcardIDName});
                            attrPSVI.fValidity = 1;
                            attrPSVI.addErrorCode("cvc-complex-type.5.1");
                        } else {
                            wildcardIDName = currDecl.fName;
                        }
                    }
lbl91:
                    // 5 sources

                    attDV = currDecl.fType;
                    attrPSVI.fDeclaration = currDecl;
                    attrPSVI.fTypeDecl = attDV;
                    attrPSVI.fValidationAttempted = (short)3;
                    if (attributes.getType(index).equals("CDATA")) {
                        type = currDecl.fType.isIDType() != false ? "ID" : "CDATA";
                        attributes.setType(index, type);
                    }
                    attrValue = attributes.getValue(index);
                    actualValue = null;
                    try {
                        actualValue = attDV.validate(attrValue, this.fValidationState, this.fValidatedInfo);
                        attrPSVI.fNormalizedValue = this.fValidatedInfo.normalizedValue;
                        attrPSVI.fMemberType = this.fValidatedInfo.memberType;
                        if (attDV.getVariety() == 1 && ((XSAtomicSimpleType)attDV).getPrimitiveKind() == 19) {
                            qName = (QName)actualValue;
                            grammar = this.fGrammarBucket.getGrammar(qName.uri);
                            if (grammar != null) {
                                this.fCurrentPSVI.fNotation = grammar.getNotationDecl(qName.localpart);
                            }
                        }
                    }
                    catch (InvalidDatatypeValueException idve) {
                        attrPSVI.fValidity = 1;
                        attrPSVI.addErrorCode("cvc-attribute.3");
                        this.reportSchemaError("cvc-attribute.3", new Object[]{element.rawname, this.fTempQName.rawname, attrValue});
                    }
                    if (actualValue != null && currDecl.getConstraintType() == 2 && !attDV.isEqual(actualValue, currDecl.fDefault.actualValue)) {
                        attrPSVI.fValidity = 1;
                        attrPSVI.addErrorCode("cvc-attribute.4");
                        this.reportSchemaError("cvc-attribute.4", new Object[]{element.rawname, this.fTempQName.rawname, attrValue});
                    }
                    if (actualValue != null && currUse != null && currUse.fConstraintType == 2 && !attDV.isEqual(actualValue, currUse.fDefault.actualValue)) {
                        attrPSVI.fValidity = 1;
                        attrPSVI.addErrorCode("cvc-complex-type.3.1");
                        this.reportSchemaError("cvc-complex-type.3.1", new Object[]{element.rawname, this.fTempQName.rawname, attrValue});
                    }
                }
            }
            ++index;
        }
        if (attrGrp.fIDAttrName != null && wildcardIDName != null) {
            attrPSVI.fValidity = 1;
            attrPSVI.addErrorCode("cvc-complex-type.3.1");
            this.reportSchemaError("cvc-complex-type.5.2", new Object[]{element.rawname, wildcardIDName, attrGrp.fIDAttrName});
        }
    }

    void addDefaultAttributes(QName element, XMLAttributes attributes, XSAttributeGroupDecl attrGrp) {
        XSAttributeUse[] attrUses = attrGrp.getAttributeUses();
        int useCount = attrUses.length;
        int i = 0;
        while (i < useCount) {
            boolean isSpecified;
            XSAttributeUse currUse = attrUses[i];
            XSAttributeDecl currDecl = currUse.fAttrDecl;
            short constType = currUse.fConstraintType;
            ValidatedInfo defaultValue = currUse.fDefault;
            if (constType == 0) {
                constType = currDecl.getConstraintType();
                defaultValue = currDecl.fDefault;
            }
            boolean bl = isSpecified = attributes.getValue(currDecl.fTargetNamespace, currDecl.fName) != null;
            if (currUse.fUse == 1 && !isSpecified) {
                this.reportSchemaError("cvc-complex-type.4", new Object[]{element.rawname, currDecl.fName});
            }
            if (!isSpecified && constType != 0) {
                QName attName = new QName(null, currDecl.fName, currDecl.fName, currDecl.fTargetNamespace);
                String type = currDecl.fType.isIDType() ? "ID" : "CDATA";
                int attrIndex = attributes.addAttribute(attName, type, defaultValue != null ? defaultValue.normalizedValue : "");
                Augmentations augs = attributes.getAugmentations(attrIndex);
                AttributePSVImpl attrPSVI = (AttributePSVImpl)augs.getItem("ATTRIBUTE_PSVI");
                if (attrPSVI != null) {
                    attrPSVI.reset();
                } else {
                    attrPSVI = new AttributePSVImpl();
                    augs.putItem("ATTRIBUTE_PSVI", attrPSVI);
                }
                attrPSVI.fSpecified = false;
                attrPSVI.fValidationContext = element.rawname;
            }
            ++i;
        }
    }

    XMLString processElementContent(QName element) {
        XMLString defaultValue = null;
        if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.fDefault != null && this.fBuffer.toString().length() == 0 && this.fChildCount == 0 && !this.fNil) {
            this.fCurrentPSVI.fSpecified = false;
            int bufLen = this.fCurrentElemDecl.fDefault.normalizedValue.length();
            char[] chars = new char[bufLen];
            this.fCurrentElemDecl.fDefault.normalizedValue.getChars(0, bufLen, chars, 0);
            defaultValue = new XMLString(chars, 0, bufLen);
            int count = this.fMatcherStack.getMatcherCount();
            int i = 0;
            while (i < count) {
                XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
                matcher.characters(defaultValue);
                ++i;
            }
        }
        if (this.fCurrentElemDecl == null || this.fCurrentElemDecl.getConstraintType() == 1) {
            // empty if block
        }
        if (this.fDoValidation) {
            String content = this.fBuffer.toString();
            if (this.fNil) {
                if (this.fChildCount != 0 || content.length() != 0) {
                    this.reportSchemaError("cvc-elt.3.2.1", new Object[]{element.rawname, this.URI_XSI + "," + this.XSI_NIL});
                    this.fCurrentPSVI.fNil = false;
                } else {
                    this.fCurrentPSVI.fNil = true;
                }
            }
            if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() != 0 && this.fChildCount == 0 && content.length() == 0 && !this.fNil) {
                if (this.fCurrentType != this.fCurrentElemDecl.fType && XSConstraints.ElementDefaultValidImmediate(this.fCurrentType, this.fCurrentElemDecl.fDefault, this.fState4XsiType, null) == null) {
                    this.reportSchemaError("cvc-elt.5.1.1", new Object[]{element.rawname, this.fCurrentType.getTypeName(), this.fCurrentElemDecl.fDefault.normalizedValue});
                }
                this.elementLocallyValidType(element, this.fCurrentElemDecl.fDefault.normalizedValue);
            } else {
                Object actualValue = this.elementLocallyValidType(element, content);
                if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2 && !this.fNil) {
                    XSSimpleType sType;
                    if (this.fChildCount != 0) {
                        this.reportSchemaError("cvc-elt.5.2.2.1", new Object[]{element.rawname});
                    }
                    if (this.fCurrentType.getXSType() == 1) {
                        XSComplexTypeDecl ctype = (XSComplexTypeDecl)this.fCurrentType;
                        if (ctype.fContentType == 2) {
                            if (!this.fCurrentElemDecl.fDefault.normalizedValue.equals(content)) {
                                this.reportSchemaError("cvc-elt.5.2.2.2.1", new Object[]{element.rawname, content, this.fCurrentElemDecl.fDefault.normalizedValue});
                            }
                        } else if (ctype.fContentType == 1 && actualValue != null && !ctype.fXSSimpleType.isEqual(actualValue, this.fCurrentElemDecl.fDefault.actualValue)) {
                            this.reportSchemaError("cvc-elt.5.2.2.2.2", new Object[]{element.rawname, content, this.fCurrentElemDecl.fDefault.normalizedValue});
                        }
                    } else if (this.fCurrentType.getXSType() == 2 && !(sType = (XSSimpleType)this.fCurrentType).isEqual(actualValue, this.fCurrentElemDecl.fDefault.actualValue)) {
                        this.reportSchemaError("cvc-elt.5.2.2.2.2", new Object[]{element.rawname, content, this.fCurrentElemDecl.fDefault.normalizedValue});
                    }
                }
            }
        }
        return defaultValue;
    }

    Object elementLocallyValidType(QName element, String textContent) {
        if (this.fCurrentType == null) {
            return null;
        }
        if (this.fUnionType) {
            int bufLen = textContent.length();
            if (bufLen >= 20) {
                this.fCharBuffer = new char[bufLen * 2];
            }
            textContent.getChars(0, bufLen, this.fCharBuffer, 0);
            this.fXMLString.setValues(this.fCharBuffer, 0, bufLen);
        }
        Object retValue = null;
        if (this.fCurrentType.getXSType() == 2) {
            if (this.fChildCount != 0) {
                this.reportSchemaError("cvc-type.3.1.2", new Object[]{element.rawname});
            }
            if (!this.fNil) {
                XSSimpleType dv = (XSSimpleType)this.fCurrentType;
                try {
                    if (!this.fNormalizeData || this.fUnionType) {
                        this.fValidationState.setNormalizationRequired(true);
                    }
                    retValue = dv.validate(textContent, this.fValidationState, this.fValidatedInfo);
                    this.fCurrentPSVI.fNormalizedValue = this.fValidatedInfo.normalizedValue;
                    this.fCurrentPSVI.fMemberType = this.fValidatedInfo.memberType;
                    if (this.fDocumentHandler != null && this.fUnionType) {
                        this.fAugmentations.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
                        this.fDocumentHandler.characters(this.fXMLString, this.fAugmentations);
                    }
                }
                catch (InvalidDatatypeValueException e) {
                    if (this.fDocumentHandler != null && this.fUnionType) {
                        this.fCurrentPSVI.fNormalizedValue = null;
                        this.fAugmentations.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
                        this.fDocumentHandler.characters(this.fXMLString, this.fAugmentations);
                    }
                    this.reportSchemaError("cvc-type.3.1.3", new Object[]{element.rawname, textContent});
                }
            }
        } else {
            retValue = this.elementLocallyValidComplexType(element, textContent);
        }
        return retValue;
    }

    Object elementLocallyValidComplexType(QName element, String textContent) {
        Object actualValue = null;
        XSComplexTypeDecl ctype = (XSComplexTypeDecl)this.fCurrentType;
        if (!this.fNil) {
            if (ctype.fContentType == 0 && (this.fChildCount != 0 || textContent.length() != 0 || this.fSawChildren)) {
                this.reportSchemaError("cvc-complex-type.2.1", new Object[]{element.rawname});
            } else if (ctype.fContentType == 1) {
                if (this.fChildCount != 0) {
                    this.reportSchemaError("cvc-complex-type.2.2", new Object[]{element.rawname});
                }
                XSSimpleType dv = ctype.fXSSimpleType;
                try {
                    if (!this.fNormalizeData || this.fUnionType) {
                        this.fValidationState.setNormalizationRequired(true);
                    }
                    actualValue = dv.validate(textContent, this.fValidationState, this.fValidatedInfo);
                    this.fCurrentPSVI.fNormalizedValue = this.fValidatedInfo.normalizedValue;
                    this.fCurrentPSVI.fMemberType = this.fValidatedInfo.memberType;
                    if (this.fDocumentHandler != null && this.fUnionType) {
                        this.fAugmentations.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
                        this.fDocumentHandler.characters(this.fXMLString, this.fAugmentations);
                    }
                }
                catch (InvalidDatatypeValueException e) {
                    if (this.fDocumentHandler != null && this.fUnionType) {
                        this.fCurrentPSVI.fNormalizedValue = null;
                        this.fAugmentations.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
                        this.fDocumentHandler.characters(this.fXMLString, this.fAugmentations);
                    }
                    this.reportSchemaError("cvc-complex-type.2.2", new Object[]{element.rawname});
                }
            } else if (ctype.fContentType == 3 && this.fSawCharacters) {
                this.reportSchemaError("cvc-complex-type.2.3", new Object[]{element.rawname});
            }
            if (!(ctype.fContentType != 3 && ctype.fContentType != 2 || this.fCurrCMState[0] < 0 || this.fCurrentCM.endContentModel(this.fCurrCMState))) {
                this.reportSchemaError("cvc-complex-type.2.4.b", new Object[]{element.rawname, ctype.fParticle.toString()});
            }
        }
        return actualValue;
    }

    void reportSchemaError(String key, Object[] arguments) {
        if (this.fDoValidation) {
            this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", key, arguments, (short)1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class OrderedHashtable
    implements Cloneable {
        private int fSize;
        private Entry[] fEntries = null;

        OrderedHashtable() {
        }

        public int size() {
            return this.fSize;
        }

        public void put(Field key, IDValue value) {
            int index = this.indexOf(key);
            if (index == -1) {
                this.ensureCapacity(this.fSize);
                index = this.fSize++;
                this.fEntries[index].key = key;
            }
            this.fEntries[index].value = value;
        }

        public IDValue get(Field key) {
            return this.fEntries[this.indexOf((Field)key)].value;
        }

        public int indexOf(Field key) {
            int i = 0;
            while (i < this.fSize) {
                if (this.fEntries[i].key == key) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Field keyAt(int index) {
            return this.fEntries[index].key;
        }

        public IDValue valueAt(int index) {
            return this.fEntries[index].value;
        }

        public void clear() {
            this.fSize = 0;
        }

        private void ensureCapacity(int size) {
            int osize = -1;
            int nsize = -1;
            if (this.fEntries == null) {
                osize = 0;
                nsize = 2;
                this.fEntries = new Entry[nsize];
            } else if (this.fEntries.length <= size) {
                osize = this.fEntries.length;
                nsize = 2 * osize;
                Entry[] array = new Entry[nsize];
                System.arraycopy(this.fEntries, 0, array, 0, osize);
                this.fEntries = array;
            }
            int i = osize;
            while (i < nsize) {
                this.fEntries[i] = new Entry();
                ++i;
            }
        }

        public Object clone() {
            OrderedHashtable hashtable = new OrderedHashtable();
            int i = 0;
            while (i < this.fSize) {
                hashtable.put(this.fEntries[i].key, this.fEntries[i].value);
                ++i;
            }
            return hashtable;
        }

        public String toString() {
            if (this.fSize == 0) {
                return "[]";
            }
            StringBuffer str = new StringBuffer();
            str.append('[');
            int i = 0;
            while (i < this.fSize) {
                if (i > 0) {
                    str.append(',');
                }
                str.append('{');
                str.append(this.fEntries[i].key);
                str.append(',');
                str.append(this.fEntries[i].value);
                str.append('}');
                ++i;
            }
            str.append(']');
            return str.toString();
        }

        public static final class Entry {
            public Field key;
            public IDValue value;
        }
    }

    protected class ValueStoreCache {
        protected final Vector fValueStores = new Vector();
        protected final Hashtable fIdentityConstraint2ValueStoreMap = new Hashtable();
        protected final Stack fGlobalMapStack = new Stack();
        protected final Hashtable fGlobalIDConstraintMap = new Hashtable();

        public void startDocument() throws XNIException {
            this.fValueStores.removeAllElements();
            this.fIdentityConstraint2ValueStoreMap.clear();
            this.fGlobalIDConstraintMap.clear();
            this.fGlobalMapStack.removeAllElements();
        }

        public void startElement() {
            this.fGlobalMapStack.push(this.fGlobalIDConstraintMap.clone());
            this.fGlobalIDConstraintMap.clear();
        }

        public void endElement() {
            if (this.fGlobalMapStack.isEmpty()) {
                return;
            }
            Hashtable oldMap = (Hashtable)this.fGlobalMapStack.pop();
            Enumeration keys = oldMap.keys();
            while (keys.hasMoreElements()) {
                IdentityConstraint id = (IdentityConstraint)keys.nextElement();
                ValueStoreBase oldVal = (ValueStoreBase)oldMap.get(id);
                if (oldVal == null) continue;
                ValueStoreBase currVal = (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
                if (currVal == null) {
                    this.fGlobalIDConstraintMap.put(id, oldVal);
                    continue;
                }
                currVal.append(oldVal);
                this.fGlobalIDConstraintMap.put(id, currVal);
            }
        }

        public void initValueStoresFor(XSElementDecl eDecl) throws XNIException {
            IdentityConstraint[] icArray = eDecl.fIDConstraints;
            int icCount = eDecl.fIDCPos;
            int i = 0;
            while (i < icCount) {
                switch (icArray[i].getType()) {
                    case 0: {
                        UniqueOrKey unique = (UniqueOrKey)icArray[i];
                        UniqueValueStore uniqueValueStore = (UniqueValueStore)this.fIdentityConstraint2ValueStoreMap.get(unique);
                        if (uniqueValueStore != null) break;
                        uniqueValueStore = new UniqueValueStore(unique);
                        this.fValueStores.addElement(uniqueValueStore);
                        this.fIdentityConstraint2ValueStoreMap.put(unique, uniqueValueStore);
                        break;
                    }
                    case 1: {
                        UniqueOrKey key = (UniqueOrKey)icArray[i];
                        KeyValueStore keyValueStore = (KeyValueStore)this.fIdentityConstraint2ValueStoreMap.get(key);
                        if (keyValueStore != null) break;
                        keyValueStore = new KeyValueStore(key);
                        this.fValueStores.addElement(keyValueStore);
                        this.fIdentityConstraint2ValueStoreMap.put(key, keyValueStore);
                        break;
                    }
                    case 2: {
                        KeyRef keyRef = (KeyRef)icArray[i];
                        KeyRefValueStore keyRefValueStore = (KeyRefValueStore)this.fIdentityConstraint2ValueStoreMap.get(keyRef);
                        if (keyRefValueStore != null) break;
                        keyRefValueStore = new KeyRefValueStore(keyRef, null);
                        this.fValueStores.addElement(keyRefValueStore);
                        this.fIdentityConstraint2ValueStoreMap.put(keyRef, keyRefValueStore);
                    }
                }
                ++i;
            }
        }

        public ValueStoreBase getValueStoreFor(Field field) {
            IdentityConstraint identityConstraint = field.getIdentityConstraint();
            return (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(identityConstraint);
        }

        public ValueStoreBase getValueStoreFor(IdentityConstraint id) {
            return (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(id);
        }

        public ValueStoreBase getGlobalValueStoreFor(IdentityConstraint id) {
            return (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
        }

        public void transplant(IdentityConstraint id) {
            if (id.getType() == 2) {
                return;
            }
            ValueStoreBase newVals = (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(id);
            this.fIdentityConstraint2ValueStoreMap.remove(id);
            ValueStoreBase currVals = (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
            if (currVals != null) {
                currVals.append(newVals);
                this.fGlobalIDConstraintMap.put(id, currVals);
            } else {
                this.fGlobalIDConstraintMap.put(id, newVals);
            }
        }

        public void endDocument() throws XNIException {
            int count = this.fValueStores.size();
            int i = 0;
            while (i < count) {
                ValueStoreBase valueStore = (ValueStoreBase)this.fValueStores.elementAt(i);
                valueStore.endDocument();
                ++i;
            }
        }

        public String toString() {
            String s = super.toString();
            int index1 = s.lastIndexOf(36);
            if (index1 != -1) {
                return s.substring(index1 + 1);
            }
            int index2 = s.lastIndexOf(46);
            if (index2 != -1) {
                return s.substring(index2 + 1);
            }
            return s;
        }
    }

    protected class KeyRefValueStore
    extends ValueStoreBase {
        protected ValueStoreBase fKeyValueStore;

        public KeyRefValueStore(KeyRef keyRef, KeyValueStore keyValueStore) {
            super(keyRef);
            this.fKeyValueStore = keyValueStore;
        }

        public void endDocumentFragment() throws XNIException {
            super.endDocumentFragment();
            this.fKeyValueStore = (ValueStoreBase)XMLSchemaValidator.this.fValueStoreCache.fGlobalIDConstraintMap.get(((KeyRef)this.fIdentityConstraint).getKey());
            if (this.fKeyValueStore == null) {
                String code = "KeyRefOutOfScope";
                String value = this.fIdentityConstraint.toString();
                XMLSchemaValidator.this.reportSchemaError(code, new Object[]{value});
                return;
            }
            int count = this.fValueTuples.size();
            int i = 0;
            while (i < count) {
                OrderedHashtable values = (OrderedHashtable)this.fValueTuples.elementAt(i);
                if (!this.fKeyValueStore.contains(values)) {
                    String code = "KeyNotFound";
                    String value = this.toString(values);
                    String element = this.fIdentityConstraint.getElementName();
                    XMLSchemaValidator.this.reportSchemaError(code, new Object[]{value, element});
                }
                ++i;
            }
        }

        public void endDocument() throws XNIException {
            super.endDocument();
        }
    }

    protected class KeyValueStore
    extends ValueStoreBase {
        public KeyValueStore(UniqueOrKey key) {
            super(key);
        }

        protected void duplicateValue(OrderedHashtable tuple) throws XNIException {
            String code = "DuplicateKey";
            String value = this.toString(tuple);
            String ename = this.fIdentityConstraint.getElementName();
            XMLSchemaValidator.this.reportSchemaError(code, new Object[]{value, ename});
        }
    }

    protected class UniqueValueStore
    extends ValueStoreBase {
        public UniqueValueStore(UniqueOrKey unique) {
            super(unique);
        }

        protected void duplicateValue(OrderedHashtable tuple) throws XNIException {
            String code = "DuplicateUnique";
            String value = this.toString(tuple);
            String ename = this.fIdentityConstraint.getElementName();
            XMLSchemaValidator.this.reportSchemaError(code, new Object[]{value, ename});
        }
    }

    protected abstract class ValueStoreBase
    implements ValueStore {
        protected IDValue NOT_AN_IDVALUE = new IDValue("\uffff", null);
        protected IdentityConstraint fIdentityConstraint;
        protected final OrderedHashtable fValues = new OrderedHashtable();
        protected int fValuesCount;
        protected final Vector fValueTuples = new Vector();

        protected ValueStoreBase(IdentityConstraint identityConstraint) {
            this.fIdentityConstraint = identityConstraint;
        }

        public void destroy() {
            this.fValuesCount = 0;
            this.fValues.clear();
            this.fValueTuples.removeAllElements();
        }

        public void append(ValueStoreBase newVal) {
            int i = 0;
            while (i < newVal.fValueTuples.size()) {
                OrderedHashtable o = (OrderedHashtable)newVal.fValueTuples.elementAt(i);
                if (!this.contains(o)) {
                    this.fValueTuples.addElement(o);
                }
                ++i;
            }
        }

        public void startValueScope() throws XNIException {
            this.fValuesCount = 0;
            int count = this.fIdentityConstraint.getFieldCount();
            int i = 0;
            while (i < count) {
                this.fValues.put(this.fIdentityConstraint.getFieldAt(i), this.NOT_AN_IDVALUE);
                ++i;
            }
        }

        public void endValueScope() throws XNIException {
            if (this.fValuesCount == 0) {
                if (this.fIdentityConstraint.getType() == 1) {
                    String code = "AbsentKeyValue";
                    String eName = this.fIdentityConstraint.getElementName();
                    XMLSchemaValidator.this.reportSchemaError(code, new Object[]{eName});
                }
                return;
            }
            if (this.fValuesCount != this.fIdentityConstraint.getFieldCount()) {
                switch (this.fIdentityConstraint.getType()) {
                    case 0: {
                        String code = "UniqueNotEnoughValues";
                        String ename = this.fIdentityConstraint.getElementName();
                        XMLSchemaValidator.this.reportSchemaError(code, new Object[]{ename});
                        break;
                    }
                    case 1: {
                        String code = "KeyNotEnoughValues";
                        UniqueOrKey key = (UniqueOrKey)this.fIdentityConstraint;
                        String ename = this.fIdentityConstraint.getElementName();
                        String kname = key.getIdentityConstraintName();
                        XMLSchemaValidator.this.reportSchemaError(code, new Object[]{ename, kname});
                        break;
                    }
                    case 2: {
                        String code = "KeyRefNotEnoughValues";
                        KeyRef keyref = (KeyRef)this.fIdentityConstraint;
                        String ename = this.fIdentityConstraint.getElementName();
                        String kname = keyref.getKey().getIdentityConstraintName();
                        XMLSchemaValidator.this.reportSchemaError(code, new Object[]{ename, kname});
                        break;
                    }
                }
                return;
            }
        }

        public void endDocumentFragment() throws XNIException {
        }

        public void endDocument() throws XNIException {
        }

        public void reportNilError(IdentityConstraint id) {
            if (id.getType() == 1) {
                String code = "KeyMatchesNillable";
                XMLSchemaValidator.this.reportSchemaError(code, new Object[]{id.getElementName()});
            }
        }

        public void addValue(Field field, IDValue value) {
            int index;
            if (!field.mayMatch()) {
                String code = "FieldMultipleMatch";
                XMLSchemaValidator.this.reportSchemaError(code, new Object[]{field.toString()});
            }
            if ((index = this.fValues.indexOf(field)) == -1) {
                String code = "UnknownField";
                XMLSchemaValidator.this.reportSchemaError(code, new Object[]{field.toString()});
                return;
            }
            IDValue storedValue = this.fValues.valueAt(index);
            if (storedValue.isDuplicateOf(this.NOT_AN_IDVALUE)) {
                ++this.fValuesCount;
            }
            this.fValues.put(field, value);
            if (this.fValuesCount == this.fValues.size()) {
                if (this.contains(this.fValues)) {
                    this.duplicateValue(this.fValues);
                }
                OrderedHashtable values = (OrderedHashtable)this.fValues.clone();
                this.fValueTuples.addElement(values);
            }
        }

        public boolean contains(OrderedHashtable tuple) {
            int tcount = tuple.size();
            int count = this.fValueTuples.size();
            int i = 0;
            while (i < count) {
                block3: {
                    OrderedHashtable vtuple = (OrderedHashtable)this.fValueTuples.elementAt(i);
                    int j = 0;
                    while (j < tcount) {
                        IDValue value2;
                        IDValue value1 = vtuple.valueAt(j);
                        if (value1.isDuplicateOf(value2 = tuple.valueAt(j))) {
                            ++j;
                            continue;
                        }
                        break block3;
                    }
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected void duplicateValue(OrderedHashtable tuple) throws XNIException {
        }

        protected String toString(OrderedHashtable tuple) {
            int size = tuple.size();
            if (size == 0) {
                return "";
            }
            StringBuffer str = new StringBuffer();
            int i = 0;
            while (i < size) {
                if (i > 0) {
                    str.append(',');
                }
                str.append(tuple.valueAt(i));
                ++i;
            }
            return str.toString();
        }

        public String toString() {
            int index2;
            String s = super.toString();
            int index1 = s.lastIndexOf(36);
            if (index1 != -1) {
                s = s.substring(index1 + 1);
            }
            if ((index2 = s.lastIndexOf(46)) != -1) {
                s = s.substring(index2 + 1);
            }
            return s + '[' + this.fIdentityConstraint + ']';
        }
    }

    protected static class XPathMatcherStack {
        protected XPathMatcher[] fMatchers = new XPathMatcher[4];
        protected int fMatchersCount;
        protected IntStack fContextStack = new IntStack();

        public void clear() {
            int i = 0;
            while (i < this.fMatchersCount) {
                this.fMatchers[i] = null;
                ++i;
            }
            this.fMatchersCount = 0;
            this.fContextStack.clear();
        }

        public int size() {
            return this.fContextStack.size();
        }

        public int getMatcherCount() {
            return this.fMatchersCount;
        }

        public void addMatcher(XPathMatcher matcher) {
            this.ensureMatcherCapacity();
            this.fMatchers[this.fMatchersCount++] = matcher;
        }

        public XPathMatcher getMatcherAt(int index) {
            return this.fMatchers[index];
        }

        public void pushContext() {
            this.fContextStack.push(this.fMatchersCount);
        }

        public void popContext() {
            this.fMatchersCount = this.fContextStack.pop();
        }

        private void ensureMatcherCapacity() {
            if (this.fMatchersCount == this.fMatchers.length) {
                XPathMatcher[] array = new XPathMatcher[this.fMatchers.length * 2];
                System.arraycopy(this.fMatchers, 0, array, 0, this.fMatchers.length);
                this.fMatchers = array;
            }
        }
    }

    private class LocationArray {
        int length;
        String[] locations = new String[2];

        private LocationArray() {
        }

        public void resize(int oldLength, int newLength) {
            String[] temp = new String[newLength];
            System.arraycopy(this.locations, 0, temp, 0, Math.min(oldLength, newLength));
            this.locations = temp;
            this.length = oldLength;
        }

        public void setLocation(String location) {
            if (this.length >= this.locations.length) {
                this.resize(this.length, this.length * 2);
            }
            this.locations[this.length++] = location;
        }

        public String[] getLocationArray() {
            String[] temp = new String[this.length];
            int i = 0;
            while (i < this.length) {
                temp[i] = XMLEntityManager.expandSystemId(this.locations[i], null);
                ++i;
            }
            this.locations = temp;
            return temp;
        }

        public String getFirstLocation() {
            return this.locations[0];
        }

        public int getLength() {
            return this.length;
        }
    }

    class XSIErrorReporter {
        XMLErrorReporter fErrorReporter;
        Vector fErrors = new Vector(8, 8);
        int[] fContext = new int[8];
        int fContextCount;

        XSIErrorReporter() {
        }

        public void reset(XMLErrorReporter errorReporter) {
            this.fErrorReporter = errorReporter;
            this.fErrors.removeAllElements();
            this.fContextCount = 0;
        }

        public void pushContext() {
            if (this.fContextCount == this.fContext.length) {
                int newSize = this.fContextCount + 8;
                int[] newArray = new int[newSize];
                System.arraycopy(this.fContext, 0, newArray, 0, this.fContextCount);
                this.fContext = newArray;
            }
            this.fContext[this.fContextCount++] = this.fErrors.size();
        }

        public String[] popContext() {
            int contextPos = this.fContext[--this.fContextCount];
            int size = this.fErrors.size() - contextPos;
            if (size == 0) {
                return null;
            }
            String[] errors = new String[size];
            int i = 0;
            while (i < size) {
                errors[i] = (String)this.fErrors.elementAt(contextPos + i);
                ++i;
            }
            this.fErrors.setSize(contextPos);
            return errors;
        }

        public void reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
            this.fErrorReporter.reportError(domain, key, arguments, severity);
            this.fErrors.addElement(key);
        }

        public void reportError(XMLLocator location, String domain, String key, Object[] arguments, short severity) throws XNIException {
            this.fErrorReporter.reportError(location, domain, key, arguments, severity);
            this.fErrors.addElement(key);
        }
    }
}

