/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public class ObjectFactory {
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$xerces$util$ObjectFactory;

    public static Object createObject(String factoryId, String fallbackClassName) throws ConfigurationError {
        return ObjectFactory.createObject(factoryId, null, fallbackClassName);
    }

    public static Object createObject(String factoryId, String propertiesFilename, String fallbackClassName) throws ConfigurationError {
        ClassLoader classLoader;
        block13: {
            ObjectFactory.debugPrintln("debug is on");
            classLoader = ObjectFactory.findClassLoader();
            try {
                String systemProp = System.getProperty(factoryId);
                if (systemProp != null) {
                    ObjectFactory.debugPrintln("found system property " + systemProp);
                    return ObjectFactory.newInstance(systemProp, classLoader);
                }
            }
            catch (SecurityException se) {
                // empty catch block
            }
            if (propertiesFilename != null) {
                try {
                    String javah = System.getProperty("java.home");
                    String configFile = javah + File.separator + "lib" + File.separator + propertiesFilename;
                    File f = new File(configFile);
                    if (f.exists()) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f));
                        String factoryClassName = props.getProperty(factoryId);
                        ObjectFactory.debugPrintln("found java.home property " + factoryClassName);
                        return ObjectFactory.newInstance(factoryClassName, classLoader);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            String serviceId = "META-INF/services/" + factoryId;
            try {
                BufferedReader rd;
                InputStream is = null;
                is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
                if (is == null) break block13;
                ObjectFactory.debugPrintln("found " + serviceId);
                try {
                    rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    rd = new BufferedReader(new InputStreamReader(is));
                }
                String factoryClassName = rd.readLine();
                rd.close();
                if (factoryClassName != null && !"".equals(factoryClassName)) {
                    ObjectFactory.debugPrintln("loaded from services: " + factoryClassName);
                    return ObjectFactory.newInstance(factoryClassName, classLoader);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (fallbackClassName == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        ObjectFactory.debugPrintln("loaded from fallback value: " + fallbackClassName);
        return ObjectFactory.newInstance(fallbackClassName, classLoader);
    }

    private static void debugPrintln(String msg) {
    }

    private static ClassLoader findClassLoader() throws ConfigurationError {
        Method m = null;
        try {
            m = (class$java$lang$Thread == null ? (class$java$lang$Thread = ObjectFactory.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException e) {
            ObjectFactory.debugPrintln("assuming JDK 1.1");
            return (class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory).getClassLoader();
        }
        try {
            return (ClassLoader)m.invoke((Object)Thread.currentThread(), null);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationError("Unexpected IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationError("Unexpected InvocationTargetException", e);
        }
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ConfigurationError {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ConfigurationError
    extends Error {
        private Exception exception;

        public ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

