/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.HTMLdtd;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HTMLSerializer
extends BaseMarkupSerializer {
    private static boolean _xhtml;
    public static String XHTMLNamespace;

    protected HTMLSerializer(boolean xhtml, OutputFormat format) {
        super(format);
        _xhtml = xhtml;
    }

    public HTMLSerializer() {
        this(false, new OutputFormat("html", "ISO-8859-1", false));
    }

    public HTMLSerializer(OutputFormat format) {
        this(false, format != null ? format : new OutputFormat("html", "ISO-8859-1", false));
    }

    public HTMLSerializer(Writer writer, OutputFormat format) {
        this(false, format != null ? format : new OutputFormat("html", "ISO-8859-1", false));
        this.setOutputCharStream(writer);
    }

    public HTMLSerializer(OutputStream output, OutputFormat format) {
        this(false, format != null ? format : new OutputFormat("html", "ISO-8859-1", false));
        this.setOutputByteStream(output);
    }

    public void setOutputFormat(OutputFormat format) {
        super.setOutputFormat(format != null ? format : new OutputFormat("html", "ISO-8859-1", false));
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
        boolean addNSAttr = false;
        try {
            String value;
            String name;
            if (this._printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(localName == null ? rawName : localName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement)) {
                    this._printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            if (rawName == null) {
                String prefix;
                rawName = localName;
                if (namespaceURI != null && (prefix = this.getPrefix(namespaceURI)).length() > 0) {
                    rawName = prefix + ":" + localName;
                }
                addNSAttr = true;
            }
            String htmlName = namespaceURI == null ? rawName : (namespaceURI.equals(XHTMLNamespace) ? localName : null);
            this._printer.printText('<');
            if (_xhtml) {
                this._printer.printText(rawName.toLowerCase());
            } else {
                this._printer.printText(rawName);
            }
            this._printer.indent();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    this._printer.printSpace();
                    name = attrs.getQName(i).toLowerCase();
                    value = attrs.getValue(i);
                    if (_xhtml || namespaceURI != null) {
                        if (value == null) {
                            this._printer.printText(name);
                            this._printer.printText("=\"\"");
                        } else {
                            this._printer.printText(name);
                            this._printer.printText("=\"");
                            this.printEscaped(value);
                            this._printer.printText('\"');
                        }
                    } else {
                        if (value == null) {
                            value = "";
                        }
                        if (!this._format.getPreserveEmptyAttributes() && value.length() == 0) {
                            this._printer.printText(name);
                        } else if (HTMLdtd.isURI(rawName, name)) {
                            this._printer.printText(name);
                            this._printer.printText("=\"");
                            this._printer.printText(this.escapeURI(value));
                            this._printer.printText('\"');
                        } else if (HTMLdtd.isBoolean(rawName, name)) {
                            this._printer.printText(name);
                        } else {
                            this._printer.printText(name);
                            this._printer.printText("=\"");
                            this.printEscaped(value);
                            this._printer.printText('\"');
                        }
                    }
                    ++i;
                }
            }
            if (htmlName != null && HTMLdtd.isPreserveSpace(htmlName)) {
                preserveSpace = true;
            }
            if (addNSAttr) {
                Enumeration enumeration = this._prefixes.keys();
                while (enumeration.hasMoreElements()) {
                    this._printer.printSpace();
                    value = (String)enumeration.nextElement();
                    name = (String)this._prefixes.get(value);
                    if (name.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(value);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                }
            }
            state = this.enterElementState(namespaceURI, localName, rawName, preserveSpace);
            if (htmlName != null && (htmlName.equalsIgnoreCase("A") || htmlName.equalsIgnoreCase("TD"))) {
                state.empty = false;
                this._printer.printText('>');
            }
            if (htmlName != null && (rawName.equalsIgnoreCase("SCRIPT") || rawName.equalsIgnoreCase("STYLE"))) {
                if (_xhtml) {
                    state.doCData = true;
                } else {
                    state.unescaped = true;
                }
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        try {
            this.endElementIO(namespaceURI, localName, rawName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElementIO(String namespaceURI, String localName, String rawName) throws IOException {
        this._printer.unindent();
        ElementState state = this.getElementState();
        String htmlName = state.namespaceURI == null ? state.rawName : (state.namespaceURI.equals(XHTMLNamespace) ? state.localName : null);
        if (_xhtml) {
            if (state.empty) {
                this._printer.printText(" />");
            } else {
                if (state.inCData) {
                    this._printer.printText("]]>");
                }
                this._printer.printText("</");
                this._printer.printText(state.rawName.toLowerCase());
                this._printer.printText('>');
            }
        } else {
            if (state.empty) {
                this._printer.printText('>');
            }
            if (htmlName == null || !HTMLdtd.isOnlyOpening(htmlName)) {
                if (this._indenting && !state.preserveSpace && state.afterElement) {
                    this._printer.breakLine();
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                }
                this._printer.printText("</");
                this._printer.printText(state.rawName);
                this._printer.printText('>');
            }
        }
        state = this.leaveElementState();
        if (htmlName == null || !htmlName.equalsIgnoreCase("A") && !htmlName.equalsIgnoreCase("TD")) {
            state.afterElement = true;
        }
        state.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        try {
            ElementState state = this.content();
            state.doCData = false;
            super.characters(chars, start, length);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void startElement(String tagName, AttributeList attrs) throws SAXException {
        try {
            if (this._printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(tagName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement)) {
                    this._printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            this._printer.printText('<');
            if (_xhtml) {
                this._printer.printText(tagName.toLowerCase());
            } else {
                this._printer.printText(tagName);
            }
            this._printer.indent();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    this._printer.printSpace();
                    String name = attrs.getName(i).toLowerCase();
                    String value = attrs.getValue(i);
                    if (_xhtml) {
                        if (value == null) {
                            this._printer.printText(name);
                            this._printer.printText("=\"\"");
                        } else {
                            this._printer.printText(name);
                            this._printer.printText("=\"");
                            this.printEscaped(value);
                            this._printer.printText('\"');
                        }
                    } else {
                        if (value == null) {
                            value = "";
                        }
                        if (!this._format.getPreserveEmptyAttributes() && value.length() == 0) {
                            this._printer.printText(name);
                        } else if (HTMLdtd.isURI(tagName, name)) {
                            this._printer.printText(name);
                            this._printer.printText("=\"");
                            this._printer.printText(this.escapeURI(value));
                            this._printer.printText('\"');
                        } else if (HTMLdtd.isBoolean(tagName, name)) {
                            this._printer.printText(name);
                        } else {
                            this._printer.printText(name);
                            this._printer.printText("=\"");
                            this.printEscaped(value);
                            this._printer.printText('\"');
                        }
                    }
                    ++i;
                }
            }
            if (HTMLdtd.isPreserveSpace(tagName)) {
                preserveSpace = true;
            }
            state = this.enterElementState(null, null, tagName, preserveSpace);
            if (tagName.equalsIgnoreCase("A") || tagName.equalsIgnoreCase("TD")) {
                state.empty = false;
                this._printer.printText('>');
            }
            if (tagName.equalsIgnoreCase("SCRIPT") || tagName.equalsIgnoreCase("STYLE")) {
                if (_xhtml) {
                    state.doCData = true;
                } else {
                    state.unescaped = true;
                }
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElement(String tagName) throws SAXException {
        this.endElement(null, null, tagName);
    }

    protected void startDocument(String rootTagName) throws IOException {
        this._printer.leaveDTD();
        if (!this._started) {
            if (this._docTypePublicId == null && this._docTypeSystemId == null) {
                if (_xhtml) {
                    this._docTypePublicId = "-//W3C//DTD XHTML 1.0 Strict//EN";
                    this._docTypeSystemId = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
                } else {
                    this._docTypePublicId = "-//W3C//DTD HTML 4.0//EN";
                    this._docTypeSystemId = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
                }
            }
            if (!this._format.getOmitDocumentType()) {
                if (!(this._docTypePublicId == null || _xhtml && this._docTypeSystemId == null)) {
                    this._printer.printText("<!DOCTYPE HTML PUBLIC ");
                    this.printDoctypeURL(this._docTypePublicId);
                    if (this._docTypeSystemId != null) {
                        if (this._indenting) {
                            this._printer.breakLine();
                            this._printer.printText("                      ");
                        } else {
                            this._printer.printText(' ');
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    this._printer.printText('>');
                    this._printer.breakLine();
                } else if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE HTML SYSTEM ");
                    this.printDoctypeURL(this._docTypeSystemId);
                    this._printer.printText('>');
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    protected void serializeElement(Element elem) throws IOException {
        String tagName = elem.getTagName();
        ElementState state = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(tagName);
            }
        } else {
            if (state.empty) {
                this._printer.printText('>');
            }
            if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement)) {
                this._printer.breakLine();
            }
        }
        boolean preserveSpace = state.preserveSpace;
        this._printer.printText('<');
        if (_xhtml) {
            this._printer.printText(tagName.toLowerCase());
        } else {
            this._printer.printText(tagName);
        }
        this._printer.indent();
        NamedNodeMap attrMap = elem.getAttributes();
        if (attrMap != null) {
            int i = 0;
            while (i < attrMap.getLength()) {
                Attr attr = (Attr)attrMap.item(i);
                String name = attr.getName().toLowerCase();
                String value = attr.getValue();
                if (attr.getSpecified()) {
                    this._printer.printSpace();
                    if (_xhtml) {
                        if (value == null) {
                            this._printer.printText(name);
                            this._printer.printText("=\"\"");
                        } else {
                            this._printer.printText(name);
                            this._printer.printText("=\"");
                            this.printEscaped(value);
                            this._printer.printText('\"');
                        }
                    } else {
                        if (value == null) {
                            value = "";
                        }
                        if (!this._format.getPreserveEmptyAttributes() && value.length() == 0) {
                            this._printer.printText(name);
                        } else if (HTMLdtd.isURI(tagName, name)) {
                            this._printer.printText(name);
                            this._printer.printText("=\"");
                            this._printer.printText(this.escapeURI(value));
                            this._printer.printText('\"');
                        } else if (HTMLdtd.isBoolean(tagName, name)) {
                            this._printer.printText(name);
                        } else {
                            this._printer.printText(name);
                            this._printer.printText("=\"");
                            this.printEscaped(value);
                            this._printer.printText('\"');
                        }
                    }
                }
                ++i;
            }
        }
        if (HTMLdtd.isPreserveSpace(tagName)) {
            preserveSpace = true;
        }
        if (elem.hasChildNodes() || !HTMLdtd.isEmptyTag(tagName)) {
            state = this.enterElementState(null, null, tagName, preserveSpace);
            if (tagName.equalsIgnoreCase("A") || tagName.equalsIgnoreCase("TD")) {
                state.empty = false;
                this._printer.printText('>');
            }
            if (tagName.equalsIgnoreCase("SCRIPT") || tagName.equalsIgnoreCase("STYLE")) {
                if (_xhtml) {
                    state.doCData = true;
                } else {
                    state.unescaped = true;
                }
            }
            Node child = elem.getFirstChild();
            while (child != null) {
                this.serializeNode(child);
                child = child.getNextSibling();
            }
            this.endElementIO(null, null, tagName);
        } else {
            this._printer.unindent();
            if (_xhtml) {
                this._printer.printText(" />");
            } else {
                this._printer.printText('>');
            }
            state.afterElement = true;
            state.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    protected void characters(String text) throws IOException {
        ElementState state = this.content();
        super.characters(text);
    }

    protected String getEntityRef(int ch) {
        return HTMLdtd.fromChar(ch);
    }

    protected String escapeURI(String uri) {
        int index = uri.indexOf("\"");
        if (index >= 0) {
            return uri.substring(0, index);
        }
        return uri;
    }

    static {
        XHTMLNamespace = "";
    }
}

