/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.db;

import com.mwc.sqld.db.Curser;
import com.mwc.sqld.db.Indexable;
import com.mwc.sqld.db.MasterTable;
import com.mwc.sqld.db.SimpleDatabase;
import com.mwc.sqld.db.Table;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbBtreeStat;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbSecondaryKeyCreate;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class BerkeleyDatabase
extends SimpleDatabase {
    public static final int MAX_TEMP_TABLES = 10;
    private String _dataDirectory;
    private String _dbname;
    private boolean _mod;
    private Object _modLock;
    private Hashtable _tables;
    private Object _tempLock;
    private LinkedList _tempIndexList;
    private MasterTable _masterTable;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        LinkedList linkedList = this._tempIndexList;
        synchronized (linkedList) {
            while (this._tempIndexList.size() > 0) {
                TempIndexTable temp = (TempIndexTable)this._tempIndexList.get(0);
                this._tempIndexList.remove(0);
                try {
                    temp._value2IndexDB.close(0);
                    temp._value2IndexFile.delete();
                }
                catch (DbException dbe1) {
                    // empty catch block
                }
                try {
                    temp._flag2IndexDB.close(0);
                    temp._flag2IndexFile.delete();
                }
                catch (DbException dbe2) {
                    // empty catch block
                }
                try {
                    temp._indexDB.close(0);
                    temp._indexFile.delete();
                }
                catch (DbException dbe0) {
                    // empty catch block
                }
            }
        }
        Enumeration e = this._tables.keys();
        while (e.hasMoreElements()) {
            BerkeleyTable bt = (BerkeleyTable)e.nextElement();
            Enumeration e2 = bt._indexTable.keys();
            while (e2.hasMoreElements()) {
                Db index = (Db)e2.nextElement();
                try {
                    index.close(0);
                }
                catch (DbException dbe) {
                    // empty catch block
                }
            }
            try {
                bt._table.close(0);
            }
            catch (DbException dbe) {
                // empty catch block
            }
        }
    }

    private void _returnTempIndexTable(TempIndexTable temp) throws DbException {
        temp._value2IndexDB.truncate(null, 0);
        temp._flag2IndexDB.truncate(null, 0);
        temp._indexDB.truncate(null, 0);
        LinkedList linkedList = this._tempIndexList;
        synchronized (linkedList) {
            if (this._tempIndexList.size() >= 10) {
                temp._value2IndexDB.close(0);
                temp._value2IndexFile.delete();
                temp._flag2IndexDB.close(0);
                temp._flag2IndexFile.delete();
                temp._indexDB.close(0);
                temp._indexFile.delete();
            } else {
                this._tempIndexList.add(0, temp);
            }
        }
    }

    private TempIndexTable _getTempIndexTable() throws DbException, IOException {
        TempIndexTable ret;
        if (this._tempIndexList.size() > 0) {
            LinkedList linkedList = this._tempIndexList;
            synchronized (linkedList) {
                ret = (TempIndexTable)this._tempIndexList.get(0);
                this._tempIndexList.remove(0);
            }
        } else {
            ret = new TempIndexTable();
            ret._indexFile = this.getTempFile();
            ret._indexDB = new Db(null, 0);
            ret._indexDB.set_error_stream((OutputStream)System.err);
            ret._indexDB.set_errpfx("BerkeleyDatabase");
            ret._indexFile.delete();
            ret._indexDB.open(ret._indexFile.getAbsolutePath(), null, 3, Db.DB_CREATE, 420);
            ret._flag2IndexFile = this.getTempFile();
            ret._flag2IndexDB = new Db(null, 0);
            ret._flag2IndexDB.set_error_stream((OutputStream)System.err);
            ret._flag2IndexDB.set_errpfx("BerkeleyDatabase");
            ret._flag2IndexDB.set_flags(Db.DB_DUP | Db.DB_DUPSORT);
            ret._flag2IndexFile.delete();
            ret._flag2IndexDB.open(ret._flag2IndexFile.getAbsolutePath(), null, 1, Db.DB_CREATE, 420);
            ret._indexDB.associate(ret._flag2IndexDB, (DbSecondaryKeyCreate)new FlagIndexMaper(), 0);
            ret._value2IndexFile = this.getTempFile();
            ret._value2IndexDB = new Db(null, 0);
            ret._value2IndexDB.set_error_stream((OutputStream)System.err);
            ret._value2IndexDB.set_errpfx("BerkeleyDatabase");
            ret._value2IndexDB.set_flags(Db.DB_DUP | Db.DB_DUPSORT);
            ret._value2IndexFile.delete();
            ret._value2IndexDB.open(ret._value2IndexFile.getAbsolutePath(), null, 1, Db.DB_CREATE, 420);
            ret._indexDB.associate(ret._value2IndexDB, (DbSecondaryKeyCreate)new ValueIndexMaper(), 0);
        }
        return ret;
    }

    public BerkeleyDatabase(String name, String dir) throws IOException, DbException {
        block6: {
            this._mod = false;
            this._modLock = new Object();
            this._tables = new Hashtable();
            this._tempLock = new Object();
            this._tempIndexList = new LinkedList();
            this._dataDirectory = dir;
            this._dbname = name;
            File f = new File(this._dataDirectory);
            if (!f.exists()) {
                f.mkdirs();
            }
            if ((f = new File(this._dataDirectory + "/data.dat")).exists()) {
                this._masterTable = new MasterTable(f);
                Curser c = this._masterTable.getNewCurser();
                try {
                    String lastTableName = "";
                    while (c.next()) {
                        String tableName = c.getValue("TableName");
                        if (lastTableName.equalsIgnoreCase(tableName)) continue;
                        lastTableName = tableName;
                        String[][] cols = this._masterTable.loadCols(tableName);
                        System.out.println("LOAD-TABLE(" + tableName + ")");
                        BerkeleyTable t = new BerkeleyTable(tableName, cols);
                        this._tables.put(t.name().toLowerCase(), t);
                    }
                    Object var11_9 = null;
                    if (c == null) break block6;
                    c.close();
                }
                catch (Throwable throwable) {
                    Object var11_10 = null;
                    if (c != null) {
                        c.close();
                    }
                    throw throwable;
                }
                {
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Table createTable(String name, String[][] cols) {
        try {
            void ioe;
            Table tbl = this.getTable(name);
            if (tbl != null) {
                return null;
            }
            tbl = new BerkeleyTable(name, cols);
            Hashtable hashtable = this._tables;
            synchronized (hashtable) {
                this._tables.put(name.toLowerCase(), tbl);
            }
            Object object = this._modLock;
            synchronized (object) {
                this._mod = true;
            }
            return ioe;
        }
        catch (Exception ioe) {
            return null;
        }
    }

    public String name() {
        return this._dbname;
    }

    public File getTempFile() {
        File f;
        Object object = this._tempLock;
        synchronized (object) {
            StringBuffer buf;
            String tempFileName = this._dataDirectory + "/temp/";
            f = new File(tempFileName);
            if (!f.exists()) {
                f.mkdirs();
            }
            String choice = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            do {
                buf = new StringBuffer();
                int i = 0;
                while (i < 50) {
                    buf.append(choice.charAt((int)(Math.random() * 1.0E9) % choice.length()));
                    ++i;
                }
            } while ((f = new File(tempFileName + buf.toString())).exists());
            try {
                FileOutputStream fout = new FileOutputStream(f);
                fout.close();
            }
            catch (IOException ioe) {
                File file = null;
                return file;
            }
        }
        return f;
    }

    public Table getTable(String table) {
        if (table.equalsIgnoreCase("Master")) {
            return this._masterTable;
        }
        return (Table)this._tables.get(table.toLowerCase());
    }

    public String[] tableNames() {
        String[] ret = new String[this._tables.size()];
        Enumeration e = this._tables.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            ret[i] = e.nextElement().toString();
            ++i;
        }
        return ret;
    }

    public boolean dropTable(String table) {
        return false;
    }

    public boolean save() {
        try {
            this._masterTable.saveState(this._dataDirectory, this._tables);
            Object object = this._modLock;
            synchronized (object) {
                this._mod = false;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public boolean modified() {
        Object object = this._modLock;
        synchronized (object) {
            boolean bl = this._mod;
            return bl;
        }
    }

    public void sync() {
        Enumeration e = this._tables.elements();
        while (e.hasMoreElements()) {
            BerkeleyTable bt = (BerkeleyTable)e.nextElement();
            try {
                bt._table.sync(0);
            }
            catch (DbException dbe) {
                // empty catch block
            }
            Enumeration e2 = bt._indexTable.elements();
            while (e2.hasMoreElements()) {
                try {
                    ((Db)e2.nextElement()).sync(0);
                }
                catch (DbException dbe2) {
                    // empty catch block
                }
            }
        }
    }

    private class BerkeleyTable
    implements Table {
        private String _name;
        private String[][] _cols;
        private Db _table;
        private File _handle;
        private Hashtable _indexTable;

        private BerkeleyTable(String name, String[][] cols) throws IOException, DbException {
            this._name = name;
            this._handle = new File(BerkeleyDatabase.this._dataDirectory + "/" + this._name + ".db");
            this._cols = cols;
            this._indexTable = new Hashtable();
            this._table = new Db(null, 0);
            this._table.set_error_stream((OutputStream)System.err);
            this._table.set_errpfx("BerkeleyDatabase");
            this._table.open(this._handle.getAbsolutePath(), null, 3, Db.DB_CREATE, 420);
            int i = 0;
            while (i < this._cols.length) {
                File f = new File(BerkeleyDatabase.this._dataDirectory + "/" + this._name + "." + this._cols[i][0] + ".db");
                Db index = new Db(null, 0);
                index.set_error_stream((OutputStream)System.err);
                index.set_errpfx("BerkeleyDatabase");
                index.set_flags(Db.DB_DUP | Db.DB_DUPSORT);
                index.open(f.getAbsolutePath(), null, 1, Db.DB_CREATE, 420);
                this._table.associate(index, (DbSecondaryKeyCreate)new IndexMaper(i), 0);
                this._indexTable.put(this._cols[i][0].toLowerCase(), index);
                ++i;
            }
        }

        public String name() {
            return this._name;
        }

        public Curser getNewCurser() {
            try {
                return new BerkeleyCurser();
            }
            catch (DbException dbe) {
                return null;
            }
        }

        public boolean insert(LinkedList values) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                BufferedOutputStream bout = new BufferedOutputStream(out);
                ObjectOutputStream oout = new ObjectOutputStream(bout);
                oout.writeObject(values);
                oout.flush();
                byte[] data = out.toByteArray();
                Dbt key = new Dbt();
                return this._table.put(null, key, new Dbt(data), Db.DB_APPEND) == 0;
            }
            catch (Exception ex) {
                return false;
            }
        }

        public boolean drop() {
            return false;
        }

        public String[][] cols() {
            return this._cols;
        }

        private class IndexMaper
        implements DbSecondaryKeyCreate {
            private int _columnIndex;

            private IndexMaper(int columnIndex) {
                this._columnIndex = columnIndex;
            }

            public int secondary_key_create(Db secondary, Dbt key, Dbt data, Dbt result) throws DbException {
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(data.get_data());
                    BufferedInputStream bin = new BufferedInputStream(in);
                    ObjectInputStream oin = new ObjectInputStream(bin);
                    LinkedList list = (LinkedList)oin.readObject();
                    Object value = list.get(this._columnIndex);
                    result.set_data(value.toString().getBytes());
                    result.set_size(value.toString().length());
                    return 0;
                }
                catch (Exception e) {
                    throw new DbException(e.getMessage());
                }
            }
        }

        private class BerkeleyCurser
        implements Curser,
        Indexable {
            private Hashtable _map = new Hashtable();
            private Vector _vec = new Vector();
            private Dbc _curser;
            private boolean _reset = false;
            private boolean _useIndex = false;
            private TempIndexTable _tempTable = null;
            private File _indexFile = null;
            private Db _indexDB = null;
            private Db _flag2IndexDB = null;
            private File _flag2IndexFile = null;
            private Db _value2IndexDB = null;
            private File _value2IndexFile = null;
            private Object _value = null;
            private boolean _gotDups = false;
            private boolean _doNotIndex = false;

            public void doNotIndex() {
                if (!this._doNotIndex) {
                    this._doNotIndex = true;
                    try {
                        this._curser.close();
                        this._curser = BerkeleyTable.this._table.cursor(null, 0);
                    }
                    catch (DbException dbe) {
                        dbe.printStackTrace();
                    }
                }
            }

            private BerkeleyCurser() throws DbException {
                int i = 0;
                while (i < BerkeleyTable.this._cols.length) {
                    this._map.put(BerkeleyTable.this._cols[i][0].toLowerCase(), new Integer(i));
                    ++i;
                }
                this._curser = BerkeleyTable.this._table.cursor(null, 0);
            }

            public boolean reset() {
                this._useIndex = false;
                this._reset = true;
                this._useIndex = false;
                if (this._indexDB != null) {
                    try {
                        this._value2IndexDB.truncate(null, 0);
                        this._flag2IndexDB.truncate(null, 0);
                        this._indexDB.truncate(null, 0);
                    }
                    catch (DbException dbe) {
                        return false;
                    }
                }
                return true;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean index(String columnName, Object value) {
                if (this._doNotIndex) {
                    return false;
                }
                int i = columnName.indexOf(46);
                if (i >= 0) {
                    columnName = columnName.substring(i + 1);
                }
                columnName = columnName.toLowerCase();
                this._useIndex = true;
                if (this._indexFile == null) {
                    try {
                        this._tempTable = BerkeleyDatabase.this._getTempIndexTable();
                        this._indexFile = this._tempTable._indexFile;
                        this._indexDB = this._tempTable._indexDB;
                        this._flag2IndexFile = this._tempTable._flag2IndexFile;
                        this._flag2IndexDB = this._tempTable._flag2IndexDB;
                        this._value2IndexFile = this._tempTable._value2IndexFile;
                        this._value2IndexDB = this._tempTable._value2IndexDB;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                Dbt key = new Dbt((columnName + ":" + value.toString()).getBytes());
                Dbt data = new Dbt();
                Dbc indexCurser = null;
                try {
                    block13: {
                        boolean bl;
                        indexCurser = this._value2IndexDB.cursor(null, 0);
                        Dbt temp = new Dbt();
                        Dbt pkey = new Dbt();
                        try {
                            if (indexCurser.pget(key, pkey, temp, Db.DB_SET) == -30990) break block13;
                            bl = true;
                            Object var11_15 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_17 = null;
                            indexCurser.close();
                            throw throwable;
                        }
                        indexCurser.close();
                        return bl;
                    }
                    Object var11_16 = null;
                    indexCurser.close();
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        BufferedOutputStream bout = new BufferedOutputStream(out);
                        ObjectOutputStream oout = new ObjectOutputStream(bout);
                        Object[] array = new Object[]{columnName, value, new Boolean(false)};
                        oout.writeObject(array);
                        oout.flush();
                        data = new Dbt(out.toByteArray());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return false;
                    }
                    key = new Dbt("false".getBytes());
                    this._indexDB.put(null, key, data, Db.DB_APPEND);
                    return true;
                }
                catch (DbException dbe) {
                    dbe.printStackTrace();
                    if (indexCurser == null) return false;
                    try {
                        indexCurser.close();
                        return false;
                    }
                    catch (DbException dbe2) {
                        dbe2.printStackTrace();
                        return false;
                    }
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private boolean _moveNext() throws DbException, IOException {
                Dbc curser;
                block4: {
                    boolean bl;
                    curser = this._flag2IndexDB.cursor(null, 0);
                    try {
                        Object[] array;
                        Dbt key = new Dbt("false".getBytes());
                        Dbt pkey = new Dbt();
                        Dbt data = new Dbt();
                        if (curser.pget(key, pkey, data, Db.DB_SET) == -30990) break block4;
                        ByteArrayInputStream in = new ByteArrayInputStream(data.get_data());
                        BufferedInputStream bin = new BufferedInputStream(in);
                        ObjectInputStream oin = new ObjectInputStream(bin);
                        try {
                            array = (Object[])oin.readObject();
                        }
                        catch (ClassNotFoundException cnfe) {
                            boolean bl2 = false;
                            Object var15_13 = null;
                            if (curser == null) return bl2;
                            curser.close();
                            return bl2;
                        }
                        this._value = array[1];
                        array[2] = new Boolean(true);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        BufferedOutputStream bout = new BufferedOutputStream(out);
                        ObjectOutputStream oout = new ObjectOutputStream(bout);
                        oout.writeObject(array);
                        oout.flush();
                        data = new Dbt(out.toByteArray());
                        curser.close();
                        curser = null;
                        this._indexDB.put(null, pkey, data, 0);
                        Db index = (Db)BerkeleyTable.this._indexTable.get(array[0].toString().toLowerCase());
                        this._curser.close();
                        this._curser = index.cursor(null, 0);
                        bl = true;
                        Object var15_14 = null;
                        if (curser == null) return bl;
                    }
                    catch (Throwable throwable) {
                        Object var15_16 = null;
                        if (curser == null) throw throwable;
                        curser.close();
                        throw throwable;
                    }
                    curser.close();
                    return bl;
                }
                Object var15_15 = null;
                if (curser == null) return false;
                curser.close();
                return false;
            }

            public boolean next() {
                try {
                    if (this._useIndex && !this._doNotIndex) {
                        if (!this._gotDups && !this._moveNext()) {
                            return false;
                        }
                        Dbt skey = new Dbt(this._value.toString().getBytes());
                        Dbt key = new Dbt();
                        Dbt data = new Dbt();
                        if (!this._gotDups) {
                            while (this._curser.pget(skey, key, data, Db.DB_SET) == -30990) {
                                if (!this._moveNext()) {
                                    return false;
                                }
                                skey = new Dbt(this._value.toString().getBytes());
                            }
                            this._gotDups = true;
                        } else {
                            int flags = Db.DB_NEXT_DUP;
                            while (this._curser.pget(skey, key, data, flags) == -30990) {
                                if (!this._moveNext()) {
                                    return false;
                                }
                                skey = new Dbt(this._value.toString().getBytes());
                                flags = Db.DB_SET;
                            }
                        }
                        ByteArrayInputStream in = new ByteArrayInputStream(data.get_data());
                        BufferedInputStream bin = new BufferedInputStream(in);
                        ObjectInputStream oin = new ObjectInputStream(bin);
                        LinkedList list = (LinkedList)oin.readObject();
                        this._vec = new Vector();
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            Object value = it.next();
                            this._vec.addElement(value);
                        }
                        return true;
                    }
                    Dbt key = new Dbt();
                    Dbt data = new Dbt();
                    if (this._reset) {
                        this._reset = false;
                        if (this._curser.get(key, data, Db.DB_FIRST) == -30990) {
                            return false;
                        }
                    } else if (this._curser.get(key, data, Db.DB_NEXT) == -30990) {
                        return false;
                    }
                    ByteArrayInputStream in = new ByteArrayInputStream(data.get_data());
                    BufferedInputStream bin = new BufferedInputStream(in);
                    ObjectInputStream oin = new ObjectInputStream(bin);
                    LinkedList list = (LinkedList)oin.readObject();
                    this._vec = new Vector();
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        this._vec.addElement(it.next());
                    }
                    return true;
                }
                catch (Exception dbe) {
                    dbe.printStackTrace();
                    return false;
                }
            }

            public boolean close() {
                try {
                    this._curser.close();
                    if (this._indexFile != null) {
                        BerkeleyDatabase.this._returnTempIndexTable(this._tempTable);
                    }
                    return true;
                }
                catch (DbException dbe) {
                    return false;
                }
            }

            public int recCount() {
                try {
                    DbBtreeStat btreeStat = (DbBtreeStat)BerkeleyTable.this._table.stat(Db.DB_FAST_STAT);
                    return btreeStat.bt_nkeys;
                }
                catch (DbException dbe) {
                    return -1;
                }
            }

            public String getValue(String name) {
                int i = name.indexOf(46);
                if (i < 0) {
                    Integer ii = (Integer)this._map.get(name.toLowerCase());
                    if (ii == null) {
                        return null;
                    }
                    return (String)this._vec.elementAt(ii);
                }
                String tblName = name.substring(0, i);
                if (tblName.equalsIgnoreCase(BerkeleyTable.this._name)) {
                    Integer ii = (Integer)this._map.get((name = name.substring(i + 1)).toLowerCase());
                    if (ii == null) {
                        return null;
                    }
                    return (String)this._vec.elementAt(ii);
                }
                return null;
            }

            public String getValue(int index) {
                return (String)this._vec.elementAt(index);
            }

            public String getType(String name) {
                int i = name.indexOf(46);
                if (i >= 0) {
                    String tblName = name.substring(0, i);
                    if (!tblName.equalsIgnoreCase(BerkeleyTable.this._name)) {
                        return null;
                    }
                    name = name.substring(i + 1);
                }
                i = 0;
                while (i < BerkeleyTable.this._cols.length) {
                    if (name.equalsIgnoreCase(BerkeleyTable.this._cols[i][0])) {
                        return BerkeleyTable.this._cols[i][1];
                    }
                    ++i;
                }
                return null;
            }

            public int size() {
                return BerkeleyTable.this._cols.length;
            }

            public String[][] cols() {
                return BerkeleyTable.this._cols;
            }
        }
    }

    private class ValueIndexMaper
    implements DbSecondaryKeyCreate {
        private ValueIndexMaper() {
        }

        public int secondary_key_create(Db secondary, Dbt key, Dbt data, Dbt result) throws DbException {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(data.get_data());
                BufferedInputStream bin = new BufferedInputStream(in);
                ObjectInputStream oin = new ObjectInputStream(bin);
                Object[] array = (Object[])oin.readObject();
                Object value = array[0];
                String s1 = value.toString();
                value = array[1];
                String s2 = value.toString();
                s1 = s1 + ":" + s2;
                result.set_data(s1.getBytes());
                result.set_size(s1.length());
                return 0;
            }
            catch (Exception e) {
                throw new DbException(e.getMessage());
            }
        }
    }

    private class FlagIndexMaper
    implements DbSecondaryKeyCreate {
        private FlagIndexMaper() {
        }

        public int secondary_key_create(Db secondary, Dbt key, Dbt data, Dbt result) throws DbException {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(data.get_data());
                BufferedInputStream bin = new BufferedInputStream(in);
                ObjectInputStream oin = new ObjectInputStream(bin);
                Object[] array = (Object[])oin.readObject();
                Object value = array[2];
                String s = value.toString();
                result.set_data(s.getBytes());
                result.set_size(s.length());
                return 0;
            }
            catch (Exception e) {
                throw new DbException(e.getMessage());
            }
        }
    }

    private class TempIndexTable {
        private File _indexFile = null;
        private Db _indexDB = null;
        private Db _flag2IndexDB = null;
        private File _flag2IndexFile = null;
        private Db _value2IndexDB = null;
        private File _value2IndexFile = null;
        private Object _value = null;

        private TempIndexTable() {
        }
    }
}

