/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.db;

import com.mwc.sqld.db.CSVFileReader;
import com.mwc.sqld.db.Curser;
import com.mwc.sqld.db.ReadWriteLock;
import java.io.File;
import java.io.IOException;

public class CSVCurser
implements Curser {
    private File _file;
    private CSVFileReader _csvReader;
    private String[][] _cols;
    private int _recCount;
    private boolean _doDelete = true;
    private ReadWriteLock _rwLock = null;

    public CSVCurser(File f, String[][] cols, int recCount) throws IOException {
        this._file = f;
        this._csvReader = new CSVFileReader(f.getAbsolutePath(), true);
        this._csvReader.open();
        this._cols = cols;
        this._recCount = recCount;
    }

    public CSVCurser(File f, String[][] cols, int recCount, ReadWriteLock rwLock) throws IOException {
        this._file = f;
        this._csvReader = new CSVFileReader(f.getAbsolutePath(), true);
        this._csvReader.open();
        this._cols = cols;
        this._recCount = recCount;
        this._rwLock = rwLock;
        this._rwLock.readLock();
    }

    public void noDeleteOnClose() {
        this._doDelete = false;
    }

    public String[][] cols() {
        return this._cols;
    }

    public int size() {
        return this._cols.length;
    }

    public boolean reset() {
        try {
            this._csvReader.close();
            this._csvReader.open();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public boolean next() {
        try {
            return this._csvReader.readLine();
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public String getValue(String colName) {
        return this._csvReader.getValue(colName);
    }

    public String getValue(int index) {
        return this._csvReader.getValue(index);
    }

    public String getType(String colName) {
        int i = 0;
        while (i < this._cols.length) {
            if (colName.equalsIgnoreCase(this._cols[i][0])) {
                return this._cols[i][1];
            }
            ++i;
        }
        return null;
    }

    public boolean close() {
        try {
            if (this._rwLock != null) {
                this._rwLock.readUnlock();
            }
            this._csvReader.close();
            if (this._doDelete) {
                this._file.delete();
            }
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public int recCount() {
        return this._recCount;
    }
}

