/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.db;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CSVFileReader {
    private String fileName;
    private boolean firstLineIsNames;
    private BufferedReader fin = null;
    private Vector line = null;
    private Hashtable names = null;

    public Enumeration colNames() {
        if (this.names == null) {
            return null;
        }
        return this.names.keys();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseLine(String rec) throws IOException {
        this.line = new Vector();
        boolean gotC = false;
        int i = 0;
        boolean j = false;
        while (i < rec.length()) {
            boolean gotQ = false;
            gotC = false;
            StringBuffer field = new StringBuffer();
            if (rec.charAt(i) == '\"') {
                gotQ = true;
                ++i;
            }
            while (i < rec.length()) {
                block10: {
                    if (rec.charAt(i) == '\"' && gotQ) {
                        if (i + 1 >= rec.length()) break;
                        if (rec.charAt(i + 1) == '\"') {
                            field.append('\"');
                            ++i;
                            break block10;
                        } else {
                            gotQ = false;
                            break;
                        }
                    }
                    if (!gotQ && rec.charAt(i) == ',') break;
                    field.append(rec.charAt(i));
                }
                while (i + 1 == rec.length() && gotQ) {
                    String temp = this.fin.readLine();
                    if (temp == null) break;
                    rec = rec + "\n";
                    rec = rec + temp;
                }
                ++i;
            }
            if (i < rec.length() && rec.charAt(i) == '\"') {
                ++i;
            }
            if (i < rec.length() && rec.charAt(i) == ',') {
                ++i;
                gotC = true;
            }
            this.line.addElement(field.toString());
        }
        if (gotC) {
            this.line.addElement("");
        }
    }

    public CSVFileReader(String fileName, boolean firstLineIsNames) {
        this.fileName = fileName;
        this.firstLineIsNames = firstLineIsNames;
    }

    public void open() throws IOException {
        this.fin = new BufferedReader(new FileReader(this.fileName));
        if (this.firstLineIsNames) {
            this.readLine();
            this.names = new Hashtable();
            int i = 0;
            while (i < this.line.size()) {
                this.names.put(this.line.elementAt(i).toString().toLowerCase(), new Integer(i));
                ++i;
            }
            this.line = null;
        }
    }

    public void close() throws IOException {
        if (this.fin == null) {
            return;
        }
        this.fin.close();
        this.fin = null;
        this.line = null;
        this.names = null;
    }

    public boolean readLine() throws IOException {
        String rec = this.fin.readLine();
        if (rec == null) {
            return false;
        }
        this.parseLine(rec);
        return true;
    }

    public String getValue(int index) {
        if (index < 0 || index >= this.line.size()) {
            return null;
        }
        return this.line.elementAt(index).toString();
    }

    public String getValue(String name) {
        if (this.names == null) {
            return null;
        }
        Integer index = (Integer)this.names.get(name.toLowerCase());
        if (index == null) {
            return null;
        }
        return this.getValue(index);
    }

    public static void main(String[] args) throws IOException {
        CSVFileReader csvFile = new CSVFileReader("test.csv", true);
        csvFile.open();
        while (csvFile.readLine()) {
            String name = csvFile.getValue("Name");
            String age = csvFile.getValue(1);
            String test = csvFile.getValue("test");
            System.out.println("Name: " + name);
            System.out.println("Age: " + age);
            System.out.println("test: " + test);
        }
        csvFile.close();
    }
}

