/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.db;

import com.mwc.sqld.db.CSVCurser;
import com.mwc.sqld.db.Criteria;
import com.mwc.sqld.db.Curser;
import com.mwc.sqld.db.DBException;
import com.mwc.sqld.db.Database;
import com.mwc.sqld.db.SQLExpression;
import com.mwc.sqld.db.SelectEngine;
import com.mwc.util.CSVEncoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;

public class CSVSelectEngine
implements SelectEngine {
    private void _printRec(Curser[] data, LinkedList colList, PrintWriter out, String[][] cols) throws DBException {
        StringBuffer buf = new StringBuffer();
        int index = 0;
        while (index < colList.size()) {
            SQLExpression expr = (SQLExpression)colList.get(index);
            Object value = expr.eval(data);
            cols[index][0] = expr.as();
            if (value instanceof Integer) {
                cols[index][1] = "INT";
            } else if (value instanceof Double) {
                cols[index][1] = "FLOAT";
            } else if (value instanceof String) {
                cols[index][1] = "TEXT";
            } else if (value instanceof Boolean) {
                cols[index][1] = "BOOLEAN";
            } else {
                throw new DBException("Bad type found after eval()!");
            }
            if (buf.length() != 0) {
                buf.append(",");
            }
            buf.append("\"" + CSVEncoder.encode(value.toString()) + "\"");
            ++index;
        }
        out.println(buf.toString());
        out.flush();
    }

    private void _doSelect(Curser[] data, Criteria c, int i, LinkedList colList, PrintWriter out, String[][] cols, int[] recCount) throws DBException {
        if (i >= data.length) {
            if (c == null || c.match(data)) {
                this._printRec(data, colList, out, cols);
                recCount[0] = recCount[0] + 1;
            }
            return;
        }
        data[i].reset();
        while (data[i].next()) {
            this._doSelect(data, c, i + 1, colList, out, cols, recCount);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Curser select(Database db, Curser[] data, Criteria c, LinkedList colList) throws DBException {
        File f = null;
        CSVCurser csvCurser = null;
        try {
            try {
                f = db.getTempFile();
                FileOutputStream fout = new FileOutputStream(f);
                BufferedOutputStream bout = new BufferedOutputStream(fout);
                PrintWriter out = new PrintWriter(bout);
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < colList.size()) {
                    if (buffer.length() != 0) {
                        buffer.append(",");
                    }
                    buffer.append("\"\"");
                    ++i;
                }
                out.println(buffer.toString());
                out.flush();
                String[][] cols = new String[colList.size()][2];
                int i2 = 0;
                while (i2 < cols.length) {
                    cols[i2][0] = "";
                    cols[i2][1] = "";
                    ++i2;
                }
                int[] rc = new int[]{0};
                try {
                    this._doSelect(data, c, 0, colList, out, cols, rc);
                    Object var16_16 = null;
                    out.flush();
                    fout.close();
                }
                catch (Throwable throwable) {
                    Object var16_17 = null;
                    out.flush();
                    fout.close();
                    throw throwable;
                }
                CSVCurser cSVCurser = csvCurser = new CSVCurser(f, cols, rc[0]);
                Object var18_20 = null;
                if (f == null) return cSVCurser;
                if (csvCurser != null) return cSVCurser;
                f.delete();
                return cSVCurser;
            }
            catch (IOException ioe) {
                throw new DBException("Unable to preforme select statement: " + ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            if (f == null) throw throwable;
            if (csvCurser != null) throw throwable;
            f.delete();
            throw throwable;
        }
    }
}

