/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.db;

import com.mwc.sqld.db.Curser;
import com.mwc.sqld.db.DBException;
import com.mwc.sqld.db.Expression;
import com.mwc.sqld.db.Indexable;
import com.mwc.sqld.db.SQLDataTranslator;
import com.mwc.sqld.db.ValueLookup;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class SQLExpression
implements Expression {
    public static final boolean DEBUG_MODE = false;
    private Stack _operandStack;
    private Stack _operatorStack;
    private String _as;
    private ValueLookup[] _tbl = null;
    private Hashtable _indexedTables = null;
    private Hashtable _usedCols = null;
    private Hashtable _allUsedCols = new Hashtable();

    public SQLExpression(Stack operand, Stack operator) {
        this._operandStack = operand;
        this._operatorStack = operator;
        this._as = "";
    }

    public SQLExpression(Stack operand, Stack operator, String as) {
        this._operandStack = operand;
        this._operatorStack = operator;
        this._as = as;
    }

    public String as() {
        return this._as;
    }

    private Object _lookupValue(Object o) throws DBException {
        if (o instanceof String) {
            String name = (String)o;
            if (name.length() > 0 && name.charAt(0) == '\'') {
                name = name.substring(1, name.length() - 1);
                return name;
            }
            if (name.equalsIgnoreCase("true")) {
                return new Boolean(true);
            }
            if (name.equalsIgnoreCase("false")) {
                return new Boolean(false);
            }
            int i = 0;
            while (i < this._tbl.length) {
                o = this._tbl[i].getValue(name);
                if (o != null) {
                    if (this._usedCols != null) {
                        this._usedCols.put(name.toLowerCase(), this._tbl[i]);
                    }
                    this._allUsedCols.put(name.toLowerCase(), this._tbl[i]);
                    return SQLDataTranslator.toData((String)o, this._tbl[i].getType(name));
                }
                ++i;
            }
            return null;
        }
        return o;
    }

    public void SQLOrExpr() throws DBException {
        this.SQLAndExpr();
        while (this._operatorStack.size() > 0 && this._operatorStack.peek().toString().compareTo("OR") == 0) {
            this._operatorStack.pop();
            Object operand2 = this._lookupValue(this._operandStack.pop());
            this.SQLAndExpr();
            Object operand1 = this._lookupValue(this._operandStack.pop());
            if (operand1 == null || operand2 == null) {
                throw new DBException("Execution time error!");
            }
            if (operand1 instanceof Boolean && operand2 instanceof Boolean) {
                this._debug("OR(" + (Boolean)operand1 + "," + (Boolean)operand2 + ")");
                Boolean res = new Boolean((Boolean)operand1 != false || (Boolean)operand2 != false);
                this._operandStack.push(res);
                continue;
            }
            throw new DBException("Bad types!");
        }
    }

    public void SQLAndExpr() throws DBException {
        this.SQLNotExpr();
        while (this._operatorStack.size() > 0 && this._operatorStack.peek().toString().compareTo("AND") == 0) {
            this._operatorStack.pop();
            Object operand2 = this._lookupValue(this._operandStack.pop());
            this.SQLNotExpr();
            Object operand1 = this._lookupValue(this._operandStack.pop());
            if (operand1 == null || operand2 == null) {
                throw new DBException("Execution time error!");
            }
            if (operand1 instanceof Boolean && operand2 instanceof Boolean) {
                this._debug("AND(" + (Boolean)operand1 + "," + (Boolean)operand2 + ")");
                Boolean res = new Boolean((Boolean)operand1 != false && (Boolean)operand2 != false);
                this._operandStack.push(res);
                continue;
            }
            throw new DBException("Bad types!");
        }
    }

    public void SQLNotExpr() throws DBException {
        this._indexedTables = new Hashtable();
        this.SQLCompareExpr();
        if (this._operatorStack.size() > 0 && this._operatorStack.peek().toString().compareTo("NOT") == 0) {
            Enumeration e = this._indexedTables.keys();
            while (e.hasMoreElements()) {
                Indexable index = (Indexable)e.nextElement();
                index.doNotIndex();
            }
            this._operatorStack.pop();
            Object operand1 = this._lookupValue(this._operandStack.pop());
            if (operand1 == null) {
                throw new DBException("Execution time error!");
            }
            if (operand1 instanceof Boolean) {
                this._debug("NOT(" + operand1.toString() + ")");
                Boolean res = new Boolean((Boolean)operand1 == false);
                this._operandStack.push(res);
            } else {
                throw new DBException("Bad types!");
            }
        }
    }

    public static boolean like(String value, String pattern) {
        if (value.compareTo("") == 0 && pattern.compareTo("") != 0 && pattern.compareTo("%") != 0) {
            return false;
        }
        int j = 0;
        int n = 0;
        int i = 0;
        while (i < value.length()) {
            char ch0 = value.charAt(i);
            if (j >= pattern.length()) {
                return false;
            }
            char ch1 = pattern.charAt(j);
            char ch2 = j + 1 < pattern.length() ? pattern.charAt(j + 1) : (char)'\u0000';
            if (ch1 == '\\' && ch2 == '_') {
                if (ch0 != '_') {
                    return false;
                }
                j += 2;
            } else if (ch1 == '_') {
                ++j;
            } else if (ch1 == '\\' && ch2 == '%') {
                if (ch0 != '%') {
                    return false;
                }
                j += 2;
            } else if (ch1 == '\\' && ch2 == '\\') {
                if (ch0 != '\\') {
                    return false;
                }
                j += 2;
            } else if (ch1 == '%' && ch2 != '%') {
                StringBuffer buf;
                int k;
                String sub = null;
                if (j + 1 < pattern.length()) {
                    int next1;
                    int nextPercent;
                    k = -1;
                    do {
                        nextPercent = pattern.indexOf("%", j + ++k + 1);
                        next1 = pattern.indexOf("_", j + k + 1);
                        if (nextPercent >= 0 || next1 >= 0) continue;
                        sub = pattern.substring(j + 1);
                        break;
                    } while (nextPercent - 1 >= 0 && pattern.charAt(nextPercent - 1) == '\\' || next1 - 1 >= 0 && pattern.charAt(next1 - 1) == '\\');
                    if (nextPercent >= 0 && next1 >= 0) {
                        sub = nextPercent < next1 ? pattern.substring(j + k + 1, nextPercent) : pattern.substring(j + k + 1, next1);
                    } else if (next1 >= 0) {
                        sub = pattern.substring(j + k + 1, next1);
                    } else if (nextPercent >= 0) {
                        sub = pattern.substring(j + k + 1, nextPercent);
                    }
                    n = sub.length();
                    buf = new StringBuffer();
                    k = 0;
                    while (k < sub.length()) {
                        if (sub.charAt(k) == '\\') {
                            if (k + 1 < sub.length()) {
                                buf.append(sub.charAt(++k));
                            }
                        } else {
                            buf.append(sub.charAt(k));
                        }
                        ++k;
                    }
                } else {
                    return true;
                }
                sub = buf.toString();
                boolean found = false;
                k = i;
                while (k < value.length()) {
                    if (value.regionMatches(k, sub, 0, sub.length())) {
                        i = k + n - 1;
                        j += n + 1;
                        found = true;
                        break;
                    }
                    ++k;
                }
                if (!found) {
                    return false;
                }
            } else if (ch0 == ch1) {
                ++j;
            } else {
                return false;
            }
            if (i + 1 >= value.length() && j < pattern.length()) {
                return pattern.charAt(j) == '%' && j == pattern.length() - 1;
            }
            ++i;
        }
        return true;
    }

    private void _doIndex(String name, Object value) throws DBException {
        int i = 0;
        while (i < this._tbl.length) {
            String o = this._tbl[i].getValue(name);
            if (o != null) {
                if (!(this._tbl[i] instanceof Indexable) || !((Indexable)((Object)this._tbl[i])).index(name, value)) break;
                this._indexedTables.put(name.toLowerCase(), this._tbl[i]);
                break;
            }
            ++i;
        }
    }

    private boolean _sameColumnName(String col1, String col2) {
        int i = col1.indexOf(46);
        String tbl1 = "";
        if (i >= 0) {
            tbl1 = col1.substring(0, i);
            col1 = col1.substring(i + 1);
        }
        i = col2.indexOf(46);
        String tbl2 = "";
        if (i >= 0) {
            tbl2 = col2.substring(0, i);
            col2 = col2.substring(i + 1);
        }
        return tbl1.equalsIgnoreCase(tbl2) && col1.equalsIgnoreCase(col2);
    }

    private void _doIndexIntersection(String col1, Object val1, String col2, Object val2) throws DBException {
        Indexable index1 = null;
        Indexable index2 = null;
        int i = 0;
        while (i < this._tbl.length) {
            String o = this._tbl[i].getValue(col1);
            if (o != null && this._tbl[i] instanceof Indexable) {
                index1 = (Indexable)((Object)this._tbl[i]);
            }
            if ((o = this._tbl[i].getValue(col2)) != null && this._tbl[i] instanceof Indexable) {
                index2 = (Indexable)((Object)this._tbl[i]);
            }
            if (index1 != null && index2 != null) break;
            ++i;
        }
        if (index1 != null && index2 == null) {
            if (index1.index(col1, val2)) {
                this._indexedTables.put(col1.toLowerCase(), index1);
            }
        } else if (index1 == null && index2 != null) {
            if (index2.index(col2, val1)) {
                this._indexedTables.put(col2.toLowerCase(), index2);
            }
        } else if (index1 != null && index2 != null) {
            if (this._sameColumnName(col1, col2)) {
                return;
            }
            if (index1 instanceof Curser && index2 instanceof Curser) {
                Curser c1 = (Curser)((Object)index1);
                Curser c2 = (Curser)((Object)index2);
                if (c1.recCount() > c2.recCount()) {
                    if (index1.index(col1, val2)) {
                        this._indexedTables.put(col1.toLowerCase(), index1);
                        index2.doNotIndex();
                    }
                } else if (index2.index(col2, val1)) {
                    this._indexedTables.put(col2.toLowerCase(), index2);
                    index1.doNotIndex();
                }
            } else if (index2.index(col2, val1)) {
                this._indexedTables.put(col2.toLowerCase(), index2);
                index1.doNotIndex();
            }
        }
    }

    private void _checkUsedCols(Hashtable used) {
        Enumeration elements = used.elements();
        while (elements.hasMoreElements()) {
            ValueLookup v1 = (ValueLookup)elements.nextElement();
            Enumeration elements2 = this._indexedTables.elements();
            while (elements2.hasMoreElements()) {
                ValueLookup v2 = (ValueLookup)elements2.nextElement();
                if (v1 != v2) continue;
                ((Indexable)((Object)v2)).doNotIndex();
            }
        }
    }

    private void _checkIndex(Object op1, Object operand1, Object op2, Object operand2, String op, Hashtable left, Hashtable right) throws DBException {
        String s1 = null;
        String s2 = null;
        boolean op1Flag = false;
        boolean op2Flag = false;
        if (op1 instanceof String && (s1 = (String)op1).length() > 0 && s1.charAt(0) != '\'') {
            op1Flag = true;
        }
        if (op2 instanceof String && (s2 = (String)op2).length() > 0 && s2.charAt(0) != '\'') {
            op2Flag = true;
        }
        if (op1Flag && !op2Flag) {
            if (op.compareTo("=") == 0) {
                this._doIndex(s1, operand2);
            }
            this._checkUsedCols(right);
        } else if (!op1Flag && op2Flag) {
            if (op.compareTo("=") == 0) {
                this._doIndex(s2, operand1);
            }
            this._checkUsedCols(left);
        } else if (op1Flag && op2Flag) {
            if (op.compareTo("=") == 0) {
                this._doIndexIntersection(s1, operand1, s2, operand2);
            }
        } else {
            this._checkUsedCols(right);
            this._checkUsedCols(left);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void SQLCompareExpr() throws DBException {
        this._usedCols = new Hashtable();
        this.SQLSumExpr();
        Hashtable right = this._usedCols;
        this._usedCols = null;
        if (this._operatorStack.size() > 0 && this._operatorStack.peek().toString().compareTo("LIKE") == 0) {
            this._operatorStack.pop();
            Object op2 = this._operandStack.pop();
            Object operand2 = this._lookupValue(op2);
            this._usedCols = new Hashtable();
            this.SQLSumExpr();
            Hashtable left = this._usedCols;
            this._usedCols = null;
            Object op1 = this._operandStack.pop();
            Object operand1 = this._lookupValue(op1);
            if (operand1 == null || operand2 == null) {
                throw new DBException("Execution time error!");
            }
            if (!(operand1 instanceof String) || !(operand2 instanceof String)) throw new DBException("Bad types!");
            this._checkIndex(op1, operand1, op2, operand2, "LIKE", left, right);
            this._debug("LIKE('" + operand1.toString() + "','" + operand2.toString() + "')");
            Boolean res = new Boolean(SQLExpression.like(((String)operand1).toLowerCase(), ((String)operand2).toLowerCase()));
            this._operandStack.push(res);
            return;
        } else {
            String op = this.SQLCompareOp();
            if (op == null) return;
            this._operatorStack.pop();
            Object op2 = this._operandStack.pop();
            Object operand2 = this._lookupValue(op2);
            this._usedCols = new Hashtable();
            this.SQLSumExpr();
            Hashtable left = this._usedCols;
            this._usedCols = null;
            Object op1 = this._operandStack.pop();
            Object operand1 = this._lookupValue(op1);
            if (operand1 == null || operand2 == null) {
                throw new DBException("Execution time error!");
            }
            if (operand1.getClass() != operand2.getClass()) {
                throw new DBException("Data types must match to compare!");
            }
            if (operand1 instanceof Comparable && operand2 instanceof Comparable) {
                Boolean res;
                this._checkIndex(op1, operand1, op2, operand2, op, left, right);
                if (operand1 instanceof String) {
                    operand1 = ((String)operand1).toLowerCase();
                }
                if (operand2 instanceof String) {
                    operand2 = ((String)operand2).toLowerCase();
                }
                this._debug("COMPARE(" + op + "," + operand1.toString() + "," + operand2.toString() + ")");
                if (op.compareTo("=") == 0) {
                    res = new Boolean(((Comparable)operand1).compareTo((Comparable)operand2) == 0);
                } else if (op.compareTo("<>") == 0) {
                    res = new Boolean(((Comparable)operand1).compareTo((Comparable)operand2) != 0);
                } else if (op.compareTo("<") == 0) {
                    res = new Boolean(((Comparable)operand1).compareTo((Comparable)operand2) < 0);
                } else if (op.compareTo("<=") == 0) {
                    res = new Boolean(((Comparable)operand1).compareTo((Comparable)operand2) <= 0);
                } else if (op.compareTo(">") == 0) {
                    res = new Boolean(((Comparable)operand1).compareTo((Comparable)operand2) > 0);
                } else {
                    if (op.compareTo(">=") != 0) throw new DBException("Bad compare operator!");
                    res = new Boolean(((Comparable)operand1).compareTo((Comparable)operand2) >= 0);
                }
                this._operandStack.push(res);
                return;
            } else {
                Boolean res;
                if (!(operand1 instanceof Boolean) || !(operand2 instanceof Boolean)) throw new DBException("Bad types!");
                this._checkIndex(op1, operand1, op2, operand2, op, left, right);
                this._debug("COMPARE(" + op + "," + operand1.toString() + "," + operand2.toString() + ")");
                if (op.compareTo("=") == 0) {
                    res = new Boolean(operand1.equals(operand2));
                } else {
                    if (op.compareTo("<>") != 0) throw new DBException("Bad compare operator!");
                    res = new Boolean(!operand1.equals(operand2));
                }
                this._operandStack.push(res);
            }
        }
    }

    public String SQLCompareOp() {
        if (this._operatorStack.size() <= 0) {
            return null;
        }
        String top = this._operatorStack.peek().toString();
        if (top.compareTo("=") == 0 || top.compareTo("<>") == 0 || top.compareTo(">") == 0 || top.compareTo(">=") == 0 || top.compareTo("<") == 0 || top.compareTo("<=") == 0) {
            return top;
        }
        return null;
    }

    private void _debug(String msg) {
    }

    public void SQLSumExpr() throws DBException {
        block7: {
            this.SQLProductExpr();
            while (true) {
                Number res;
                Object operand1;
                Object operand2;
                if (this._operatorStack.size() > 0 && this._operatorStack.peek().toString().compareTo("+") == 0) {
                    this._operatorStack.pop();
                    operand2 = this._lookupValue(this._operandStack.pop());
                    this.SQLProductExpr();
                    operand1 = this._lookupValue(this._operandStack.pop());
                    if (operand1 == null || operand2 == null) {
                        throw new DBException("Execution time error!");
                    }
                    if (operand1 instanceof Integer && operand2 instanceof Integer) {
                        this._debug("ADD(" + (Integer)operand1 + "," + (Integer)operand2 + ")");
                        res = new Integer((Integer)operand1 + (Integer)operand2);
                        this._operandStack.push(res);
                        continue;
                    }
                    if (operand1 instanceof Double && operand2 instanceof Double) {
                        this._debug("ADD(" + (Double)operand1 + "," + (Double)operand2 + ")");
                        res = new Double((Double)operand1 + (Double)operand2);
                        this._operandStack.push(res);
                        continue;
                    }
                    throw new DBException("Bad types!");
                }
                if (this._operatorStack.size() <= 0 || this._operatorStack.peek().toString().compareTo("-") != 0) break block7;
                this._operatorStack.pop();
                operand2 = this._lookupValue(this._operandStack.pop());
                this.SQLProductExpr();
                operand1 = this._lookupValue(this._operandStack.pop());
                if (operand1 == null || operand2 == null) {
                    throw new DBException("Execution time error!");
                }
                if (operand1 instanceof Integer && operand2 instanceof Integer) {
                    this._debug("SUB(" + (Integer)operand1 + "," + (Integer)operand2 + ")");
                    res = new Integer((Integer)operand1 - (Integer)operand2);
                    this._operandStack.push(res);
                    continue;
                }
                if (!(operand1 instanceof Double) || !(operand2 instanceof Double)) break;
                this._debug("SUB(" + (Double)operand1 + "," + (Double)operand2 + ")");
                res = new Double((Double)operand1 - (Double)operand2);
                this._operandStack.push(res);
            }
            throw new DBException("Bad types!");
        }
    }

    public void SQLProductExpr() throws DBException {
        block7: {
            this.SQLUnaryExpr();
            while (true) {
                Number res;
                Object operand1;
                Object operand2;
                if (this._operatorStack.size() > 0 && this._operatorStack.peek().toString().compareTo("*") == 0) {
                    this._operatorStack.pop();
                    operand2 = this._lookupValue(this._operandStack.pop());
                    this.SQLUnaryExpr();
                    operand1 = this._lookupValue(this._operandStack.pop());
                    if (operand1 == null || operand2 == null) {
                        throw new DBException("Execution time error!");
                    }
                    if (operand1 instanceof Integer && operand2 instanceof Integer) {
                        this._debug("MUL(" + (Integer)operand1 + "," + (Integer)operand2 + ")");
                        res = new Integer((Integer)operand1 * (Integer)operand2);
                        this._operandStack.push(res);
                        continue;
                    }
                    if (operand1 instanceof Double && operand2 instanceof Double) {
                        this._debug("MUL(" + (Double)operand1 + "," + (Double)operand2 + ")");
                        res = new Double((Double)operand1 * (Double)operand2);
                        this._operandStack.push(res);
                        continue;
                    }
                    throw new DBException("Bad types!");
                }
                if (this._operatorStack.size() <= 0 || this._operatorStack.peek().toString().compareTo("/") != 0) break block7;
                this._operatorStack.pop();
                operand2 = this._lookupValue(this._operandStack.pop());
                this.SQLUnaryExpr();
                operand1 = this._lookupValue(this._operandStack.pop());
                if (operand1 == null || operand2 == null) {
                    throw new DBException("Execution time error!");
                }
                if (operand1 instanceof Integer && operand2 instanceof Integer) {
                    this._debug("DIV(" + (Integer)operand1 + "," + (Integer)operand2 + ")");
                    res = new Integer((Integer)operand1 / (Integer)operand2);
                    this._operandStack.push(res);
                    continue;
                }
                if (!(operand1 instanceof Double) || !(operand2 instanceof Double)) break;
                this._debug("DIV(" + (Double)operand1 + "," + (Double)operand2 + ")");
                res = new Double((Double)operand1 / (Double)operand2);
                this._operandStack.push(res);
            }
            throw new DBException("Bad types!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void SQLUnaryExpr() throws DBException {
        if (this._operatorStack.size() > 0 && this._operatorStack.peek().toString().compareTo("u+") == 0) {
            this._operatorStack.pop();
            this.SQLTerm();
            Object operand1 = this._lookupValue(this._operandStack.pop());
            this._debug("UADD(" + operand1.toString() + ")");
            if (operand1 instanceof Integer) {
                Integer res = new Integer((Integer)operand1);
                this._operandStack.push(res);
                return;
            } else {
                if (!(operand1 instanceof Double)) throw new DBException("Bad types!");
                Double res = new Double((Double)operand1);
                this._operandStack.push(res);
            }
            return;
        } else if (this._operatorStack.size() > 0 && this._operatorStack.peek().toString().compareTo("u-") == 0) {
            this._operatorStack.pop();
            this.SQLTerm();
            Object operand1 = this._lookupValue(this._operandStack.pop());
            this._debug("USUB(" + operand1.toString() + ")");
            if (operand1 instanceof Integer) {
                Integer res = new Integer(-((Integer)operand1).intValue());
                this._operandStack.push(res);
                return;
            } else {
                if (!(operand1 instanceof Double)) throw new DBException("Bad types!");
                Double res = new Double(-((Double)operand1).doubleValue());
                this._operandStack.push(res);
            }
            return;
        } else {
            this.SQLTerm();
        }
    }

    private boolean _matchClass(Class c1, Class c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.getName().compareTo(c2.getName()) == 0) {
            return true;
        }
        if (c1.isPrimitive()) {
            return c1.getName().compareTo("int") == 0 ? c2.getName().compareTo("java.lang.Integer") == 0 : c1.getName().compareTo("double") == 0 && c2.getName().compareTo("java.lang.Double") == 0;
        }
        return this._matchClass(c1, c2.getSuperclass());
    }

    private boolean _paramMatch(Class[] a1, Class[] a2) {
        boolean match = true;
        if (a1.length == a2.length) {
            int i = 0;
            while (i < a1.length) {
                if (!this._matchClass(a1[i], a2[i])) {
                    match = false;
                    break;
                }
                ++i;
            }
        } else {
            match = false;
        }
        return match;
    }

    public void SQLTerm() throws DBException {
        if (this._operatorStack.size() > 0 && this._operatorStack.peek().toString().compareTo(")") == 0) {
            this._operatorStack.pop();
            Hashtable used = this._usedCols;
            this._usedCols = null;
            Hashtable total = this._allUsedCols;
            this._allUsedCols = new Hashtable();
            this.SQLOrExpr();
            this._usedCols = used;
            Enumeration e = this._allUsedCols.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object data = this._allUsedCols.get(key);
                total.put(key, data);
                this._usedCols.put(key, data);
            }
            this._allUsedCols = total;
            if (this._operatorStack.size() <= 0 || this._operatorStack.peek().toString().compareTo("(") != 0) {
                throw new DBException("Expected (");
            }
            this._operatorStack.pop();
        } else if (this._operatorStack.size() > 0 && this._operatorStack.peek().toString().equalsIgnoreCase("JCALL")) {
            this._operatorStack.pop();
            LinkedList argList = (LinkedList)this._operandStack.pop();
            if (argList.size() < 2) {
                throw new DBException("JCALL: bad parameters!");
            }
            Expression expr = (Expression)argList.get(0);
            String clazz = (String)expr.eval(this._tbl);
            expr = (Expression)argList.get(1);
            String method = (String)expr.eval(this._tbl);
            Iterator it = argList.iterator();
            it.next();
            it.next();
            LinkedList<Object> actualArgList = new LinkedList<Object>();
            while (it.hasNext()) {
                Object data;
                Object key;
                SQLExpression sqlExpr = (SQLExpression)it.next();
                actualArgList.add(sqlExpr.eval(this._tbl));
                Enumeration enumeration = sqlExpr._allUsedCols.keys();
                while (enumeration.hasMoreElements()) {
                    key = enumeration.nextElement();
                    data = sqlExpr._allUsedCols.get(key);
                    this._usedCols.put(key, data);
                    this._allUsedCols.put(key, data);
                }
                if (sqlExpr._indexedTables == null) continue;
                enumeration = sqlExpr._indexedTables.keys();
                while (enumeration.hasMoreElements()) {
                    key = enumeration.nextElement();
                    data = sqlExpr._indexedTables.get(key);
                    this._indexedTables.put(key, data);
                }
            }
            Object[] argArray = new Object[actualArgList.size()];
            it = actualArgList.iterator();
            int i = 0;
            while (i < argArray.length) {
                argArray[i] = it.next();
                ++i;
            }
            try {
                Class<?> cls = Class.forName(clazz);
                Class[] params = new Class[argArray.length];
                int i2 = 0;
                while (i2 < argArray.length) {
                    params[i2] = argArray[i2].getClass();
                    ++i2;
                }
                Method[] mArray = cls.getMethods();
                Method m = null;
                int i3 = 0;
                while (i3 < mArray.length) {
                    if (mArray[i3].getName().compareTo(method) == 0 && this._paramMatch(mArray[i3].getParameterTypes(), params)) {
                        m = mArray[i3];
                        break;
                    }
                    ++i3;
                }
                if (m == null) {
                    throw new DBException("JCALL: no such method!");
                }
                Object ret = m.invoke(null, argArray);
                if (ret != null) {
                    if (ret instanceof String) {
                        ret = "'" + (String)ret + "'";
                    }
                    this._operandStack.push(ret);
                } else {
                    this._operandStack.push("''");
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new DBException("JCALL: error attementing to invoke " + clazz + "." + method);
            }
        }
    }

    private void _debugStack() {
    }

    public Object eval(ValueLookup[] tbl) throws DBException {
        this._tbl = tbl;
        if (this._operandStack.size() == 1 && this._operatorStack.size() == 0) {
            Object res = this._operandStack.peek();
            if (this._as.compareTo("") == 0) {
                this._as = res.toString();
                if (this._as.length() > 0 && this._as.charAt(0) == '\'') {
                    this._as = this._as.substring(1, this._as.length() - 1);
                }
            }
            return this._lookupValue(res);
        }
        Stack operandStack = (Stack)this._operandStack.clone();
        Stack operatorStack = (Stack)this._operatorStack.clone();
        this._debugStack();
        this.SQLOrExpr();
        this._debugStack();
        Object res = this._operandStack.pop();
        this._operandStack = operandStack;
        this._operatorStack = operatorStack;
        return this._lookupValue(res);
    }
}

