/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.db;

import com.mwc.sqld.db.Criteria;
import com.mwc.sqld.db.DBException;
import com.mwc.sqld.db.Expression;
import com.mwc.sqld.db.SQLTypeChecker;
import com.mwc.sqld.db.UpdateCurser;
import com.mwc.sqld.db.UpdateEngine;
import java.util.Iterator;
import java.util.LinkedList;

public class SimpleUpdateEngine
implements UpdateEngine {
    private int _updateCount;

    private void _doUpdate(int i, UpdateCurser[] data, LinkedList setList, Criteria c) throws DBException {
        if (i >= data.length) {
            if (c == null || c.match(data)) {
                Iterator iterator = setList.iterator();
                while (iterator.hasNext()) {
                    Object[] array = (Object[])iterator.next();
                    String columnName = (String)array[0];
                    boolean found = false;
                    int j = 0;
                    while (j < data.length) {
                        if (data[j].getValue(columnName) != null) {
                            Expression expression = (Expression)array[1];
                            Object value = expression.eval(data);
                            if (value == null) {
                                throw new DBException("Unable to eval expression for set on column \"" + columnName + "\"!");
                            }
                            if (value.equals("") && data[j].notNull(columnName)) {
                                throw new DBException("Column \"" + columnName + "\" does not allow NULL!");
                            }
                            if (SQLTypeChecker.badTypes(value, data[j].getType(columnName))) {
                                throw new DBException("Expected type \"" + data[j].getType(columnName) + "\" for column \"" + columnName + "\"!");
                            }
                            if (!data[j].setValue(columnName, value.toString())) {
                                throw new DBException("Unable to update column " + columnName + "!");
                            }
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        throw new DBException("Column name " + columnName + " was not found!");
                    }
                    ++this._updateCount;
                }
            }
            return;
        }
        data[i].reset();
        while (data[i].next()) {
            this._doUpdate(i + 1, data, setList, c);
        }
    }

    public int update(UpdateCurser[] data, LinkedList setList, Criteria c) throws DBException {
        this._updateCount = 0;
        this._doUpdate(0, data, setList, c);
        return this._updateCount;
    }
}

