/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.db;

public class Soundex {
    public static final transient int NO_MAX = -1;
    protected boolean DropLastSBoolean = false;
    protected int LengthInt = 4;
    protected boolean PadBoolean = true;
    protected int[] SoundexInts = Soundex.createArray();
    private static final String LowerS = "s";
    private static final String UpperS = "S";

    public String encode(String word) {
        word = word.trim();
        if (this.DropLastSBoolean && word.length() > 1 && (word.endsWith(UpperS) || word.endsWith(LowerS))) {
            word = word.substring(0, word.length() - 1);
        }
        word = this.reduce(word);
        int wordLength = word.length();
        int sofar = 0;
        int max = this.LengthInt - 1;
        if (this.LengthInt < 0) {
            max = wordLength;
        }
        int code = 0;
        StringBuffer buf = new StringBuffer(max);
        buf.append(Character.toLowerCase(word.charAt(0)));
        int i = 1;
        while (i < wordLength && sofar < max) {
            code = this.getCode(word.charAt(i));
            if (code > 0) {
                buf.append(code);
                ++sofar;
            }
            ++i;
        }
        if (this.PadBoolean && this.LengthInt > 0) {
            while (sofar < max) {
                buf.append('0');
                ++sofar;
            }
        }
        return buf.toString();
    }

    public int getCode(char ch) {
        int arrayidx = -1;
        if ('a' <= ch || ch <= 'z') {
            arrayidx = ch - 97;
        } else if ('A' <= ch || ch <= 'Z') {
            arrayidx = ch - 65;
        }
        if (arrayidx >= 0 && arrayidx < this.SoundexInts.length) {
            return this.SoundexInts[arrayidx];
        }
        return -1;
    }

    public boolean getDropLastS() {
        return this.DropLastSBoolean;
    }

    public int getLength() {
        return this.LengthInt;
    }

    public boolean getPad() {
        return this.PadBoolean;
    }

    public static void main(String[] strings) {
        if (strings == null || strings.length == 0) {
            System.out.println("Specify some words and this will display a soundex code for each.");
            System.exit(0);
        }
        Soundex sndx = new Soundex();
        int i = 0;
        while (i < strings.length) {
            System.out.println(sndx.encode(strings[i]));
            ++i;
        }
    }

    public void setCode(char ch, int code) {
        int arrayidx = -1;
        if ('a' <= ch || ch <= 'z') {
            arrayidx = ch - 97;
        } else if ('A' <= ch || ch <= 'Z') {
            arrayidx = ch - 65;
        }
        if (0 <= arrayidx && arrayidx < this.SoundexInts.length) {
            this.SoundexInts[arrayidx] = code;
        }
    }

    public void setDropLastS(boolean bool) {
        this.DropLastSBoolean = bool;
    }

    public void setLength(int length) {
        this.LengthInt = length;
    }

    public void setPad(boolean bool) {
        this.PadBoolean = bool;
    }

    protected static int[] createArray() {
        return new int[]{-1, 1, 2, 3, -1, 1, 2, -1, -1, 2, 2, 4, 5, 5, -1, 1, 2, 6, 2, 3, -1, 1, -1, 2, -1, 2};
    }

    protected String reduce(String word) {
        int len = word.length();
        StringBuffer buf = new StringBuffer(len);
        char ch = word.charAt(0);
        int currentCode = this.getCode(ch);
        buf.append(ch);
        int lastCode = currentCode;
        int i = 1;
        while (i < len) {
            ch = word.charAt(i);
            currentCode = this.getCode(ch);
            if (currentCode != lastCode && currentCode >= 0) {
                buf.append(ch);
                lastCode = currentCode;
            }
            ++i;
        }
        if (buf.length() == len) {
            return word;
        }
        return buf.toString();
    }
}

