/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.sqld.db;

import com.mwc.sqld.db.Curser;
import com.mwc.sqld.db.DBException;
import com.mwc.sqld.db.MasterTable;
import com.mwc.sqld.db.ReadWriteLock;
import com.mwc.sqld.db.SimpleDatabase;
import com.mwc.sqld.db.Table;
import com.mwc.sqld.db.UpdateCurser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLDatabase
extends SimpleDatabase {
    private String _name;
    private String _dataDirectory;
    private Hashtable _tables;
    private boolean _mod;
    private Object _modLock;
    private MasterTable _masterTable;
    private DocumentBuilder _db;

    public XMLDatabase(String name, String dataDirectory) throws DBException {
        block11: {
            this._tables = new Hashtable();
            this._mod = false;
            this._modLock = new Object();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(true);
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setCoalescing(true);
            dbf.setExpandEntityReferences(false);
            this._db = null;
            try {
                this._db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                throw new DBException(pce.getMessage());
            }
            this._db.setErrorHandler(new XMLErrorHandler());
            this._name = name;
            this._dataDirectory = dataDirectory;
            File f = new File(this._dataDirectory);
            if (!f.exists()) {
                f.mkdir();
            }
            if (!(f = new File(this._dataDirectory + "/table.dtd")).exists()) {
                try {
                    FileOutputStream fout = new FileOutputStream(f);
                    BufferedOutputStream bout = new BufferedOutputStream(fout);
                    PrintStream out = new PrintStream(bout);
                    out.println("<?xml version='1.0' encoding='us-ascii'?>");
                    out.println("<!ELEMENT table (rec*)>");
                    out.println("<!ELEMENT rec (ANY+)>");
                    out.flush();
                    fout.close();
                }
                catch (Throwable th) {
                    throw new DBException(th.getMessage());
                }
            }
            if ((f = new File(this._dataDirectory + "/data.dat")).exists()) {
                this._masterTable = new MasterTable(f);
                Curser c = this._masterTable.getNewCurser();
                try {
                    String lastTableName = "";
                    while (c.next()) {
                        String tableName = c.getValue("TableName");
                        if (lastTableName.equalsIgnoreCase(tableName)) continue;
                        lastTableName = tableName;
                        String[][] cols = this._masterTable.loadCols(tableName);
                        String tableFileName = this._dataDirectory + "/" + tableName + ".xml";
                        System.out.println("LOAD-TABLE(" + tableName + ")");
                        XMLTable t = new XMLTable(tableName, tableFileName, cols);
                        this._tables.put(t.name().toLowerCase(), t);
                    }
                    Object var13_13 = null;
                    if (c == null) break block11;
                    c.close();
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    if (c != null) {
                        c.close();
                    }
                    throw throwable;
                }
                {
                }
            }
        }
    }

    public Table createTable(String name, String[][] cols) {
        Table tbl = this.getTable(name);
        if (tbl != null) {
            return null;
        }
        String fileName = this._dataDirectory + "/" + name + ".xml";
        try {
            tbl = new XMLTable(name, fileName, cols);
        }
        catch (DBException dbe) {
            return null;
        }
        Hashtable hashtable = this._tables;
        synchronized (hashtable) {
            this._tables.put(name.toLowerCase(), tbl);
        }
        Object object = this._modLock;
        synchronized (object) {
            this._mod = true;
        }
        return tbl;
    }

    public String name() {
        return this._name;
    }

    public File getTempFile() {
        File f = new File(this._dataDirectory + "/temp");
        if (!f.exists()) {
            f.mkdir();
        }
        try {
            return File.createTempFile("TEMP_", ".dat", f);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Table getTable(String table) {
        if (table.equalsIgnoreCase("Master")) {
            return this._masterTable;
        }
        Hashtable hashtable = this._tables;
        synchronized (hashtable) {
            Table table2 = (Table)this._tables.get(table.toLowerCase());
            return table2;
        }
    }

    public String[] tableNames() {
        Hashtable hashtable = this._tables;
        synchronized (hashtable) {
            String[] ret = new String[this._tables.size()];
            Enumeration e = this._tables.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                ret[i] = ((Table)e.nextElement()).name();
                ++i;
            }
            String[] stringArray = ret;
            return stringArray;
        }
    }

    public boolean dropTable(String table) {
        return false;
    }

    public boolean save() {
        try {
            this._masterTable.saveState(this._dataDirectory, this._tables);
            Object object = this._modLock;
            synchronized (object) {
                this._mod = false;
            }
            this.sync();
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public boolean modified() {
        Object object = this._modLock;
        synchronized (object) {
            boolean bl = this._mod;
            return bl;
        }
    }

    public void sync() {
        Enumeration enumeration = this._tables.elements();
        while (enumeration.hasMoreElements()) {
            XMLTable xmlTable = (XMLTable)enumeration.nextElement();
            if (!xmlTable.modified()) continue;
            xmlTable.save();
        }
    }

    public void close() {
    }

    private static class XMLErrorHandler
    implements ErrorHandler {
        LinkedList errorList = new LinkedList();

        private XMLErrorHandler() {
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            this.errorList.add(spe);
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.errorList.add(spe);
        }

        public void error(SAXParseException spe) throws SAXException {
            this.errorList.add(spe);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            this.errorList.add(spe);
        }
    }

    class XMLTable
    implements Table {
        private ReadWriteLock _rwLock = new ReadWriteLock();
        private String[][] _cols;
        private String _name;
        private String _fileName;
        private Document _doc;
        private Object _modLock = new Object();
        private boolean _mod = false;

        public boolean modified() {
            Object object = this._modLock;
            synchronized (object) {
                boolean bl = this._mod;
                return bl;
            }
        }

        public XMLTable(String name, String fileName, String[][] cols) throws DBException {
            File f = new File(fileName);
            if (!f.exists()) {
                try {
                    FileOutputStream fout = new FileOutputStream(fileName);
                    BufferedOutputStream bout = new BufferedOutputStream(fout);
                    PrintStream out = new PrintStream(bout);
                    out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                    out.println("<!DOCTYPE table SYSTEM \"table.dtd\">");
                    out.println("<table/>");
                    out.flush();
                    fout.close();
                }
                catch (Throwable th) {
                    throw new DBException(th.getMessage());
                }
            }
            this._doc = null;
            try {
                this._doc = XMLDatabase.this._db.parse(new File(fileName));
            }
            catch (SAXException se) {
                se.printStackTrace();
                throw new DBException(se.getMessage());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new DBException(ioe.getMessage());
            }
            this._name = name;
            this._fileName = fileName;
            this._cols = cols;
        }

        public String name() {
            return this._name;
        }

        public Curser getNewCurser() {
            return new XMLCurser(-1);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean insert(LinkedList values) {
            this._rwLock.writeLock();
            try {
                Node node;
                Element rec = this._doc.createElement("rec");
                Iterator iterator = values.iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    Element field = this._doc.createElement(this._cols[index][0]);
                    Text data = this._doc.createTextNode(value.toString());
                    field.appendChild(data);
                    rec.appendChild(field);
                    ++index;
                }
                DocumentTraversal traversable = (DocumentTraversal)((Object)this._doc);
                NodeIterator nodeIterator = traversable.createNodeIterator(this._doc, 1, null, true);
                while ((node = nodeIterator.nextNode()) != null) {
                    void var10_10;
                    if (var10_10.getNodeName() == null || var10_10.getNodeName().compareTo("table") != 0) continue;
                    var10_10.appendChild(rec);
                    boolean bl = true;
                    Object var13_13 = null;
                    Object object = this._modLock;
                    synchronized (object) {
                        this._mod = true;
                    }
                    this._rwLock.writeUnlock();
                    return bl;
                }
                boolean bl = false;
                Object var13_14 = null;
                Object object = this._modLock;
                synchronized (object) {
                    this._mod = true;
                }
                this._rwLock.writeUnlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                Object object = this._modLock;
                synchronized (object) {
                    this._mod = true;
                }
                this._rwLock.writeUnlock();
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean save() {
            Object object;
            this._rwLock.writeLock();
            try {
                try {
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("omit-xml-declaration", "no");
                    transformer.setOutputProperty("encoding", "utf-8");
                    transformer.setOutputProperty("doctype-system", "table.dtd");
                    transformer.transform(new DOMSource(this._doc), new StreamResult(new File(this._fileName)));
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    boolean bl = false;
                    Object var4_4 = null;
                    Object object3 = this._modLock;
                    synchronized (object3) {
                        this._mod = false;
                    }
                    this._rwLock.writeUnlock();
                    return bl;
                }
                Object var4_3 = null;
                object = this._modLock;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                Object object2 = this._modLock;
                synchronized (object2) {
                    this._mod = false;
                }
                this._rwLock.writeUnlock();
                throw throwable;
            }
            synchronized (object) {
                this._mod = false;
            }
            this._rwLock.writeUnlock();
            return true;
        }

        public boolean drop() {
            return false;
        }

        public String[][] cols() {
            return this._cols;
        }

        class XMLCurser
        implements UpdateCurser {
            private int _recCount;
            private Hashtable _tbl = new Hashtable();
            private Vector _valueVector;
            private NodeIterator _recIterator;
            private Node _currentNode;
            private Hashtable _rmTbl = null;

            XMLCurser(int recCount) {
                this._recCount = recCount;
                XMLTable.this._rwLock.readLock();
                int i = 0;
                while (i < XMLTable.this._cols.length) {
                    this._tbl.put(XMLTable.this._cols[i][0].toLowerCase(), new Integer(i));
                    ++i;
                }
                this.reset();
            }

            public boolean remove() {
                if (this._currentNode == null) {
                    return false;
                }
                if (this._rmTbl == null) {
                    this._rmTbl = new Hashtable();
                }
                this._rmTbl.put(this._currentNode, this._currentNode);
                Object object = XMLTable.this._modLock;
                synchronized (object) {
                    XMLTable.this._mod = true;
                }
                return true;
            }

            public boolean notNull(String name) {
                int index = name.indexOf(46);
                if (index >= 0) {
                    String tableName = name.substring(0, index);
                    if (!XMLTable.this._name.equalsIgnoreCase(tableName)) {
                        return false;
                    }
                    name = name.substring(index + 1);
                }
                int i = 0;
                while (i < XMLTable.this._cols.length) {
                    if (XMLTable.this._cols[i][0].equalsIgnoreCase(name)) {
                        return XMLTable.this._cols[i][2].compareTo("true") == 0;
                    }
                    ++i;
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public boolean setValue(String name, String value) {
                if (this._currentNode == null) {
                    return false;
                }
                int index = name.indexOf(46);
                if (index >= 0) {
                    String tableName = name.substring(0, index);
                    if (!XMLTable.this._name.equalsIgnoreCase(tableName)) {
                        return false;
                    }
                    name = name.substring(index + 1);
                }
                boolean ret = false;
                Document document = XMLTable.this._doc;
                synchronized (document) {
                    Node fieldNode;
                    DocumentTraversal traversable = (DocumentTraversal)((Object)XMLTable.this._doc);
                    NodeIterator fieldIterator = traversable.createNodeIterator(this._currentNode, 1, new FieldFilter(), true);
                    while ((fieldNode = fieldIterator.nextNode()) != null) {
                        Node textNode;
                        void var8_9;
                        if (var8_9.getNodeName() == null || !var8_9.getNodeName().equalsIgnoreCase(name)) continue;
                        Text v = XMLTable.this._doc.createTextNode(value.toString());
                        NodeIterator textIterator = traversable.createNodeIterator((Node)var8_9, -1, null, true);
                        LinkedList<void> nodeList = new LinkedList<void>();
                        while ((textNode = textIterator.nextNode()) != null) {
                            void var10_13;
                            if (var10_13.getNodeName() != null && var10_13.getNodeName().equalsIgnoreCase(name)) continue;
                            nodeList.add(var10_13);
                        }
                        Iterator it = nodeList.iterator();
                        while (it.hasNext()) {
                            textNode = (Node)it.next();
                            textNode.getParentNode().removeChild(textNode);
                        }
                        var8_9.appendChild(v);
                        ret = true;
                        break;
                    }
                }
                if (ret) {
                    Object object = XMLTable.this._modLock;
                    synchronized (object) {
                        XMLTable.this._mod = true;
                    }
                }
                return ret;
            }

            public boolean reset() {
                this._valueVector = null;
                DocumentTraversal traversable = (DocumentTraversal)((Object)XMLTable.this._doc);
                this._recIterator = traversable.createNodeIterator(XMLTable.this._doc, 1, new RecFilter(), true);
                this._currentNode = null;
                return true;
            }

            public String nodeType(short type) {
                switch (type) {
                    case 2: {
                        return "ATTRIBUTE_NODE";
                    }
                    case 4: {
                        return "CDATA_SECTION_NODE";
                    }
                    case 8: {
                        return "COMMENT_NODE";
                    }
                    case 11: {
                        return "DOCUMENT_FRAGMENT_NODE";
                    }
                    case 9: {
                        return "DOCUMENT_NODE";
                    }
                    case 10: {
                        return "DOCUMENT_TYPE_NODE";
                    }
                    case 1: {
                        return "ELEMENT_NODE";
                    }
                    case 6: {
                        return "ENTITY_NODE";
                    }
                    case 5: {
                        return "ENTITY_REFERENCE_NODE";
                    }
                    case 12: {
                        return "NOTATION_NODE";
                    }
                    case 7: {
                        return "PROCESSING_INSTRUCTION_NODE";
                    }
                    case 3: {
                        return "TEXT_NODE";
                    }
                }
                return "<UNKNOWN>";
            }

            /*
             * WARNING - void declaration
             */
            public boolean next() {
                Document document = XMLTable.this._doc;
                synchronized (document) {
                    Node fieldNode;
                    this._currentNode = this._recIterator.nextNode();
                    if (this._currentNode == null) {
                        boolean bl = false;
                        return bl;
                    }
                    this._valueVector = new Vector();
                    DocumentTraversal traversable = (DocumentTraversal)((Object)XMLTable.this._doc);
                    NodeIterator fieldIterator = traversable.createNodeIterator(this._currentNode, 1, new FieldFilter(), true);
                    while ((fieldNode = fieldIterator.nextNode()) != null) {
                        Node textNode;
                        void var5_5;
                        StringBuffer value = new StringBuffer();
                        NodeIterator textIterator = traversable.createNodeIterator((Node)var5_5, 28, null, true);
                        while ((textNode = textIterator.nextNode()) != null) {
                            void var7_7;
                            value.append(var7_7.getNodeValue());
                        }
                        this._valueVector.addElement(value.toString());
                    }
                    boolean bl = true;
                    return bl;
                }
            }

            public boolean close() {
                if (this._rmTbl != null) {
                    Document document = XMLTable.this._doc;
                    synchronized (document) {
                        Enumeration enumeration = this._rmTbl.keys();
                        while (enumeration.hasMoreElements()) {
                            this._currentNode = (Node)enumeration.nextElement();
                            this._currentNode.getParentNode().removeChild(this._currentNode);
                        }
                    }
                }
                this._currentNode = null;
                XMLTable.this._rwLock.readUnlock();
                return true;
            }

            public int recCount() {
                return this._recCount;
            }

            public String getValue(String name) {
                Integer index;
                int i = name.indexOf(46);
                if (i < 0) {
                    index = (Integer)this._tbl.get(name.toLowerCase());
                } else {
                    String tblName = name.substring(0, i);
                    if (tblName.equalsIgnoreCase(XMLTable.this._name)) {
                        name = name.substring(i + 1);
                        index = (Integer)this._tbl.get(name.toLowerCase());
                    } else {
                        index = null;
                    }
                }
                if (index == null) {
                    return null;
                }
                return (String)this._valueVector.elementAt(index);
            }

            public String getValue(int index) {
                return (String)this._valueVector.elementAt(index);
            }

            public String getType(String colName) {
                int i = colName.indexOf(46);
                if (i >= 0) {
                    String tblName = colName.substring(0, i);
                    if (!tblName.equalsIgnoreCase(XMLTable.this._name)) {
                        return null;
                    }
                    colName = colName.substring(i + 1);
                }
                i = 0;
                while (i < XMLTable.this._cols.length) {
                    if (colName.equalsIgnoreCase(XMLTable.this._cols[i][0])) {
                        return XMLTable.this._cols[i][1];
                    }
                    ++i;
                }
                return null;
            }

            public int size() {
                return this._valueVector.size();
            }

            public String[][] cols() {
                return XMLTable.this._cols;
            }

            class FieldFilter
            implements NodeFilter {
                FieldFilter() {
                }

                public short acceptNode(Node n) {
                    String nodeName = n.getNodeName();
                    int ret = nodeName != null ? (nodeName.compareTo("rec") != 0 ? 1 : 2) : 3;
                    return (short)ret;
                }
            }

            class RecFilter
            implements NodeFilter {
                RecFilter() {
                }

                public short acceptNode(Node n) {
                    String nodeName = n.getNodeName();
                    int ret = nodeName != null ? (nodeName.compareTo("rec") == 0 ? 1 : 3) : 3;
                    return (short)ret;
                }
            }
        }
    }
}

