/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.util;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

public class ThreadPool {
    private int _min;
    private int _max;
    private long _timeOut;
    private int _maxQueue;
    private LinkedList _threadList = new LinkedList();
    private LinkedList _queue = new LinkedList();
    private boolean _stopped = false;
    private Object _stopLock = new Object();

    private void _debug(String msg) {
    }

    private void _removeMe() {
        if (this._threadList.size() > this._min) {
            this._debug("REMOVING THREAD " + Thread.currentThread().getName());
            Iterator it = this._threadList.iterator();
            while (it.hasNext()) {
                Thread t = (Thread)it.next();
                if (t != Thread.currentThread()) continue;
                it.remove();
            }
            this._threadList.notify();
        }
    }

    public ThreadPool(int min, int max, long timeOut, int maxQueue) {
        this._min = min;
        this._max = max;
        this._timeOut = timeOut;
        this._maxQueue = maxQueue;
        int i = 0;
        while (i < this._min) {
            PoolThread pt = new PoolThread();
            this._threadList.add(pt);
            pt.start();
            ++i;
        }
    }

    public void postTaskForExecution(Runnable task) {
        this._debug("ThreadPool.postTaskForExecution(Runnable task)");
        this._debug("WAITING FOR QUEUE LOCK 1");
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            this._debug("GOT QUEUE LOCK");
            while (this._queue.size() >= this._maxQueue) {
                try {
                    this._debug("WAITING FOR QUEUE TO GET SMALLER");
                    this._queue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this._queue.add(task);
            this._queue.notifyAll();
            this._debug("TASK IN QUEUE");
        }
        LinkedList linkedList2 = this._threadList;
        synchronized (linkedList2) {
            PoolThread pt;
            this._debug("GOT THREAD LIST LOCK");
            this._debug("LOOP");
            Object object = this._stopLock;
            synchronized (object) {
                if (this._stopped) {
                    return;
                }
            }
            this._debug("PAST STOP LOCK");
            int index = -1;
            long time = -1L;
            int i = 0;
            while (i < this._threadList.size()) {
                pt = (PoolThread)this._threadList.get(i);
                long t = pt.isWaiting();
                if ((time == -1L || t < time) && t != -1L) {
                    time = t;
                    index = i;
                }
                ++i;
            }
            this._debug("index=" + index);
            if (index != -1) {
                pt = (PoolThread)this._threadList.get(index);
                this._debug("WAITING FOR QUEUE LOCK 2");
                boolean doNotify = false;
                LinkedList linkedList3 = this._queue;
                synchronized (linkedList3) {
                    this._debug("QUEUE LOCK GOT");
                    if (this._queue.size() > 0) {
                        this._debug("NOTIFY POOLED THREAD");
                        doNotify = true;
                    }
                }
                if (doNotify) {
                    while (pt.isWaiting() != -1L) {
                        System.out.println("[" + Thread.currentThread().getName() + "]NOTIFY(" + pt.getName() + ")");
                        Object object2 = pt._waitOn;
                        synchronized (object2) {
                            pt._waitOn.notify();
                        }
                    }
                }
                this._debug("RETURN");
                return;
            }
            if (this._threadList.size() >= this._max) {
                return;
            }
            boolean isDone = false;
            this._debug("GET QUEUE LOCK NEXT");
            LinkedList linkedList4 = this._queue;
            synchronized (linkedList4) {
                this._debug("GOT QUEUE LOCK AGAIN");
                if (this._queue.size() == 0) {
                    isDone = true;
                }
            }
            if (!isDone) {
                pt = new PoolThread();
                this._debug("CREATING AND STARTING NEW POOLED THREAD " + pt.getName());
                this._threadList.add(pt);
                pt.start();
            } else {
                this._debug("TASK ALREADY RAN");
            }
            this._debug("RETURN");
            return;
        }
    }

    public void stop() {
        Object object = this._stopLock;
        synchronized (object) {
            this._stopped = true;
        }
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.notifyAll();
        }
    }

    public Stat getStats() {
        Stat ret = new Stat();
        ret.max = this._max;
        ret.min = this._min;
        ret.timeOut = this._timeOut;
        ret.queueMax = this._maxQueue;
        LinkedList linkedList = this._threadList;
        synchronized (linkedList) {
            ret.poolSize = this._threadList.size();
        }
        Object object = this._stopLock;
        synchronized (object) {
            ret.stopped = this._stopped;
        }
        LinkedList linkedList2 = this._queue;
        synchronized (linkedList2) {
            ret.queueSize = this._queue.size();
        }
        return ret;
    }

    class PoolThread
    extends Thread {
        private long _waitingFlag = -1L;
        private Object _waitingLock = new Object();
        private Object _waitOn = new Object();

        PoolThread() {
        }

        public long isWaiting() {
            Object object = this._waitingLock;
            synchronized (object) {
                long l = this._waitingFlag;
                return l;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                ThreadPool.this._debug("PoolThread.run()");
                long totalWait = 0L;
                while (true) {
                    LinkedList linkedList;
                    Object object;
                    boolean timeOutReached;
                    int qSize;
                    Object object3;
                    LinkedList linkedList2 = ThreadPool.this._threadList;
                    synchronized (linkedList2) {
                        object3 = ThreadPool.this._stopLock;
                        synchronized (object3) {
                            if (ThreadPool.this._stopped) {
                                ThreadPool.this._debug("STOP");
                                ThreadPool.this._removeMe();
                                return;
                            }
                        }
                    }
                    Runnable task = null;
                    long temp = 0L;
                    object3 = ThreadPool.this._queue;
                    synchronized (object3) {
                        qSize = ThreadPool.this._queue.size();
                        if (qSize != 0) {
                            task = (Runnable)ThreadPool.this._queue.get(0);
                            ThreadPool.this._queue.remove(0);
                            timeOutReached = false;
                            ThreadPool.this._queue.notifyAll();
                        }
                    }
                    timeOutReached = false;
                    ThreadPool.this._debug("QUEEU_SIZE=" + qSize);
                    if (qSize == 0) {
                        Object object2;
                        Object var18_13;
                        try {
                            try {
                                ThreadPool.this._debug("WAITING");
                                System.out.println("[" + Thread.currentThread().getName() + "]WAITING");
                                object = this._waitingLock;
                                synchronized (object) {
                                    temp = this._waitingFlag = new Date().getTime();
                                }
                                linkedList = ThreadPool.this._threadList;
                                synchronized (linkedList) {
                                    ThreadPool.this._threadList.notify();
                                }
                                Object object4 = this._waitOn;
                                synchronized (object4) {
                                    if (ThreadPool.this._timeOut < 0L) {
                                        this._waitOn.wait();
                                    } else {
                                        this._waitOn.wait(Math.abs(ThreadPool.this._timeOut - totalWait));
                                    }
                                }
                                System.out.println("[" + Thread.currentThread().getName() + "]WAKEUP");
                                timeOutReached = true;
                            }
                            catch (InterruptedException ie) {
                                linkedList = ThreadPool.this._threadList;
                                synchronized (linkedList) {
                                    ThreadPool.this._debug("Interrupted");
                                    ThreadPool.this._removeMe();
                                }
                                var18_13 = null;
                                totalWait += new Date().getTime() - temp;
                                object2 = this._waitingLock;
                                synchronized (object2) {
                                    this._waitingFlag = -1L;
                                    return;
                                }
                            }
                            var18_13 = null;
                            totalWait += new Date().getTime() - temp;
                            object2 = this._waitingLock;
                        }
                        catch (Throwable throwable) {
                            var18_13 = null;
                            totalWait += new Date().getTime() - temp;
                            object2 = this._waitingLock;
                            synchronized (object2) {
                                this._waitingFlag = -1L;
                                throw throwable;
                            }
                        }
                        synchronized (object2) {
                            this._waitingFlag = -1L;
                        }
                    }
                    if (timeOutReached) {
                        object = ThreadPool.this._threadList;
                        synchronized (object) {
                            ThreadPool.this._debug("WAITING FOR QUEUE LOCK 4");
                            linkedList = ThreadPool.this._queue;
                            synchronized (linkedList) {
                                ThreadPool.this._debug("GOT QUEUE LOCK 4");
                                if (totalWait >= ThreadPool.this._timeOut && ThreadPool.this._queue.size() <= 0 && ThreadPool.this._threadList.size() > ThreadPool.this._min) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 16, 18, 28, 29, 30] lbl92 : MonitorExitStatement: MONITOREXIT : var13_11
                                    ThreadPool.this._debug("TIMEOUT");
                                    ThreadPool.this._removeMe();
                                    return;
                                }
                                ThreadPool.this._debug("RUN AGAIN");
                                continue;
                            }
                        }
                    }
                    totalWait = 0L;
                    ThreadPool.this._debug("RUNNING TASK");
                    task.run();
                    ThreadPool.this._debug("TASK DONE");
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
        }
    }

    public class Stat {
        public int min;
        public int max;
        public long sleepTime;
        public long timeOut;
        public int queueMax;
        public int queueSize;
        public boolean stopped;
        public int poolSize;

        private Stat() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("min=" + this.min + "\n");
            buf.append("max=" + this.max + "\n");
            buf.append("timeOut=" + this.timeOut + "\n");
            buf.append("queueMax=" + this.queueMax + "\n");
            buf.append("queueSize=" + this.queueSize + "\n");
            buf.append("stopped=" + this.stopped + "\n");
            buf.append("poolSize=" + this.poolSize + "\n");
            return buf.toString();
        }
    }
}

