/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.cmdline;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.TransletOutputHandler;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.dom.DOMBuilder;
import org.apache.xalan.xsltc.dom.DOMImpl;
import org.apache.xalan.xsltc.dom.DTDMonitor;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;
import org.apache.xalan.xsltc.runtime.DefaultSAXOutputHandler;
import org.apache.xalan.xsltc.runtime.Parameter;
import org.apache.xalan.xsltc.runtime.TextOutput;
import org.apache.xalan.xsltc.runtime.TransletLoader;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class Transform {
    private TransletOutputHandler _handler;
    private String _fileName;
    private String _className;
    private String _jarFileSrc;
    private boolean _isJarFileSpecified = false;
    private Vector _params = null;
    private boolean _uri;
    private boolean _debug;
    private static boolean _allowExit = true;

    public Transform(String className, String fileName, boolean uri, boolean debug) {
        this._fileName = fileName;
        this._className = className;
        this._uri = uri;
        this._debug = debug;
    }

    public void setParameters(Vector params) {
        this._params = params;
    }

    private void setJarFileInputSrc(boolean flag, String jarFile) {
        this._isJarFileSpecified = flag;
        this._jarFileSrc = jarFile;
    }

    private Class loadTranslet(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            TransletLoader loader = new TransletLoader();
            return loader.loadTranslet(name);
        }
    }

    private void doTransform() {
        block34: {
            try {
                Class clazz = this.loadTranslet(this._className);
                Translet translet = (Translet)clazz.newInstance();
                SAXParserFactory factory = SAXParserFactory.newInstance();
                try {
                    factory.setFeature("http://xml.org/sax/features/namespaces", true);
                }
                catch (Exception e) {
                    factory.setNamespaceAware(true);
                }
                SAXParser parser2 = factory.newSAXParser();
                XMLReader reader = parser2.getXMLReader();
                DOMImpl dom = new DOMImpl();
                DOMBuilder builder = dom.getBuilder();
                reader.setContentHandler(builder);
                try {
                    String prop = "http://xml.org/sax/properties/lexical-handler";
                    reader.setProperty(prop, builder);
                }
                catch (SAXException e) {
                    // empty catch block
                }
                DTDMonitor dtdMonitor = new DTDMonitor(reader);
                AbstractTranslet _translet = (AbstractTranslet)translet;
                dom.setDocumentURI(this._fileName);
                if (this._uri) {
                    reader.parse(this._fileName);
                } else {
                    reader.parse(new File(this._fileName).toURL().toExternalForm());
                }
                builder = null;
                dtdMonitor.buildIdIndex(dom, 0, _translet);
                _translet.setDTDMonitor(dtdMonitor);
                int n = this._params.size();
                int i = 0;
                while (i < n) {
                    Parameter param = (Parameter)this._params.elementAt(i);
                    translet.addParameter(param._name, param._value);
                    ++i;
                }
                String encoding = _translet._encoding;
                DefaultSAXOutputHandler saxHandler = new DefaultSAXOutputHandler(System.out, encoding);
                TextOutput textOutput = new TextOutput(saxHandler, saxHandler, encoding);
                translet.transform((DOM)dom, textOutput);
            }
            catch (TransletException e) {
                if (this._debug) {
                    e.printStackTrace();
                }
                System.err.println(ErrorMsg.getTransletErrorMessage() + e.getMessage());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (RuntimeException e) {
                if (this._debug) {
                    e.printStackTrace();
                }
                System.err.println(ErrorMsg.getTransletErrorMessage() + e.getMessage());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (FileNotFoundException e) {
                if (this._debug) {
                    e.printStackTrace();
                }
                ErrorMsg err = new ErrorMsg(8, this._fileName);
                System.err.println(ErrorMsg.getTransletErrorMessage() + err.toString());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (MalformedURLException e) {
                if (this._debug) {
                    e.printStackTrace();
                }
                ErrorMsg err = new ErrorMsg(9, this._fileName);
                System.err.println(ErrorMsg.getTransletErrorMessage() + err.toString());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (ClassNotFoundException e) {
                if (this._debug) {
                    e.printStackTrace();
                }
                ErrorMsg err = new ErrorMsg(5, this._className);
                System.err.println(ErrorMsg.getTransletErrorMessage() + err.toString());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (UnknownHostException e) {
                if (this._debug) {
                    e.printStackTrace();
                }
                ErrorMsg err = new ErrorMsg(9, this._fileName);
                System.err.println(ErrorMsg.getTransletErrorMessage() + err.toString());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (SAXException e) {
                Exception ex = e.getException();
                if (this._debug) {
                    if (ex != null) {
                        ex.printStackTrace();
                    }
                    e.printStackTrace();
                }
                System.err.print(ErrorMsg.getTransletErrorMessage());
                if (ex != null) {
                    System.err.println(ex.getMessage());
                } else {
                    System.err.println(e.getMessage());
                }
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (Exception e) {
                if (this._debug) {
                    e.printStackTrace();
                }
                System.err.println(ErrorMsg.getTransletErrorMessage() + e.getMessage());
                if (!_allowExit) break block34;
                System.exit(-1);
            }
        }
    }

    public static void printUsage() {
        System.err.println(new ErrorMsg(73));
        if (_allowExit) {
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                boolean uri = false;
                boolean debug = false;
                boolean isJarFileSpecified = false;
                String jarFile = null;
                int i = 0;
                while (i < args.length && args[i].charAt(0) == '-') {
                    if (args[i].equals("-u")) {
                        uri = true;
                    } else if (args[i].equals("-x")) {
                        debug = true;
                    } else if (args[i].equals("-s")) {
                        _allowExit = false;
                    } else if (args[i].equals("-j")) {
                        isJarFileSpecified = true;
                        jarFile = args[++i];
                    } else {
                        Transform.printUsage();
                    }
                    ++i;
                }
                if (args.length - i < 2) {
                    Transform.printUsage();
                }
                Transform handler = new Transform(args[i + 1], args[i], uri, debug);
                handler.setJarFileInputSrc(isJarFileSpecified, jarFile);
                Vector<Parameter> params = new Vector<Parameter>();
                i += 2;
                while (i < args.length) {
                    int equal = args[i].indexOf(61);
                    if (equal > 0) {
                        String name = args[i].substring(0, equal);
                        String value = args[i].substring(equal + 1);
                        params.addElement(new Parameter(name, value));
                    } else {
                        Transform.printUsage();
                    }
                    ++i;
                }
                if (i == args.length) {
                    handler.setParameters(params);
                    handler.doTransform();
                    if (_allowExit) {
                        System.exit(0);
                    }
                }
            } else {
                Transform.printUsage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

