/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Dictionary;
import java.util.Vector;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.GOTO_W;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.xalan.xsltc.compiler.LocationPathPattern;
import org.apache.xalan.xsltc.compiler.Mode;
import org.apache.xalan.xsltc.compiler.Pattern;
import org.apache.xalan.xsltc.compiler.Template;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;

final class TestSeq {
    private Vector _patterns = null;
    private Mode _mode = null;
    private Template _default = null;
    private InstructionList _instructionList;
    private InstructionHandle _start = null;

    public TestSeq(Vector patterns, Mode mode) {
        this._patterns = patterns;
        this._mode = mode;
    }

    public double getPriority() {
        double tp;
        double prio = -1.7976931348623157E308;
        int count = this._patterns.size();
        int i = 0;
        while (i < count) {
            Pattern pattern = (Pattern)this._patterns.elementAt(i);
            Template template = pattern.getTemplate();
            double tp2 = template.getPriority();
            if (tp2 > prio) {
                prio = tp2;
            }
            ++i;
        }
        if (this._default != null && (tp = this._default.getPriority()) > prio) {
            prio = tp;
        }
        return prio;
    }

    public int getPosition() {
        int tp;
        int pos = Integer.MIN_VALUE;
        int count = this._patterns.size();
        int i = 0;
        while (i < count) {
            Pattern pattern = (Pattern)this._patterns.elementAt(i);
            Template template = pattern.getTemplate();
            int tp2 = template.getPosition();
            if (tp2 > pos) {
                pos = tp2;
            }
            ++i;
        }
        if (this._default != null && (tp = this._default.getPosition()) > pos) {
            pos = tp;
        }
        return pos;
    }

    public void reduce() {
        Vector<LocationPathPattern> newPatterns = new Vector<LocationPathPattern>();
        int count = this._patterns.size();
        int i = 0;
        while (i < count) {
            LocationPathPattern pattern = (LocationPathPattern)this._patterns.elementAt(i);
            pattern.reduceKernelPattern();
            if (pattern.isWildcard()) {
                this._default = pattern.getTemplate();
                break;
            }
            newPatterns.addElement(pattern);
            ++i;
        }
        this._patterns = newPatterns;
    }

    public void findTemplates(Dictionary templates) {
        if (this._default != null) {
            templates.put(this._default, this);
        }
        int i = 0;
        while (i < this._patterns.size()) {
            LocationPathPattern pattern = (LocationPathPattern)this._patterns.elementAt(i);
            templates.put(pattern.getTemplate(), this);
            ++i;
        }
    }

    private InstructionHandle getTemplateHandle(Template template) {
        return this._mode.getTemplateInstructionHandle(template);
    }

    private LocationPathPattern getPattern(int n) {
        return (LocationPathPattern)this._patterns.elementAt(n);
    }

    public InstructionHandle compile(ClassGenerator classGen, MethodGenerator methodGen, InstructionHandle continuation) {
        int count = this._patterns.size();
        if (this._start != null) {
            return this._start;
        }
        if (count == 0) {
            this.getTemplateHandle(this._default);
        }
        InstructionHandle fail = this._default != null ? this.getTemplateHandle(this._default) : continuation;
        int n = count - 1;
        while (n >= 0) {
            LocationPathPattern pattern = this.getPattern(n);
            Template template = pattern.getTemplate();
            InstructionList il = new InstructionList();
            il.append(methodGen.loadCurrentNode());
            il.append(pattern.compile(classGen, methodGen));
            InstructionHandle gtmpl = this.getTemplateHandle(template);
            BranchHandle success = il.append(new GOTO_W(gtmpl));
            pattern.backPatchTrueList(success);
            pattern.backPatchFalseList(fail);
            fail = il.getStart();
            if (this._instructionList != null) {
                il.append(this._instructionList);
            }
            this._instructionList = il;
            --n;
        }
        this._start = fail;
        return this._start;
    }

    public InstructionList getInstructionList() {
        return this._instructionList;
    }
}

