/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.util;

import java.io.PrintStream;

public final class IntegerArray {
    private static final int InitialSize = 32;
    private int[] _array;
    private int _size;
    private int _free = 0;

    public IntegerArray() {
        this(32);
    }

    public IntegerArray(int size) {
        this._size = size;
        this._array = new int[this._size];
    }

    public IntegerArray(int[] array) {
        this(array.length);
        this._free = this._size;
        System.arraycopy(array, 0, this._array, 0, this._free);
    }

    public void clear() {
        this._free = 0;
    }

    public Object clone() {
        return new IntegerArray(this._array);
    }

    public int[] toIntArray() {
        int[] result = new int[this.cardinality()];
        System.arraycopy(this._array, 0, result, 0, this.cardinality());
        return result;
    }

    public final int at(int index) {
        return this._array[index];
    }

    public final void set(int index, int value) {
        this._array[index] = value;
    }

    public int indexOf(int n) {
        int i = 0;
        while (i < this._free) {
            if (n == this._array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final void add(int value) {
        if (this._free == this._size) {
            this.growArray(this._size * 2);
        }
        this._array[this._free++] = value;
    }

    public void addNew(int value) {
        int i = 0;
        while (i < this._free) {
            if (this._array[i] == value) {
                return;
            }
            ++i;
        }
        this.add(value);
    }

    private void growArray(int size) {
        this._size = size;
        int[] newArray = new int[this._size];
        System.arraycopy(this._array, 0, newArray, 0, this._free);
        this._array = newArray;
    }

    public int popLast() {
        return this._array[--this._free];
    }

    public int last() {
        return this._array[this._free - 1];
    }

    public void setLast(int n) {
        this._array[this._free - 1] = n;
    }

    public void pop() {
        --this._free;
    }

    public void pop(int n) {
        this._free -= n;
    }

    public final int cardinality() {
        return this._free;
    }

    public void print(PrintStream out) {
        if (this._free > 0) {
            int i = 0;
            while (i < this._free - 1) {
                out.print(this._array[i]);
                out.print(' ');
                ++i;
            }
            out.println(this._array[this._free - 1]);
        } else {
            out.println("IntegerArray: empty");
        }
    }
}

