/* Generated By:JavaCC: Do not edit this line. SQLParser.java */
package com.mwc.sqld;

import java.io.*;
import java.util.*;

import com.mwc.util.*;
import com.mwc.sqld.db.*;

public class SQLParser implements SQLParserConstants {
   private Stack _operandStack;
   private Stack _operatorStack;
   private UserContext _ctx;

   private class QueryTask implements Runnable {
      private LinkedList _tableList;
      private LinkedList _colList;
      private LinkedList _orderByList;
      private String _resID;
      private Criteria _c;
      private boolean _asc;

      private QueryTask(LinkedList tableList,
                        LinkedList colList,
                        LinkedList orderByList,
                        String resID,
                        Criteria c,
                        boolean asc) {
         _tableList = tableList;
         _colList = colList;
         _orderByList = orderByList;
         _resID = resID;
         _c = c;
         _asc = asc;
      }

      public void run() {
         if(_tableList == null) {
            File temp = _ctx.currentDatabase().getTempFile();
            FileOutputStream fout = null;
            try {
               fout = new FileOutputStream(temp.getAbsolutePath());
               BufferedOutputStream bout = new BufferedOutputStream(fout);
               PrintStream out = new PrintStream(bout);
               StringBuffer buffer = new StringBuffer();
               String cols[][] = new String[_colList.size()][2];
               SQLExpression sqlExpr;
               for(int i = 0; i < _colList.size(); i++) {
                  if(buffer.length() != 0)
                     buffer.append(",");
                  sqlExpr = (SQLExpression)_colList.get(i);
                  cols[i][0] = sqlExpr.as();
                  buffer.append("\""+CSVEncoder.encode(sqlExpr.as()) + "\"");
               }
               out.println(buffer.toString());
               out.flush();
               buffer = new StringBuffer();
               Expression expr2;
               Curser[] data = new Curser[0];
               Object o;
               try {
                  for(int i = 0; i < _colList.size(); i++) {
                     expr2 = (Expression)_colList.get(i);
                     if(buffer.length() != 0)
                        buffer.append(",");
                     o = expr2.eval(data);
                     if(o == null)
                        throw new ParseException("Unable to evaluate expression!");
                     if(o instanceof String)
                        cols[i][1] = "TEXT";
                     else if(o instanceof Integer)
                        cols[i][1] = "INT";
                     else if(o instanceof Boolean)
                        cols[i][1] = "BOOLEAN";
                     else if(o instanceof Double)
                        cols[i][1] = "FLOAT";
                     else
                        throw new ParseException("Unknown result type!");
                     buffer.append("\""+CSVEncoder.encode(o.toString()) + "\"");
                  }
               }
               finally {
                  SQLFunctions.unregisterCurrentThreadUniqueData();
               }
               out.println(buffer.toString());
               out.flush();
               fout.close();
               _ctx.registerResults(_resID, new CSVCurser(temp, cols, 1));
            }
            catch(Throwable e) {
               if(fout != null) {
                  try {
                     fout.close();
                  }
                  catch(IOException ioe2) {
                     ;
                  }
               }
               if(temp != null)
                  temp.delete();
               _ctx.registerResults(_resID, e);
            }
         }
         else {
            Curser rs = null;
            try {
               Curser[] data = new Curser[_tableList.size()];
               Table tbl;
               for(int i = 0; i < data.length; i++) {
                  tbl = _ctx.currentDatabase().getTable(_tableList.get(i).toString());
                  data[i] = tbl.getNewCurser();
               }
               try {
                  rs = _ctx.currentDatabase().select(data, _c, _colList);
               }
               finally {
                  SQLFunctions.unregisterCurrentThreadUniqueData();
                  for(int i = 0; i < data.length; i++)
                     data[i].close();
               }

               if(_orderByList != null) {
                  ValueLookupComparator vlc = new SQLValueLookupComparator(_orderByList, _asc);
                  Sorter sorter = _ctx.currentDatabase().getNewSorter();
                  rs = sorter.sort(rs, vlc);
               }

               _ctx.registerResults(_resID, rs);
               rs = null;
            }
            catch(Throwable th) {
               th.printStackTrace();
               _ctx.registerResults(_resID, th);
            }
            finally {
               if(rs != null)
                  rs.close();
            }
         }
      }
   }

   private Expression _makeExpression(String oneString) {
      Stack operand = new Stack();
      Stack operator = new Stack();
      operand.push(oneString);
      Expression ret = new SQLExpression(operand, operator);
      return ret;
   }

   private String _unSQL(String s) {
      if(s.compareTo("''") == 0)
         return s;
      StringBuffer buffer = new StringBuffer();
      char ch;
      for(int i = 0; i < s.length(); i++) {
         ch = s.charAt(i);
         if((i+1) < s.length()) {
            if(ch == '\'' && s.charAt(i+1) == '\'') {
               i++;
               ch = s.charAt(i);
            }
         }
         buffer.append(ch);
      }
      return buffer.toString();
   }

   public static void parseStatement(String statement, UserContext ctx)
   throws ParseException {
      StringReader sr = new StringReader(statement);
      SQLParser parser = new SQLParser(sr);
      parser._ctx = ctx;
      parser.OneStatement();
   }

/*******************************************************************
 * The PL-SQL grammar starts here
 *******************************************************************/
  final public void SQLAndExpr() throws ParseException {
    SQLNotExpr();

    label_1:
    while (true) {
      if (jj_2_1(2)) {
        ;
      } else {
        break label_1;
      }
      jj_consume_token(AND);
          _operatorStack.push("AND");
      SQLNotExpr();

    }

  }

  final public void SQLBetweenClause() throws ParseException {
    if (jj_2_2(2)) {
      jj_consume_token(NOT);

    } else {
      ;
    }
    jj_consume_token(BETWEEN);

    SQLSumExpr();

    jj_consume_token(AND);

    SQLSumExpr();


  }

  final public void SQLColRef() throws ParseException {
    SQLLvalue();

  }

  final public void SQLCompareExpr() throws ParseException {
    if (jj_2_4(2147483647)) {
      SQLSelect();

    } else if (jj_2_5(2147483647)) {
      SQLIsClause();

    } else if (jj_2_6(2147483647)) {
      SQLExistsClause();

    } else if (jj_2_7(2)) {
      SQLSumExpr();

      if (jj_2_3(2)) {
        SQLCompareExprRight();

      } else {
        ;
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }

  }

  final public void SQLCompareExprRight() throws ParseException {
  String op = null;
    if (jj_2_8(2)) {
      SQLLikeClause();

    } else if (jj_2_9(2)) {
      SQLInClause();

    } else if (jj_2_10(2)) {
      SQLLeftJoinClause();

    } else if (jj_2_11(2147483647)) {
      SQLRightJoinClause();

    } else if (jj_2_12(2)) {
      SQLBetweenClause();

    } else if (jj_2_13(2)) {
      op = SQLCompareOp();
                          _operatorStack.push(op);
      SQLSumExpr();

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }

  }

  final public String SQLCompareOp() throws ParseException {
    if (jj_2_14(2)) {
      jj_consume_token(EQUAL);
                     {if (true) return ("=");}
    } else if (jj_2_15(2)) {
      jj_consume_token(NOTEQUAL);
                     {if (true) return ("<>");}
    } else if (jj_2_16(2)) {
      jj_consume_token(NOTEQUAL2);
                     {if (true) return ("<>");}
    } else if (jj_2_17(2)) {
      jj_consume_token(GREATER);
                     {if (true) return (">");}
    } else if (jj_2_18(2)) {
      jj_consume_token(GREATEREQUAL);
                     {if (true) return (">=");}
    } else if (jj_2_19(2)) {
      jj_consume_token(LESS);
                     {if (true) return ("<");}
    } else if (jj_2_20(2)) {
      jj_consume_token(LESSEQUAL);
                     {if (true) return ("<=");}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

  final public void SQLCursorArgs() throws ParseException {
    jj_consume_token(OPENPAREN);
    if (jj_2_28(2)) {
      if (jj_2_22(2)) {
        SQLColRef();
        if (jj_2_21(2)) {
          SQLDataType();
        } else {
          ;
        }
      } else if (jj_2_23(2)) {
        SQLFunction();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_2:
      while (true) {
        if (jj_2_24(2)) {
          ;
        } else {
          break label_2;
        }
        jj_consume_token(154);
        if (jj_2_26(2)) {
          SQLColRef();
          if (jj_2_25(2)) {
            SQLDataType();
          } else {
            ;
          }
        } else if (jj_2_27(2)) {
          SQLFunction();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
    jj_consume_token(CLOSEPAREN);

  }

  final public void SQLCursorClose() throws ParseException {
  Token cursorName;
    jj_consume_token(CLOSE);
    cursorName = jj_consume_token(ID);


  }

  final public void SQLCursorDeclare() throws ParseException {
 Token x, y;
    jj_consume_token(CURSOR);
    x = jj_consume_token(ID);

    if (jj_2_29(2)) {
      SQLCursorArgs();

    } else {
      ;
    }
    jj_consume_token(IS);
    SQLSelect();
    jj_consume_token(SEMICOLON);

  }

  final public void SQLCursorFetch() throws ParseException {
    jj_consume_token(FETCH);

    SQLSelectCols();

    if (jj_2_30(2)) {
      jj_consume_token(INTO);

      SQLSelectCols();

    } else {
      ;
    }

  }

  final public void SQLCursorOpen() throws ParseException {
  Token cursorName;
    jj_consume_token(OPEN);
    cursorName = jj_consume_token(ID);

    if (jj_2_31(2)) {
      SQLCursorArgs();
    } else {
      ;
    }

  }

  final public String SQLDataType() throws ParseException {
 Token x;
 int size = 0;
    if (jj_2_36(2)) {
      if (jj_2_32(2)) {
        jj_consume_token(INTEGER);
      } else if (jj_2_33(2)) {
        jj_consume_token(INT);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
       {if (true) return "INT";}
    } else if (jj_2_37(2)) {
      jj_consume_token(FLOAT);
              {if (true) return "FLOAT";}
    } else if (jj_2_38(2)) {
      if (jj_2_34(2)) {
        jj_consume_token(CHAR);
      } else if (jj_2_35(2)) {
        jj_consume_token(CHARACTER);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
                             size = 1;
      jj_consume_token(OPENPAREN);
      x = jj_consume_token(INTEGER_LITERAL);
      jj_consume_token(CLOSEPAREN);
                                     size = Integer.valueOf(x.image).intValue();
       {if (true) return "CHAR(" + size + ")";}
    } else if (jj_2_39(2)) {
      jj_consume_token(VARCHAR);
                size = 1;
      jj_consume_token(OPENPAREN);
      x = jj_consume_token(INTEGER_LITERAL);
      jj_consume_token(CLOSEPAREN);
                                     size = Integer.valueOf(x.image).intValue();
       {if (true) return "VARCHAR("+size+")";}
    } else if (jj_2_40(2)) {
      jj_consume_token(TEXT);
             {if (true) return "TEXT";}
    } else if (jj_2_41(2)) {
      jj_consume_token(BOOLEAN);
       {if (true) return "BOOLEAN";}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void SQLDelete() throws ParseException {
  LinkedList tableList = null;
  Criteria c = null;
  _operandStack = new Stack();
  _operatorStack = new Stack();
    jj_consume_token(DELETE);
    jj_consume_token(FROM);

    tableList = SQLTableList();

    if (jj_2_42(2)) {
      SQLWhere();
                 c = new SQLCriteria(_operandStack, _operatorStack);
    } else {
      ;
    }

    jj_consume_token(SEMICOLON);
     Table tbl;
     Iterator it = tableList.iterator();
     UpdateCurser data[] = new UpdateCurser[tableList.size()];
     int index = 0;
     while(it.hasNext()) {
        tbl = _ctx.currentDatabase().getTable((String)it.next());
        try {
           data[index] = (UpdateCurser)tbl.getNewCurser();
        }
        catch(Throwable th) {
           for(int j = 0; j < index; j++)
              data[j].close();
           {if (true) throw new ParseException(th.getMessage());}
        }
        index++;
     }
     try {
        int count;
        try {
           count = _ctx.currentDatabase().delete(data, c);
        }
        finally {
           for(index = 0; index < data.length; index++)
              data[index].close();
        }
        _ctx.out().println("OK");
        _ctx.out().flush();
     }
     catch(DBException dbe) {
        {if (true) throw new ParseException(dbe.getMessage());}
     }
  }

  final public void SQLExistsClause() throws ParseException {
    jj_consume_token(EXISTS);

    jj_consume_token(OPENPAREN);
    SQLSelect();

    jj_consume_token(CLOSEPAREN);

  }

  final public void SQLFunction() throws ParseException {
  Token otherFunction;
  LinkedList argList;
    if (jj_2_43(2)) {
      jj_consume_token(JCALL);
              _operatorStack.push("JCALL");
      argList = SQLFunctionArgs();
                                  _operandStack.push(argList);
    } else if (jj_2_44(2)) {
      jj_consume_token(UPPER);

      SQLFunctionArgs();

    } else if (jj_2_45(2)) {
      jj_consume_token(MAX);
            _operatorStack.push("JCALL");
      argList = SQLFunctionArgs();
            argList.addFirst(_makeExpression("'max'"));
            argList.addFirst(_makeExpression("'java.lang.Math'"));
            _operandStack.push(argList);
    } else if (jj_2_46(2)) {
      jj_consume_token(MIN);
            _operatorStack.push("JCALL");
      argList = SQLFunctionArgs();
            argList.addFirst(_makeExpression("'min'"));
            argList.addFirst(_makeExpression("'java.lang.Math'"));
            _operandStack.push(argList);
    } else if (jj_2_47(2)) {
      jj_consume_token(LEFT);
             _operatorStack.push("JCALL");
      argList = SQLFunctionArgs();
            argList.addFirst(_makeExpression("'left'"));
            argList.addFirst(_makeExpression("'com.mwc.sqld.db.SQLFunctions'"));
            _operandStack.push(argList);
    } else if (jj_2_48(2)) {
      jj_consume_token(RIGHT);
              _operatorStack.push("JCALL");
      argList = SQLFunctionArgs();
            argList.addFirst(_makeExpression("'right'"));
            argList.addFirst(_makeExpression("'com.mwc.sqld.db.SQLFunctions'"));
            _operandStack.push(argList);
    } else if (jj_2_49(2)) {
      jj_consume_token(MID);
            _operatorStack.push("JCALL");
      argList = SQLFunctionArgs();
            argList.addFirst(_makeExpression("'mid'"));
            argList.addFirst(_makeExpression("'com.mwc.sqld.db.SQLFunctions'"));
            _operandStack.push(argList);
    } else if (jj_2_50(2)) {
      jj_consume_token(SUBSTRING);
                  _operatorStack.push("JCALL");
      argList = SQLFunctionArgs();
            argList.addFirst(_makeExpression("'mid'"));
            argList.addFirst(_makeExpression("'com.mwc.sqld.db.SQLFunctions'"));
            _operandStack.push(argList);
    } else if (jj_2_51(2)) {
      jj_consume_token(SOUNDEX);
                _operatorStack.push("JCALL");
      argList = SQLFunctionArgs();
            argList.addFirst(_makeExpression("'soundex'"));
            argList.addFirst(_makeExpression("'com.mwc.sqld.db.SQLFunctions'"));
            _operandStack.push(argList);
    } else if (jj_2_52(2)) {
      jj_consume_token(STR_CONCAT);
                   _operatorStack.push("JCALL");
      argList = SQLFunctionArgs();
            argList.addFirst(_makeExpression("'concat'"));
            argList.addFirst(_makeExpression("'com.mwc.sqld.db.SQLFunctions'"));
            _operandStack.push(argList);
    } else if (jj_2_53(2)) {
      jj_consume_token(UNIQUE);
               _operatorStack.push("JCALL");
      argList = SQLFunctionArgs();
            argList.addFirst(_makeExpression("'unique'"));
            argList.addFirst(_makeExpression("'com.mwc.sqld.db.SQLFunctions'"));
            _operandStack.push(argList);
    } else if (jj_2_54(2)) {
      jj_consume_token(CRYPT);
              _operatorStack.push("JCALL");
      argList = SQLFunctionArgs();
            argList.addFirst(_makeExpression("'crypt'"));
            argList.addFirst(_makeExpression("'com.mwc.sqld.db.SQLFunctions'"));
            _operandStack.push(argList);
    } else if (jj_2_55(2)) {
      jj_consume_token(BASE64);
               _operatorStack.push("JCALL");
      argList = SQLFunctionArgs();
            argList.addFirst(_makeExpression("'base64'"));
            argList.addFirst(_makeExpression("'com.mwc.sqld.db.SQLFunctions'"));
            _operandStack.push(argList);
    } else if (jj_2_56(2)) {
      jj_consume_token(SUM);

      SQLFunctionArgs();

    } else if (jj_2_57(2)) {
      jj_consume_token(COUNT);

      SQLFunctionArgs();

    } else if (jj_2_58(2)) {
      jj_consume_token(LPAD);

      SQLFunctionArgs();

    } else if (jj_2_59(2)) {
      jj_consume_token(LTRIM);

      SQLFunctionArgs();

    } else if (jj_2_60(2)) {
      jj_consume_token(RTRIM);

      SQLFunctionArgs();

    } else if (jj_2_61(2)) {
      jj_consume_token(LENGTH);

      SQLFunctionArgs();

    } else if (jj_2_62(2)) {
      jj_consume_token(REPLACE);

      SQLFunctionArgs();

    } else if (jj_2_63(2)) {
      jj_consume_token(SUBSTR);

      SQLFunctionArgs();

    } else if (jj_2_64(2)) {
      jj_consume_token(TO_CHAR);

      SQLFunctionArgs();

    } else if (jj_2_65(2)) {
      jj_consume_token(TO_NUMBER);

      SQLFunctionArgs();

    } else if (jj_2_66(3)) {
      jj_consume_token(ORIGINPLUS);
      jj_consume_token(DOT);
      jj_consume_token(CONVERT_TIMESTAMP_TO_DATE);

      SQLFunctionArgs();

    } else if (jj_2_67(3)) {
      jj_consume_token(ORIGINPLUS);
      jj_consume_token(DOT);
      jj_consume_token(FORMAT_AUDIT_HEADER);

      SQLFunctionArgs();

    } else if (jj_2_68(3)) {
      jj_consume_token(ORIGINPLUS);
      jj_consume_token(DOT);
      jj_consume_token(FORMAT_ATTRIBUTE_SUBSTRING);

      SQLFunctionArgs();

    } else if (jj_2_69(3)) {
      jj_consume_token(ORIGINPLUS);
      jj_consume_token(DOT);
      jj_consume_token(GET_CURRENT_TIMESTAMP);

    } else if (jj_2_70(2147483647)) {
      otherFunction = jj_consume_token(ID);

      SQLFunctionArgs();

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }

  }

  final public LinkedList SQLFunctionArgs() throws ParseException {
  LinkedList ret = new LinkedList();
  Expression expr;
    jj_consume_token(OPENPAREN);
     Stack oldOperandStack = _operandStack;
     Stack oldOperatorStack = _operatorStack;
     _operandStack = new Stack();
     _operatorStack = new Stack();
    if (jj_2_72(2)) {
      SQLSumExpr();
         expr = new SQLExpression(_operandStack, _operatorStack);
         ret.add(expr);
         _operandStack = new Stack();
         _operatorStack = new Stack();
      label_3:
      while (true) {
        if (jj_2_71(2)) {
          ;
        } else {
          break label_3;
        }
        jj_consume_token(154);

        SQLSumExpr();
            expr = new SQLExpression(_operandStack, _operatorStack);
            ret.add(expr);
            _operandStack = new Stack();
            _operatorStack = new Stack();
      }
    } else {
      ;
    }
    jj_consume_token(CLOSEPAREN);
     _operandStack = oldOperandStack;
     _operatorStack = oldOperatorStack;
     {if (true) return ret;}
    throw new Error("Missing return statement in function");
  }

  final public void SQLGroupBy() throws ParseException {
    jj_consume_token(GROUP);
    jj_consume_token(BY);

    SQLOrderByList();


  }

  final public void SQLInClause() throws ParseException {
    if (jj_2_73(2)) {
      jj_consume_token(NOT);

    } else {
      ;
    }
    jj_consume_token(IN);

    jj_consume_token(OPENPAREN);

    SQLLValueList();

    jj_consume_token(CLOSEPAREN);


  }

  final public void SQLInsert() throws ParseException {
  LinkedList tableList;
  LinkedList colList = null;
  LinkedList valList = new LinkedList();
    jj_consume_token(INSERT);
    jj_consume_token(INTO);

    tableList = SQLTableList();
      Iterator it = tableList.iterator();
      String name;
      while(it.hasNext()) {
         name = it.next().toString();
         if(_ctx.currentDatabase().getTable(name) == null)
            {if (true) throw new ParseException("Table \"" + name + "\" is not defined!");}
      }
    if (jj_2_75(2)) {
      jj_consume_token(OPENPAREN);
          colList = new LinkedList();
          Token x;
      x = jj_consume_token(ID);
             colList.add(x.image);
      label_4:
      while (true) {
        if (jj_2_74(2)) {
          ;
        } else {
          break label_4;
        }
        jj_consume_token(154);

        x = jj_consume_token(ID);
                colList.add(x.image);
      }
      jj_consume_token(CLOSEPAREN);

    } else {
      ;
    }
    jj_consume_token(VALUES);

    jj_consume_token(OPENPAREN);
          String literal;
    literal = SQLLiteral();
      valList.add(_unSQL(literal));
    label_5:
    while (true) {
      if (jj_2_76(2)) {
        ;
      } else {
        break label_5;
      }
      jj_consume_token(154);

      literal = SQLLiteral();
         valList.add(_unSQL(literal));
    }
    jj_consume_token(CLOSEPAREN);

    jj_consume_token(SEMICOLON);
          if(!_ctx.writeAccess())
             {if (true) throw new ParseException("You do not have write access in the current database!");}
          try {
             _ctx.currentDatabase().insert(tableList, colList, valList);
          }
          catch(DBException dbe) {
             {if (true) throw new ParseException(dbe.getMessage());}
          }
   _ctx.out().println("OK");
   _ctx.out().flush();
  }

  final public void SQLIsClause() throws ParseException {
    SQLColRef();

    jj_consume_token(IS);

    if (jj_2_77(2)) {
      jj_consume_token(NOT);

    } else {
      ;
    }
    jj_consume_token(NULL);


  }

  final public void SQLLeftJoinClause() throws ParseException {
  Token theComparison;
    jj_consume_token(JOINPLUS);
    SQLCompareOp();

    SQLSumExpr();


  }

  final public void SQLLikeClause() throws ParseException {
    if (jj_2_78(2)) {
      jj_consume_token(NOT);
            _operatorStack.push("NOT");
    } else {
      ;
    }
    jj_consume_token(LIKE);
           _operatorStack.push("LIKE");
    SQLPattern();


  }

  final public String SQLLiteral() throws ParseException {
 Token x;
    if (jj_2_81(2)) {
      x = jj_consume_token(STRING_LITERAL);

    } else if (jj_2_82(2)) {
      x = jj_consume_token(INTEGER_LITERAL);

    } else if (jj_2_83(2)) {
      x = jj_consume_token(FLOATING_POINT_LITERAL);

    } else if (jj_2_84(2)) {
      if (jj_2_79(2)) {
        x = jj_consume_token(ZEROS);
      } else if (jj_2_80(2)) {
        x = jj_consume_token(ZERO);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }

    } else if (jj_2_85(2)) {
      x = jj_consume_token(SPACES);

    } else if (jj_2_86(2)) {
      x = jj_consume_token(ASTERISK);

    } else if (jj_2_87(2)) {
      x = jj_consume_token(TRUE);

    } else if (jj_2_88(2)) {
      x = jj_consume_token(FALSE);

    } else if (jj_2_89(2)) {
      x = jj_consume_token(NULL);
                 {if (true) return "\'\'";}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return x.image;}
    throw new Error("Missing return statement in function");
  }

  final public void SQLLvalue() throws ParseException {
  Token x, y;
    if (jj_2_90(2)) {
      jj_consume_token(REQUEST);
      jj_consume_token(DOT);

      SQLLvalueTerm();

    } else if (jj_2_91(2)) {
      jj_consume_token(REPLY_REPEATING_GROUP);
      jj_consume_token(DOT);

      SQLLvalueTerm();

    } else if (jj_2_92(2)) {
      jj_consume_token(REPLY);
      jj_consume_token(DOT);

      SQLLvalueTerm();

    } else if (jj_2_93(2)) {
      jj_consume_token(SQL_I_O_CORRECT);

    } else if (jj_2_94(2)) {
      jj_consume_token(ROW_NOT_FOUND);

    } else if (jj_2_95(2)) {
      SQLLvalueTerm();

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }

  }

  final public void SQLLvalueTerm() throws ParseException {
  Token x, y;
    x = jj_consume_token(ID);

    label_6:
    while (true) {
      if (jj_2_96(2)) {
        ;
      } else {
        break label_6;
      }
      jj_consume_token(DOT);
      y = jj_consume_token(ID);

    }

  }

  final public void SQLNotExpr() throws ParseException {
    if (jj_2_97(2)) {
      jj_consume_token(NOT);
   _operatorStack.push("NOT");
    } else {
      ;
    }
    SQLCompareExpr();

  }

  final public void SQLOrderBy() throws ParseException {
    jj_consume_token(ORDER);
    jj_consume_token(BY);

    SQLOrderByList();


  }

  final public void SQLOrderByElem() throws ParseException {
    SQLColRef();

    if (jj_2_98(2)) {
      SQLOrderDirection();

    } else {
      ;
    }

  }

  final public void SQLOrderByList() throws ParseException {
    SQLOrderByElem();

    label_7:
    while (true) {
      if (jj_2_99(2)) {
        ;
      } else {
        break label_7;
      }
      jj_consume_token(154);

      SQLOrderByElem();

    }

  }

  final public void SQLOrderDirection() throws ParseException {
    if (jj_2_100(2)) {
      jj_consume_token(ASC);

    } else if (jj_2_101(2)) {
      jj_consume_token(DESC);

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }

  }

  final public void SQLOrExpr() throws ParseException {
    SQLAndExpr();

    label_8:
    while (true) {
      if (jj_2_102(2)) {
        ;
      } else {
        break label_8;
      }
      jj_consume_token(OR);
             _operatorStack.push("OR");
      SQLAndExpr();

    }

  }

  final public void SQLPattern() throws ParseException {
 Token x;
    if (jj_2_103(2)) {
      x = jj_consume_token(STRING_LITERAL);
                           _operandStack.push(_unSQL(x.image));
    } else if (jj_2_104(2)) {
      jj_consume_token(QUESTIONMARK);

    } else if (jj_2_105(2)) {
      jj_consume_token(USER);

    } else if (jj_2_106(2)) {
      SQLLvalue();

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }

  }

  final public void SQLProductExpr() throws ParseException {
  String op = null;
    SQLUnaryExpr();

    label_9:
    while (true) {
      if (jj_2_107(2)) {
        ;
      } else {
        break label_9;
      }
      if (jj_2_108(2)) {
        jj_consume_token(ASTERISK);
            _operatorStack.push("*");
      } else if (jj_2_109(2)) {
        jj_consume_token(SLASH);
            _operatorStack.push("/");
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      SQLUnaryExpr();

    }

  }

  final public void SQLRightJoinClause() throws ParseException {
  Token theComparison;

    SQLCompareOp();

    SQLSumExpr();

    jj_consume_token(JOINPLUS);

  }

  final public void SQLSelect() throws ParseException {
  LinkedList colList = new LinkedList();
  LinkedList tableList = null;
  _operandStack = new Stack();
  _operatorStack = new Stack();
  Token x = null;
  Criteria c = null;
  Curser data[] = null;
  Table tbl;
  LinkedList orderByList = null;
  boolean asc = true;
  String id;
  boolean star = false;
    jj_consume_token(SELECT);

    if (jj_2_113(2)) {
      jj_consume_token(ASTERISK);
             star = true;
    } else if (jj_2_114(2)) {
      SQLOrExpr();
      if (jj_2_110(2)) {
        jj_consume_token(AS);

        x = jj_consume_token(ID);

      } else {
        ;
      }
             String as;
             if(x == null)
                as = "";
             else
                as = x.image;
             Expression expr = new SQLExpression(_operandStack, _operatorStack, as);
             colList.add(expr);
             _operandStack = new Stack();
             _operatorStack = new Stack();
             x = null;
      label_10:
      while (true) {
        if (jj_2_111(2)) {
          ;
        } else {
          break label_10;
        }
        jj_consume_token(154);

        SQLOrExpr();
        if (jj_2_112(2)) {
          jj_consume_token(AS);

          x = jj_consume_token(ID);

        } else {
          ;
        }
                       if(x == null)
                          as = "";
                       else
                          as = x.image;
                       expr = new SQLExpression(_operandStack, _operatorStack, as);
                       colList.add(expr);
                       _operandStack = new Stack();
                       _operatorStack = new Stack();
                       x = null;
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_115(2)) {
      jj_consume_token(FROM);

      tableList = SQLTableList();
      Iterator it = tableList.iterator();
      String tblName;
      Expression expr;
      String [][]cols;
      while(it.hasNext()) {
         tblName = it.next().toString();
         tbl = _ctx.currentDatabase().getTable(tblName);
         if(tbl == null)
            {if (true) throw new ParseException("Table " + tblName + " is not defined!");}
         if(star) {
            cols = tbl.cols();
            for(int i = 0; i < cols.length; i++) {
                      _operandStack = new Stack();
                      _operatorStack = new Stack();
               _operandStack.push(tblName+"."+cols[i][0]);
                      expr = new SQLExpression(_operandStack, _operatorStack, "");
                      colList.add(expr);
                   }
         }
      }
             _operandStack = new Stack();
             _operatorStack = new Stack();
    } else {
      ;
    }
    if (jj_2_116(2)) {
      SQLWhere();
      c = new SQLCriteria(_operandStack, _operatorStack);
    } else {
      ;
    }
    if (jj_2_117(2)) {
      SQLGroupBy();

    } else {
      ;
    }
    if (jj_2_124(2)) {
      jj_consume_token(ORDER);
                id = "";
      jj_consume_token(BY);
             orderByList = new LinkedList();
      if (jj_2_118(2)) {
        x = jj_consume_token(ID);
                   id = x.image + ".";
        jj_consume_token(DOT);

      } else {
        ;
      }
      x = jj_consume_token(ID);
                 id += x.image;
                 orderByList.add(id);
      label_11:
      while (true) {
        if (jj_2_119(2)) {
          ;
        } else {
          break label_11;
        }
        jj_consume_token(154);
             id = "";
        if (jj_2_120(2)) {
          x = jj_consume_token(ID);
                                     id = x.image + ".";
          jj_consume_token(DOT);

        } else {
          ;
        }
        x = jj_consume_token(ID);
                  id += x.image;
                  orderByList.add(id);
      }

      if (jj_2_123(2)) {
        if (jj_2_121(2)) {
          jj_consume_token(ASC);

        } else if (jj_2_122(2)) {
          jj_consume_token(DESC);
                            asc = false;
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }

    } else {
      ;
    }

    jj_consume_token(SEMICOLON);
          if(!_ctx.readAccess())
             {if (true) throw new ParseException("You do not have read access in the current database!");}
          String resID = _ctx.getNextResultSetID();
          _ctx.out().println("OK");
          _ctx.out().println(resID);
          _ctx.out().flush();
   QueryTask task = new QueryTask(tableList, colList, orderByList, resID, c, asc);
   _ctx.threadPool().postTaskForExecution(task);
  }

  final public void SQLSelectCols() throws ParseException {
    label_12:
    while (true) {
      if (jj_2_125(2)) {
        ;
      } else {
        break label_12;
      }
      if (jj_2_126(2)) {
        jj_consume_token(ALL);

      } else if (jj_2_127(2)) {
        jj_consume_token(DISTINCT);

      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if (jj_2_130(2)) {
      if (jj_2_128(2)) {
        jj_consume_token(ASTERISK);

      } else if (jj_2_129(2)) {
        SQLSelectList();

      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }

  }

  final public void SQLSelectList() throws ParseException {
    SQLSumExpr();

    label_13:
    while (true) {
      if (jj_2_131(2)) {
        ;
      } else {
        break label_13;
      }
      jj_consume_token(154);

      SQLSumExpr();

    }

  }

  final public void OneStatement() throws ParseException {
    SQLStatement();
    jj_consume_token(0);

  }

  final public void SQLStatement() throws ParseException {
  Token x;
    if (jj_2_132(2)) {
      SQLCreateTable();

    } else if (jj_2_133(2)) {
      SQLSelect();

    } else if (jj_2_134(2)) {
      SQLInsert();

    } else if (jj_2_135(2)) {
      SQLUpdate();

    } else if (jj_2_136(2)) {
      SQLDelete();

    } else if (jj_2_137(2)) {
      SQLCursorOpen();

    } else if (jj_2_138(2)) {
      SQLCursorFetch();

    } else if (jj_2_139(2)) {
      SQLCursorClose();

    } else if (jj_2_140(2)) {
      jj_consume_token(EXIT);

      jj_consume_token(SEMICOLON);
               _ctx.exit();
    } else if (jj_2_141(2)) {
      jj_consume_token(SET);

      jj_consume_token(CURRENT);

      jj_consume_token(DATABASE);

      x = jj_consume_token(ID);

      jj_consume_token(SEMICOLON);
      Database db = _ctx.currentDatabase();
      if(db != null) {
         db.sync();
         if(db.modified())
            db.save();
      }
      if(!_ctx.changeCurrentDatabase(x.image.toLowerCase()))
         {if (true) throw new ParseException("Unable to change current database to: " + x.image);}
      _ctx.out().println("OK");
      _ctx.out().flush();
    } else if (jj_2_142(2)) {
      jj_consume_token(GET);

      jj_consume_token(RESULTS);

      x = jj_consume_token(ID);

      jj_consume_token(SEMICOLON);
       Object ref = _ctx.acquireResults(x.image);
       if(ref == null)
         {if (true) throw new ParseException("No results!");}
       if(ref instanceof Exception)
         {if (true) throw new ParseException(((Exception)ref).getMessage());}
       Curser curser = (Curser)ref;
       try {
         String cols[][] = curser.cols();
         StringBuffer buffer = new StringBuffer();
         for(int i = 0; i < cols.length; i++) {
            if(buffer.length() != 0)
               buffer.append(",");
            buffer.append("\""+CSVEncoder.encode(cols[i][0])+"\"");
         }
         _ctx.out().println("OK");
         _ctx.out().println(buffer.toString());
         _ctx.out().flush();
         buffer = new StringBuffer();
         for(int i = 0; i < cols.length; i++) {
            if(buffer.length() != 0)
               buffer.append(",");
            buffer.append("\""+CSVEncoder.encode(cols[i][1])+"\"");
         }
         _ctx.out().println(buffer.toString());
         _ctx.out().flush();
         String line;
         L1: while(true) {
            while(curser.next()) {
              line = _ctx.readLine();
              if(line == null)
                 break L1;
              line = line.trim();
              if(line.equalsIgnoreCase("next;")) {
                 _ctx.out().println("OK");
                 _ctx.out().flush();
              }
              else if(line.equalsIgnoreCase("close;"))
                 break L1;
              else if(line.equalsIgnoreCase("reset;")) {
                 _ctx.out().println("OK");
                 _ctx.out().flush();
                 curser.reset();
                 continue;
              }
              else
                 {if (true) throw new ParseException("Bad curser command!");}
              buffer = new StringBuffer();
              for(int i = 0; i < curser.size(); i++) {
                 if(buffer.length() != 0)
                    buffer.append(",");
                 buffer.append("\""+CSVEncoder.encode(curser.getValue(i))+"\"");
              }
              _ctx.out().println(buffer.toString());
              _ctx.out().flush();
            }
            L2: while(true) {
               line = _ctx.readLine();
               if(line == null)
                  break L1;
               line = line.trim();
               if(line.equalsIgnoreCase("next;"))
                  ;
               else if(line.equalsIgnoreCase("close;"))
                  break L1;
               else if(line.equalsIgnoreCase("reset;")) {
                  _ctx.out().println("OK");
                  _ctx.out().flush();
                  break L2;
               }
               else
                  {if (true) throw new ParseException("Bad curser command!");}
               _ctx.out().println("END");
               _ctx.out().flush();
            }
            curser.reset();
         }
       }
       finally {
         curser.close();
       }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void SQLCreateTable() throws ParseException {
 Token tableName;
 LinkedList names = new LinkedList();
 LinkedList types = new LinkedList();
 LinkedList nns = new LinkedList();
 Token x;
 String t;
    jj_consume_token(CREATE);

    jj_consume_token(TABLE);

    tableName = jj_consume_token(ID);
                      Table tbl = _ctx.currentDatabase().getTable(tableName.image);
                      if(tbl != null)
                        {if (true) throw new ParseException("Table \"" + tableName.image + "\" has is alread been defined!");}
    jj_consume_token(OPENPAREN);

    if (jj_2_146(2)) {
      x = jj_consume_token(ID);
                       names.add(x.image);
      t = SQLDataType();
                                types.add(t);
      if (jj_2_143(2)) {
        jj_consume_token(NOT);

        jj_consume_token(NULL);
                 nns.add("true");
      } else {
        ;
      }
               if(nns.size() != names.size())
                  nns.add("false");
      label_14:
      while (true) {
        if (jj_2_144(2)) {
          ;
        } else {
          break label_14;
        }
        jj_consume_token(154);

        x = jj_consume_token(ID);
                          names.add(x.image);
        t = SQLDataType();
                                   types.add(t);
        if (jj_2_145(2)) {
          jj_consume_token(NOT);

          jj_consume_token(NULL);
                    nns.add("true");
        } else {
          ;
        }
                  if(nns.size() != names.size())
                     nns.add("false");
      }
    } else {
      ;
    }
    jj_consume_token(CLOSEPAREN);

    jj_consume_token(SEMICOLON);
             if(!_ctx.writeAccess())
                {if (true) throw new ParseException("You do not have write access in the current database!");}
      String cols[][] = new String[names.size()][3];
      Iterator it = names.iterator();
      Iterator it2 = types.iterator();
      Iterator it3 = nns.iterator();
      for(int i = 0; i < cols.length; i++) {
         cols[i][0] = it.next().toString();
         cols[i][1] = it2.next().toString();
         cols[i][2] = it3.next().toString();
      }
      if(_ctx.currentDatabase().createTable(tableName.image, cols) == null)
         {if (true) throw new ParseException("Unable to create table: " + tableName.image);}
      _ctx.out().println("OK");
      _ctx.out().flush();
  }

  final public void SQLSumExpr() throws ParseException {
  String op = null;
    SQLProductExpr();

    label_15:
    while (true) {
      if (jj_2_147(2)) {
        ;
      } else {
        break label_15;
      }
      if (jj_2_148(2)) {
        jj_consume_token(PLUS);
                            _operatorStack.push("+");
      } else if (jj_2_149(2)) {
        jj_consume_token(MINUS);
                            _operatorStack.push("-");
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      SQLProductExpr();

    }

  }

  final public LinkedList SQLTableList() throws ParseException {
   String name;
   LinkedList list = new LinkedList();
    name = SQLTableRef();
                         list.add(name);
    label_16:
    while (true) {
      if (jj_2_150(2)) {
        ;
      } else {
        break label_16;
      }
      jj_consume_token(154);

      name = SQLTableRef();
                           list.add(name);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public String SQLTableRef() throws ParseException {
 Token tableName, aliasName;
    tableName = jj_consume_token(ID);

    if (jj_2_151(2)) {
      aliasName = jj_consume_token(ID);

    } else {
      ;
    }
      {if (true) return tableName.image;}
    throw new Error("Missing return statement in function");
  }

  final public void SQLTerm() throws ParseException {
  Token other;
  String val;
  Token x;
  String id;
    if (jj_2_153(2)) {
      jj_consume_token(OPENPAREN);
            _operatorStack.push("(");
      SQLOrExpr();

      jj_consume_token(CLOSEPAREN);
            _operatorStack.push(")");
    } else if (jj_2_154(2)) {
      x = jj_consume_token(ID);
          id = x.image;
      if (jj_2_152(2)) {
        jj_consume_token(DOT);

        x = jj_consume_token(ID);
            id += "." + x.image;
      } else {
        ;
      }
         _operandStack.push(id);
    } else if (jj_2_155(2)) {
      val = SQLLiteral();
     if((val.length() > 0) && (val.charAt(0) == '\'')) {
        _operandStack.push(_unSQL(val));
     }
     else {
        try {
           _operandStack.push(new Integer(val));
        }
        catch(NumberFormatException nfe) {
           try {
              _operandStack.push(new Double(val));
           }
           catch(NumberFormatException nfe2) {
              if(val.equalsIgnoreCase("true") || val.equalsIgnoreCase("false"))
                 _operandStack.push(new Boolean(val));
              else
                 {if (true) throw new ParseException("Bad literal");}
           }
        }
     }
    } else if (jj_2_156(2)) {
      SQLFunction();

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }

  }

  final public void SQLUnaryExpr() throws ParseException {
  String op = null;
    if (jj_2_159(2)) {
      if (jj_2_157(2)) {
        jj_consume_token(PLUS);
            op = "u+";
      } else if (jj_2_158(2)) {
        jj_consume_token(MINUS);
            op = "u-";
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    SQLTerm();
                if(op != null) _operatorStack.push(op);

  }

  final public void SQLUpdate() throws ParseException {
  LinkedList tableListName = null;
  LinkedList tableList = null;
  LinkedList setList = null;
  String columnName = null;
  String tableName = null;
  Expression expr = null;
  SQLCriteria where = null;
  Token x;
    jj_consume_token(UPDATE);
           if(_ctx.currentDatabase() == null)
              {if (true) throw new ParseException("No current database!");}
    tableListName = SQLTableList();
     Table tbl;
     Iterator iterator = tableListName.iterator();
     tableList = new LinkedList();
     while(iterator.hasNext()) {
        tableName = (String)iterator.next();
        tbl = _ctx.currentDatabase().getTable(tableName);
        if(tbl == null)
           {if (true) throw new ParseException("Table name \"" + tableName + "\" not found in "
                                    + "database \"" + _ctx.currentDatabase().name() + "\"!");}
        tableList.add(tbl);
     }
     tableName = null;
    jj_consume_token(SET);
           setList = new LinkedList();
    if (jj_2_160(2)) {
      x = jj_consume_token(ID);
            tableName = x.image;
      jj_consume_token(DOT);

    } else {
      ;
    }
    x = jj_consume_token(ID);
         columnName = x.image;
         if(tableName != null)
            columnName = tableName + "." + columnName;
    jj_consume_token(EQUAL);

    expr = SQLUpdateAssignment();
        setList.add(new Object[]{columnName, expr});
        tableName = columnName = null;
    if (jj_2_163(2)) {
      label_17:
      while (true) {
        jj_consume_token(154);

        if (jj_2_161(2)) {
          x = jj_consume_token(ID);
             tableName = x.image;
          jj_consume_token(DOT);

        } else {
          ;
        }
        x = jj_consume_token(ID);
          columnName = x.image;
          if(tableName != null)
             columnName = tableName + "." + columnName;
        jj_consume_token(EQUAL);

        expr = SQLUpdateAssignment();
         setList.add(new Object[]{columnName, expr});
         tableName = columnName = null;
        if (jj_2_162(2)) {
          ;
        } else {
          break label_17;
        }
      }
    } else {
      ;
    }
     _operandStack = new Stack();
     _operatorStack = new Stack();
    if (jj_2_164(2)) {
      SQLWhere();
         where = new SQLCriteria(_operandStack, _operatorStack);
         _operandStack = _operatorStack = null;
    } else {
      ;
    }

    jj_consume_token(SEMICOLON);
      UpdateCurser data[] = new UpdateCurser[tableList.size()];
      Iterator it = tableList.iterator();
      int i = 0;
      try {
         while(it.hasNext()) {
            tbl = (Table)it.next();
            try {
               data[i] = (UpdateCurser)tbl.getNewCurser();
            }
            catch(Throwable th) {
               {if (true) throw new ParseException(th.getMessage());}
            }
            i++;
         }
         try {
            int n = _ctx.currentDatabase().update(data, setList, where);
         }
         catch(DBException dbe) {
dbe.printStackTrace();
            {if (true) throw new ParseException(dbe.getMessage());}
         }
         _ctx.out().println("OK");
         _ctx.out().flush();
      }
      finally {
         for(i = 0; i < data.length; i++)
            data[i].close();
      }
  }

  final public Expression SQLUpdateAssignment() throws ParseException {
  _operandStack = new Stack();
  _operatorStack = new Stack();
    if (jj_2_165(2)) {
      SQLTerm();

    } else if (jj_2_166(2)) {
      SQLSumExpr();

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return new SQLExpression(_operandStack, _operatorStack);}
    throw new Error("Missing return statement in function");
  }

  final public void SQLLValueElement() throws ParseException {
    if (jj_2_167(2)) {
      jj_consume_token(NULL);

    } else if (jj_2_168(2)) {
      SQLSumExpr();

    } else if (jj_2_169(2)) {
      SQLSelect();

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }

  }

  final public void SQLLValueList() throws ParseException {
    SQLLValueElement();

    label_18:
    while (true) {
      if (jj_2_170(2)) {
        ;
      } else {
        break label_18;
      }
      jj_consume_token(154);

      SQLLValueElement();

    }

  }

  final public void SQLWhere() throws ParseException {
    jj_consume_token(WHERE);

    SQLOrExpr();

  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_3();
    jj_save(2, xla);
    return retval;
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_4();
    jj_save(3, xla);
    return retval;
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_5();
    jj_save(4, xla);
    return retval;
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_6();
    jj_save(5, xla);
    return retval;
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_7();
    jj_save(6, xla);
    return retval;
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_8();
    jj_save(7, xla);
    return retval;
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_9();
    jj_save(8, xla);
    return retval;
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_10();
    jj_save(9, xla);
    return retval;
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_11();
    jj_save(10, xla);
    return retval;
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_12();
    jj_save(11, xla);
    return retval;
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_13();
    jj_save(12, xla);
    return retval;
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_14();
    jj_save(13, xla);
    return retval;
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_15();
    jj_save(14, xla);
    return retval;
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_16();
    jj_save(15, xla);
    return retval;
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_17();
    jj_save(16, xla);
    return retval;
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_18();
    jj_save(17, xla);
    return retval;
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_19();
    jj_save(18, xla);
    return retval;
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_20();
    jj_save(19, xla);
    return retval;
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_21();
    jj_save(20, xla);
    return retval;
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_22();
    jj_save(21, xla);
    return retval;
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_23();
    jj_save(22, xla);
    return retval;
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_24();
    jj_save(23, xla);
    return retval;
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_25();
    jj_save(24, xla);
    return retval;
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_26();
    jj_save(25, xla);
    return retval;
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_27();
    jj_save(26, xla);
    return retval;
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_28();
    jj_save(27, xla);
    return retval;
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_29();
    jj_save(28, xla);
    return retval;
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_30();
    jj_save(29, xla);
    return retval;
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_31();
    jj_save(30, xla);
    return retval;
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_32();
    jj_save(31, xla);
    return retval;
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_33();
    jj_save(32, xla);
    return retval;
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_34();
    jj_save(33, xla);
    return retval;
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_35();
    jj_save(34, xla);
    return retval;
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_36();
    jj_save(35, xla);
    return retval;
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_37();
    jj_save(36, xla);
    return retval;
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_38();
    jj_save(37, xla);
    return retval;
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_39();
    jj_save(38, xla);
    return retval;
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_40();
    jj_save(39, xla);
    return retval;
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_41();
    jj_save(40, xla);
    return retval;
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_42();
    jj_save(41, xla);
    return retval;
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_43();
    jj_save(42, xla);
    return retval;
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_44();
    jj_save(43, xla);
    return retval;
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_45();
    jj_save(44, xla);
    return retval;
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_46();
    jj_save(45, xla);
    return retval;
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_47();
    jj_save(46, xla);
    return retval;
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_48();
    jj_save(47, xla);
    return retval;
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_49();
    jj_save(48, xla);
    return retval;
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_50();
    jj_save(49, xla);
    return retval;
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_51();
    jj_save(50, xla);
    return retval;
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_52();
    jj_save(51, xla);
    return retval;
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_53();
    jj_save(52, xla);
    return retval;
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_54();
    jj_save(53, xla);
    return retval;
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_55();
    jj_save(54, xla);
    return retval;
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_56();
    jj_save(55, xla);
    return retval;
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_57();
    jj_save(56, xla);
    return retval;
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_58();
    jj_save(57, xla);
    return retval;
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_59();
    jj_save(58, xla);
    return retval;
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_60();
    jj_save(59, xla);
    return retval;
  }

  final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_61();
    jj_save(60, xla);
    return retval;
  }

  final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_62();
    jj_save(61, xla);
    return retval;
  }

  final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_63();
    jj_save(62, xla);
    return retval;
  }

  final private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_64();
    jj_save(63, xla);
    return retval;
  }

  final private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_65();
    jj_save(64, xla);
    return retval;
  }

  final private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_66();
    jj_save(65, xla);
    return retval;
  }

  final private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_67();
    jj_save(66, xla);
    return retval;
  }

  final private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_68();
    jj_save(67, xla);
    return retval;
  }

  final private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_69();
    jj_save(68, xla);
    return retval;
  }

  final private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_70();
    jj_save(69, xla);
    return retval;
  }

  final private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_71();
    jj_save(70, xla);
    return retval;
  }

  final private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_72();
    jj_save(71, xla);
    return retval;
  }

  final private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_73();
    jj_save(72, xla);
    return retval;
  }

  final private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_74();
    jj_save(73, xla);
    return retval;
  }

  final private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_75();
    jj_save(74, xla);
    return retval;
  }

  final private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_76();
    jj_save(75, xla);
    return retval;
  }

  final private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_77();
    jj_save(76, xla);
    return retval;
  }

  final private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_78();
    jj_save(77, xla);
    return retval;
  }

  final private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_79();
    jj_save(78, xla);
    return retval;
  }

  final private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_80();
    jj_save(79, xla);
    return retval;
  }

  final private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_81();
    jj_save(80, xla);
    return retval;
  }

  final private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_82();
    jj_save(81, xla);
    return retval;
  }

  final private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_83();
    jj_save(82, xla);
    return retval;
  }

  final private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_84();
    jj_save(83, xla);
    return retval;
  }

  final private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_85();
    jj_save(84, xla);
    return retval;
  }

  final private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_86();
    jj_save(85, xla);
    return retval;
  }

  final private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_87();
    jj_save(86, xla);
    return retval;
  }

  final private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_88();
    jj_save(87, xla);
    return retval;
  }

  final private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_89();
    jj_save(88, xla);
    return retval;
  }

  final private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_90();
    jj_save(89, xla);
    return retval;
  }

  final private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_91();
    jj_save(90, xla);
    return retval;
  }

  final private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_92();
    jj_save(91, xla);
    return retval;
  }

  final private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_93();
    jj_save(92, xla);
    return retval;
  }

  final private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_94();
    jj_save(93, xla);
    return retval;
  }

  final private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_95();
    jj_save(94, xla);
    return retval;
  }

  final private boolean jj_2_96(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_96();
    jj_save(95, xla);
    return retval;
  }

  final private boolean jj_2_97(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_97();
    jj_save(96, xla);
    return retval;
  }

  final private boolean jj_2_98(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_98();
    jj_save(97, xla);
    return retval;
  }

  final private boolean jj_2_99(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_99();
    jj_save(98, xla);
    return retval;
  }

  final private boolean jj_2_100(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_100();
    jj_save(99, xla);
    return retval;
  }

  final private boolean jj_2_101(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_101();
    jj_save(100, xla);
    return retval;
  }

  final private boolean jj_2_102(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_102();
    jj_save(101, xla);
    return retval;
  }

  final private boolean jj_2_103(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_103();
    jj_save(102, xla);
    return retval;
  }

  final private boolean jj_2_104(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_104();
    jj_save(103, xla);
    return retval;
  }

  final private boolean jj_2_105(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_105();
    jj_save(104, xla);
    return retval;
  }

  final private boolean jj_2_106(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_106();
    jj_save(105, xla);
    return retval;
  }

  final private boolean jj_2_107(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_107();
    jj_save(106, xla);
    return retval;
  }

  final private boolean jj_2_108(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_108();
    jj_save(107, xla);
    return retval;
  }

  final private boolean jj_2_109(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_109();
    jj_save(108, xla);
    return retval;
  }

  final private boolean jj_2_110(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_110();
    jj_save(109, xla);
    return retval;
  }

  final private boolean jj_2_111(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_111();
    jj_save(110, xla);
    return retval;
  }

  final private boolean jj_2_112(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_112();
    jj_save(111, xla);
    return retval;
  }

  final private boolean jj_2_113(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_113();
    jj_save(112, xla);
    return retval;
  }

  final private boolean jj_2_114(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_114();
    jj_save(113, xla);
    return retval;
  }

  final private boolean jj_2_115(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_115();
    jj_save(114, xla);
    return retval;
  }

  final private boolean jj_2_116(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_116();
    jj_save(115, xla);
    return retval;
  }

  final private boolean jj_2_117(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_117();
    jj_save(116, xla);
    return retval;
  }

  final private boolean jj_2_118(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_118();
    jj_save(117, xla);
    return retval;
  }

  final private boolean jj_2_119(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_119();
    jj_save(118, xla);
    return retval;
  }

  final private boolean jj_2_120(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_120();
    jj_save(119, xla);
    return retval;
  }

  final private boolean jj_2_121(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_121();
    jj_save(120, xla);
    return retval;
  }

  final private boolean jj_2_122(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_122();
    jj_save(121, xla);
    return retval;
  }

  final private boolean jj_2_123(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_123();
    jj_save(122, xla);
    return retval;
  }

  final private boolean jj_2_124(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_124();
    jj_save(123, xla);
    return retval;
  }

  final private boolean jj_2_125(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_125();
    jj_save(124, xla);
    return retval;
  }

  final private boolean jj_2_126(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_126();
    jj_save(125, xla);
    return retval;
  }

  final private boolean jj_2_127(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_127();
    jj_save(126, xla);
    return retval;
  }

  final private boolean jj_2_128(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_128();
    jj_save(127, xla);
    return retval;
  }

  final private boolean jj_2_129(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_129();
    jj_save(128, xla);
    return retval;
  }

  final private boolean jj_2_130(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_130();
    jj_save(129, xla);
    return retval;
  }

  final private boolean jj_2_131(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_131();
    jj_save(130, xla);
    return retval;
  }

  final private boolean jj_2_132(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_132();
    jj_save(131, xla);
    return retval;
  }

  final private boolean jj_2_133(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_133();
    jj_save(132, xla);
    return retval;
  }

  final private boolean jj_2_134(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_134();
    jj_save(133, xla);
    return retval;
  }

  final private boolean jj_2_135(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_135();
    jj_save(134, xla);
    return retval;
  }

  final private boolean jj_2_136(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_136();
    jj_save(135, xla);
    return retval;
  }

  final private boolean jj_2_137(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_137();
    jj_save(136, xla);
    return retval;
  }

  final private boolean jj_2_138(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_138();
    jj_save(137, xla);
    return retval;
  }

  final private boolean jj_2_139(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_139();
    jj_save(138, xla);
    return retval;
  }

  final private boolean jj_2_140(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_140();
    jj_save(139, xla);
    return retval;
  }

  final private boolean jj_2_141(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_141();
    jj_save(140, xla);
    return retval;
  }

  final private boolean jj_2_142(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_142();
    jj_save(141, xla);
    return retval;
  }

  final private boolean jj_2_143(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_143();
    jj_save(142, xla);
    return retval;
  }

  final private boolean jj_2_144(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_144();
    jj_save(143, xla);
    return retval;
  }

  final private boolean jj_2_145(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_145();
    jj_save(144, xla);
    return retval;
  }

  final private boolean jj_2_146(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_146();
    jj_save(145, xla);
    return retval;
  }

  final private boolean jj_2_147(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_147();
    jj_save(146, xla);
    return retval;
  }

  final private boolean jj_2_148(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_148();
    jj_save(147, xla);
    return retval;
  }

  final private boolean jj_2_149(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_149();
    jj_save(148, xla);
    return retval;
  }

  final private boolean jj_2_150(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_150();
    jj_save(149, xla);
    return retval;
  }

  final private boolean jj_2_151(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_151();
    jj_save(150, xla);
    return retval;
  }

  final private boolean jj_2_152(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_152();
    jj_save(151, xla);
    return retval;
  }

  final private boolean jj_2_153(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_153();
    jj_save(152, xla);
    return retval;
  }

  final private boolean jj_2_154(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_154();
    jj_save(153, xla);
    return retval;
  }

  final private boolean jj_2_155(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_155();
    jj_save(154, xla);
    return retval;
  }

  final private boolean jj_2_156(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_156();
    jj_save(155, xla);
    return retval;
  }

  final private boolean jj_2_157(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_157();
    jj_save(156, xla);
    return retval;
  }

  final private boolean jj_2_158(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_158();
    jj_save(157, xla);
    return retval;
  }

  final private boolean jj_2_159(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_159();
    jj_save(158, xla);
    return retval;
  }

  final private boolean jj_2_160(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_160();
    jj_save(159, xla);
    return retval;
  }

  final private boolean jj_2_161(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_161();
    jj_save(160, xla);
    return retval;
  }

  final private boolean jj_2_162(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_162();
    jj_save(161, xla);
    return retval;
  }

  final private boolean jj_2_163(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_163();
    jj_save(162, xla);
    return retval;
  }

  final private boolean jj_2_164(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_164();
    jj_save(163, xla);
    return retval;
  }

  final private boolean jj_2_165(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_165();
    jj_save(164, xla);
    return retval;
  }

  final private boolean jj_2_166(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_166();
    jj_save(165, xla);
    return retval;
  }

  final private boolean jj_2_167(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_167();
    jj_save(166, xla);
    return retval;
  }

  final private boolean jj_2_168(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_168();
    jj_save(167, xla);
    return retval;
  }

  final private boolean jj_2_169(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_169();
    jj_save(168, xla);
    return retval;
  }

  final private boolean jj_2_170(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_170();
    jj_save(169, xla);
    return retval;
  }

  final private boolean jj_3_116() {
    if (jj_3R_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_71() {
    if (jj_scan_token(154)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_72() {
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_71()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_112() {
    if (jj_scan_token(AS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_70() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_72()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CLOSEPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_scan_token(UPDATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_115() {
    if (jj_scan_token(FROM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_111() {
    if (jj_scan_token(154)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_42()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_112()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_69() {
    if (jj_scan_token(ORIGINPLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GET_CURRENT_TIMESTAMP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_68() {
    if (jj_scan_token(ORIGINPLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(FORMAT_ATTRIBUTE_SUBSTRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_158() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_157() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_67() {
    if (jj_scan_token(ORIGINPLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(FORMAT_AUDIT_HEADER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_159() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_157()) {
    jj_scanpos = xsp;
    if (jj_3_158()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_66() {
    if (jj_scan_token(ORIGINPLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CONVERT_TIMESTAMP_TO_DATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_110() {
    if (jj_scan_token(AS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_41() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_159()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_55()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_65() {
    if (jj_scan_token(TO_NUMBER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_64() {
    if (jj_scan_token(TO_CHAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_63() {
    if (jj_scan_token(SUBSTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_62() {
    if (jj_scan_token(REPLACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_156() {
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_61() {
    if (jj_scan_token(LENGTH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_60() {
    if (jj_scan_token(RTRIM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_59() {
    if (jj_scan_token(LTRIM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_58() {
    if (jj_scan_token(LPAD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_114() {
    if (jj_3R_42()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_110()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_111()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_57() {
    if (jj_scan_token(COUNT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_56() {
    if (jj_scan_token(SUM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_113() {
    if (jj_scan_token(ASTERISK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_55() {
    if (jj_scan_token(BASE64)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_scan_token(SELECT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_113()) {
    jj_scanpos = xsp;
    if (jj_3_114()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_115()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_116()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_117()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_124()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_54() {
    if (jj_scan_token(CRYPT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_155() {
    if (jj_3R_35()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_53() {
    if (jj_scan_token(UNIQUE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_152() {
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_52() {
    if (jj_scan_token(STR_CONCAT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_51() {
    if (jj_scan_token(SOUNDEX)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_154() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_152()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_3R_27()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(JOINPLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_50() {
    if (jj_scan_token(SUBSTRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_153() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_42()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CLOSEPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_109() {
    if (jj_scan_token(SLASH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_49() {
    if (jj_scan_token(MID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_108() {
    if (jj_scan_token(ASTERISK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_153()) {
    jj_scanpos = xsp;
    if (jj_3_154()) {
    jj_scanpos = xsp;
    if (jj_3_155()) {
    jj_scanpos = xsp;
    if (jj_3_156()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_107() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_108()) {
    jj_scanpos = xsp;
    if (jj_3_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_41()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_41()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_107()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_48() {
    if (jj_scan_token(RIGHT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_47() {
    if (jj_scan_token(LEFT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_106() {
    if (jj_3R_40()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_105() {
    if (jj_scan_token(USER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_104() {
    if (jj_scan_token(QUESTIONMARK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_103() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_scan_token(MIN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_103()) {
    jj_scanpos = xsp;
    if (jj_3_104()) {
    jj_scanpos = xsp;
    if (jj_3_105()) {
    jj_scanpos = xsp;
    if (jj_3_106()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_151() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_scan_token(MAX)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_151()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_149() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_scan_token(UPPER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_148() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_scan_token(JCALL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3_44()) {
    jj_scanpos = xsp;
    if (jj_3_45()) {
    jj_scanpos = xsp;
    if (jj_3_46()) {
    jj_scanpos = xsp;
    if (jj_3_47()) {
    jj_scanpos = xsp;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3_50()) {
    jj_scanpos = xsp;
    if (jj_3_51()) {
    jj_scanpos = xsp;
    if (jj_3_52()) {
    jj_scanpos = xsp;
    if (jj_3_53()) {
    jj_scanpos = xsp;
    if (jj_3_54()) {
    jj_scanpos = xsp;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3_56()) {
    jj_scanpos = xsp;
    if (jj_3_57()) {
    jj_scanpos = xsp;
    if (jj_3_58()) {
    jj_scanpos = xsp;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3_60()) {
    jj_scanpos = xsp;
    if (jj_3_61()) {
    jj_scanpos = xsp;
    if (jj_3_62()) {
    jj_scanpos = xsp;
    if (jj_3_63()) {
    jj_scanpos = xsp;
    if (jj_3_64()) {
    jj_scanpos = xsp;
    if (jj_3_65()) {
    jj_scanpos = xsp;
    if (jj_3_66()) {
    jj_scanpos = xsp;
    if (jj_3_67()) {
    jj_scanpos = xsp;
    if (jj_3_68()) {
    jj_scanpos = xsp;
    if (jj_3_69()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_102() {
    if (jj_scan_token(OR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_150() {
    if (jj_scan_token(154)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_54()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_102()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_3R_54()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_150()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_101() {
    if (jj_scan_token(DESC)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_100() {
    if (jj_scan_token(ASC)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_147() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_148()) {
    jj_scanpos = xsp;
    if (jj_3_149()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(EXISTS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CLOSEPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_37() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_100()) {
    jj_scanpos = xsp;
    if (jj_3_101()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_147()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_99() {
    if (jj_scan_token(154)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_38()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_3R_38()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_99()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_98() {
    if (jj_3R_37()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_98()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_145() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NULL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_144() {
    if (jj_scan_token(154)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_97() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_3R_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_97()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_57()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_143() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NULL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_146() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_29()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_scan_token(DELETE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(FROM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_96() {
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_scan_token(CHARACTER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_96()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_scan_token(INT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_scan_token(BOOLEAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_scan_token(TEXT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_39() {
    if (jj_scan_token(VARCHAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_scan_token(CHAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TABLE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3_35()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_scan_token(FLOAT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_95() {
    if (jj_3R_36()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_scan_token(INTEGER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_29() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_36()) {
    jj_scanpos = xsp;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3_40()) {
    jj_scanpos = xsp;
    if (jj_3_41()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_36() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_94() {
    if (jj_scan_token(ROW_NOT_FOUND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_93() {
    if (jj_scan_token(SQL_I_O_CORRECT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_3R_31()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_92() {
    if (jj_scan_token(REPLY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_36()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_91() {
    if (jj_scan_token(REPLY_REPEATING_GROUP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_36()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_80() {
    if (jj_scan_token(ZERO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_90() {
    if (jj_scan_token(REQUEST)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_36()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_40() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_90()) {
    jj_scanpos = xsp;
    if (jj_3_91()) {
    jj_scanpos = xsp;
    if (jj_3_92()) {
    jj_scanpos = xsp;
    if (jj_3_93()) {
    jj_scanpos = xsp;
    if (jj_3_94()) {
    jj_scanpos = xsp;
    if (jj_3_95()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_scan_token(INTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_32()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_89() {
    if (jj_scan_token(NULL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_scan_token(FETCH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_32()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_30()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_88() {
    if (jj_scan_token(FALSE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_87() {
    if (jj_scan_token(TRUE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_86() {
    if (jj_scan_token(ASTERISK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_79() {
    if (jj_scan_token(ZEROS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_85() {
    if (jj_scan_token(SPACES)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_84() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_79()) {
    jj_scanpos = xsp;
    if (jj_3_80()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_83() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_82() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(WHERE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_42()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_81() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_3R_29()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_3R_31()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_35() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_81()) {
    jj_scanpos = xsp;
    if (jj_3_82()) {
    jj_scanpos = xsp;
    if (jj_3_83()) {
    jj_scanpos = xsp;
    if (jj_3_84()) {
    jj_scanpos = xsp;
    if (jj_3_85()) {
    jj_scanpos = xsp;
    if (jj_3_86()) {
    jj_scanpos = xsp;
    if (jj_3_87()) {
    jj_scanpos = xsp;
    if (jj_3_88()) {
    jj_scanpos = xsp;
    if (jj_3_89()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_3R_29()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_170() {
    if (jj_scan_token(154)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_78() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_170()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_24() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_78()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LIKE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_59()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_25()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_scan_token(CLOSE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_169() {
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_168() {
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_167() {
    if (jj_scan_token(NULL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_167()) {
    jj_scanpos = xsp;
    if (jj_3_168()) {
    jj_scanpos = xsp;
    if (jj_3_169()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_scan_token(154)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3_27()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_scan_token(JOINPLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_27()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_21()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_24()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_166() {
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_28()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CLOSEPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_165() {
    if (jj_3R_55()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_77() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(IS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_77()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NULL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_scan_token(LESSEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_scan_token(LESS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_scan_token(GREATEREQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_scan_token(GREATER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_scan_token(NOTEQUAL2)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_scan_token(NOTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_scan_token(EQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_27()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(JOINPLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_27() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3_20()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_20()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_3R_27()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_28()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_3R_64()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_142() {
    if (jj_scan_token(GET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RESULTS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_26()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_25()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(EXISTS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(IS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3_13()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_76() {
    if (jj_scan_token(154)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_35()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_3R_66()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_141() {
    if (jj_scan_token(SET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CURRENT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_140() {
    if (jj_scan_token(EXIT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_57() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3_7()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_139() {
    if (jj_3R_52()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_138() {
    if (jj_3R_51()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_137() {
    if (jj_3R_50()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_136() {
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_135() {
    if (jj_3R_48()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_134() {
    if (jj_3R_47()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_133() {
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_132() {
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_22() {
    if (jj_3R_40()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_164() {
    if (jj_3R_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_74() {
    if (jj_scan_token(154)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_129() {
    if (jj_3R_45()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_131() {
    if (jj_scan_token(154)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_131()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_75() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_128() {
    if (jj_scan_token(ASTERISK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_130() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_128()) {
    jj_scanpos = xsp;
    if (jj_3_129()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_19()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_3R_19()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_1()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_127() {
    if (jj_scan_token(DISTINCT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_125() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_126()) {
    jj_scanpos = xsp;
    if (jj_3_127()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_126() {
    if (jj_scan_token(ALL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_161() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_32() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_125()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    xsp = jj_scanpos;
    if (jj_3_130()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_120() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_162() {
    if (jj_scan_token(154)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_161()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_122() {
    if (jj_scan_token(DESC)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_scan_token(INSERT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(INTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_163() {
    Token xsp;
    if (jj_3_162()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_162()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_121() {
    if (jj_scan_token(ASC)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_123() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_121()) {
    jj_scanpos = xsp;
    if (jj_3_122()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_73() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_119() {
    if (jj_scan_token(154)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_120()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_25() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_73()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(IN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_68()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CLOSEPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_118() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_124() {
    if (jj_scan_token(ORDER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(BY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_118()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_119()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    xsp = jj_scanpos;
    if (jj_3_123()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_160() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(GROUP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(BY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_117() {
    if (jj_3R_44()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public SQLParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[0];
  final private int[] jj_la1_0 = {};
  final private int[] jj_la1_1 = {};
  final private int[] jj_la1_2 = {};
  final private int[] jj_la1_3 = {};
  final private int[] jj_la1_4 = {};
  final private JJCalls[] jj_2_rtns = new JJCalls[170];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public SQLParser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public SQLParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public SQLParser(SQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(SQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enum = jj_expentries.elements(); enum.hasMoreElements();) {
        int[] oldentry = (int[])(enum.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[155];
    for (int i = 0; i < 155; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 155; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 170; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
            case 85: jj_3_86(); break;
            case 86: jj_3_87(); break;
            case 87: jj_3_88(); break;
            case 88: jj_3_89(); break;
            case 89: jj_3_90(); break;
            case 90: jj_3_91(); break;
            case 91: jj_3_92(); break;
            case 92: jj_3_93(); break;
            case 93: jj_3_94(); break;
            case 94: jj_3_95(); break;
            case 95: jj_3_96(); break;
            case 96: jj_3_97(); break;
            case 97: jj_3_98(); break;
            case 98: jj_3_99(); break;
            case 99: jj_3_100(); break;
            case 100: jj_3_101(); break;
            case 101: jj_3_102(); break;
            case 102: jj_3_103(); break;
            case 103: jj_3_104(); break;
            case 104: jj_3_105(); break;
            case 105: jj_3_106(); break;
            case 106: jj_3_107(); break;
            case 107: jj_3_108(); break;
            case 108: jj_3_109(); break;
            case 109: jj_3_110(); break;
            case 110: jj_3_111(); break;
            case 111: jj_3_112(); break;
            case 112: jj_3_113(); break;
            case 113: jj_3_114(); break;
            case 114: jj_3_115(); break;
            case 115: jj_3_116(); break;
            case 116: jj_3_117(); break;
            case 117: jj_3_118(); break;
            case 118: jj_3_119(); break;
            case 119: jj_3_120(); break;
            case 120: jj_3_121(); break;
            case 121: jj_3_122(); break;
            case 122: jj_3_123(); break;
            case 123: jj_3_124(); break;
            case 124: jj_3_125(); break;
            case 125: jj_3_126(); break;
            case 126: jj_3_127(); break;
            case 127: jj_3_128(); break;
            case 128: jj_3_129(); break;
            case 129: jj_3_130(); break;
            case 130: jj_3_131(); break;
            case 131: jj_3_132(); break;
            case 132: jj_3_133(); break;
            case 133: jj_3_134(); break;
            case 134: jj_3_135(); break;
            case 135: jj_3_136(); break;
            case 136: jj_3_137(); break;
            case 137: jj_3_138(); break;
            case 138: jj_3_139(); break;
            case 139: jj_3_140(); break;
            case 140: jj_3_141(); break;
            case 141: jj_3_142(); break;
            case 142: jj_3_143(); break;
            case 143: jj_3_144(); break;
            case 144: jj_3_145(); break;
            case 145: jj_3_146(); break;
            case 146: jj_3_147(); break;
            case 147: jj_3_148(); break;
            case 148: jj_3_149(); break;
            case 149: jj_3_150(); break;
            case 150: jj_3_151(); break;
            case 151: jj_3_152(); break;
            case 152: jj_3_153(); break;
            case 153: jj_3_154(); break;
            case 154: jj_3_155(); break;
            case 155: jj_3_156(); break;
            case 156: jj_3_157(); break;
            case 157: jj_3_158(); break;
            case 158: jj_3_159(); break;
            case 159: jj_3_160(); break;
            case 160: jj_3_161(); break;
            case 161: jj_3_162(); break;
            case 162: jj_3_163(); break;
            case 163: jj_3_164(); break;
            case 164: jj_3_165(); break;
            case 165: jj_3_166(); break;
            case 166: jj_3_167(); break;
            case 167: jj_3_168(); break;
            case 168: jj_3_169(); break;
            case 169: jj_3_170(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
