package com.mwc.sqld.db;

import java.io.*;
import java.util.*;

import com.mwc.util.*;

import com.sleepycat.db.*;

public class BerkeleyDatabase extends SimpleDatabase {
   public static final int MAX_TEMP_TABLES = 10;
   private String _dataDirectory;
   private String _dbname;
   private boolean _mod = false;
   private Object _modLock = new Object();
   private Hashtable _tables = new Hashtable();
   private Object _tempLock = new Object();
   private LinkedList _tempIndexList = new LinkedList();
   private MasterTable _masterTable;

   private class TempIndexTable {
      private File _indexFile = null;
      private Db _indexDB = null;
      private Db _flag2IndexDB = null;
      private File _flag2IndexFile = null;
      private Db _value2IndexDB = null;
      private File _value2IndexFile = null;
      private Object _value = null;
   }
   
   public void close() {
      synchronized(_tempIndexList) {
         TempIndexTable temp;
         while(_tempIndexList.size() > 0) {
            temp = (TempIndexTable)_tempIndexList.get(0);
            _tempIndexList.remove(0);
            try {
               temp._value2IndexDB.close(0);
               temp._value2IndexFile.delete();
            }
            catch(DbException dbe1) {
               ;
            }
            try {
               temp._flag2IndexDB.close(0);
               temp._flag2IndexFile.delete();
            }
            catch(DbException dbe2) {
               ;
            }
            try {
               temp._indexDB.close(0);
               temp._indexFile.delete();
            }
            catch(DbException dbe0) {
               ;
            }
         }
      }
      Enumeration e = _tables.keys();
      BerkeleyTable bt;
      Db index;
      Enumeration e2;
      while(e.hasMoreElements()) {
         bt = (BerkeleyTable)e.nextElement();
         e2 = bt._indexTable.keys();
         while(e2.hasMoreElements()) {
            index = (Db)e2.nextElement();
            try {
               index.close(0);
            }
            catch(DbException dbe) {
               ;
            }
         }
         try {
            bt._table.close(0);
         }
         catch(DbException dbe) {
            ;
         }
      }
   }
   
   private void _returnTempIndexTable(TempIndexTable temp)
   throws DbException {
      temp._value2IndexDB.truncate(null, 0);
      temp._flag2IndexDB.truncate(null, 0);
      temp._indexDB.truncate(null, 0);
      synchronized(_tempIndexList) {
         if(_tempIndexList.size() >= MAX_TEMP_TABLES) {
            temp._value2IndexDB.close(0);
            temp._value2IndexFile.delete();
            temp._flag2IndexDB.close(0);
            temp._flag2IndexFile.delete();
            temp._indexDB.close(0);
            temp._indexFile.delete();
         }
         else 
            _tempIndexList.add(0,temp);
      }
   }
   
   private class FlagIndexMaper implements DbSecondaryKeyCreate {
      public int secondary_key_create(Db secondary, Dbt key, Dbt data, Dbt result)
      throws DbException {
         try {
            ByteArrayInputStream in = new ByteArrayInputStream(data.get_data());
            BufferedInputStream bin = new BufferedInputStream(in);
            ObjectInputStream oin = new ObjectInputStream(bin);
            Object array[] = (Object[])oin.readObject();
            Object value = array[2];
            String s = value.toString();
            result.set_data(s.getBytes());
            result.set_size(s.length());
            return 0;
         }
         catch(Exception e) {
            throw new DbException(e.getMessage());
         }
      }
   }
         
   private class ValueIndexMaper implements DbSecondaryKeyCreate {
      public int secondary_key_create(Db secondary, Dbt key, Dbt data, Dbt result)
      throws DbException {
         try {
            ByteArrayInputStream in = new ByteArrayInputStream(data.get_data());
            BufferedInputStream bin = new BufferedInputStream(in);
            ObjectInputStream oin = new ObjectInputStream(bin);
            Object array[] = (Object[])oin.readObject();
            Object value = array[0];
            String s1 = value.toString();
            value = array[1];
            String s2 = value.toString();
            s1 += ":" + s2;
            result.set_data(s1.getBytes());
            result.set_size(s1.length());
            return 0;
         }
         catch(Exception e) {
            throw new DbException(e.getMessage());
         }
      }
   }

   private TempIndexTable _getTempIndexTable() 
   throws DbException, IOException {
      TempIndexTable ret;
      if(_tempIndexList.size() > 0) {
         synchronized(_tempIndexList) {
            ret = (TempIndexTable)_tempIndexList.get(0);
            _tempIndexList.remove(0);
         }
      }
      else {
         ret = new TempIndexTable();
         ret._indexFile = getTempFile();
         ret._indexDB = new Db(null, 0);
         ret._indexDB.set_error_stream(System.err);
         ret._indexDB.set_errpfx("BerkeleyDatabase");
         ret._indexFile.delete();
         ret._indexDB.open(ret._indexFile.getAbsolutePath(), null, Db.DB_RECNO, Db.DB_CREATE, 0644);
         ret._flag2IndexFile = getTempFile();
         ret._flag2IndexDB = new Db(null, 0);
         ret._flag2IndexDB.set_error_stream(System.err);
         ret._flag2IndexDB.set_errpfx("BerkeleyDatabase");
         ret._flag2IndexDB.set_flags(Db.DB_DUP | Db.DB_DUPSORT);
         ret._flag2IndexFile.delete();
         ret._flag2IndexDB.open(ret._flag2IndexFile.getAbsolutePath(), null, Db.DB_BTREE, Db.DB_CREATE, 0644);
         ret._indexDB.associate(ret._flag2IndexDB, new FlagIndexMaper(), 0);
         ret._value2IndexFile = getTempFile();
         ret._value2IndexDB = new Db(null, 0);
         ret._value2IndexDB.set_error_stream(System.err);
         ret._value2IndexDB.set_errpfx("BerkeleyDatabase");
         ret._value2IndexDB.set_flags(Db.DB_DUP | Db.DB_DUPSORT);
         ret._value2IndexFile.delete();
         ret._value2IndexDB.open(ret._value2IndexFile.getAbsolutePath(), null, Db.DB_BTREE, Db.DB_CREATE, 0644);
         ret._indexDB.associate(ret._value2IndexDB, new ValueIndexMaper(), 0);
      }
      return ret;
   }
   
   private class BerkeleyTable implements Table {
      private String _name;
      private String _cols[][];
      private Db _table;
      private File _handle;
      private Hashtable _indexTable;

      private class BerkeleyCurser implements Curser, Indexable {
         private Hashtable _map = new Hashtable();
         private Vector _vec = new Vector();
         private Dbc _curser;
         private boolean _reset = false;
         private boolean _useIndex = false;
         private TempIndexTable _tempTable = null;
         private File _indexFile = null;
         private Db _indexDB = null;
         private Db _flag2IndexDB = null;
         private File _flag2IndexFile = null;
         private Db _value2IndexDB = null;
         private File _value2IndexFile = null;
         private Object _value = null;
         private boolean _gotDups = false;
         private boolean _doNotIndex = false;
         
         public void doNotIndex() {
            if(!_doNotIndex) {
               _doNotIndex = true;
               try {
                  _curser.close();
                  _curser = _table.cursor(null, 0);
               }
               catch(DbException dbe) {
                  dbe.printStackTrace();
               }
            }
         }
         
         private BerkeleyCurser() throws DbException {
            for(int i = 0; i < _cols.length; i++)
               _map.put(_cols[i][0].toLowerCase(), new Integer(i));
            _curser = _table.cursor(null, 0);
         }
         
         public boolean reset() {
            _useIndex = false;
            _reset = true;
            _useIndex = false;
            if(_indexDB != null) {
               try {
                  _value2IndexDB.truncate(null, 0);
                  _flag2IndexDB.truncate(null, 0);
                  _indexDB.truncate(null, 0);
               }
               catch(DbException dbe) {
                  return false;
               }
            }
            return true;
         }
         
         public boolean index(String columnName, Object value) {
            if(_doNotIndex)
               return false;
            int i = columnName.indexOf('.');
            if(i >= 0)
               columnName = columnName.substring(i+1);
            columnName = columnName.toLowerCase();
            _useIndex = true;
            if(_indexFile == null) {
               try {
                  _tempTable = _getTempIndexTable();
                  _indexFile = _tempTable._indexFile;
                  _indexDB = _tempTable._indexDB;
                  _flag2IndexFile = _tempTable._flag2IndexFile;
                  _flag2IndexDB = _tempTable._flag2IndexDB;
                  _value2IndexFile = _tempTable._value2IndexFile;
                  _value2IndexDB = _tempTable._value2IndexDB;
               }
               catch(Exception e) {
                  e.printStackTrace();
                  return false;
               }
            }
            Dbt key = new Dbt((columnName + ":" + value.toString()).getBytes());
            Dbt data = new Dbt();
            Dbc indexCurser = null;
            try {
               indexCurser = _value2IndexDB.cursor(null, 0);
               Dbt temp = new Dbt();
               Dbt pkey = new Dbt();
               
               try {
                  if(indexCurser.pget(key, pkey, temp, Db.DB_SET) != Db.DB_NOTFOUND)
                     return true;
               }
               finally {
                  indexCurser.close();
               }
               try {
                  ByteArrayOutputStream out = new ByteArrayOutputStream();
                  BufferedOutputStream bout = new BufferedOutputStream(out);
                  ObjectOutputStream oout = new ObjectOutputStream(bout);
                  Object array[] = new Object[]{ columnName, value, new Boolean(false) };
                  oout.writeObject(array);
                  oout.flush();
                  data = new Dbt(out.toByteArray());
               }
               catch(Exception ex) {
                  ex.printStackTrace();
                  return false;
               }
               key = new Dbt("false".getBytes());
               _indexDB.put(null, key, data, Db.DB_APPEND);
            }
            catch(DbException dbe) {
               dbe.printStackTrace();
               if(indexCurser != null) {
                  try {
                     indexCurser.close();
                  }
                  catch(DbException dbe2) {
                     dbe2.printStackTrace();
                     return false;
                  }
               }
               return false;
            }
            
            return true;
         }

         private boolean _moveNext()
         throws DbException, IOException {
            Dbc curser = _flag2IndexDB.cursor(null, 0);
            try {
               Dbt key = new Dbt("false".getBytes());
               Dbt pkey = new Dbt();
               Dbt data = new Dbt();
               if(curser.pget(key, pkey, data, Db.DB_SET) != Db.DB_NOTFOUND) {
                  ByteArrayInputStream in = new ByteArrayInputStream(data.get_data());
                  BufferedInputStream bin = new BufferedInputStream(in);
                  ObjectInputStream oin = new ObjectInputStream(bin);
                  Object array[];
                  try {
                     array = (Object[])oin.readObject();
                  }
                  catch(ClassNotFoundException cnfe) {
                     return false;
                  }
                  _value = array[1];
                  array[2] = new Boolean(true);
                  ByteArrayOutputStream out = new ByteArrayOutputStream();
                  BufferedOutputStream bout = new BufferedOutputStream(out);
                  ObjectOutputStream oout = new ObjectOutputStream(bout);
                  oout.writeObject(array);
                  oout.flush();
                  data = new Dbt(out.toByteArray());
                  curser.close();
                  curser = null;
                  _indexDB.put(null, pkey, data, 0);
                  Db index = (Db)_indexTable.get(array[0].toString().toLowerCase());
                  _curser.close();
                  _curser = index.cursor(null, 0);
                  return true;
               }
            }
            finally {
               if(curser != null)
                  curser.close();
            }
            return false;
         }
         
         public boolean next() {
            try {
               if(_useIndex && !_doNotIndex) {
                  if(!_gotDups && !_moveNext()) {
                     return false;
                  }

                  Dbt skey = new Dbt(_value.toString().getBytes());
                  Dbt key = new Dbt();
                  Dbt data = new Dbt();
                  if(!_gotDups) {
                     while(true) {
                        if(_curser.pget(skey, key, data, Db.DB_SET) == Db.DB_NOTFOUND) {
                           if(!_moveNext()) {
                              return false;
                           }
                           else
                              skey = new Dbt(_value.toString().getBytes());
                        }
                        else {
                           break;
                        }
                     }
                     _gotDups = true;
                  }
                  else {
                     int flags = Db.DB_NEXT_DUP;
                     while(true) {
                        if(_curser.pget(skey, key, data, flags) == Db.DB_NOTFOUND) {
                           if(!_moveNext()) {
                              return false;
                           }
                           else {
                              skey = new Dbt(_value.toString().getBytes());
                              flags = Db.DB_SET;
                           }
                        }
                        else {
                           break;
                        }
                     }
                  }
                  ByteArrayInputStream in = new ByteArrayInputStream(data.get_data());
                  BufferedInputStream bin = new BufferedInputStream(in);
                  ObjectInputStream oin = new ObjectInputStream(bin);
                  LinkedList list = (LinkedList)oin.readObject();
                  _vec = new Vector();
                  Iterator it = list.iterator();
                  Object value;
                  while(it.hasNext()) {
                     value = it.next();
                     _vec.addElement(value);
                  }
                  return true;
               }
               else {
                  Dbt key = new Dbt();
                  Dbt data = new Dbt();
                  if(_reset) {
                     _reset = false;
                     if(_curser.get(key, data, Db.DB_FIRST) == Db.DB_NOTFOUND)
                        return false;
                  }
                  else {
                     if(_curser.get(key, data, Db.DB_NEXT) == Db.DB_NOTFOUND)
                        return false;
                  }
                  ByteArrayInputStream in = new ByteArrayInputStream(data.get_data());
                  BufferedInputStream bin = new BufferedInputStream(in);
                  ObjectInputStream oin = new ObjectInputStream(bin);
                  LinkedList list = (LinkedList)oin.readObject();
                  _vec = new Vector();
                  Iterator it = list.iterator();
                  while(it.hasNext())
                     _vec.addElement(it.next());
                  return true;
               }
            }
            catch(Exception dbe) {
               dbe.printStackTrace();
               return false;
            }
         }
         
         public boolean close() {
            try {
               _curser.close();
               if(_indexFile != null)
                  _returnTempIndexTable(_tempTable);
               return true;
            }
            catch(DbException dbe) {
               return false;
            }
         }
         
         public int recCount() {
            try {
               DbBtreeStat btreeStat = (DbBtreeStat)_table.stat(Db.DB_FAST_STAT);
               return btreeStat.bt_nkeys;
            }
            catch(DbException dbe) {
               return -1;
            }
         }
         
         public String getValue(String name) {
            int i = name.indexOf('.');
            if(i < 0) {
               Integer ii = (Integer)_map.get(name.toLowerCase());
               if(ii == null)
                  return null;
               return (String)_vec.elementAt(ii.intValue());
            }
            else {
               String tblName = name.substring(0,i);
               if(tblName.equalsIgnoreCase(_name)) {
                  name = name.substring(i+1);
                  Integer ii = (Integer)_map.get(name.toLowerCase());
                  if(ii == null)
                     return null;
                  return (String)_vec.elementAt(ii.intValue());
               }
               else
                  return null;
            }
         }
         
         public String getValue(int index) {
            return (String)_vec.elementAt(index);
         }
         
         public String getType(String name) {
            int i = name.indexOf('.');
            if(i >= 0) {
               String tblName = name.substring(0,i);
               if(!tblName.equalsIgnoreCase(_name))
                  return null;
               name = name.substring(i+1);
            }
            for(i = 0; i < _cols.length; i++) {
               if(name.equalsIgnoreCase(_cols[i][0])) {
                  return _cols[i][1];
               }
            }
            return null;
         }
         
         public int size() {
            return _cols.length;
         }
         
         public String[][] cols() {
            return _cols;
         }
      }
      
      private class IndexMaper implements DbSecondaryKeyCreate {
         private int _columnIndex;
         
         private IndexMaper(int columnIndex) {
            _columnIndex = columnIndex;
         }
         
         public int secondary_key_create(Db secondary, Dbt key, Dbt data, Dbt result)
         throws DbException {
            try {
               ByteArrayInputStream in = new ByteArrayInputStream(data.get_data());
               BufferedInputStream bin = new BufferedInputStream(in);
               ObjectInputStream oin = new ObjectInputStream(bin);
               LinkedList list = (LinkedList)oin.readObject();
               Object value = list.get(_columnIndex);
               result.set_data(value.toString().getBytes());
               result.set_size(value.toString().length());
               return 0;
            }
            catch(Exception e) {
               throw new DbException(e.getMessage());
            }
         }
      }
      
      private BerkeleyTable(String name, String cols[][])
      throws IOException, DbException {
         _name = name;
         _handle = new File(_dataDirectory + "/" + _name + ".db");
         _cols = cols;
         _indexTable = new Hashtable();
         Db index;
         File f;
         _table = new Db(null, 0);
         _table.set_error_stream(System.err);
         _table.set_errpfx("BerkeleyDatabase");
         _table.open(_handle.getAbsolutePath(), null, Db.DB_RECNO, Db.DB_CREATE, 0644);
         for(int i = 0; i < _cols.length; i++) {
            f = new File(_dataDirectory + "/" + _name + "." + _cols[i][0] + ".db");
            index = new Db(null, 0);
            index.set_error_stream(System.err);
            index.set_errpfx("BerkeleyDatabase");
            index.set_flags(Db.DB_DUP | Db.DB_DUPSORT);
            index.open(f.getAbsolutePath(), null, Db.DB_BTREE, Db.DB_CREATE, 0644);
            _table.associate(index, new IndexMaper(i), 0);
            _indexTable.put(_cols[i][0].toLowerCase(), index);
         }
      }
      
      public String name() {
         return _name;
      }
      
      public Curser getNewCurser() {
         try {
            return new BerkeleyCurser();
         }
         catch(DbException dbe) {
            return null;
         }
      }
      
      public boolean insert(LinkedList values) {
         try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedOutputStream bout = new BufferedOutputStream(out);
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(values);
            oout.flush();
            byte[] data = out.toByteArray();
            Dbt key = new Dbt();
            if(_table.put(null, key, new Dbt(data), Db.DB_APPEND) != 0)
               return false;
            return true;
         }
         catch(Exception ex) {
            return false;
         }
      }
      
      public boolean drop() {
         return false;
      }
      
      public String[][] cols() {
         return _cols;
      }
   }
   
   public BerkeleyDatabase(String name, String dir)
   throws IOException, DbException {
      _dataDirectory = dir;
      _dbname = name;
      File f = new File(_dataDirectory);
      if(!f.exists())
         f.mkdirs();
      f = new File(_dataDirectory + "/data.dat");
      if(f.exists()) {
         _masterTable = new MasterTable(f);
         Curser c = _masterTable.getNewCurser();
         try {
            Table t;
            String tableName, lastTableName = "";
            String cols[][];
            int i;
            while(c.next()) {
               tableName = c.getValue("TableName");
               if(!lastTableName.equalsIgnoreCase(tableName)) {
                  lastTableName = tableName;
                  cols = _masterTable.loadCols(tableName);
                           
System.out.println("LOAD-TABLE("+tableName+")");                           
                  t = new BerkeleyTable(tableName, cols);
                  _tables.put(t.name().toLowerCase(), t);
               }
            }
         }
         finally {
            if(c != null)
               c.close();
         }
      }
   }
   
   public Table createTable(String name, String cols[][]) {
      try {
         Table tbl = getTable(name);
         if(tbl != null)
            return null;
         tbl = new BerkeleyTable(name, cols);
         synchronized(_tables) {
            _tables.put(name.toLowerCase(), tbl);
         }
         synchronized(_modLock) {
            _mod = true;
         }
         return tbl;
      }
      catch(Exception ioe) {
         return null;
      }
   }
   
   public String name() {
      return _dbname;
   }
   
   public File getTempFile() {
      File f;
      synchronized(_tempLock) {
         String tempFileName =  _dataDirectory + "/temp/";
         f = new File(tempFileName);
         if(!f.exists())
            f.mkdirs();
         String choice = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
         StringBuffer buf;
         do {
            buf = new StringBuffer();
            for(int i = 0; i < 50; i++)
               buf.append(choice.charAt((int)(Math.random() * 1000000000) % choice.length()));
            f = new File(tempFileName + buf.toString());
         }
         while(f.exists());
         try {
            FileOutputStream fout = new FileOutputStream(f);
            fout.close();
         }
         catch(IOException ioe) {
            return null;
         }
      }
      return f;
   }
   
   public Table getTable(String table) {
      if(table.equalsIgnoreCase("Master"))
         return _masterTable;
      return (Table)_tables.get(table.toLowerCase());
   }
   
   public String[] tableNames() {
      String ret[] = new String[_tables.size()];
      Enumeration e = _tables.keys();
      int i = 0;
      while(e.hasMoreElements()) {
         ret[i] = e.nextElement().toString();
         i++;
      }
      return ret;
   }
   
   public boolean dropTable(String table) {
      return false;
   }
   
   public boolean save() {
      try {
         _masterTable.saveState(_dataDirectory, _tables);
         synchronized(_modLock) {
            _mod = false;
         }
      }
      catch(Throwable throwable) {
         return false;
      }
      return true;
   }
   
   public boolean modified() {
      synchronized(_modLock) {
         return _mod;
      }
   }
   
   public void sync() {
      Enumeration e = _tables.elements();
      BerkeleyTable bt;
      while(e.hasMoreElements()) {
         bt = (BerkeleyTable)e.nextElement();
         try {
            bt._table.sync(0);
         }
         catch(DbException dbe) {
            ;
         }
         Enumeration e2 = bt._indexTable.elements();
         while(e2.hasMoreElements()) {
            try {
               ((Db)e2.nextElement()).sync(0);
            }
            catch(DbException dbe2) {
               ;
            }
         }
      }
   }
}