package com.mwc.sqld.db;

import java.io.*;
import java.util.*;

import com.mwc.util.*;

public class CSVSelectEngine implements SelectEngine {
   private void _printRec(Curser data[], 
                          LinkedList colList, 
                          PrintWriter out,
                          String cols[][])
   throws DBException {
      Object value;
      SQLExpression expr;
      StringBuffer buf = new StringBuffer();
      int index = 0;
      while(index < colList.size()) {
         expr = (SQLExpression)colList.get(index);
         value = expr.eval(data);
         cols[index][0] = expr.as();
         if(value instanceof Integer)
            cols[index][1] = "INT";
         else if(value instanceof Double)
            cols[index][1] = "FLOAT";
         else if(value instanceof String)
            cols[index][1] = "TEXT";
         else if(value instanceof Boolean)
            cols[index][1] = "BOOLEAN";
         else
            throw new DBException("Bad type found after eval()!");
         if(buf.length() != 0)
            buf.append(",");
         buf.append("\"" + CSVEncoder.encode(value.toString()) + "\"");
         index++;
      }
      out.println(buf.toString());
      out.flush();
   }

   private void _doSelect(Curser data[], 
                          Criteria c, 
                          int i, 
                          LinkedList colList,
                          PrintWriter out,
                          String cols[][],
                          int recCount[]) 
   throws DBException {
      if(i >= data.length) {
         if(c == null || c.match(data)) {
            _printRec(data, colList, out, cols);
            recCount[0]++;
         }
         return;
      }
      data[i].reset();
      while(data[i].next()) {
         _doSelect(data, c, i+1, colList, out, cols, recCount);
      }
   }

   public Curser select(Database db, Curser data[], Criteria c, LinkedList colList) 
   throws DBException {
      File f = null;
      CSVCurser csvCurser = null;
      try {
         f = db.getTempFile();
         FileOutputStream fout = new FileOutputStream(f);
         BufferedOutputStream bout = new BufferedOutputStream(fout);
         PrintWriter out = new PrintWriter(bout);

         StringBuffer buffer = new StringBuffer();
         for(int i = 0; i < colList.size(); i++) {
            if(buffer.length() != 0)
               buffer.append(",");
            buffer.append("\"\"");
         }
         out.println(buffer.toString());
         out.flush();
         
         String cols[][] = new String[colList.size()][2];
         for(int i = 0; i < cols.length; i++) {
            cols[i][0] = "";
            cols[i][1] = "";
         }
         int rc[] = new int[1];
         rc[0] = 0;
         try {
            _doSelect(data, c, 0, colList, out, cols, rc);
         }
         finally {
            out.flush();
            fout.close();
         }
         
         csvCurser = new CSVCurser(f, cols, rc[0]);
         return csvCurser;
      }
      catch(IOException ioe) {
         throw new DBException("Unable to preforme select statement: " + ioe.getMessage());
      }
      finally {
         if(f != null && csvCurser == null)
            f.delete();
      }
   }
}