package com.mwc.sqld.db;

import java.lang.reflect.*;

public class DatabaseFactory {
   /**
    * Create or open a database
    * @param implName the name of the database implementation
    * @param dbName the name of hte database
    * @param dbDir the directory for the database
    * @exception Exception if error
    * @return a reference to a database instance or null
    *         if the implementation was not found
    */
   public static Database getDatabase(String implName,
                                      String dbName,
                                      String dbDir)
   throws Exception {
      Class clazz = DatabaseImplManager.getImplClass(implName);
      if(clazz == null)
         return null;
      Class javaLangString = Class.forName("java.lang.String");
      Constructor constructor = clazz.getConstructor(new Class[]{javaLangString,javaLangString});
      if(constructor == null)
         return null;
      Database database = (Database)constructor.newInstance(new Object[]{dbName, dbDir});
      return database;
   }
}