package com.mwc.sqld.db;

import java.util.*;

/**
 * A class to staticly manage all the Database implementations
 * in a JVM instance in a thread safe way.
 * @author Matthew W. Coan
 */
public class DatabaseImplManager {
   private static Hashtable _dbClassTable = new Hashtable();
   
   /**
    * Register an implemenation with the framework.
    * @param name the name of the implementation
    * @param dbClass the class for the implementation
    * @return the previous class for that implementation or null
    */
   public static Class registerImpl(String name, Class dbClass) {
      synchronized(_dbClassTable) {
         return (Class)_dbClassTable.put(name.toLowerCase(), dbClass);
      }
   }
   
   /**
    * Get a class for an implementation.
    * @param name the name of the implementation
    * @return the class for that impl or null
    */
   public static Class getImplClass(String name) { 
      synchronized(_dbClassTable) {
         return (Class)_dbClassTable.get(name.toLowerCase());
      }
   }
}