package com.mwc.sqld.db;

import java.util.*;
import java.lang.reflect.*;

public class SQLExpression implements Expression {
   public static final boolean DEBUG_MODE = false;
   private Stack _operandStack;
   private Stack _operatorStack;
   private String _as;
   private ValueLookup _tbl[] = null;
   private Hashtable _indexedTables = null;
   private Hashtable _usedCols = null;
   private Hashtable _allUsedCols = new Hashtable();
     
   public SQLExpression(Stack operand, Stack operator) {
      _operandStack = operand;
      _operatorStack = operator;
      _as = "";
   }
   
   public SQLExpression(Stack operand, Stack operator, String as) {
      _operandStack = operand;
      _operatorStack = operator;
      _as = as;
   }
   
   public String as() { 
      return _as; 
   }
         
   private Object _lookupValue(Object o)
   throws DBException {
      if(o instanceof String) {
         String name = (String)o;
         if(name.length() > 0 && name.charAt(0) == '\'') {
            name = name.substring(1, name.length()-1);
            return name;
         }
         if(name.equalsIgnoreCase("true"))
            return new Boolean(true);
         if(name.equalsIgnoreCase("false"))
            return new Boolean(false);
         for(int i = 0; i < _tbl.length; i++) {
            o = _tbl[i].getValue(name);
            if(o != null) {
               if(_usedCols != null)
                  _usedCols.put(name.toLowerCase(), _tbl[i]);
               _allUsedCols.put(name.toLowerCase(), _tbl[i]);
               return SQLDataTranslator.toData((String)o, _tbl[i].getType(name));
            }
         }
         return null;
      }
      return o;
   }
   
   public void SQLOrExpr() 
   throws DBException {
      Object operand1, operand2, res;
      SQLAndExpr();
      while(_operatorStack.size() > 0 
            && _operatorStack.peek().toString().compareTo("OR") == 0) {
         _operatorStack.pop();
         operand2 = _lookupValue(_operandStack.pop());
         SQLAndExpr();
         operand1 = _lookupValue(_operandStack.pop());
         if(operand1 == null || operand2 == null)
            throw new DBException("Execution time error!");
         if(operand1 instanceof Boolean
            && operand2 instanceof Boolean) {
            _debug("OR(" + ((Boolean)operand1).booleanValue()
                         +","+ ((Boolean)operand2).booleanValue()+")");
            res = new Boolean(((Boolean)operand1).booleanValue()
                              || ((Boolean)operand2).booleanValue());
            _operandStack.push(res);
         }
         else {
            throw new DBException("Bad types!");
         }
      }
   }
   
   public void SQLAndExpr() 
   throws DBException {
      Object operand1, operand2, res;
      SQLNotExpr();
      while(_operatorStack.size() > 0 
            && _operatorStack.peek().toString().compareTo("AND") == 0) {
         _operatorStack.pop();
         operand2 = _lookupValue(_operandStack.pop());
         SQLNotExpr();
         operand1 = _lookupValue(_operandStack.pop());
         if(operand1 == null || operand2 == null)
            throw new DBException("Execution time error!");
         if(operand1 instanceof Boolean
            && operand2 instanceof Boolean) {
            _debug("AND(" + ((Boolean)operand1).booleanValue()
                         +","+ ((Boolean)operand2).booleanValue()+")");
            res = new Boolean(((Boolean)operand1).booleanValue()
                              && ((Boolean)operand2).booleanValue());
            _operandStack.push(res);
         }
         else {
            throw new DBException("Bad types!");
         }
      }
   }

   public void SQLNotExpr()
   throws DBException {
      Object operand1, res;
      _indexedTables = new Hashtable();
      SQLCompareExpr();
      if(_operatorStack.size() > 0 
         && _operatorStack.peek().toString().compareTo("NOT") == 0) {
         Enumeration e = _indexedTables.keys();
         Indexable index;
         while(e.hasMoreElements()) {
            index = (Indexable)e.nextElement();
            index.doNotIndex();
         }
         _operatorStack.pop();
         operand1 = _lookupValue(_operandStack.pop());
         if(operand1 == null)
            throw new DBException("Execution time error!");
         if(operand1 instanceof Boolean) {
            _debug("NOT("+operand1.toString()+")");
            res = new Boolean(!((Boolean)operand1).booleanValue());
            _operandStack.push(res);
         }
         else {
            throw new DBException("Bad types!");
         }
	     }
   }
   
   public static boolean like(String value, String pattern) {
      if(value.compareTo("") == 0 
         && pattern.compareTo("") != 0
         && pattern.compareTo("%") != 0)
         return false;
      char ch0, ch1, ch2;
      int j = 0;
      int n = 0;

      for(int i = 0; i < value.length(); i++) {
         ch0 = value.charAt(i);
         if(j >= pattern.length())
            return false;
         ch1 = pattern.charAt(j);
         if((j+1) < pattern.length()) 
            ch2 = pattern.charAt((j+1));
         else
            ch2 = '\0';
         
         if(ch1 == '\\' && ch2 == '_') {
            if(ch0 != '_')
               return false;
            else
               j += 2;
         }
         else if(ch1 == '_') {
            j++;
         }
         else if(ch1 == '\\' && ch2 == '%') {
            if(ch0 != '%') 
               return false;
            else 
               j += 2;
         }
         else if(ch1 == '\\' && ch2 == '\\') {
            if(ch0 != '\\')
               return false;
            else
               j += 2;
         }
         else if(ch1 == '%' && ch2 != '%') {
            int nextPercent;
            int next1;
            String sub = null;
            int k;
            if((j+1) < pattern.length()) {
               k = -1;
               do {
                  k++;
                  nextPercent = pattern.indexOf("%", j+k+1);
                  next1 = pattern.indexOf("_", j+k+1);
                  if(nextPercent < 0 && next1 < 0) {
                     sub = pattern.substring(j+1);
                     break;
                  }
               }
               while(((nextPercent-1) >= 0 
                     && pattern.charAt(nextPercent-1) == '\\')
                     || ((next1-1) >= 0 
                         && pattern.charAt(next1-1) == '\\'));
               
               if(nextPercent >= 0 && next1 >= 0) {
                  if(nextPercent < next1)
                     sub = pattern.substring(j+k+1, nextPercent);
                  else
                     sub = pattern.substring(j+k+1, next1);
               }
               else if(next1 >= 0)
                  sub = pattern.substring(j+k+1, next1);
               else if(nextPercent >= 0)
                  sub = pattern.substring(j+k+1, nextPercent);
               
               n = sub.length();
               StringBuffer buf = new StringBuffer();
               for(k = 0; k < sub.length(); k++) {
                  if(sub.charAt(k) == '\\') {
                     if((k+1) < sub.length()) {
                        k++;
                        buf.append(sub.charAt(k));
                     }
                  }
                  else
                     buf.append(sub.charAt(k));
               }
               sub = buf.toString();
            }
            else
               return true;
            
            boolean found = false;
            for(k = i; k < value.length(); k++) {
               if(value.regionMatches(k, sub, 0, sub.length())) {
                  i = k + n - 1;
                  j += n + 1;
                  found = true;
                  break;
               }
            }
            if(!found)
               return false;
         }
         else if(ch0 == ch1) {
            j++;
         }
         else {
            return false;
         }
         if((i+1) >= value.length() && j < pattern.length()) {
            if((pattern.charAt(j) == '%') && (j == (pattern.length() - 1)))
               return true;
            return false;
         }
      }
      return true;
   }
   
   private void _doIndex(String name, Object value)
   throws DBException {
      Object o;
      for(int i = 0; i < _tbl.length; i++) {
         o = _tbl[i].getValue(name);
         if(o != null) {
            if(_tbl[i] instanceof Indexable) {
               if(((Indexable)_tbl[i]).index(name, value))
                  _indexedTables.put(name.toLowerCase(), _tbl[i]);
            }
            break;
         }
      }
   }
   
   private boolean _sameColumnName(String col1, String col2) {
      int i = col1.indexOf('.');
      String tbl1 = "";
      if(i >= 0) {
         tbl1 = col1.substring(0,i);
         col1 = col1.substring(i+1);
      }
      i = col2.indexOf('.');
      String tbl2 = "";
      if(i >= 0) {
         tbl2 = col2.substring(0, i);
         col2 = col2.substring(i+1);
      }
      if(tbl1.equalsIgnoreCase(tbl2)) {
         if(col1.equalsIgnoreCase(col2))
            return true;
      }
      return false;
   }
   
   private void _doIndexIntersection(String col1, Object val1,
                                     String col2, Object val2)
   throws DBException {
      Object o;
      Indexable index1 = null, index2 = null;
      for(int i = 0; i < _tbl.length; i++) {
         o = _tbl[i].getValue(col1);
         if(o != null) {
            if(_tbl[i] instanceof Indexable)
               index1 = (Indexable)_tbl[i];
         }
         o = _tbl[i].getValue(col2);
         if(o != null) {
            if(_tbl[i] instanceof Indexable)
               index2 = (Indexable)_tbl[i];
         }
         if(index1 != null && index2 != null)
            break;
      }
      
      if(index1 != null && index2 == null) {
         if(index1.index(col1, val2))
            _indexedTables.put(col1.toLowerCase(), index1);
      }
      else if(index1 == null && index2 != null) {
         if(index2.index(col2, val1))
            _indexedTables.put(col2.toLowerCase(), index2);
      }
      else if(index1 != null && index2 != null) {
         if(_sameColumnName(col1, col2))
            return;
         if(index1 instanceof Curser && index2 instanceof Curser) {
            Curser c1 = (Curser)index1;
            Curser c2 = (Curser)index2;
            if(c1.recCount() > c2.recCount()) {
               if(index1.index(col1, val2)) {
                  _indexedTables.put(col1.toLowerCase(), index1);
                  index2.doNotIndex();
               }
            }
            else {
               if(index2.index(col2, val1)) {
                  _indexedTables.put(col2.toLowerCase(), index2);
                  index1.doNotIndex();
               }
            }
         }
         else {
            if(index2.index(col2, val1)) {
               _indexedTables.put(col2.toLowerCase(), index2);
               index1.doNotIndex();
            }
         }
      }
   }
   
   private void _checkUsedCols(Hashtable used) {
      Enumeration elements = used.elements();
      Enumeration elements2;
      ValueLookup v1, v2;
      while(elements.hasMoreElements()) {
         v1 = (ValueLookup)elements.nextElement();
         elements2 = _indexedTables.elements();
         while(elements2.hasMoreElements()) {
            v2 = (ValueLookup)elements2.nextElement();
            if(v1 == v2) {
               ((Indexable)v2).doNotIndex();
            }
         }
      }
   }
   
   private void _checkIndex(Object op1, 
                            Object operand1, 
                            Object op2, 
                            Object operand2, 
                            String op,
                            Hashtable left,
                            Hashtable right)
   throws DBException {
      String s1 = null, s2 = null;
      boolean op1Flag = false;
      boolean op2Flag = false;
      if(op1 instanceof String) {
         s1 = (String)op1;
         if(s1.length() > 0 && s1.charAt(0) != '\'')
            op1Flag = true;
      }
      if(op2 instanceof String) {
         s2 = (String)op2;
         if(s2.length() > 0 && s2.charAt(0) != '\'')
            op2Flag = true;
      }
               
      if(op1Flag && !op2Flag) {
         if(op.compareTo("=") == 0)
            _doIndex(s1, operand2);
         _checkUsedCols(right);
      }
      else if(!op1Flag && op2Flag) {
         if(op.compareTo("=") == 0)
            _doIndex(s2, operand1);
         _checkUsedCols(left);
      }
      else if(op1Flag && op2Flag) {
         if(op.compareTo("=") == 0)
            _doIndexIntersection(s1, operand1, s2, operand2);
      }
      else {
         _checkUsedCols(right);
         _checkUsedCols(left);
      }
   }
   
   public void SQLCompareExpr()
   throws DBException  {
      Object operand1, operand2, res;
      _usedCols = new Hashtable();
      SQLSumExpr(); 
      Hashtable right = _usedCols;
      _usedCols = null;
      String op;
      if(_operatorStack.size() > 0 
         && _operatorStack.peek().toString().compareTo("LIKE") == 0) {
         _operatorStack.pop();
         Object op2 = _operandStack.pop();
         operand2 = _lookupValue(op2);
         _usedCols = new Hashtable();
         SQLSumExpr();
         Hashtable left = _usedCols;
         _usedCols = null;
         Object op1 = _operandStack.pop();
         operand1 = _lookupValue(op1);
         if(operand1 == null || operand2 == null)
            throw new DBException("Execution time error!");
         if(operand1 instanceof String 
            && operand2 instanceof String) {
            _checkIndex(op1, 
                        operand1, 
                        op2, 
                        operand2, 
                        "LIKE",
                        left,
                        right);
            _debug("LIKE(\'"+operand1.toString()+"\',\'"+operand2.toString()+"\')");
            res = new Boolean(like(((String)operand1).toLowerCase(), 
                                   ((String)operand2).toLowerCase()));
            _operandStack.push(res);
         }
         else {
            throw new DBException("Bad types!");
         }
      }
      else if((op = SQLCompareOp()) != null) {
         _operatorStack.pop();
         Object op2 = _operandStack.pop();
         operand2 = _lookupValue(op2);
         _usedCols = new Hashtable();
         SQLSumExpr();
         Hashtable left = _usedCols;
         _usedCols = null;
         Object op1 = _operandStack.pop();
         operand1 = _lookupValue(op1);
         if(operand1 == null || operand2 == null)
            throw new DBException("Execution time error!");
         if(operand1.getClass() != operand2.getClass()) 
            throw new DBException("Data types must match to compare!");
         if(operand1 instanceof Comparable
            && operand2 instanceof Comparable) {
            _checkIndex(op1, 
                        operand1, 
                        op2, 
                        operand2, 
                        op,
                        left,
                        right);
            if(operand1 instanceof String)
               operand1 = ((String)operand1).toLowerCase();
            if(operand2 instanceof String)
               operand2 = ((String)operand2).toLowerCase();
            _debug("COMPARE(" + op + "," + operand1.toString() + "," + operand2.toString()+")");
            if(op.compareTo("=") == 0)               
               res = new Boolean(((Comparable)operand1).compareTo(((Comparable)operand2)) == 0);
            else if(op.compareTo("<>") == 0)
               res = new Boolean(((Comparable)operand1).compareTo(((Comparable)operand2)) != 0);
            else if(op.compareTo("<") == 0)
               res = new Boolean(((Comparable)operand1).compareTo(((Comparable)operand2)) < 0);
            else if(op.compareTo("<=") == 0)
               res = new Boolean(((Comparable)operand1).compareTo(((Comparable)operand2)) <= 0);
            else if(op.compareTo(">") == 0)
               res = new Boolean(((Comparable)operand1).compareTo(((Comparable)operand2)) > 0);
            else if(op.compareTo(">=") == 0)
               res = new Boolean(((Comparable)operand1).compareTo(((Comparable)operand2)) >= 0);
            else
               throw new DBException("Bad compare operator!");
                        
            _operandStack.push(res);
         }
         else if(operand1 instanceof Boolean
                 && operand2 instanceof Boolean) {
            _checkIndex(op1, 
                        operand1, 
                        op2, 
                        operand2, 
                        op,
                        left,
                        right);            
            _debug("COMPARE(" + op + "," + operand1.toString() + "," + operand2.toString()+")");
            if(op.compareTo("=") == 0)
               res = new Boolean(operand1.equals(operand2));
            else if(op.compareTo("<>") == 0)
               res = new Boolean(!operand1.equals(operand2));
            else
               throw new DBException("Bad compare operator!");
            
            _operandStack.push(res);
         }
         else {
            throw new DBException("Bad types!");
         }
      }
   }   
   
   public String SQLCompareOp() {
      if(_operatorStack.size() <= 0)
         return null;
      String top = _operatorStack.peek().toString();
      if(top.compareTo("=") == 0
         || top.compareTo("<>") == 0
         || top.compareTo(">") == 0
         || top.compareTo(">=") == 0
         || top.compareTo("<") == 0
         || top .compareTo("<=") == 0)
         return top;
      return null;
   }
   
   private void _debug(String msg) {
      if(DEBUG_MODE)
         System.out.println(msg);
   }
   
   public void SQLSumExpr() 
   throws DBException {
      Object operand1, operand2, res;
      SQLProductExpr();
      while(true) {
         if(_operatorStack.size() > 0 
            && _operatorStack.peek().toString().compareTo("+") == 0) {
            _operatorStack.pop();
            operand2 = _lookupValue(_operandStack.pop());
            SQLProductExpr();
            operand1 = _lookupValue(_operandStack.pop());
            if(operand1 == null || operand2 == null)
               throw new DBException("Execution time error!");
            if(operand1 instanceof Integer
               && operand2 instanceof Integer) {
               _debug("ADD("+((Integer)operand1).intValue()+","
                                 + ((Integer)operand2).intValue()+")");
               res = new Integer(((Integer)operand1).intValue()
                                 + ((Integer)operand2).intValue());
               _operandStack.push(res);
            }
            else if(operand1 instanceof Double
               && operand2 instanceof Double) {
               _debug("ADD("+((Double)operand1).doubleValue()+","
                                 + ((Double)operand2).doubleValue()+")");
               res = new Double(((Double)operand1).doubleValue()
                                 + ((Double)operand2).doubleValue());
               _operandStack.push(res);
            }
            else {
               throw new DBException("Bad types!");
            }
         }
         else if(_operatorStack.size() > 0 
                 && _operatorStack.peek().toString().compareTo("-") == 0) {
            _operatorStack.pop();
            operand2 = _lookupValue(_operandStack.pop());
            SQLProductExpr();
            operand1 = _lookupValue(_operandStack.pop());
            if(operand1 == null || operand2 == null)
               throw new DBException("Execution time error!");
            if(operand1 instanceof Integer
               && operand2 instanceof Integer) {
               _debug("SUB("+((Integer)operand1).intValue()+","
                                 + ((Integer)operand2).intValue()+")");
               res = new Integer(((Integer)operand1).intValue()
                                 - ((Integer)operand2).intValue());
               _operandStack.push(res);
            }
            else if(operand1 instanceof Double
               && operand2 instanceof Double) {
               _debug("SUB("+((Double)operand1).doubleValue()+","
                                 + ((Double)operand2).doubleValue()+")");
               res = new Double(((Double)operand1).doubleValue()
                                 - ((Double)operand2).doubleValue());
               _operandStack.push(res);
            }
            else {
               throw new DBException("Bad types!");
            }
         }
         else
            break;
      }
   }

   public void SQLProductExpr()
   throws DBException {
      Object operand1, operand2, res;
      SQLUnaryExpr();
      while(true) {
         if(_operatorStack.size() > 0 
            && _operatorStack.peek().toString().compareTo("*") == 0) {
            _operatorStack.pop();
            operand2 = _lookupValue(_operandStack.pop());
            SQLUnaryExpr();
            operand1 = _lookupValue(_operandStack.pop());
            if(operand1 == null || operand2 == null)
               throw new DBException("Execution time error!");
            if(operand1 instanceof Integer
               && operand2 instanceof Integer) {
               _debug("MUL("+((Integer)operand1).intValue()+","
                                 + ((Integer)operand2).intValue()+")");
               res = new Integer(((Integer)operand1).intValue()
                                 * ((Integer)operand2).intValue());
               _operandStack.push(res);
            }
            else if(operand1 instanceof Double
               && operand2 instanceof Double) {
               _debug("MUL("+((Double)operand1).doubleValue()+","
                                 + ((Double)operand2).doubleValue()+")");
               res = new Double(((Double)operand1).doubleValue()
                                 * ((Double)operand2).doubleValue());
               _operandStack.push(res);
            }
            else {
               throw new DBException("Bad types!");
            }
         }
         else if(_operatorStack.size() > 0 
                 && _operatorStack.peek().toString().compareTo("/") == 0) {
            _operatorStack.pop();
            operand2 = _lookupValue(_operandStack.pop());
            SQLUnaryExpr();
            operand1 = _lookupValue(_operandStack.pop());
            if(operand1 == null || operand2 == null)
               throw new DBException("Execution time error!");
            if(operand1 instanceof Integer
               && operand2 instanceof Integer) {
               _debug("DIV("+((Integer)operand1).intValue()+","
                                 + ((Integer)operand2).intValue()+")");
               res = new Integer(((Integer)operand1).intValue()
                                 / ((Integer)operand2).intValue());
               _operandStack.push(res);
            }
            else if(operand1 instanceof Double
               && operand2 instanceof Double) {
               _debug("DIV("+((Double)operand1).doubleValue()+","
                                 + ((Double)operand2).doubleValue()+")");
               res = new Double(((Double)operand1).doubleValue()
                                 / ((Double)operand2).doubleValue());
               _operandStack.push(res);
            }
            else {
               throw new DBException("Bad types!");
            }
         }
         else 
            break;
      }
   }

   public void SQLUnaryExpr()
   throws DBException {
      Object operand1, res;
      if(_operatorStack.size() > 0 
         && _operatorStack.peek().toString().compareTo("u+") == 0) {
         _operatorStack.pop();
         SQLTerm();
         operand1 = _lookupValue(_operandStack.pop());
         _debug("UADD("+operand1.toString()+")");
         if(operand1 instanceof Integer) {
            res = new Integer(+(((Integer)operand1).intValue()));
            _operandStack.push(res);
         }
         else if(operand1 instanceof Double) {
            res = new Double(+(((Double)operand1).doubleValue()));
            _operandStack.push(res);
         }
         else {
            throw new DBException("Bad types!");
         }
      }
      else if(_operatorStack.size() > 0 
              && _operatorStack.peek().toString().compareTo("u-") == 0) {
         _operatorStack.pop();
         SQLTerm();
         operand1 = _lookupValue(_operandStack.pop());
         _debug("USUB("+operand1.toString()+")");
         if(operand1 instanceof Integer) {
            res = new Integer(-(((Integer)operand1).intValue()));
            _operandStack.push(res);
         }
         else if(operand1 instanceof Double) {
            res = new Double(-(((Double)operand1).doubleValue()));
            _operandStack.push(res);
         }
         else {
            throw new DBException("Bad types!");
         }
      }
      else
         SQLTerm();
   }

   private boolean _matchClass(Class c1, Class c2) {
      if(c1 == null || c2 == null)
         return false;
      if(c1.getName().compareTo(c2.getName()) == 0)
         return true;
      else {
         if(c1.isPrimitive()) {
            if(c1.getName().compareTo("int") == 0) {
               if(c2.getName().compareTo("java.lang.Integer") == 0)
                  return true;
            }
            else if(c1.getName().compareTo("double") == 0) {
               if(c2.getName().compareTo("java.lang.Double") == 0) 
                  return true;
            }
         }
         else
            return _matchClass(c1, c2.getSuperclass());
      }
      return false;
   }
   
   private boolean _paramMatch(Class a1[], Class a2[]) {
      boolean match = true;
      if(a1.length == a2.length) {
         for(int i = 0; i < a1.length; i++) {
            if(!_matchClass(a1[i], a2[i])) {
               match = false;
               break;
            }
         }
      }
      else
         match = false;
      return match;
   }
   
   public void SQLTerm()
   throws DBException {
      if(_operatorStack.size() > 0 
         && _operatorStack.peek().toString().compareTo(")") == 0) {
         _operatorStack.pop();
         Hashtable used = _usedCols;
         _usedCols = null;
         Hashtable total = _allUsedCols;
         _allUsedCols = new Hashtable();
         SQLOrExpr();
         _usedCols = used;
         Object key, data;
         Enumeration e = _allUsedCols.keys();
         while(e.hasMoreElements()) {
            key = e.nextElement();
            data = _allUsedCols.get(key);
            total.put(key, data);
            _usedCols.put(key, data);
         }
         _allUsedCols = total;
         
         if(!(_operatorStack.size() > 0 
            && _operatorStack.peek().toString().compareTo("(") == 0))
            throw new DBException("Expected (");
         _operatorStack.pop();
      }
      else if(_operatorStack.size() > 0
              && _operatorStack.peek().toString().equalsIgnoreCase("JCALL")) {
         _operatorStack.pop();
         LinkedList argList = (LinkedList)_operandStack.pop();
         if(argList.size() < 2)
            throw new DBException("JCALL: bad parameters!");
         // Get class and method name
         Expression expr;
         expr = (Expression)argList.get(0);
         String clazz = (String)expr.eval(_tbl);
         expr = (Expression)argList.get(1);
         String method = (String)expr.eval(_tbl);
         
         // Build actual argument array
         Iterator it = argList.iterator();
         it.next();
         it.next();
         LinkedList actualArgList = new LinkedList();
         SQLExpression sqlExpr;
         Enumeration enum;
         Object key, data;
         while(it.hasNext()) {
            sqlExpr = ((SQLExpression)it.next());
            actualArgList.add(sqlExpr.eval(_tbl));
            enum = sqlExpr._allUsedCols.keys();
            while(enum.hasMoreElements()) {
               key = enum.nextElement();
               data = sqlExpr._allUsedCols.get(key);
               _usedCols.put(key, data);
               _allUsedCols.put(key, data);
            }
            if(sqlExpr._indexedTables != null) {
               enum = sqlExpr._indexedTables.keys();
               while(enum.hasMoreElements()) {
                  key = enum.nextElement();
                  data = sqlExpr._indexedTables.get(key);
                  _indexedTables.put(key,data);
               }
            }
         }
         Object argArray[] = new Object[actualArgList.size()];
         it = actualArgList.iterator();
         for(int i = 0; i < argArray.length; i++)
            argArray[i] = it.next();
         
         try {
            // Lookup the static method
            Class cls, params[];
            cls = Class.forName(clazz);
            params = new Class[argArray.length];
            for(int i = 0; i < argArray.length; i++)
               params[i] = argArray[i].getClass();
            Method mArray[] = cls.getMethods();
            Method m = null;
            for(int i = 0; i < mArray.length; i++) {
               if(mArray[i].getName().compareTo(method) == 0) {
                  if(_paramMatch(mArray[i].getParameterTypes(), params)) {
                     m = mArray[i];
                     break;
                  }
               }
            }
            if(m == null)
               throw new DBException("JCALL: no such method!");

            // Call the method
            Object ret = m.invoke(null, argArray);
            
            // If there is a return value put it on the stack
            if(ret != null) {
               if(ret instanceof String)
                  ret = "'" + ((String)ret) + "'";
               _operandStack.push(ret);
            }
            else
               _operandStack.push("''");
         }
         catch(Throwable throwable) {
            throwable.printStackTrace();
            throw new DBException("JCALL: error attementing to invoke " + clazz + "." + method);
         }
      }
   }

   private void _debugStack() {
      if(DEBUG_MODE) {
         for(int i = 0; i < _operatorStack.size(); i++)
            System.out.println("operatorStack["+i+"]=\""+_operatorStack.elementAt(i).toString()+"\"");
         if(_operatorStack.size() > 0)
            System.out.println("operatorStack.top()=\""+_operatorStack.peek().toString()+"\"");
         for(int i = 0; i < _operandStack.size(); i++)
            System.out.println("operandStack["+i+"]=\""+_operandStack.elementAt(i).toString()+"\"");
         if(_operandStack.size() > 0)
            System.out.println("operandStack.top()=\""+_operandStack.peek().toString()+"\"");
         System.out.println();
      }
   }
   
   public Object eval(ValueLookup tbl[]) throws DBException {
      _tbl = tbl;
      Object res;
      if(_operandStack.size() == 1 && _operatorStack.size() == 0) {
         res = _operandStack.peek();
         if(_as.compareTo("") == 0) {
            _as = res.toString();
            if(_as.length() > 0 && _as.charAt(0) == '\'')
               _as = _as.substring(1,_as.length()-1);
         }
         return _lookupValue(res);
      }
      
      Stack operandStack = (Stack)_operandStack.clone();
      Stack operatorStack = (Stack)_operatorStack.clone();      

      _debugStack();
      SQLOrExpr();
      _debugStack();
      
      res = _operandStack.pop();
      _operandStack = operandStack;
      _operatorStack = operatorStack;
      return _lookupValue(res);
   }
}