package com.mwc.sqld.db;

import java.util.*;
import java.io.*;

import sun.misc.*;

import cryptix.tools.UnixCrypt;

public class SQLFunctions {
   private static Hashtable _uniqueTable = new Hashtable();
   
   public static String base64(Boolean flag, String text) {
      if(flag.booleanValue()) {
         BASE64Encoder encoder = new BASE64Encoder();
         return encoder.encode(text.getBytes());
      }
      else {
         BASE64Decoder decoder = new BASE64Decoder();
         try {
            return new String(decoder.decodeBuffer(text));
         }
         catch(IOException ioe) {
            return null;
         }
      }
   }
   
   public static String crypt(String salt, String value) {
      return (new UnixCrypt(salt)).crypt(value);
   }
   
   public static void unregisterCurrentThreadUniqueData() {
      synchronized(_uniqueTable) {
         _uniqueTable.remove(Thread.currentThread().getName());
      }
   }
   
   public static boolean unique(String columnName, String value) {
      Hashtable myTable;
      synchronized(_uniqueTable) {
         myTable = (Hashtable)_uniqueTable.get(Thread.currentThread().getName());
         if(myTable == null) {
            myTable = new Hashtable();
            _uniqueTable.put(Thread.currentThread().getName(), myTable);
         }
      }
      
      Hashtable valueTable = (Hashtable)myTable.get(columnName.toLowerCase());
      if(valueTable == null) {
         valueTable = new Hashtable();
         myTable.put(columnName.toLowerCase(), valueTable);
      }

      String svalue = value.toString().toLowerCase();
      return (valueTable.put(svalue, svalue) == null);
   }
   
   public static boolean unique(String columnName, Integer value) {
      Hashtable myTable;
      synchronized(_uniqueTable) {
         myTable = (Hashtable)_uniqueTable.get(Thread.currentThread().getName());
         if(myTable == null) {
            myTable = new Hashtable();
            _uniqueTable.put(Thread.currentThread().getName(), myTable);
         }
      }
      
      Hashtable valueTable = (Hashtable)myTable.get(columnName.toLowerCase());
      if(valueTable == null) {
         valueTable = new Hashtable();
         myTable.put(columnName.toLowerCase(), valueTable);
      }

      String svalue = value.toString().toLowerCase();
      return (valueTable.put(svalue, svalue) == null);
   }
   
   public static boolean unique(String columnName, Boolean value) {
      Hashtable myTable;
      synchronized(_uniqueTable) {
         myTable = (Hashtable)_uniqueTable.get(Thread.currentThread().getName());
         if(myTable == null) {
            myTable = new Hashtable();
            _uniqueTable.put(Thread.currentThread().getName(), myTable);
         }
      }
      
      Hashtable valueTable = (Hashtable)myTable.get(columnName.toLowerCase());
      if(valueTable == null) {
         valueTable = new Hashtable();
         myTable.put(columnName.toLowerCase(), valueTable);
      }

      String svalue = value.toString().toLowerCase();
      return (valueTable.put(svalue, svalue) == null);
   }

   public static boolean unique(String columnName, Double value) {
      Hashtable myTable;
      synchronized(_uniqueTable) {
         myTable = (Hashtable)_uniqueTable.get(Thread.currentThread().getName());
         if(myTable == null) {
            myTable = new Hashtable();
            _uniqueTable.put(Thread.currentThread().getName(), myTable);
         }
      }
      
      Hashtable valueTable = (Hashtable)myTable.get(columnName.toLowerCase());
      if(valueTable == null) {
         valueTable = new Hashtable();
         myTable.put(columnName.toLowerCase(), valueTable);
      }

      String svalue = value.toString().toLowerCase();
      return (valueTable.put(svalue, svalue) == null);
   }

   public static String left(String str, Integer n) {
      int nn = n.intValue();
      if(nn > str.length())
         return (str);
      return (str.substring(0, nn));
   }
   
   public static String right(String str, Integer n) {
      int nn = n.intValue();
      if(nn > str.length())
         return str;
      return str.substring(str.length()-nn);
   }
   
   public static String mid(String str, Integer i, Integer n) {
      int ii = i.intValue();
      int nn = n.intValue();
      if(ii <= 0 || ii > str.length())
         return "";
      if(((ii-1) + nn) > str.length())
         return str.substring(ii-1);
      return str.substring(ii-1, (ii-1)+nn);
   }
   
   public static String soundex(String str) {
      Soundex s = new Soundex();
      return s.encode(str);
   }
   
   public static String concat(String str1, String str2) {
      return str1 + str2;
   }
}