package com.mwc.sqld.db;

public class SQLTypeChecker {
   public static boolean badTypes(Object data, String type) {
      type = type.toLowerCase();
      if(data instanceof String) {
         if(type.startsWith("varchar(")) {
            int sz = Integer.parseInt(type.substring(8,type.length()-1));
            if(data.toString().length() > sz)
               return true;
            return false;
         }
         else if(type.startsWith("char(")) {
            int sz = Integer.parseInt(type.substring(5,type.length()-1));
            if(data.toString().length() > sz)
               return true;
            return false;
         }
         else
            return true;
      }
      else if(data instanceof Integer) {
         if(type.compareTo("integer") == 0)
            return false;
         else if(type.compareTo("int") == 0)
            return false;
         else
            return true;
      }
      else if(data instanceof Double) {
         if(type.equalsIgnoreCase("float"))
            return false;
         else
            return true;
      }
      else if(data instanceof Boolean) {
         if(type.compareTo("boolean") == 0)
            return false;
         else
            return true;
      }
      else
         return true;
   }
}